
/* VelocityDemo */

/* Demo program by Ingemar Ragnemalm 1995 */
/* This program demonstrates a way to get mouse control like the one you find in Crystal Quest, */
/* where the mouse position controls the speed rather than the position of an object. */

/* I use fixed-point numbers, by shifting integers 4 binary digits. That makes the movement */
/* nice and smooth. */

#include <CursorDevices.h>


	WindowPtr myWindow;				/* Our window*/

	Point integerPosition, position;	/* The position of our object, in integer and fixed-point*/
	Point centerOfScreen;			/* The center of the screen*/
	Point theMouse;					/* A Point that we get the mouse position in*/
	Rect drawingRectangle;			/* A rectangle used for drawing*/
	Point speed;					/* The accumulated speed*/

#define	kHeight 16
#define	kWidth	16
#define	kFixedPointDigits	4


/* SetMouse, sets the mouse position */

static void SetMouse(Point newMousePosition)
{
	CursorDevicePtr	theCursorDevice = nil;
	OSErr			errorCode;

	if (NGetTrapAddress(0xAADB, ToolTrap) !=
		NGetTrapAddress(_Unimplemented, ToolTrap)) /* Is Cursor Device Mgr available? */
	{
/* Find a device with one button. That ought to be the standard mouse! */
	do {
		errorCode = CursorDeviceNextDevice(&theCursorDevice);
		} while ((theCursorDevice != nil) &&
				(*theCursorDevice).cntButtons != 1);
	}

	if (nil != theCursorDevice)
		{
		LocalToGlobal(&newMousePosition);
		errorCode = CursorDeviceMoveTo(theCursorDevice, newMousePosition.h, newMousePosition.v);
		errorCode = CursorDeviceButtons(theCursorDevice, 0);
		}
	else /* If Cursor Device Mgr is not around, do it the old way. */
		{
		LocalToGlobal(&newMousePosition);
		*(Point *)0x82c = newMousePosition;
		*(Point *)0x828 = newMousePosition;
		*(short *)0x8ce = 0xffff;
		}
} /* SetMouse */


/* Standard inits */

static void InitToolbox(void) {
	InitGraf (&qd.thePort);
	InitFonts ();
	FlushEvents (everyEvent,0);
	InitWindows ();
	InitMenus ();
	TEInit ();
	InitDialogs (nil);
	InitCursor ();
}


/* VelocityDemo main program */

void main(void)
{
	long	loopStartTime;

	InitToolbox();

/* Set up the window */
	myWindow = NewCWindow(nil, &qd.screenBits.bounds, "\pMemoryGame", true, 0, (WindowPtr)-1, false, 0);
	SetPort(myWindow);

/* It will look a little bit fancier on a black background */
	ForeColor(redColor);
	BackColor(blackColor);
	EraseRect(&myWindow->portRect);

/* Hide the cursor - it won't make sense anyway */
	HideCursor();

/* Calculate the center */
	centerOfScreen.h = (qd.screenBits.bounds.right - qd.screenBits.bounds.left) / 2;
	centerOfScreen.v = (qd.screenBits.bounds.bottom - qd.screenBits.bounds.top) / 2;

/* Let the cursor start in the center */
	SetMouse(centerOfScreen);

/* Initialize the position */
	integerPosition = centerOfScreen;
	position.h = (integerPosition.h << kFixedPointDigits);	/* Make fixed-point by shifting left*/
	position.v = (integerPosition.v << kFixedPointDigits);	/* Make fixed-point by shifting left*/

/* Let's start with speed zero! */
	speed.h = 0;
	speed.v = 0;

/* Initialize the Rect drawingRectangle, too. */
	SetRect(&drawingRectangle, integerPosition.h, integerPosition.v, integerPosition.h + kWidth, integerPosition.v + kHeight);

	do
	{
/* Get the current time */
		loopStartTime = TickCount();
/* Get the current position */
		GetMouse(&theMouse);
/* Set the speed to the distance between the mouse position and the center */
		speed.h = theMouse.h - centerOfScreen.h;
		speed.v = theMouse.v - centerOfScreen.v;
/* Move the fixed-point position by that much */
		position.h = position.h + speed.h;
		position.v = position.v + speed.v;
/* Stay on the screen! */
		if ( position.h < 0 )
		{
			position.h = 0;		/* Keep on screen*/
			speed.h = 0;		/* Zero speed*/
		};
		if ( position.v < 0 )
		{
			position.v = 0;		/* Keep on screen*/
			speed.v = 0;		/* Zero speed*/
		};
		if ( (position.h >> kFixedPointDigits) > qd.screenBits.bounds.right - qd.screenBits.bounds.left - kWidth )
		{
			position.h = (qd.screenBits.bounds.right - qd.screenBits.bounds.left - kWidth << kFixedPointDigits);
			speed.h = 0;		/* Zero speed*/
		};
		if ( (position.v >> kFixedPointDigits) > qd.screenBits.bounds.bottom - qd.screenBits.bounds.top - kHeight )
		{
			position.v = (qd.screenBits.bounds.bottom - qd.screenBits.bounds.top - kHeight << kFixedPointDigits);
			speed.v = 0;		/* Zero speed*/
		};
/* Erase from the previous position*/
		EraseRect(&drawingRectangle);
/* Divide the fixed-point position by 16 - which is the same as shifting it 4 steps (kFixedPointDigits)!*/
		integerPosition.h = (position.h >> kFixedPointDigits);
		integerPosition.v = (position.v >> kFixedPointDigits);
/* Draw!*/
		SetRect(&drawingRectangle, integerPosition.h, integerPosition.v, integerPosition.h + kWidth, integerPosition.v + kHeight);
		PaintRect(&drawingRectangle);
/* Limit speed - not more than 60 fps! */
		do {} while (TickCount() < loopStartTime + 1);
	} while (!Button ());
	ShowCursor ();
} /* VelocityDemo*/
