import java.net.Socket;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

/**
 * FtpUsersApplet to test sockets
 * @author Peter Parnes
 * @version 0.1, 950405
 * @version 0.2, 960519, ported to JDK1.0.2
 */

public class FtpUsersApplet extends Applet implements Runnable {
  /**
   * Applet methods
   */

  Thread kicker = null;
  Socket sock;
  byte buf[] = new byte[256];
  byte max_buf[] = new byte[256];
  int len,max_len;
  Color bgColor;
  Color fgColor;
  Font font;
  
  public void init() {
    font = new Font("Helvetica", Font.BOLD, 32);
    bgColor = new Color(210, 210, 210);
    fgColor = Color.black;
  }	
  
  public void run() {
    Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
    while(kicker != null) {
      get_info();
      try {
	Thread.sleep(5000);
      } catch(Exception e);
    }
  }
  
  public void start() {
    if (kicker == null) {
      kicker = new Thread(this);
      kicker.start(); 
    }  
  }

  public void get_info() {
    try {
      sock = new Socket("ftp.luth.se", 7101);
      sock.getOutputStream().write('a');
      len = sock.getInputStream().read(buf);
      sock = new Socket("ftp.luth.se", 7101);
      sock.getOutputStream().write('m');
      max_len = sock.getInputStream().read(max_buf);
      repaint();
    } catch (Exception e) {
      System.out.println(e);
    }
  }
  
  public void stop() {
    kicker = null;
  }
  
  public void paint(Graphics g) {
    String str1 = " Current:";
    String str2 = "Max:";
    int tmp;

    g.setColor(bgColor);
    g.fillRect(1, 1, size().width - 2, size().height -2);
    g.setColor(fgColor);
    g.drawRect(0, 0, size().width - 1, size().height - 1);
    g.setFont(font);

    String str = str1 + new String(buf,0,0,len) + "  " + str2 +
      new String(max_buf,0,0,max_len);

    g.drawChars(str.toCharArray(),0,str.length(),10,
		(size().height - font.getSize())/2 + 24);
    
    //    tmp = g.drawStringWidth(str1,10,
    //    ((height - font.height) / 2) + font.ascent + 2);
    //    tmp = tmp + g.drawBytesWidth(buf, 0, len, tmp,
    //    ((height - font.height) / 2) + font.ascent + 2);
    //    tmp = tmp + g.drawStringWidth(str2,tmp+20,
    //    ((height - font.height) / 2) + font.ascent + 2);
    //    tmp = tmp + g.drawBytesWidth(max_buf, 0, max_len, tmp+20,
    //    ((height - font.height) / 2) + font.ascent + 2);
    
  }
}
