/*

 // PrePrinted ... 
    versionPrePrintedLevels = true;
 
  // fullScreen 
   // first setup line !
 
 // DEBUGGING: waitForThePlotter

 
 // -------------------------------
 // PLOTARCADE
 // PLOTOLEC & OSC
 //
 // PlotterGamez
 // -------------------------------
 // rene.bauer@zhdk.ch
 // PlotterArcade or Computergames
 
 // ToDo: OSC in / out: plotter ready ...
 
 // attention: to use OSC
 // > stateRunningStart =  "osc"; // !!!!
 
 // optimize:
 // todo: move X, move Y > look forward and skip too long distance !!!
 
 
 // debug ...
 // waitForThePlotter = false;  !!!
 
 // One Game Setting
 //
 // [GAMEPICTURE] [PLOTTER]
 //
 // Computergame
 //
 // [PLOTTER]
 //   [TITLESCREEN]
 //   [MENUSCREEN]
 //   [INGAME]
 //
 
 // description
 
 - "simple plotter game engine"
 
 // ADD endless paper
 // ADD A SMALL DISPLAY? FOR SCORE? (LIKE IN PINBALLS?
 
 // How this works
 
 1. "realtime record" : pen
 
 moveTo();
 lineTo();
 drawShapeAt();
 
 > arrList
 > addLine
 
 2. "realtime idealistic printing" : plotterPen
 
 based on arrList
 
 processLines()
 > plotterMoveTo()
 > plotterLineTo()
 
 > plotterPosition: plotterPen
 
 3. "realtime":
 here is the plotter pen really
 
 Multimedia
 - unterlegte Grafiken (kopiert oder gemalt)
 - unterlegte Grafiken Farbe oder Schwarz-Weiss ..
 - der Stift kann farbig sein ...
 
 Levels
 - Line-Effekt - hinzufügen und weiter mit dem System
 
 Getroffen
 - - | (additiv)
 - \ / > X
 - neue Objekte
 
 Übertatowieren
 - umwandeln in etwas anderes
 - Geile Mann > der Gelbe Mann
 
 GameIdeen
 
 - Rogue like
 - Rumgehen und wenn man auf etwas trifft, dann wird die Welt gezeichnet
 - madPlotter done
 - Kolonialkartenzeichner*
 - interaktive Zeichnung ... 
 
 - xouoooxzzzz
 
 - jump ... pen/up down ... nothing more ... !!!
 
 - check interreput?
 - longer distances!
 
 - ideen: inverse ballerburg ... tippex ... oder weissem kulli !!!
 
 Real-time painting software for AxiDraw
 https://github.com/evil-mad/AxiDraw-Processing
 
 Based on RoboPaint RT:
 https://github.com/evil-mad/robopaint-rt
 
 */

/*

 // draw ... wait for next movetime
 MoveXY > with draw !!!
 
 nextMoveTime
 
 
 */



import de.looksgood.ani.*;
import processing.serial.*;

import processing.sound.*;
import java.util.Vector;

// OSC
import oscP5.*;
import netP5.*;
OscP5 oscP5;
NetAddress sendToAddress;

boolean oscActive = true;

// --------------------------------
// IMPORTANT SETTINGS
// --------------------------------
/*
    setup
 initHardwareSettings
 
 draw
 initGame
 updateGame
 */

// !!!!!!!!!!!!!!!!!!!!!!!!
// ToDo: load from a file ... file exits yes or no ... 
// ToDo: enable with 0 or so

boolean versionPrePrintedLevels = false; // * true - no background

// !!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!

String gameName = "PLOTOLEC";

// !!!!!!!!!!!!!!!!!!!!!!!!
boolean optimizeLineMove = true;  // todo: problems with mines!
// !!!!!!!!!!!!!!!!!!!!!!!!


boolean soundOn = true;
boolean debugVectorGraphics = false; // show svg file in the gui

// dont disable
boolean simulatePenLinesGUI = true;  // green lines
boolean showPenUpLines = true;
boolean realTimeSimulation = true; // visual

// !!!!!!!!!!!!!!!!!!!!!!!!
// DEBUG
// !!!!!!!!!!!!!!!!!!!!!!!!
// wait for the plotter
boolean waitForThePlotter = true; // true - false for fast developping online!

// plotter active = connected?
boolean plotterConnected = false;

// work on osc ...
// here ...

// startState / title menu ingamelineridepaint ingamespacetaxi ingamepotshot ingamedemotypes ingamepotshot ingametennisfortwo ingamelinejewels ingamerp ingametennisfortwo ingamethrust 
String stateRunningStart =  "ingamespacetaxi"; // "osc", "ingametennisfortwo", "ingamemines", "ingamejumpandrun"; // "ingametron"; // ingamelinejewels // "ingamemadpen"; // "menu"; // title | menu
// String stateRunningStart =  "osc";

boolean standAlone = false;  // set on true so a

// future: take also preprinted levels ...
// boolean prePrinted = true; // skip frame and things around ...
// even levels printed is possible!

// scale
float gameRatio = 1.0f;   // size of the fields ...
// influences
//  > gameRatio

public void setGameVisualRatio( float newR ) {
  gameRatio = newR;
  plotterScale = (int) (1000*gameRatio);
  guiPaperScale = (int) (50* gameRatio);
}

// tmp
PShape tmpShape;


void setup()
{
  // fullScreen();
  // fullScreen(2); // screen 2 ! 
    
  background(colorGUIWhite);
  size(840+400, 676+200);

  Ani.init(this); // Initialize animation library
  Ani.setDefaultEasing(Ani.LINEAR);

  firstPath = true;

  //// Allow frame to be resized?
  //  if (frame != null) {
  //    frame.setResizable(true);
  //  }



  shiftKeyDown = false;

  frameRate(60);  // sets maximum speed only

  initHardwareSettings();

  // Game Ping
  gamePing = new SoundFile(this, "soundPing.wav");


  // Set initial position of indicator at carriage minimum 0,0
  int[] pos = getMotorPixelPos();

  pos[0] = 0;
  pos[1] = 0;

  // vectorgraphis load
  vectorgraphics = loadShape("vectorgraphics.svg");
  // SAVED AS SVG1.1 Tiny
  // Format: <line fill="none" stroke="#000000" stroke-miterlimit="10" x1="26.79" y1="84.97" x2="48.19" y2="84.97"/>

  // titleSVG.rotate(0.2);
  // titleSVG.scale()

  // load settings
  // boolean fileExists = doesFileExist("./setting.txt");
  // if (fileExists) {  
  
  try {
    
    String[] lines = loadStrings("setting.txt");
    println("Setting.txt:" + lines.length + " lines");
    for (int i = 0 ; i < lines.length; i++) {
      // println(lines[i]);
      // 0
      if (i==0) {
           stateRunningStart = ""+lines[i]; 
           println("> StartUp with "+gameStateRunning);
      }      
      // 1 true/false > 
      if (lines[i].equals("true")) {
        versionPrePrintedLevels = true;
        println("> PrePrintedVersion: "+versionPrePrintedLevels);
      }
      
      // rest is comment ...
      // 
      
    }
  } catch( Exception ex ) {
     println("File setting.txt not found");    
  }
  
  // } else {
  //   println("File setting.txt not found"); 
  // }
   

  // println("params "+titleSVG.getParams());

  // resetPlayfield
  resetPlayfield();

  // joystick active?
  updateOSCJoystick();

  nextMoveTime = millis();
}

boolean doesFileExist(String filePath) {
  return new File(dataPath(filePath)).exists();
}

// -----------------
// graphics
// -----------------

// svg
PShape vectorgraphics;

float importScale = 0.1f;

// -----------------
// game pen setup
// -----------------

int penSpeedUpdate = 0;
int penSpeedUpdateIndex = 0;

int offsetX = 0;
int offsetY = 0;
int plotterScale = 1000;

// actual pen position in the simulation (!= gamepen && real plotterpen!)
PVector pen = new PVector();
PVector penOld = new PVector();

// the ideal pen for the next line !!!!
// goto
PVector plotterPen = new PVector();

// simulated Plotter pen - actual now!!
PVector plotterPenInThisMoment = new PVector();

// pen in a game
PVector avatarPosition = new PVector();
PVector avatarPositionOld = new PVector();

// -----------------
// game state
// -----------------

// only hardware state
int gameState = 0; // init
// 0 start
// 1 connect
// 2 gameon / running

// starting with gameState
String gameStateRunning = ""; //
String gameStateSubRunning = "";

int vx = 1;
int vy = 0;

int speed = 3;

int zz = 0;

// soundz
// -------------
SoundFile gamePing;


// -----------------
// field
// -----------------

int fieldWidth = 840;
int fieldHeight = 1188;

int[][] gameField = new int[fieldHeight][fieldWidth];


int gameTimerStart = 0;
int score = 0;
int life = 3;
int gameTimer = 0;
int level = 0;

// INITGAME
public void initGame() {

  println("# -----------------");
  println("# InitGame");
  println("# -----------------");

  // do game setup here!
  // start-screen

  nextMoveTime = millis();

  // tmpShape = vectorgraphics.getChild("a");
  // addPShapeAt(tmpShape,5,5);

  //  drawGraphicAt( "a", 0.0f, 0.0f);

  // nullpoint
  moveToNullPoint();

  //   delay(1000);

  gameState= 2;

  gameStateRunning = ""+stateRunningStart; // title | menu | ingame | gameover | won
  gameStateSubRunning = "";

  if ((!gameStateRunning.equals("title"))&&(!gameStateRunning.equals("menu"))) {
    standAlone = true;
  }

  // mainscreen or! (visual?)
  // menuscreen ..
}

// --------------------------------
// UPDATE Selection
// --------------------------------
// selection 
String oldgameStateRunning = "";
public void updateSelection() {
  
  if (gameStateSubRunning=="") {
    // move back
    MoveToXY( 0, 0 );
    optimizeLineMove = true; 
    gameStateSubRunning = "plotting";
  }
  
  // wait for input
  if (gameStateSubRunning.equals("plotting")) {
    if (plotterReadForInput()) {
      gameStateSubRunning = "running";
      MotorsOff();
    }
  }

  // wait for input
  if (gameStateSubRunning.equals("running")) {
    
    if ((pressedKeyChar.equals(" "))||(pressedKeyChar.equals("e"))) {
      MotorsOn();
      gameStateRunning = oldgameStateRunning; 
      gameStateSubRunning = "";      
    }
    
    textSize(24);
    
    String strGames = "";
    String[] games = {"OSC","TITLE","TRON","JEWELS","MADPEN","MINES!*","ROLEPLAY*","TENNISFORTWO","PLOT|POTSHOT","WOW-AFTERPARTY (DEMO)*","RIDE LINE PAINT","SPACETAXI","RACING*"};
    String[] gamesIntern = {"osc","title","ingametron","ingamelinejewels","ingamemadpen","ingamemines","ingamerp","ingametennisfortwo","ingamepotshot","ingamedemotypes","ingamelineridepaint","ingamespacetaxi","ingameracing"};

    for (int kraftwerk=0;kraftwerk<games.length;kraftwerk++) {
       
       String ks = ""+kraftwerk;
       if (kraftwerk>9) {
         ks = ""+char(kraftwerk-10+97);
       }
       strGames += "\n'"+ks+"' "+games[kraftwerk]; 
       
       if (pressedKeyChar.equals(""+ks)) {
           MotorsOn();
          gameStateRunning = gamesIntern[kraftwerk]; 
          gameStateSubRunning = "";
          pressedKeyChar = "";
       }
    }
    
    
    

    
    
    text("# SELECTION\n\nYou can now adjust plotter: Push pen to 0-position. Left smallest corner.\n\nPress ' ' or 'e' for restart game.\nor select here: "+strGames, 20, 80);

    
  }

  
}

// --------------------------------
// UPDATE TITLE MENU
// --------------------------------


float titleX = 00.0f+18.0;
float titleY = 0.0f;

int menupointSelected = 0;

public void updateGameTitle() {

  if (gameStateSubRunning=="") {
    println("updateGameTitle() draw");
    gameStateSubRunning="waiting";

    // test
    /*
    moveTo(7,1);
     moveTo(10,2);
     drawLine( 1,2, 5,8);
     drawLine( 3,3, 6,8);
     */

    if (!versionPrePrintedLevels) {
      drawGraphicAt("title", 0.0f+titleX, 0.0f+titleY);
      // drawTextAt("PRESS FIRE",1.0f+titleX,2.0f+titleY,0.2f);
  
      drawTextAt(".PLOTARCADEZ", 0.0f+titleX-0.5, 2.0f+1.5f+ titleY, 0.3f);
    }
    
    // move to ...
    // moveTo(0.5f+titleX,2.0f+0.25f+titleY);

    // skip all this! take too long time!
    gameStateRunning = "menu";
    gameStateSubRunning="";
    pressedKeyChar = "";
  }

  // menu wait ..
  if (gameStateSubRunning.equals("waiting")) {
    // println("updateGameTitle() wait");

    // wait for the key ...
    if (pressedKeyChar.equals(" ")) {
      // next ...

      // check if all is painted?
      gameStateRunning = "menu";
      gameStateSubRunning="";
      pressedKeyChar = "";
    }
  }
}

// --------------------------------
// UPDATE GAME MENU
// --------------------------------

float menuX = 0.0f+18.0;
float menuY = 3.0f;

String[] arrMenuPoints = {  /*"WALK",*/ "vTRON", "MINES!", "JEWELS", "MADPEN", "T42", "ROLEPLAY", "JUMP!" /*, "ABOUT"*/ };
String[] arrMenuStates = { /*"ingame",*/ "ingametron", "ingamemines", "ingamelinejewels", "ingametennis4two", "ingamerp", "ingamemadpen", "ingamejumpandrun" /*, "about"*/ };

public void updateGameMenu() {
  // println("updateGameMenu()");

  if (gameStateSubRunning=="") {
    println("updateGameTitle() draw");
    gameStateSubRunning="waiting";

    // drawTextAt(""+gameName,0.0f+menuX,0.0f+menuY,0.5);

    // drawTextAt("f PLAY",0.5f+menuX,2.0f+menuY,0.5f);
    // drawTextAt("f ABOUT",0.5f+menuX,3.0f+menuY,0.5f);


    //    drawGraphicAt("title",0.0f+titleX,0.0f+titleY);
    if (!versionPrePrintedLevels) {
      for (int h=0; h<arrMenuPoints.length; h++) {
        String menuStr = arrMenuPoints[h];
        drawTextAt("f "+menuStr, 0.5f+menuX, 2.0f+h*0.5f+menuY, 0.3f);
      }
    }

    // move to ...
    menupointSelected = 0;
    moveTo(0.5f+0.25f+menuX, 2.0f+menupointSelected*0.5f+0.25f+menuY);
  }

  // menu wait ..
  if (gameStateSubRunning=="waiting") {
    // println("updateGameTitle() wait");

    // up and down
    // menupointSelected

    if (pressedKeyChar.equals("w")) {
      menupointSelected -= 1;
      if (menupointSelected==-1) menupointSelected = 1;
      moveTo(0.5f+0.25f+menuX, 2.0f+menupointSelected*0.5f+0.25f+menuY);

      pressedKeyChar = "";
    }
    if (pressedKeyChar.equals("s")) {
      menupointSelected += 1;
      if (menupointSelected==arrMenuPoints.length) menupointSelected = 0;

      // go to menupoint
      moveTo(0.5f+0.25f+menuX, 2.0f+menupointSelected*0.5f+0.25f+menuY);

      pressedKeyChar = "";
    }

    // wait for the key ...
    if (pressedKeyChar.equals(" ")) {
      // next ...
      println("menu selected "+menupointSelected+"   "+arrMenuStates[menupointSelected]);

      // state?
      // check if all is painted?
      gameStateRunning = ""+arrMenuStates[menupointSelected];
      gameStateSubRunning="";
      pressedKeyChar = "";

      moveTo(0, 0);
    }
  }
}

// ----------
// OSC
// ----------
/*
  this is a very simple "realtime" osc-to-draw plugin.
 so sorry if it is too easy.
 
 # oscport 9007
 the osc port in is 9007. send your data here.
 
 # recording
 recording: movetoprocess and text will be recorded and executed
 
 # commands
 
 /clear              simulation only
 
 /penup
 /pendown
 
 /movetox 0.0-1.0    xpos
 /movetoy 0.0-1.0    ypos
 /movetoprocess      goto xpos/ypos
 
 /square             creates a 1x1 square
 /cross              creates a 1x1 cross
 
 /text BLA           draw text BLA at xpos/ypos
 
 # message back, if plotter is free
 server/host: 127.0.0.1
 port: 9008 
 /ready
 
 > app sends a command and wait for /ready 
 // there is no 0 it is only ready ... 
 
 */
float oscX = 0.0;
float oscY = 0.0;
float oscXLast = 0.0;
float oscYLast = 0.0;


// OSC-Processing

void oscEvent(OscMessage theOscMessage) {
  if (theOscMessage.addrPattern().equals("/test")) {
    println("OSC: /test");
  }

  // penUp / penDown
  if (theOscMessage.addrPattern().equals("/penup")) {
    println("OSC: /penup");
    penUp();
  }
  if (theOscMessage.addrPattern().equals("/pendown")) {
    println("OSC: /pendown");
    penDown();
  }

  // splitted
  if (theOscMessage.addrPattern().equals("/movetox")) {
    float fx = theOscMessage.get(0).floatValue();
    oscX =  (fx*10.0f);
    println("OSC: /movetox "+fx+" > "+oscX);
  }
  if (theOscMessage.addrPattern().equals("/movetoy")) {
    float fy = theOscMessage.get(0).floatValue();
    oscY =  (fy*10.0f);
    println("OSC: /movetoy "+fy+" > "+oscY);
  }
  if (theOscMessage.addrPattern().equals("/movetoprocess")) {
    println("OSC: /movetoprocess");
    if (penState==1) lineTo(oscX, oscY);
    if (penState==0) moveTo(oscX, oscY);
    oscXLast = oscX;
    oscYLast = oscY;
  }

  // one call
  if (theOscMessage.addrPattern().equals("/moveto")) {
    float fx = theOscMessage.get(0).floatValue();
    float fy = theOscMessage.get(1).floatValue();

    oscX = (fx*10.0f);
    oscY = (fy*10.0f);

    println("OSC:/moveto "+oscX+"/"+oscY);
    if (penState==1) lineTo(oscX, oscY);
    if (penState==0) moveTo(oscX, oscY);

    oscXLast = oscX;
    oscYLast = oscY;
  }

  if (theOscMessage.addrPattern().equals("/text")) {
    String txt = theOscMessage.get(0).stringValue();
    println("OSC: /text " +txt);
    drawTextAt(txt, oscX, oscY);
  }

  if (theOscMessage.addrPattern().equals("/square")) {
    println("OSC: /square");
    float ox = oscX;
    float oy = oscY;
    lineTo(ox+1.0, oy);
    lineTo(ox+1.0, oy+1.0);
    lineTo(ox+0.0, oy+1.0);
    lineTo(ox+0.0, oy+0.0);
  }

  if (theOscMessage.addrPattern().equals("/cross")) {
    println("OSC: /square");
    float ox = oscX;
    float oy = oscY;
    lineTo(ox+1.0, oy+1.0);
    lineTo(ox+0.5, oy+0.5);
    lineTo(ox+0.0, oy+1.0);
    lineTo(ox+1.0, oy+0.0);
    moveTo(ox+0.0, oy+0.0);
  }


  if (theOscMessage.addrPattern().equals("/clear")) {
    println("OSC: /clear");
    resetLines();
  }

  // ---------------------
  // DEFAULT JOYSTICK
  // 4 WAYS 
  // COMPETITION PRO
  // ---------------------
  // CompetitionPro
    // controller 0
  if (theOscMessage.addrPattern().indexOf("/joyosc/devices/js")!=-1) {

    // println("CP "+theOscMessage);
    
    int ikey = theOscMessage.get(0).intValue();
    int xal = theOscMessage.get(1).intValue();
    
     // x 
     if (ikey==0) {
       // println("osc-competitionpro x: "+xal);     
       joystickXAxis = 0;
       if (xal==-32768) { joystickXAxis=-1; joystickXAxisDirect=-1; }
       // wtf?
       if (xal==32767) { joystickXAxis=1; joystickXAxisDirect = 1; }
     }
     // y
     if (ikey==1) {
       joystickYAxis = 0;
       // println("osc-competitionpro y: "+xal);     
       if (xal==-32768) { joystickYAxis=-1; joystickYAxisDirect=-1; }
       // wtf?
       if (xal==32767) { joystickYAxis=1; joystickYAxisDirect=1; }
     }
     
     // correct axis vs buttons!
     if (ikey==3) {
       // joystickAction = 0;
       // println("osc-competitionpro action: "+xal);
       joystickAction=xal;
       joystickActionDirect=xal;
     }     

  }
  
  // SONY DUAL SENSE 5
  // controller 0
  if (theOscMessage.addrPattern().indexOf("/joyosc/devices/ps0/")!=-1) {

    String fstr = theOscMessage.get(0).stringValue();
    int xal = theOscMessage.get(1).intValue();
    
     if (fstr.equals("leftx")) {
       tennisForTwoAxisX[0] = xal;       
     }
     if (fstr.equals("lefty")) {
       tennisForTwoAxisY[0] = xal;
     }
     if (fstr.equals("a")) {
       tennisForTwoButton[0] = xal;
       joystickAction = xal;
     }

     // for normal joystick system
     if (fstr.equals("a")) {
       tennisForTwoButton[0] = xal;
       joystickAction = xal;
     }

     if (fstr.equals("dpleft")) {
       joystickXAxis = -xal;
     }
     if (fstr.equals("dpright")) {
       joystickXAxis = xal;
     }
     if (fstr.equals("dpup")) {
       joystickYAxis = -xal;
     }
     if (fstr.equals("dpdown")) {
       joystickYAxis = xal;
     }


  }

  // controller 1
  if (theOscMessage.addrPattern().indexOf("/joyosc/devices/ps1/")!=-1) {

    String fstr = theOscMessage.get(0).stringValue();
    int xal = theOscMessage.get(1).intValue();
    
     if (fstr.equals("leftx")) {
       tennisForTwoAxisX[1] = xal;
     }
     if (fstr.equals("lefty")) {
       tennisForTwoAxisY[1] = xal;
     }
     if (fstr.equals("a")) {
       tennisForTwoButton[1] = xal;
     }

  }

  // println("theOscMessage "+theOscMessage);
}

public void updateOSC() {

  if (gameStateSubRunning.equals("")) {
    gameStateSubRunning="plotting";
    // OSC?
    oscP5 = new OscP5(this, 9007);
    sendToAddress = new NetAddress("127.0.0.1", 9008); // Replace with your remote address and port

  }
  
  if (plotterReadForInput()) {
     OscMessage myReadyMessage = new OscMessage("/ready");
     // Send the message to the specified remote location
     oscP5.send(myReadyMessage, sendToAddress);
  }
  
  // keys
  // key / controls
  if (pressedKeyChar.equals("d")) {
    avatarPosition.x += 1;
    pressedKeyChar = "";
  }
  if (pressedKeyChar.equals("a")) {
    avatarPosition.x -= 1;
    pressedKeyChar = "";
  }
  if (pressedKeyChar.equals("w")) {
    avatarPosition.y -= 1;
    pressedKeyChar = "";
  }
  if (pressedKeyChar.equals("s")) {
    avatarPosition.y += 1;
    pressedKeyChar = "";
  }


  //  print("("+pen.x+"/"+pen.y+")");

  // change pen
  if (avatarPosition.x!=avatarPositionOld.x || avatarPosition.y!=avatarPositionOld.y) {

    // pointer only!
    //     moveTo(avatarPosition.x,avatarPosition.y);
    lineTo(avatarPosition.x, avatarPosition.y);

    // draw
    // addLine(penOld,pen);
  }


  avatarPositionOld.x = avatarPosition.x;
  avatarPositionOld.y = avatarPosition.y;
}

public void updateOSCTennisForTwo() {

  if (gameStateSubRunning.equals("")) {
    // OSC?
    oscP5 = new OscP5(this, 9007);
      
  }
}

public void updateOSCJoystick() {

  if (gameStateSubRunning.equals("")) {
    // OSC?
    oscP5 = new OscP5(this, 9007);
      
  }
}


int gameX = 0;
int gameY = 0;

public void updateInGame() {

  // println("-"+pressedKeyChar);

  // keys
  // key / controls
  if (pressedKeyChar.equals("d")) {
    avatarPosition.x += 1;
    pressedKeyChar = "";
  }
  if (pressedKeyChar.equals("a")) {
    avatarPosition.x -= 1;
    pressedKeyChar = "";
  }
  if (pressedKeyChar.equals("w")) {
    avatarPosition.y -= 1;
    pressedKeyChar = "";
  }
  if (pressedKeyChar.equals("s")) {
    avatarPosition.y += 1;
    pressedKeyChar = "";
  }


  //  print("("+pen.x+"/"+pen.y+")");

  // change pen
  if (avatarPosition.x!=avatarPositionOld.x || avatarPosition.y!=avatarPositionOld.y) {

    // pointer only!
    //     moveTo(avatarPosition.x,avatarPosition.y);
    lineTo(avatarPosition.x, avatarPosition.y);

    // draw
    // addLine(penOld,pen);
  }


  avatarPositionOld.x = avatarPosition.x;
  avatarPositionOld.y = avatarPosition.y;


  // special
  if (pressedKeyChar.equals(" ")) {
    tmpShape = vectorgraphics.getChild("a");
    // addPShapeAt(tmpShape,pen.x,pen.y);
    // println("fire");
    //addLine( new PVector(0,0), pen );
    addShapeXAt(avatarPosition.x, avatarPosition.y);

    pressedKeyChar = "";
  }

  if (pressedKeyChar.equals("e")) {
    // println("SHOOT E");
    //      tmpShape = vectorgraphics.getChild("b");
    // addPShapeAt(tmpShape,pen.x,pen.y);
    // println("fire");
    //addLine( new PVector(0,0), pen );
    //      addPShapeAt(tmpShape,pen.x,pen.y);

    drawGraphicAt("k", avatarPosition.x, avatarPosition.y);



    pressedKeyChar = "";
  }
}


// --------------------------------------
// TRON
// --------------------------------------

int gameTronDirectionX = 0;
int gameTronDirectionY = 0;

int gameTronLifes = 3;

public void updateInGameTron() {

  // println("-"+pressedKeyChar);

  // start up / set graphics
  if (gameStateSubRunning.equals("")) {
    gameStateSubRunning="plotting";

    resetLines();

    println("gametron.start");

    gameTronDirectionX = 0;
    gameTronDirectionY = 0;

    // bigger field
    playfieldWith = 16;
    playfieldHeight = 12;

    level = 0;
    life = 0;
    score = 0;

    gameTronLifes = 3;

    // display playfield
    String[] aStr = { " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", "f", "v", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " "  };
    randomPlayfield( aStr );

    // random ... new objects ..
    avatarPosition.x = playfieldWith/2;
    avatarPosition.y = playfieldHeight/2;

    playfieldRect(" ", 0, 0, playfieldWith-1, playfieldHeight-1);

    setPlayfield(" ", (int) avatarPosition.x, (int) avatarPosition.y);

    drawPlayfield();

    playfieldRect("f", 0, 0, playfieldWith-1, playfieldHeight-1);

    // draw by hand
    float os = playfieldTileSize*0.5f;
    float ps = playfieldTileSize;
    // always one line
    drawLine( os, os, (playfieldWith-1)*ps+os, os );
    drawLine( os+(playfieldWith-1)*ps, os, os+(playfieldWith-1)*ps, (playfieldHeight-1)*ps+os );
    drawLine( (playfieldWith-1)*ps+os, (playfieldHeight-1)*ps+os, os, (playfieldHeight-1)*ps+os );
    drawLine( os, (playfieldHeight-1)*ps+os, os, os );

    // drawPlayfield();

    // todo: check if there is something
    // own home?

    avatarPosition.x = playfieldWith/2;
    avatarPosition.y = playfieldHeight/2;

    moveTo( avatarPosition.x+playfieldTileSize*0.5f, avatarPosition.y+playfieldTileSize*0.5f);

    gameTimerStart = 0;

    // loading music ...
  }

  // finished
  //  gameStateSubRunning="run";
  if (gameStateSubRunning.equals("plotting")) {
    if (plotterReadForInput()) {
      println("gametron.start > running");
      gameStateSubRunning = "running";
      gameTimer = millis();
    }
  }

  if (gameStateSubRunning.equals("running")) {


    // println("-"+pressedKeyChar);

    // -----------
    //  random
    //  movement
    // -----------
    if (plotterReadForInput())
    if (gameTimer<millis()) {
      gameTimer = millis()+500;
      // println("NEXT EVENT");
      if ((gameTronDirectionX!=0.0)||(gameTronDirectionY!=0.0)) {
        avatarPosition.x += gameTronDirectionX;
        avatarPosition.y += gameTronDirectionY;
      }
    }

    // keys
    // key / controls
    // if (pressedKeyChar.equals("d")) {
    if (getJoystickOrKeyboard("right")) {
      pressedKeyChar = "";
      gameTronDirectionX = 1;
      gameTronDirectionY = 0;
      pressedKeyChar = "";
    }
//    if (pressedKeyChar.equals("a")) {
    if (getJoystickOrKeyboard("left")) {
      pressedKeyChar = "";
      gameTronDirectionX = -1;
      gameTronDirectionY = 0;
      pressedKeyChar = "";
    }
//    if (pressedKeyChar.equals("w")) {
    if (getJoystickOrKeyboard("up")) {
      pressedKeyChar = "";
      gameTronDirectionX = 0;
      gameTronDirectionY = -1;
      pressedKeyChar = "";
    }
//    if (pressedKeyChar.equals("s")) {
    if (getJoystickOrKeyboard("down")) {
      pressedKeyChar = "";
      gameTronDirectionX = 0;
      gameTronDirectionY = 1;
    }
  }




  // change pen
  if (avatarPosition.x!=avatarPositionOld.x || avatarPosition.y!=avatarPositionOld.y) {

    lineTo(avatarPosition.x+playfieldTileSize*0.5f, avatarPosition.y+playfieldTileSize*0.5f);

    String actualPlayfieldX = getPlayfield((int)avatarPosition.x, (int)avatarPosition.y);
    // gameover !!!
    if (actualPlayfieldX.equals("v")) {

      // drawPlayfieldGraphicNameAt("y",avatarPosition.x,avatarPosition.y);
      // not working correctly!

      // todo: ping ...
      score += 3;
      playPing();
    }

    // gameover !!!
    if (actualPlayfieldX.equals("f")) {

      drawPlayfieldGraphicNameAt("q", avatarPosition.x, avatarPosition.y);

      gameTronLifes--;

      // display lifes
      if (gameTronLifes>0) {
        // write go back to start
        drawTextAt("."+gameTronLifes, gameTronLifes*3*playfieldTileSize, 1*playfieldTileSize, 0.3f);

        gameTronDirectionX = 0;
        gameTronDirectionY = 0;

        avatarPosition.x = playfieldWith/2;
        avatarPosition.y = playfieldHeight/2;

        moveTo( avatarPosition.x+playfieldTileSize*0.5f, avatarPosition.y+playfieldTileSize*0.5f);
      }

      if (gameTronLifes==-1) {
        gameStateSubRunning = "lost";
        drawTextAt(".WON   "+score+"  PTS ", 1*playfieldTileSize, 12*playfieldTileSize, 0.3f);
        drawTextAt(".NEW PAPER ... FIRE ", 1*playfieldTileSize, 13*playfieldTileSize, 0.3f);
        penUp();
      }
    }

    setPlayfield("f", (int)avatarPosition.x, (int)avatarPosition.y);
    score += 1;
    playPing();
  }


  avatarPositionOld.x = avatarPosition.x;
  avatarPositionOld.y = avatarPosition.y;


  // lost
  if (gameStateSubRunning.equals("lost")) {

    // collect - restart ...
//    if ((pressedKeyChar.equals("e"))||(pressedKeyChar.equals(" "))) {
    if (getJoystickOrKeyboard("action")) {

      // direct
      gameStateSubRunning = "";

      pressedKeyChar = "";
    }
  }
}

// --------------------------------------
// MADPEN
// --------------------------------------


public void updateInGameMadPen() {

  // start up / set graphics
  if (gameStateSubRunning.equals("")) {
    gameStateSubRunning="plotting";

    println("updateInGameMadPen()");

    resetLines();

    // bigger field
    playfieldWith = 16;
    playfieldHeight = 12;

    level = 0;
    life = 0;
    score = 0;


    // display playfield
    //     String[] aStr = { " "," "," "," "," "," "," "," "," "," "," "," ","d","a"," "," "," "," "," "," "," " ," "," " ," "," "  };
    //     randomPlayfield( aStr );

    // a
    var inserted = 0;
    do {
      var tx = (int) (random(0, playfieldWith-2)+1);
      var ty = (int) (random(0, playfieldHeight-2)+1);
      if (getPlayfield(tx, ty)==" ") {
        setPlayfield("d", tx, ty);
        inserted++;
      }
    } while (inserted<10);

    // d
    inserted = 0;
    do {
      var tx = (int) (random(0, playfieldWith-2)+1);
      var ty = (int) (random(0, playfieldHeight-2)+1);
      if (getPlayfield(tx, ty)==" ") {
        setPlayfield("a", tx, ty);
        inserted++;
      }
    } while (inserted<4);


    // random ... new objects ..


    avatarPosition.x = playfieldWith/2;
    avatarPosition.y = playfieldHeight/2;

    setPlayfield(" ", (int) avatarPosition.x, (int) avatarPosition.y);

    playfieldRect(" ", 0, 0, playfieldWith-1, playfieldHeight-1);

    drawPlayfield();

    playfieldRect("a", 0, 0, playfieldWith-1, playfieldHeight-1);

    // draw by hand
    float os = playfieldTileSize*0.5f;
    float ps = playfieldTileSize;
    if (!versionPrePrintedLevels) {
      drawLine( os, os, (playfieldWith-1)*ps+os, os );
      drawLine( os+(playfieldWith-1)*ps, os, os+(playfieldWith-1)*ps, (playfieldHeight-1)*ps+os );
      drawLine( (playfieldWith-1)*ps+os, (playfieldHeight-1)*ps+os, os, (playfieldHeight-1)*ps+os );
      drawLine( os, (playfieldHeight-1)*ps+os, os, os );
    }
    
    // drawPlayfield();

    // todo: check if there is something
    // own home?

    moveTo( avatarPosition.x, avatarPosition.y );

    gameTimerStart = 0;

    // loading music ...
  }

  // finished
  //  gameStateSubRunning="run";
  if (gameStateSubRunning.equals("plotting")) {
    if (plotterReadForInput()) {
      gameStateSubRunning = "running";
      gameTimer = millis();
    }
  }


  if (gameStateSubRunning=="running") {


    // println("-"+pressedKeyChar);

    // -----------
    //  random
    //  movement
    // -----------

    // stop here ...

    if (gameTimer<millis()) {
      gameTimer = millis()+500;
      // println("NEXT EVENT");
      int irnd = (int) random(30);
      if (irnd==0) {
        if (avatarPosition.x<(playfieldWith-2)) avatarPosition.x += 1;
      }
      if (irnd==1) {
        if (avatarPosition.x>1) avatarPosition.x -= 1;
      }
      if (irnd==2) {
        if (avatarPosition.y<(playfieldHeight-2)) avatarPosition.y += 1;
      }
      if (irnd==3) {
        if (avatarPosition.y>1) avatarPosition.y -= 1;
      }
    }

    // life <1 black trail!

    String actualPlayfield = getPlayfield((int)avatarPosition.x, (int)avatarPosition.y);

    // -------------
    // take chrisie
    // ---------------

    // level 0
    if (actualPlayfield.equals("d")) {
      setPlayfield("/", (int)avatarPosition.x, (int)avatarPosition.y);
      drawPlayfieldGraphic((int)avatarPosition.x, (int)avatarPosition.y);
      score +=1;

      // check if there is still an a

      // create new as


      // and add second ...
      // println("playfield "+checkPlayfieldFor("d"));
      if (checkPlayfieldFor("d")==0) {
        level = 1;
        // search for "/" > "\"
      }
    }


    if (level==1) {
      if (actualPlayfield.equals("/")) {
        setPlayfield("\\", (int)avatarPosition.x, (int)avatarPosition.y);
        drawPlayfieldGraphic((int)avatarPosition.x, (int)avatarPosition.y);
        score +=1;

        // check if there is still an a

        // create new as


        // and add second ...
        if (checkPlayfieldFor("/")==0) {
          level = 2;
          // search for "/" > "\"
          int timeInSecs = (int) (millis()-gameTimerStart)/1000;

          println("score: "+timeInSecs+" "+life*10);

          timeInSecs += life*10;



          drawTextAt(""+timeInSecs+" S INC LIFES "+life+" * 10S", 1*playfieldTileSize, 12*playfieldTileSize, 0.25f);

          gameStateSubRunning = "won";

          // enter a new page and press key !!!
          drawTextAt("PAPER!", 1*playfieldTileSize, 13*playfieldTileSize, 0.25f);
        }
      }
    }



    // -------------
    // dead?
    // ---------------

    // level 1
    if (actualPlayfield.equals("a")) {
      // setPlayfield("X",(int)avatarPosition.x,(int)avatarPosition.y);
      // drawPlayfieldGraphic((int)avatarPosition.x,(int)avatarPosition.y);
      life += 1;


      // start again ... !!! ...
      //        moveTo(0,0);
      drawPlayfieldGraphicNameAt("q", avatarPosition.x+0.25, avatarPosition.y+0.25);

      // do something
      avatarPosition.x = playfieldWith/2;
      avatarPosition.y = playfieldHeight/2;

      //       moveTo(avatarPosition.x,avatarPosition.y);
    }


    // -----------
    // keys
    // -----------
    // key / controls
//    if (pressedKeyChar.equals("d")) {
    if (getJoystickOrKeyboard("right")) {
      if (avatarPosition.x<(playfieldWith-2)) avatarPosition.x += 1;
      pressedKeyChar = "";
    }
//    if (pressedKeyChar.equals("a")) {
    if (getJoystickOrKeyboard("left")) {
      if (avatarPosition.x>1) avatarPosition.x -= 1;
      pressedKeyChar = "";
    }
//    if (pressedKeyChar.equals("w")) {
    if (getJoystickOrKeyboard("up")) {

    if (avatarPosition.y>1) avatarPosition.y -= 1;
      pressedKeyChar = "";
    }
//    if (pressedKeyChar.equals("s")) {
    if (getJoystickOrKeyboard("down")) {
      if (avatarPosition.y<(playfieldHeight-2)) avatarPosition.y += 1;
      pressedKeyChar = "";
    }


    //  print("("+pen.x+"/"+pen.y+")");

    // change pen
    if (avatarPosition.x!=avatarPositionOld.x || avatarPosition.y!=avatarPositionOld.y) {

      // pointer only!
      if (life<5) {
        moveTo(avatarPosition.x+0.5f, avatarPosition.y+0.5f);
      } else {
        lineTo(avatarPosition.x+0.5f, avatarPosition.y+0.5f);
      }
    }


    avatarPositionOld.x = avatarPosition.x;
    avatarPositionOld.y = avatarPosition.y;
  }

  // start again ...
  if (plotterReadForInput()) {
    if (gameStateSubRunning.equals( "won")) {
      // wait for " "
//      if ((pressedKeyChar.equals(" "))||(pressedKeyChar.equals("e"))) {
    if (getJoystickOrKeyboard("action")) {
        gameStateSubRunning = "";

        pressedKeyChar = "";
      }
    }
  }
}

// --------------------------------------
// MINES
// --------------------------------------

public void updateInGameMines() {
  
  // todo: no optimized moves
  optimizeLineMove = false; 

  // start up / set graphics
  if (gameStateSubRunning.equals("")) {
    gameStateSubRunning="plotting";

    println("updateInGameMines()");

    resetLines();

    // bigger field
    playfieldWith = 16;
    playfieldHeight = 12;

    level = 0;
    life = 0;
    score = 0;


    // display playfield
    String[] aStr = { " ", " ", " ", " ", " ", "*", "*", "*", "*", "h", " ", " ", " ", " ", " ", " ", " ", " ", " ", " "  };
    randomPlayfield( aStr );

    // random ... new objects ..

    avatarPosition.x = 0;
    avatarPosition.y = 0; // playfieldHeight/2;

    setPlayfield(" ", (int) avatarPosition.x, (int) avatarPosition.y);

    // playfieldRect(" ",0,0,playfieldWith-1,playfieldHeight-1);

    //     playfieldRect("a",0,0,playfieldWith-1,playfieldHeight-1);

    // draw houses !!!
    // drawPlayfield();


    // draw by hand
    float os = 0.0;
    float ps = playfieldTileSize;
    if (!versionPrePrintedLevels) {
   
      if (false) {
        drawLine( os, os, (playfieldWith-1)*ps+os, os );
        drawLine( os+(playfieldWith)*ps, os, os+(playfieldWith)*ps, (playfieldHeight)*ps+os );
        drawLine( (playfieldWith)*ps+os, (playfieldHeight)*ps+os, os, (playfieldHeight)*ps+os );
        drawLine( os, (playfieldHeight)*ps+os, os, os );
      }

      // draw the lines or print it ...
      for (int i=1;i<(playfieldHeight/playfieldTileSize);i++) {
        // version 1
        // drawLine( 0, i*playfieldTileSize, playfieldWith, i*playfieldTileSize );        
        // version 2 .-)
        if (i%2==0) drawLine( 0, i*playfieldTileSize, playfieldWith, i*playfieldTileSize );   
        if (i%2==1) drawLine( playfieldWith, i*playfieldTileSize, 0, i*playfieldTileSize );   
      }

      // draw the lines or print it ...
      for (int i=1;i<(playfieldWith/playfieldTileSize);i++) {
        // drawLine( i*playfieldTileSize, 0, i*playfieldTileSize, playfieldHeight );        
        // version 2 optimized
        if (i%2==0) drawLine( i*playfieldTileSize, 0, i*playfieldTileSize, playfieldHeight );        
        if (i%2==1) drawLine( i*playfieldTileSize, playfieldHeight, i*playfieldTileSize, 0  );        
        
      }

  
    }


    // drawPlayfield();

    // todo: check if there is something
    // own home?

    moveTo( avatarPosition.x+0.5, avatarPosition.y+0.5 );

    gameTimerStart = 0;

    // loading music ...
  }

  // finished
  //  gameStateSubRunning="run";
  if (gameStateSubRunning.equals("plotting")) {
    if (plotterReadForInput()) {
      gameStateSubRunning = "running";
      gameTimer = millis();
    }
  }


  if (gameStateSubRunning=="running") {

    // println("plotterNothingToDo "+plotterNothingToDo);

    // println("-"+pressedKeyChar);

    // -----------
    //  random
    //  movement
    // -----------

    // stop here ...

    /*
    if (gameTimer<millis()) {
     gameTimer = millis()+500;
     // println("NEXT EVENT");
     int irnd = (int) random(30);
     if (irnd==0) avatarPosition.x += 1;
     if (irnd==1) avatarPosition.x -= 1;
     if (irnd==2) avatarPosition.y += 1;
     if (irnd==3) avatarPosition.y -= 1;
     }
     */

    // life <1 black trail!

    String actualPlayfield = getPlayfield((int)avatarPosition.x, (int)avatarPosition.y);


    // start again ...
    if (gameStateSubRunning.equals( "won")) {
      /*
      // wait for " "
       if (pressedKeyChar.equals(" ")) {
       gameStateSubRunning = "";
       pressedKeyChar = "";
       }
       */
    }

    // -------------
    // dead?
    // ---------------


    // -----------
    // keys
    // -----------
    // key / controls
    // only if game is ready!!!
    if (plotterReadForInput()) {

      // if (pressedKeyChar.equals("d")) {
      if (getJoystickOrKeyboard("right")) {  
        avatarPosition.x += 1;
        pressedKeyChar = "";
      }

//      if (pressedKeyChar.equals("a")) {
      if (getJoystickOrKeyboard("left")) {  
        avatarPosition.x -= 1;
        pressedKeyChar = "";
      }
//      if (pressedKeyChar.equals("w")) {
      if (getJoystickOrKeyboard("up")) {  
        avatarPosition.y -= 1;
        pressedKeyChar = "";
      }
//      if (pressedKeyChar.equals("s")) {
      if (getJoystickOrKeyboard("down")) {  
        
        avatarPosition.y += 1;
        pressedKeyChar = "";
      }

      // correct here
      if (avatarPosition.x < 0) avatarPosition.x = 0;
      if (avatarPosition.y < 0) avatarPosition.y = 0;
      if (avatarPosition.x > playfieldWith) avatarPosition.x = playfieldWith;
      if (avatarPosition.y > playfieldHeight) avatarPosition.y = playfieldHeight;


      //  print("("+pen.x+"/"+pen.y+")");

      // change pen
      if (avatarPosition.x!=avatarPositionOld.x || avatarPosition.y!=avatarPositionOld.y) {
        lineTo(avatarPosition.x+0.5f, avatarPosition.y+0.5f);
      }

      // new position
      String newPlayfield = getPlayfield((int)avatarPosition.x, (int)avatarPosition.y);

      // ---------------------
      // show a new field
      // ---------------------
      // ... show it now ..
      if (getPlayfieldVar((int)avatarPosition.x, (int)avatarPosition.y)==0) {
        // on what are you?
        // mine or house?
        // hit
        // mine
        if (newPlayfield.equals("*")) {
          drawPlayfieldGraphic((int)avatarPosition.x, (int)avatarPosition.y);
          // seen ...
          // explosion
//          setPlayfieldVar(1, (int)avatarPosition.x, (int)avatarPosition.y);
//          moveTo((int)avatarPosition.x+0.5, (int)avatarPosition.y+0.5);
//          drawPlayfieldGraphicNameAt("q", avatarPosition.x, avatarPosition.y);

          // back to the start ...
          moveTo((int)avatarPosition.x+0.5, (int)avatarPosition.y+0.5);
        }
        // house
        if (newPlayfield.equals("h")) {
          drawPlayfieldGraphic((int)avatarPosition.x, (int)avatarPosition.y);
          // seen ...
          setPlayfieldVar(1, (int)avatarPosition.x, (int)avatarPosition.y);
          moveTo((int)avatarPosition.x+0.5, (int)avatarPosition.y+0.5);
        }
        // house - chest
        if (newPlayfield.equals("c")) {
          drawPlayfieldGraphic((int)avatarPosition.x, (int)avatarPosition.y);
          // seen ...
          setPlayfieldVar(1, (int)avatarPosition.x, (int)avatarPosition.y);
          moveTo((int)avatarPosition.x+0.5, (int)avatarPosition.y+0.5);
        }
      }
      // ---------------------
      // detector
      // ---------------------
      // check new area
      // ...
      if (getPlayfieldVar((int)avatarPosition.x, (int)avatarPosition.y)==0) {

        String am = " ";
        var count = 0;
        for (var c=-1; c<2; c++) {
          for (var cc=-1; cc<2; cc++) {

            if (((int)avatarPosition.x+c)<0) continue;
            if (((int)avatarPosition.y+cc)<0) continue;

            // check for mines
            am = getPlayfield((int)avatarPosition.x+c, (int)avatarPosition.y+cc);
            if (am.equals("*")) {
              count++;
            }
          }
        }
        // set the field now ..
        // setPlayfield(""+count,(int)avatarPosition.x,(int)avatarPosition.y);
        // drawPlayfieldGraphic((int)avatarPosition.x,(int)avatarPosition.y);
        // add 1 !
        setPlayfieldVar(count+1, (int)avatarPosition.x, (int)avatarPosition.y);
        // display
        // 0 point
        if (count>0) {
          drawTextAt(""+count, avatarPosition.x+0.5, avatarPosition.y+0.5, 0.2f);
        }


        // display
        // small point
      }

      avatarPositionOld.x = avatarPosition.x;
      avatarPositionOld.y = avatarPosition.y;
    }
  }
}

// --------------------------------------
// RolePlay
// --------------------------------------
// * prototype


String activeTool = ""; // last active tool ...


boolean checkPositionRolePlayField( String cat, int dx, int dy) {

  String apfield = getPlayfield((int)avatarPosition.x+dx, (int)avatarPosition.y+dy);
  /*
      
   // o| |i
   
   // l_  p---
   
   // edges ..
   // r j
   // n b
   
   // g how / hacke
   // c sword
   // n spitz
   // w crash
   // ; key
   
   */

  if (apfield.equals("o")) return false;
  if (apfield.equals("i")) return false;
  if (apfield.equals("l")) return false;
  if (apfield.equals("p")) return false;

  if (apfield.equals("r")) return false;
  if (apfield.equals("j")) return false;
  if (apfield.equals("b")) return false;
  if (apfield.equals("n")) return false;

  return true;
}

void checkVisualsRolePlayNearBy() {
  // do all 9 possibilities ...
  int zardozX = (int)avatarPosition.x;
  int zardozY = (int)avatarPosition.y;

  for (int uix=zardozX-1; uix<(zardozX+2); uix++) {
    for (int uiy=zardozY-1; uiy<(zardozY+2); uiy++) {
      // ok check for something to paint ...
      // get var ...
      int cpm = getPlayfieldVar(uix, uiy);
      if (cpm==0) {
        boolean drawElement = false;
        String apfield = getPlayfield(uix, uiy);
        if (!apfield.equals(" ")) {
          if (!apfield.equals("x")) {
            // also dont show without digging!
            // c sword
            // w trash
            // ; key
            // d diamant
            if (!apfield.equals("d")) {
              boolean dit = true;
              if (apfield.equals("c")) dit = false;
              if (apfield.equals("w")) dit = false;
              if (apfield.equals(";")) dit = false;
              // display now and here
              if (dit) drawPlayfieldGraphicNameAt( apfield, uix, uiy );
            }
          }
        }
      }

      setPlayfieldVar(1, uix, uiy);
    }
  }
}


public void updateInGameRolePlay() {

  // start up / set graphics
  if (gameStateSubRunning.equals("")) {
    gameStateSubRunning="plotting";

    println("updateInGameMines()");

    resetLines();

    // bigger field
    playfieldWith = 22;
    playfieldHeight = 12;

    level = 0;
    life = 0;
    score = 0;


    // display playfield
    //     String[] aStr = { " "," "," "," "," ","*","*","*","*","h"," "," "," "," "," "," " ," "," " ," "," "  };
    //     randomPlayfield( aStr );
    // loadLevel ...


    // tttt
    //
    // o| |i

    // l_  p---

    // edges ..
    // r j
    // n b


    // g how / hacke
    // n spitz

    // c sword
    // w trash
    // ; key
    // d diamant

    // random ... new objects ..
    // loadLevel
    String lv = "xllllllllllxxllxxxxxxx\n"+
      "o wc   m   nb  ixxxxxx\n"+
      "o rjwrpppj     nlllllx\n"+
      "o nb nlll pppj  w ;  i\n"+
      "o     d  ixxxo  m d  i\n"+
      "xj rpppj ixxxo    d  i\n"+
      "xo nlllb ixxxo d  w  i\n"+
      "xodwg w  ixxxxpppppppx\n"+
      "xxpppjsrpxxxxxxxxxxxxx\n"+
      "xxxxxo ixxxxxxxxxxxxxx\n"+
      "xxxxxxxxxxxxxxxxxxxxx\n"+
      "  ";
    insertLevel( lv );

    //  drawPlayfield();

    avatarPosition.x = 1;
    avatarPosition.y = 1; // playfieldHeight/2;

    //    setPlayfield(" ",(int) avatarPosition.x,(int) avatarPosition.y);

    // playfieldRect(" ",0,0,playfieldWith-1,playfieldHeight-1);

    //     playfieldRect("a",0,0,playfieldWith-1,playfieldHeight-1);

    // draw houses !!!
    // drawPlayfield();


    // draw by hand
    float os = 0.0;
    float ps = playfieldTileSize;
    if (false) {
      drawLine( os, os, (playfieldWith-1)*ps+os, os );
      drawLine( os+(playfieldWith)*ps, os, os+(playfieldWith)*ps, (playfieldHeight)*ps+os );
      drawLine( (playfieldWith)*ps+os, (playfieldHeight)*ps+os, os, (playfieldHeight)*ps+os );
      drawLine( os, (playfieldHeight)*ps+os, os, os );
    }

    // drawPlayfield();

    // todo: check if there is something
    // own home?

    moveTo( avatarPosition.x+0.5, avatarPosition.y+0.5 );

    gameTimerStart = 0;

    // loading music ...
  }

  // finished
  //  gameStateSubRunning="run";
  if (gameStateSubRunning.equals("plotting")) {
    if (plotterReadForInput()) {
      gameStateSubRunning = "running";
      gameTimer = millis();
    }
  }


  if (gameStateSubRunning=="running") {

    // println("plotterNothingToDo "+plotterNothingToDo);

    // println("-"+pressedKeyChar);

    // -----------
    //  random
    //  movement
    // -----------

    // stop here ...

    /*
    if (gameTimer<millis()) {
     gameTimer = millis()+500;
     // println("NEXT EVENT");
     int irnd = (int) random(30);
     if (irnd==0) avatarPosition.x += 1;
     if (irnd==1) avatarPosition.x -= 1;
     if (irnd==2) avatarPosition.y += 1;
     if (irnd==3) avatarPosition.y -= 1;
     }
     */

    // life <1 black trail!

    String actualPlayfield = getPlayfield((int)avatarPosition.x, (int)avatarPosition.y);


    // -------------
    // dead?
    // ---------------


    // -----------
    // keys
    // -----------
    // key / controls
    // only if game is ready!!!
    if (plotterReadForInput()) {


    if (getJoystickOrKeyboard("right")) {
//      if (pressedKeyChar.equals("d")) {
        if (checkPositionRolePlayField("go", 1, 0)) {
          avatarPosition.x += 1;
        }
        pressedKeyChar = "";
      }

 //     if (pressedKeyChar.equals("a")) {
     if (getJoystickOrKeyboard("left")) {
       if (checkPositionRolePlayField("go", -1, 0)) {
          avatarPosition.x -= 1;
        }
        pressedKeyChar = "";
      }
//      if (pressedKeyChar.equals("w")) {
    if (getJoystickOrKeyboard("up")) {
        if (checkPositionRolePlayField("go", 0, -1)) {
          avatarPosition.y -= 1;
        }
        pressedKeyChar = "";
      }
//      if (pressedKeyChar.equals("s")) {
    if (getJoystickOrKeyboard("down")) {
        if (checkPositionRolePlayField("go", 0, 1)) {
          avatarPosition.y += 1;
          pressedKeyChar = "";
        }
      }

      // new position
      String newPlayfield = getPlayfield((int)avatarPosition.x, (int)avatarPosition.y);

      // -------------------
      // action here ...
      // -------------------
//      if (pressedKeyChar.equals(" ") || pressedKeyChar.equals("e")) {
    if (getJoystickOrKeyboard("action")) {

        pressedKeyChar = "";

        // spitzhacke
        if (activeTool.equals("g")) {
          if (newPlayfield.equals("d")) {
            playPing();
            // show diamant
          }
          // w
          if (newPlayfield.equals("w")) {
            playPing();
            // show trash
            drawPlayfieldGraphicNameAt( newPlayfield, (int)avatarPosition.x, (int)avatarPosition.y );
          }
          // c
          if (newPlayfield.equals("c")) {
            playPing();
            // show trash
            drawPlayfieldGraphicNameAt( newPlayfield, (int)avatarPosition.x, (int)avatarPosition.y );
          }
          // w
          if (newPlayfield.equals("w")) {
            playPing();
            // show trash
            drawPlayfieldGraphicNameAt( newPlayfield, (int)avatarPosition.x, (int)avatarPosition.y );
          }
          // ;
          if (newPlayfield.equals(";")) {
            playPing();
            // show key
            drawPlayfieldGraphicNameAt( newPlayfield, (int)avatarPosition.x, (int)avatarPosition.y );
          }
          // diamant
          if (newPlayfield.equals("d")) {
            playPing();
            // show key
            drawPlayfieldGraphicNameAt( newPlayfield, (int)avatarPosition.x, (int)avatarPosition.y );
          }

          // die ...
        }
      }

      // sword
      if (activeTool.equals("s")) {
      }








      // optional: small footstep ..
      // lineTo( avatarPosition.x+0.5f+0.1f, avatarPosition.y+0.5f );

      // in a new field
      if (avatarPosition.x!=avatarPositionOld.x || avatarPosition.y!=avatarPositionOld.y ) {
        checkVisualsRolePlayNearBy();

        moveTo( avatarPosition.x+0.5f, avatarPosition.y+0.5f );

        // check for things
        // g how / hacke
        // c sword
        // n spitz
        // w crash
        // ; key
        if (newPlayfield.equals("g")) {
          activeTool = "g";
          playPing();
        }
        if (newPlayfield.equals("c")) {
          playPing();
          activeTool = "c";
        }
      }

      // or horror? something is growing?


      avatarPositionOld.x = avatarPosition.x;
      avatarPositionOld.y = avatarPosition.y;
    }
  }

  // start again ...
  if (gameStateSubRunning.equals( "won")) {
    /*
    // wait for " "
     if (pressedKeyChar.equals(" ")) {
     gameStateSubRunning = "";
     pressedKeyChar = "";
     }
     */
  }
}



// --------------------------------------
// LINE JEWELS
// --------------------------------------

// REMAKE OF THE LINEJEWELS@CHLUDENS.CH

// IDEA: 2 stones !!!
// IDEA: 2 D
// PROBLEM: HAND?

float jplayfieldOffsetX = 1;
float jplayfieldOffsetY = 1;

float JewelsPositionX = 0;
float JewelsPositionY = 0;

float JewelsPositionXSize = 0.5;
float JewelsPositionYSize = 0.5;

String actualJewl = "w";
int actualLinePressedState = 0;
String stoneToSet = "";

int maxSizeLine = 1+7 ;

int scrollLineScore = 0;

int JewelsPositionYMax = 18; // max lines to the end of the game!

boolean oldplotter = false;

// check ...
/*
float[] arrCheckX = new float[50];
 float[] arrCheckY = new float[50];
 int arrCheckIndex = 0;
 */

public void updateInGameLineJewels() {

  // start up / set graphics
  if (gameStateSubRunning.equals("")) {
    gameStateSubRunning="start";

    println("updateInGameMines()");

    resetLines();

    // bigger field
    playfieldWith = 16;
    playfieldHeight = 12;

    level = 0;
    life = 0;
    score = 0;

    jplayfieldOffsetX = 1;
    jplayfieldOffsetY = 1;

    drawTextAt("LINEJEWELS",0.1,0.1,0.4f);


    // loading music ...
  }

  // finished
  //  gameStateSubRunning="start";
  if (gameStateSubRunning.equals("start")) {

    JewelsPositionX = 0;
    JewelsPositionY = 0;


    // random ... new objects ..
    avatarPosition.x = 0;
    avatarPosition.y = 0; // playfieldHeight/2;

    // playfieldRect("*",0,0,playfieldWith-1,playfieldHeight-1);
    // playfieldRect("a",0,0,playfieldWith-1,playfieldHeight-1);
    // draw houses !!!
    // drawPlayfield();

    // draw by hand
    /*
     float os = 0.0;
     float ps = playfieldTileSize;
     if (true) {
     drawLine( os, os, (playfieldWith-1)*ps+os, os );
     drawLine( os+(playfieldWith)*ps, os, os+(playfieldWith)*ps, (playfieldHeight)*ps+os );
     drawLine( (playfieldWith)*ps+os, (playfieldHeight)*ps+os, os, (playfieldHeight)*ps+os );
     drawLine( os, (playfieldHeight)*ps+os, os, os );
     }
     */

    actualLinePressedState = 0;

    // drawPlayfield();

    // todo: check if there is something
    // own home?



    float posix = jplayfieldOffsetX+JewelsPositionX*JewelsPositionXSize;
    float posiy = jplayfieldOffsetY+JewelsPositionY*JewelsPositionYSize;
    moveTo(posix+JewelsPositionXSize-0.1, posiy);
    lineTo(posix+JewelsPositionXSize-0.1, posiy+JewelsPositionXSize*21);
    moveTo(posix, posiy);

    gameTimerStart = 0;

    gameStateSubRunning = "plotting";
  }


  // finished
  //  gameStateSubRunning="run";
  if (gameStateSubRunning.equals("plotting")) {
    if (plotterReadForInput()) {
      gameStateSubRunning = "running";
      gameTimer = millis();
    }
  }


  if (gameStateSubRunning=="running") {

    // println("plotterNothingToDo "+plotterNothingToDo);

    boolean op = plotterReadForInput();
    if (op!=oldplotter) {
      // println("plotterready? "+op);
    }
    oldplotter = op;

    // println("-"+pressedKeyChar);

    // -----------
    //  random
    //  movement
    // -----------

    // stop here ...


    // visual position
    float posix = jplayfieldOffsetX+JewelsPositionX*JewelsPositionXSize;
    float posiy = jplayfieldOffsetY+JewelsPositionY*JewelsPositionYSize;

    int posixInt = (int)(jplayfieldOffsetX+JewelsPositionX);
    int posiyInt = (int)(jplayfieldOffsetY+JewelsPositionY);

    String ds = "LJ DEBUG" // JewelsPositionXSize
      +"\njplayfieldOffsetX: "+jplayfieldOffsetX
      +"\njplayfieldOffsetY: "+jplayfieldOffsetY
      +"\nJewelsPositionX: "+JewelsPositionX
      +"\nJewelsPositionY: "+JewelsPositionY
      +"\n\nscore: "+score
      +"\nscrollLineScore: "+scrollLineScore
      +"\nactualLinePressedState: "+actualLinePressedState;

    text(ds, width/2, 200);

    // go forward
    if (plotterReadForInput()) // only if the plotter is ready ...
    if (gameTimer<millis()) {
      //      if (plotterReadForInput()) {
      if (true) {

        gameTimer = millis()+2000;
        // println("NEXT MOVE");

        // int irnd = (int) random(30);

        String[] arrC = { "x", "y", "z" }; // ,"u" };
        int ridiot = (int)random(arrC.length);
        // println("ridiot "+ridiot);
        String NExT = arrC[ridiot];

        float stoneSize = 0.4f;

        if (JewelsPositionX==0) {
          actualJewl = arrC[(int)random(arrC.length)];
          NExT = actualJewl;
          actualLinePressedState = 0;
          scrollLineScore = 0;
          // println("NEWLINE: char: "+NExT);

          // drawTextAt("",posix,posiy,0.25);
          // drawGraphicAt(""+NExT, posix, posiy, false); // optimized
          drawTextAt(""+NExT, posix, posiy, stoneSize); // optimized
          
        }

        if (JewelsPositionX > 0) {

          if (actualLinePressedState==1) {
            NExT = actualJewl;
            setPlayfield( NExT, (int)(posixInt), (int)(posiyInt) );
          }
          // drawTextAt("",posix,posiy,0.25);
//          drawGraphicAt(""+NExT, posix, posiy, false); // optimized
          drawTextAt(""+NExT, posix, posiy, stoneSize); // optimized


          setPlayfield( NExT, (int)(posixInt), (int)(posiyInt) );
          // println(debugPlayfield((int)(jplayfieldOffsetX), (int)(jplayfieldOffsetY),10,10));

          if (actualLinePressedState==1) {
            NExT = actualJewl;
            setPlayfield( NExT, (int)(posixInt), (int)(posiyInt) );

            // playPing();

            actualLinePressedState = 2;
            // println(JewelsPositionY+" - "+JewelsPositionX+" SET STONE NOW!!!!!!!");
            // check now ...
            // checkit - fast check?
            // ...

            // results
            // arrResults

            //
            // show lines now ...
            // skip all waitings ...
            // > wait till end of line ...
            //
            int startX = (int)(posixInt);
            int startY = (int)(posiyInt);

            int lineSpec = 0;
            // max ...
            int foundSomething = 0;

            // debug playfield
            var foundT = 0;
            var val = "";

            // debug here ..
            // println(debugPlayfield((int)jplayfieldOffsetX,(int)jplayfieldOffsetY,10,10));


            var debugThis = false;

            var minMax = 0;

            // --------------
            // *
            // --------------
            debugThis = false;
            println("check up vs "+NExT);
            foundT = 0;
            val = "";
            int checkX = (int)(jplayfieldOffsetX+JewelsPositionX);
            int checkY = (int)(jplayfieldOffsetY+JewelsPositionY);
            println("----"+startY);
            float itxZ = jplayfieldOffsetX+(JewelsPositionX+0.5f)*JewelsPositionXSize;
            float ityZ = jplayfieldOffsetY+(JewelsPositionY+0.5f)*JewelsPositionYSize;

            float itx = 0.0f;
            float ity = 0.0f;

            scrollLineScore = 0;

            // -----
            // ^
            // |
            debugThis = true;
            minMax = 0;
            foundT = 0;
            for (int ix=checkY; ix>=0; ix--) {
              val = getPlayfield(checkX, ix);
              // break;
              if (debugThis) println("   v "+ix+": "+val);
              if (val.equals(NExT)) {
                foundT++;
                minMax = ix-1;
              } else {
                break;
              }
            }
            // new score
            if (foundT>2) {
              // lineSpec = (foundT*10 + (foundT-3)*10)*3;
              lineSpec = foundT;

              if (debugThis) println("line up: "+lineSpec);
              scrollLineScore += lineSpec;
              // add line now ...
              moveTo(itxZ, ityZ);

              //            float itxZ = jplayfieldOffsetX+(JewelsPositionX+0.5f)*JewelsPositionXSize;
              //            float ityZ = jplayfieldOffsetY+(JewelsPositionY+0.5f)*JewelsPositionYSize;

              //   itx = jplayfieldOffsetX+(checkX-1.0f+0.5f)*JewelsPositionXSize;
              //   ity = jplayfieldOffsetY+(minMax+0.5f)*JewelsPositionYSize;

              itx = jplayfieldOffsetX+(checkX-jplayfieldOffsetX+0.5f)*JewelsPositionXSize;
              ity = jplayfieldOffsetY+(minMax-jplayfieldOffsetY+1.0f+0.5f)*JewelsPositionYSize;


              lineTo(itx, ity);
              moveTo(itxZ, ityZ);
              playPing();
            }

            // -----
            // ^
            //  \
            debugThis = false;
            minMax = 0;
            foundT = 0;
            int cxt = checkY;
            for (int ix=checkX; ix>=1; ix--) { // not x?
              val = getPlayfield(ix, cxt);
              // break;
              if (debugThis)  println("    "+ix+"/"+cxt+": "+val);
              if (val.equals(NExT)) {
                foundT++;
                minMax = ix;
                cxt--;
              } else {
                break;
              }
            }
            if (debugThis) {
              println("line left: size: "+foundT);
            }
            // new score
            if (foundT>2) {
              // lineSpec = (foundT*10 + (foundT-3)*10)*3;
              lineSpec = foundT*2;

              if (debugThis)  println("line left: "+lineSpec);
              scrollLineScore += lineSpec;
              // add line now ...
              moveTo(itxZ, ityZ);

              itx = jplayfieldOffsetX+(minMax-jplayfieldOffsetX-1.0f+0.5f)*JewelsPositionXSize;
              ity = jplayfieldOffsetY+(cxt-jplayfieldOffsetY+0.5f)*JewelsPositionYSize;


              lineTo(itx, ity);
              moveTo(posix, posiy);
              playPing();
            }

            // -----
            //  ^
            // /
            debugThis = false;
            minMax = 0;
            foundT = 0;
            cxt = checkY;
            for (int ix=checkX; ix<maxSizeLine; ix++) { // not x?
              val = getPlayfield(ix, cxt);
              // break;
              if (debugThis)  println("    "+ix+"/"+cxt+": "+val);
              if (val.equals(NExT)) {
                foundT++;
                minMax = ix;
                cxt--;
              } else {
                break;
              }
            }
            if (debugThis) {
              println("line left: size: "+foundT);
            }
            // new score
            if (foundT>2) {
              // lineSpec = (foundT*10 + (foundT-3)*10)*3;
              lineSpec = foundT*2;

              if (debugThis)  println("line left: "+lineSpec);
              scrollLineScore += lineSpec;
              // add line now ...
              moveTo(itxZ, ityZ);

              itx = jplayfieldOffsetX+(minMax-jplayfieldOffsetX+0.5f)*JewelsPositionXSize+0.1;
              ity = jplayfieldOffsetY+(cxt-jplayfieldOffsetY+0.5f)*JewelsPositionYSize+0.1;

              lineTo(itx, ity);
              moveTo(posix, posiy);
              playPing();
            }

            // -----
            //
            // <----
            debugThis = false;
            minMax = 0;
            foundT = 0;
            for (int ix=checkX; ix>=1; ix--) {
              val = getPlayfield(ix, checkY);
              // break;
              if (debugThis) println("   v "+ix+": "+val);
              if (val.equals(NExT)) {
                foundT++;
                minMax = ix;
              } else {
                // minMax = ix-1;
                break;
              }
            }
            // new score
            if (foundT>2) {
              // lineSpec = ((foundT*10 + (foundT-3)*10)*3)*2;
              lineSpec = foundT*3;

              if (debugThis) println("line left only: "+lineSpec);
              scrollLineScore += lineSpec;
              // add line now ...
              moveTo(itxZ, ityZ);
              itx = jplayfieldOffsetX+(minMax-jplayfieldOffsetX+0.5f)*JewelsPositionXSize; // +0.5f;
              ity = jplayfieldOffsetY+(checkY-jplayfieldOffsetY+0.5f)*JewelsPositionYSize; // +0.5f;
              lineTo(itx, ity);
              moveTo(itxZ, itxZ);
              playPing();
            }
            if (debugThis) println("scoreLine: "+scrollLineScore);

            // score
            score += scrollLineScore;
          }
        }


        // go forward
        JewelsPositionX +=1;


        // -------------------------
        // next game
        // -------------------------
        // 10
        if (JewelsPositionX==maxSizeLine) {

          // finish old
          JewelsPositionX = 0;
          JewelsPositionY +=1;

          // end of a game
          if (JewelsPositionY>JewelsPositionYMax) {
            // score !!!
            // draw
            drawTextAt(""+score, jplayfieldOffsetX+JewelsPositionXSize+0.4, jplayfieldOffsetY+(JewelsPositionYMax+2)*JewelsPositionXSize, 0.4f);
            gameStateSubRunning = "waitnextgame";
          }

          // actualLinePressedState = 0;

          //          drawGraphicAt(""+actualJewl,posix,posiy,false);
        }
      }
      // faster all line to !!!

      // next line ..
      // moveTo(posix,posiy);



      /*
          int jplayfieldOffsetX = 0;
       int jplayfieldOffsetY = 0;
       
       int JewelsPositionX = 0;
       int JewelsPositionY = 0;
       */
    }


    // life <1 black trail!

    String actualPlayfield = getPlayfield((int)avatarPosition.x, (int)avatarPosition.y);


    // start again ...
    if (gameStateSubRunning.equals( "won")) {
      /*
      // wait for " "
       if (pressedKeyChar.equals(" ")) {
       gameStateSubRunning = "";
       pressedKeyChar = "";
       }
       */
    }


    // -----------
    // keys
    // -----------
    // key / controls
    // only if game is ready!!!

//    if ((pressedKeyChar.equals(" "))||(pressedKeyChar.equals("e"))) {
     if (getJoystickOrKeyboard("action")) {
      
      // println("space");
      // set
      if (actualLinePressedState==0) {
        actualLinePressedState = 1;
        println(JewelsPositionY+" PRESS E > SET STONE");

        // todo: bling sound !!!
        playPing();
      } else {
        // println("SORRY PRINTED!");
      }

      pressedKeyChar = "";
    }
  }

  // waitfornextgame
  if (gameStateSubRunning.equals("waitnextgame")) {

    if (plotterReadForInput()) {

      // if ((pressedKeyChar.equals(" "))||(pressedKeyChar.equals("e"))) {
        if (getJoystickOrKeyboard("action")) {

        int opv = (int) jplayfieldOffsetX;
        jplayfieldOffsetX +=  ((int)(maxSizeLine*JewelsPositionXSize))+1;

        JewelsPositionX = 0;
        JewelsPositionY = 0;

        score = 0;

        gameStateSubRunning = "start";

        if (jplayfieldOffsetX>playfieldWith) {

          // new ... paper ...
          gameStateSubRunning = "restart";
          drawTextAt("PAPER!", opv+JewelsPositionXSize+0.4, jplayfieldOffsetY+(JewelsPositionYMax+4)*JewelsPositionXSize, 0.4f);
          moveTo( opv+JewelsPositionXSize+0.4, jplayfieldOffsetY+(JewelsPositionYMax+4)*JewelsPositionXSize );
        }

        pressedKeyChar = "";
      }
    }
  }

  // restart
  if (gameStateSubRunning.equals("restart")) {

    if (plotterReadForInput()) {

      // if ((pressedKeyChar.equals(" "))||(pressedKeyChar.equals("e"))) {
      if (getJoystickOrKeyboard("action")) {  
        gameStateSubRunning = "";

        pressedKeyChar = "";
      }
    }
  }
}


// --------------------------------------
// DemoTypes
// --------------------------------------

float radius = 1.0f;
int demoCounter = 0;

String demoMode = "demoscener"; // '' 'perfect' 'circle' 'flower' 'band' 'drunkenperfect'
String demoModeSub = "";

String walkMode = ""; // walk down | walk left

int behavior = 0;
  
float startPointX = 1.0f;
float startPointY = 1.0f;

int demoCounterSpeed = 0; // max counter ... 

float homeX = 0.0f;
float homeY = 0.0f;

float workX = 0.0f;
float workY = 0.0f;
              
String[] drunkenActions={"ZZZ","BULP","FCK ALCOHOL","OH NO","I AM DRUNK","TOO MUCH","SHIT","INY","NOO","DEMO?","HOME?","LEFT?","HEY","CPX","LDA"};               

String[] arrAreas={"PARTY","PARTY","FRIENDS","OHCP","MOUTAIN","BYTES"};

boolean partDone = true;

float demoFontSize = 0.25; // 0.3 ?? 
              
public void updateInGameTennisForDemoTypes() {
   // start up / set graphics
  if (gameStateSubRunning.equals("")) {
    gameStateSubRunning="start";

    // bigger field
    playfieldWith = 16;
    playfieldHeight = 17; // 8 - less distance less drawtime

    ballVx = 0.0f;
    ballVy = 0.0f;

    println("updateInGameDemoTypes()");

    resetLines();
    
    drawTextAt( "CYBERLOOPZ", 0.1f, 0.1f, 0.5f );
    
    
    partDone = false;
    
    // drawTextLINESAt( "ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789 ; - . ", 0.5f, 0.5f, 1.0f );
    // drawTextAt( "ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789 ; - . ", 0.5f, 0.5f, 1.0f );
    
  }
  
  if (gameStateSubRunning.equals("start")) {
    
    gameStateSubRunning="plotting";


    startPointX = random(0.5,2.5f);
    startPointY = random(1.0f,5.5f);
  
    avatarPosition.x = startPointX;
    avatarPosition.y = startPointY; 

    moveTo(avatarPosition.x,avatarPosition.y);
    
    demoCounterSpeed = 100;

    gameTimerStart = 0;
    
    
    // move now 
    demoMode = "demoscener"; // '' 'perfect' 'circle' 'flower' 'band' 'drunkenperfect'
    demoModeSub = "demo";

  }

  // finished
  //  gameStateSubRunning="run";
  if (gameStateSubRunning.equals("plotting")) {
    if (plotterReadForInput()) {
      gameStateSubRunning = "running";
      gameTimer = millis();
      gameTimerStart =  millis();
    }
  }


  if (gameStateSubRunning=="running") {

                
        text("#demomode "+demoMode+"\n"+demoModeSub+"\ntime:"+(int)(gameTimer/1000),50,570);
      
        gameTimer = millis() - gameTimerStart;
        
        /*
        if (demoMode=="perfect") { // sin
          
            ballVx = 0.01;
            avatarPosition.x += ballVx;
            avatarPosition.y = startPointX+ sin(gameTimer/1000.0f)*2.0f;
  
            lineTo(avatarPosition.x,avatarPosition.y);        
        }
        
        if (demoMode=="circle") {
        
            ballVx = 0.01;
            avatarPosition.x = startPointX+ cos(gameTimer/1000.0f)*2.0f;
            avatarPosition.y = startPointY+ sin(gameTimer/1000.0f)*2.0f;
  
            lineTo(avatarPosition.x,avatarPosition.y);        

          
        }

        // regelgrafiken 
        if (demoMode=="flower") {
        
            ballVx = 0.01;
            radius += 0.001f;
            avatarPosition.x = startPointX+ cos(gameTimer/1000.0f)*radius;
            avatarPosition.y = startPointY+ sin(gameTimer/1000.0f)*radius;
  
            lineTo(avatarPosition.x,avatarPosition.y);                  
        }

        if (demoMode=="band") {
              ballVx = 0.01;    
              
            avatarPosition.x += ballVx;
    
            avatarPosition.y = startPointX + sin(gameTimer/1000.0f)*2.0;        
            float offsetix = avatarPosition.x + sin(cos(gameTimer/1000.0f)*avatarPosition.y)*3.0f;
            
            lineTo(offsetix,avatarPosition.y);        

       } 
        
        if (demoMode=="drunkenperfect") {
              ballVx = 0.01;
                  
              
              
    //         avatarPosition.x = 3.0f + cos(gameTimer/10.0f)*4.0;        
    
            avatarPosition.y = startPointX + sin(gameTimer/1000.0f)*2.0;        
            float offsetix = avatarPosition.x + sin(cos(gameTimer/1000.0f)*avatarPosition.y)*3.0f;
            
            float mA = -0.1;
            float mB = 0.1;
            
            if ((int)(gameTimer/1000)%2==0) {
              mA = 0;
              mB = 0;
            }
            
              avatarPosition.x += random(mA,mB);
              avatarPosition.y += random(mA,mB);
       
              lineTo(offsetix,avatarPosition.y);        

       }
       */
        
       // 
       // demoparty
       // 
       // walk home
       // inspired by warja lavater 
       // 
       // 
       
       // -----------------
       // DEMO PART
       // -----------------
       // the normal thing
       if (demoMode=="demoscener") {
                  
          
         // making a demo
         // full speed
         if (demoModeSub.equals("demo")) {
           
               // demos 
               int demoType = 5; // 5
               
               demoType = (int) random(0,7);
               
                 // ballVx += 0.1f;
             
                // show a little bit of a demo ...
                // random size !!!

int startDemo = 150;
int stopDemo =  220;
                
                int maxSize = (int) random(startDemo,stopDemo);
                for (int i=0;i<maxSize;i++) {
                  
                  // the lines ... 
                  
                  float ot = i;
                  
                  // cool lines OOOO
                  float offsetix = 0.0f;
                  float offsetiy = 0.0f;

// demoType = 1;
                  
                  if (demoType==0) { // OOOOOOOOOOO
                     ballVx = 0.075f;
                     avatarPosition.x += ballVx; 
                     offsetix = cos(ot)*0.5f;
                     offsetiy = sin(ot)*0.5f;  
                  }
                  
                  if (demoType==1) {
                    ot = i/2.0f;
                    avatarPosition.x += 0.08f; // 0.05f; 
                    offsetix = 0;
                    offsetiy = sin(ot/2.5f)*1.5f;                       
                  }

                  if (demoType==2) {
                    ot = i/2.0f;
                    avatarPosition.x += 0.08f; 
                    offsetix = 0;
                    offsetiy = sin(ot)*0.5f;                       
                  }
                  
                  if (demoType==3) {
                    ot = i/2.0f;
                    avatarPosition.x += 0.05f; 
                    offsetix = cos(ot)*0.5f+cos(avatarPosition.y);
                    offsetiy = sin(ot)*0.5f+sin(avatarPosition.x);                       
                  }
                  
                  if (demoType==4) {
                    offsetix = cos(ot)*1.0f;
                    offsetiy = sin(ot)*1.0f;                     
                    if (i%20==0) {
                        avatarPosition.x += 1.5f;
                    }
                  }

                  if (demoType==5) {
                    offsetix = cos(ot)*0.5f;
                    offsetiy = sin(ot)*0.5f;                     
                    if (i<200) {
                      if (i%10==0) {
                          avatarPosition.x += 1.0f;
                      }
                    }
                  }

          
                  if (demoType==6) {
                    offsetix = 0;
                    offsetiy = 0;
                    if (i%20==0) {
                        avatarPosition.x += 0.5f;
                    }
                    if (i%20==5) {
                        avatarPosition.y += 0.5f;
                    }
                    if (i%20==15) {
                        avatarPosition.x += 0.5f;
                    }
                    if (i%20==19) {
                        avatarPosition.y -= 0.5f;
                    }
                    
                    // _| |_ doors 
                    if (false) {
                      lineTo(avatarPosition.x+0.5f,avatarPosition.y);
                      lineTo(avatarPosition.x+0.5f,avatarPosition.y+0.5f);
                      lineTo(avatarPosition.x+0.5f+0.5f,avatarPosition.y+0.5f);
                      lineTo(avatarPosition.x+0.5f+0.5f,avatarPosition.y+0.0f);
                    }
                  }
                  
                  // draw ... wow ... 
  
                  float rx = avatarPosition.x+offsetix;
                  float ry = avatarPosition.y+offsetiy-0.5f;
                
                  
                  if (i>50&&i<maxSize-40) {
                    if (random(0,60)<1) {
                      moveTo(rx,ry);
                      drawTextAt("WOW",rx,ry,0.25f);
                      moveTo(rx,avatarPosition.y+offsetiy);
                    }
                  }
                  
                  if (i==(maxSize-2)) {
                    moveTo(rx,ry);
                    drawTextAt("  I GO HOME!",rx,ry,0.25f); 
                    moveTo(rx,avatarPosition.y+offsetiy);
                  }
                  
                  // circles

                  
                  if (i==0) {
                    if (!partDone) {
                      moveTo(avatarPosition.x+offsetix,avatarPosition.y+offsetiy);
                      drawTextAt("PARTY!",avatarPosition.x-1.0f,avatarPosition.y-1.0f, 0.5f);
                      drawTextAt("DEMO:",avatarPosition.x-1.0f,avatarPosition.y-0.5f, 0.5f);
                      moveTo(avatarPosition.x+offsetix,avatarPosition.y+offsetiy);
                      partDone = true; 
                    }
                  }
                  lineTo(avatarPosition.x+offsetix,avatarPosition.y+offsetiy);
                  
                }
                
                
                demoModeSub = "wait";
           }
        
         demoCounter++;         

demoCounterSpeed = 10;         
         
         if (demoCounter>demoCounterSpeed) {
           demoCounter = 0;
           
           // demoCounterSpeed--;
           
           // 1. beatiful demo & dancing

           // 2. going outside _| |_
           
           // 3. drunken walking in a direction ... slowly like a ball
          
           
             
          
           // walk > random 
           if (demoModeSub.equals("")) {
               float mA = -0.25f;
               float mB = 0.25f;
               
               float offsetiX = 0.0f;
               float offsetiY = 0.0f;
      
               offsetiX += random(mA,mB);
               offsetiY += random(mA,mB);
             
               lineTo(avatarPosition.x+offsetiX,avatarPosition.y+offsetiY);    
               
               avatarPosition.x += 0.0f;
               avatarPosition.y += 0.1f;
               
               // some directions ... 
               
               // objects ... found near .. .
               
               walkMode = "";
           
               // random stuff
               // randomness
               
               String[] walkActions = {"text","text","text","text","remember"};
               // if (false)
               if (random(0,30)<1) { 
               int NExTStep=(int)(random(0,walkActions.length));
 
                 demoModeSub = "text"; 
                 demoModeSub = ""+walkActions[NExTStep];
                 println("NExTStep "+demoModeSub); 
               }
               
               // walk ... 
               if (random(0,10)<1) {
                 // demoModeSub = "walkleft";
               }
               
               if (avatarPosition.y>(playfieldHeight*2/3)) {
                 if ((random(0,100)<1)||(avatarPosition.y>(playfieldHeight-1))) {
                      demoModeSub = "walkleft";
                 }
               }

// demoModeSub = "walkleft";

         }
           
               // walk left
               if (demoModeSub.equals("walkleft")) {
                     float mA = -0.25f;
                     float mB = 0.25f;
                     
                     float offsetiX = 0.0f;
                     float offsetiY = 0.0f;
            
                     offsetiX += random(mA,mB);
                     offsetiY += random(mA,mB);
                   
                     lineTo(avatarPosition.x+offsetiX,avatarPosition.y+offsetiY);    
                     
                     avatarPosition.x -= 0.1f;
                     avatarPosition.y += 0.0f;
                     
                     // some directions ... 
                     
                     // objects ... found near .. .
                     
                     walkMode = "left";    
                 
                     // random stuff
                     // randomness
                     
                     // if (false)
                     if (random(0,50)<1) { 
                     String[] leftActions={"text"};
                     int NExTStep=(int)(random(0,leftActions.length));
       
                       demoModeSub = "text"; 
                       demoModeSub = ""+leftActions[NExTStep];
                       println("NExTStep "+demoModeSub); 
                       
                       // demoModeSub = "wait"+""; 
                     }
                     
                     // demoModeSub = "wait"+"walkleft";
                     
                     if (random(0,20)<1) {
                         // demoModeSub = "";
                     }
                     
                     // home .. 
                     if (avatarPosition.x<(playfieldHeight*2/3)) {
                         if ((random(0,10)<1)||(avatarPosition.x<8.0f)) {
                            // and then wait                             
                            drawTextAt("HOME", avatarPosition.x-1.0f, avatarPosition.y+random(-1.0f,1.0f),demoFontSize);   
                            homeX = avatarPosition.x- 0.5f;
                            homeY = avatarPosition.y- 0.1f;
                            demoModeSub = "homearound";
                         }
                     }
                 }
                 
           
           
           
           // events ... 
           // text
           if (demoModeSub.equals("text")) {
              println("text"); 
              
              // texts ... 
              String strText = "";
              
//              String[] drunkenActions={"SHIT","Z","ZZ","?","UFF","NO","INX","INA","INY","DEC","HEY","I HATE DEMOS","CRACK IT","DIGITAL!","FUTURE!"};
//              String[] drunkenActions={"SHIT","Z","ZZ","?","UFF","NO","FCK","INX","INA","INY","DEC","HEY","I HATE DEMOS","CRACK IT","DIGITAL!","FUTURE!"};
  
             
            if (walkMode.equals("left")) {
                // drunkenActions={"ZZZ","SHIT","DEX","NO","HOME?" };
             }
             
              int NExTStep=(int)(random(0,drunkenActions.length));   
              strText = drunkenActions[NExTStep];
              
              // shit ?
              if (strText.equals("SHIT")) {
                  avatarPosition.x += 1.0f;
                  lineTo(avatarPosition.x,avatarPosition.y);
              }
              /// shit ?
              if (strText.equals("NO")) {
                  avatarPosition.x -= 1.0f;
                  lineTo(avatarPosition.x,avatarPosition.y);
              }
              if (strText.equals("FCK")) {
                  avatarPosition.y += 1.0f;
                  lineTo(avatarPosition.x,avatarPosition.y);
              }

              
              float offsetTextX = random(0.3,0.5);
              float offsetTextY = random(0.0,0.0);
              if (walkMode.equals("left"))  offsetTextY = random(-0.2,1.2);
              
               drawTextAt(strText, avatarPosition.x+offsetTextX, avatarPosition.y-0.2f+offsetTextY,demoFontSize);              
               moveTo(avatarPosition.x, avatarPosition.y);
             //  behavior+= 1.0f;
               demoModeSub = "wait" + "";
               if (walkMode.equals("left")) demoModeSub = "wait" + "walkleft";

         }
           
           if (demoModeSub.equals("smoke")) {
              println("smoke"); 
              
              float offsetTextX = 0.0f;
              float offsetTextY = 0.0f;
              
              for (int n=0;n<10;n++) {
                offsetTextY -= 0.1f;                 
                lineTo(avatarPosition.x+offsetTextX,avatarPosition.y+offsetTextY);                  
              }
              
              moveTo(avatarPosition.x, avatarPosition.y);
              
              demoModeSub = "wait" + "";
           }
           
           // text
           if (demoModeSub.equals("area")) {
              println("area"); 
              /*
              // texts ... 
              String strText = "";
              
              String[] drunkenActions={"HOME","WORK","SCHOOL","RESTAURANT","CINEMA","SUPERMARKET","BTX","POST"};
              int NExTStep=(int)(random(0,drunkenActions.length));   
              strText = drunkenActions[NExTStep];
              
              float offsetTextX = random(0+1.0f,playfieldWith-2.0f);
              float offsetTextY = random(0+3.0f,playfieldHeight-2.0f)-1.0f;
              moveTo(avatarPosition.x, avatarPosition.y);
              drawTextAt(strText, offsetTextX, offsetTextY,0.3f);              
               moveTo(avatarPosition.x, avatarPosition.y);
             //  behavior+= 1.0f;
             */
               demoModeSub = "wait" + "";
               if (walkMode.equals("left")) demoModeSub = "wait" + "walkleft";
         }
           
           
           if (demoModeSub.equals("remember")) {
              println("remember"); 
              
              /*
              // texts ... 
              String strText = "";
              
              int NExTStep=(int)(random(0,arrAreas.length));   
              strText = arrAreas[NExTStep];
              
              arrAreas[NExTStep] = "";
              
              if (!strText.equals("")) {
                
                float offsetTextX = random(0.1,1.0f);
                float offsetTextY = random(0.1,1.0f);
                
                moveTo(  offsetTextX, 0.4f+offsetTextY );
                drawTextAt(strText, offsetTextX, offsetTextY,0.3f);              
                 moveTo(avatarPosition.x, avatarPosition.y);
                 // behavior+= 1.0f;
              
              }
              */
              demoModeSub = "wait" + "";
               if (walkMode.equals("left")) demoModeSub = "wait" + "walkleft";
           }
           
           // around the home ... 
           if (demoModeSub.equals("homearound")) {
              println("homearound"); 
              
              for (int v=0;v<30;v++) {
                ballVx = 0.01;
                avatarPosition.x = homeX+ cos((gameTimer+v*300)/1000.0f)*0.5f;
                avatarPosition.y = homeY+ sin((gameTimer+v*300)/1000.0f)*0.5f;    
                lineTo(avatarPosition.x,avatarPosition.y);        
              }
              
                            // random code ...
              if (random(0,8)<1) {
                drawTextAt("CODING", avatarPosition.x-random(-0.5f,0.5f), avatarPosition.y-2.0f-random(-0.5f,0.5f),demoFontSize); 
              }
              if (random(0,15)<1) {
                drawTextAt("SIZECODING", avatarPosition.x-random(-0.5f,0.5f), avatarPosition.y-2.0f,demoFontSize); 
              }


              demoModeSub = "wait" + "workbuild";
              
              
           }
          
          // home, work, girlfriend ..
           if (demoModeSub.equals("workbuild")) {
              println("workaround"); 

             if (workX==0) {
               workX = homeX - 1.5f;
               workY = homeY - 0.0f;
               drawTextAt("WORK", workX-0.2f, workY ,0.2f);   
              }

             
              
              // random 
              demoModeSub = "wait" + "workaround";
              
              // got to the start?
              if (random(0,3)<1) {
                 lineTo(startPointX,startPointY); 
                 gameStateSubRunning = "start";
              }
              
           }
           
           // home, work, girlfriend ..
           if (demoModeSub.equals("workaround")) {
              println("workaround"); 
              
              for (int v=0;v<30;v++) {
                ballVx = 0.01;
                avatarPosition.x = workX+ cos((gameTimer+v*300)/1000.0f)*0.5f;
                avatarPosition.y = workY+ sin((gameTimer+v*300)/1000.0f)*0.5f;    
                lineTo(avatarPosition.x,avatarPosition.y);        
              }
              
              
              
              // random 
              demoModeSub = "wait" + "homearound";
              
           }
           
          
           // smoke ...
           // sinus up?
           
           
           
           // wait till the plotter is ready ... 
           if (demoModeSub.indexOf("wait")==0) {
               if (plotterReadForInput()) {
                   demoModeSub = demoModeSub.substring("wait".length());
               }
           }
           
           // ideas:
           // start - creates something else !!!
           
         }
         
       }
       
       
       

  }

}

// -----------------------------------------------------------
// Realtime ... Write directly on the plotter pen (up/down)
// ------------------------------------------------------------
// not working 
// the plotter is not really 

// some graphics
ArrayList<PVector> arrGraphicsReal = new ArrayList<PVector>();
ArrayList<Line> arrGraphicsRealLines = new ArrayList<Line>();

String realTimeMode = "";

boolean penStateTime = false;

int gameTimeTimeO =0;


String timerState = "";
int waitForTime = 0;
boolean realTimePen = false;

public void updateInGameRealtime() {
   // start up / set graphics
  if (gameStateSubRunning.equals("")) {
    gameStateSubRunning="start";

    // bigger field
    playfieldWith = 16;
    playfieldHeight = 12; // 8 - less distance less drawtime

    ballVx = 0.0f;
    ballVy = 0.0f;

    println("updateInGameRealTime()");
    

    resetLines();
    
    // drawTextAt( "REALTIMEGRAPHICS", 0.1f, 0.1f, 0.5f );
    
    partDone = false;
    


  }
  
  if (gameStateSubRunning.equals("start")) {
    
    gameStateSubRunning="plotting";


    // random
    PVector fv = new PVector();
    PVector ov = new PVector();
    int maxR = 10;
    for (int i=0;i<maxR;i++) {
        
      PVector pv = new PVector(random(0,playfieldWith),random(0,playfieldHeight));
      if (i==0) fv = pv;
      if (i<(maxR-1)) {
          arrGraphicsReal.add(new PVector(pv.x,pv.y));  
      }
      if (i>1) { 
         Line pl = new Line();  
         pl.p1 = new PVector(ov.x, ov.y);
         pl.p2 = new PVector(pv.x, pv.y);  
         arrGraphicsRealLines.add(pl);
      }
      
       ov = pv; 
    }
    
     arrGraphicsReal.add(fv);
    
   // mot to start 
    PVector pr = arrGraphicsReal.get(0);
    avatarPosition.x = pr.x;
    avatarPosition.y = pr.y;
    moveTo(avatarPosition.x,avatarPosition.y);
    
    demoCounterSpeed = 100;

    gameTimerStart = 0;
    
    
    waitForTime = millis();

    PVector or;
      for (int u=0;u<arrGraphicsReal.size();u++) {
          or = arrGraphicsReal.get(u);
          moveFreeTo(or.x,or.y);        
      }
            
    
  }

  // finished
  //  gameStateSubRunning="run";
  if (gameStateSubRunning.equals("plotting")) {
    
    // during plotting show .. 
      if (millis()>waitForTime) {
        
        println("next waitfortime "+millis()+"   "+realTimePen);
        
            waitForTime = millis()+300;
            realTimePen = !realTimePen;
            /*
            if (timerState.equals("turndown")) {
               if (realTimePen) penUpNoWaitPlotter();
               println("realtime: penup");
               timerState = "";
            }
            */
            if (realTimePen)  penUpNoWaitPlotter();
            if (!realTimePen) penDownNoWaitPlotter();
        }    
    
      if (plotterReadForInput()) {
        gameStateSubRunning = "running";
        gameTimer = millis();
        gameTimerStart =  millis();
      }
  }


  if (gameStateSubRunning=="running") {

      text("#realtime-experiments",50,570);

      /*
      // ok show now ... 
      if (realTimeMode=="") {
        
        PVector or;
        for (int u=0;u<arrGraphicsReal.size();u++) {
            or = arrGraphicsReal.get(u);
            moveFreeTo(or.x,or.y);        
        }
        
        gameTimerStart =  millis();
        
        realTimeMode = "ridethepen";
      }
        
      // ride the pen
      if (realTimeMode=="ridethepen") {
        
        // 
        
        // you can also up and down the pen with the 
        // hold down = hold the pen down? (gestic?)
        
        // or small 0.1f next to this !!!
        // ((
        
        // random
        if (false) {
          if (random(0,50*4)<1) { penDownNoWait(); } 
          if (random(0,50*4)<1) { penUpNoWait(); } 
        }
        
        // cascades
        if (millis()>waitForTime) {
            if (timerState.equals("")) {
              waitForTime = millis()+300;
              penDownNoWaitPlotter();
               println("realtime: pendown");
              timerState = "turndown";
            }
        }
        
        if (millis()>waitForTime) {
            waitForTime = millis()+300;
            if (timerState.equals("turndown")) {
               penUpNoWaitPlotter();
               println("realtime: penup");
               timerState = "";
            }
        }




        
        // really ... check if pushed or joystick
        if (false) {
          if ((pressedKeyChar.equals(" "))||(pressedKeyChar.equals("e"))) {
             penDownNoWait(); 
          } else {
  //           penUpNoWait(); 
          }  
        }

        // switch 
        if (getJoystickOrKeyboard("action")) {
           penStateTime=!penStateTime;
           if (penStateTime) penDownNoWait(); 
           if (!penStateTime) penUpNoWait(); 
           
        }

        
      }
      */
    
  }
}

// -----------------------------------------------------------
// Jump! Simple realtime jump game
// ------------------------------------------------------------

public void updateInGameJump() {
  
   // start up / set graphics
  if (gameStateSubRunning.equals("")) {
    gameStateSubRunning="start";

    // bigger field
    playfieldWith = 16;
    playfieldHeight = 17; // 8 - less distance less drawtime

 
    println("updateInGameDemoTypes()");

    resetLines();
    
    drawTextAt( "CYBERLOOPZ", 0.1f, 0.1f, 0.5f );
    
    
    partDone = false;
    
    // drawTextLINESAt( "ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789 ; - . ", 0.5f, 0.5f, 1.0f );
    // drawTextAt( "ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789 ; - . ", 0.5f, 0.5f, 1.0f );
    
  }
  
  if (gameStateSubRunning.equals("start")) {
    
    gameStateSubRunning="plotting";


    startPointX = random(0.5,2.5f);
    startPointY = random(1.0f,5.5f);
  
    avatarPosition.x = startPointX;
    avatarPosition.y = startPointY; 

    moveTo(avatarPosition.x,avatarPosition.y);
    
    demoCounterSpeed = 100;

    gameTimerStart = 0;
    
    
    // move now 
    demoMode = "demoscener"; // '' 'perfect' 'circle' 'flower' 'band' 'drunkenperfect'
    demoModeSub = "demo";

  }

  // finished
  //  gameStateSubRunning="run";
  if (gameStateSubRunning.equals("plotting")) {
    if (plotterReadForInput()) {
      gameStateSubRunning = "running";
      gameTimer = millis();
      gameTimerStart =  millis();
    }
  }


  if (gameStateSubRunning=="running") {

                
        text("#demomode "+demoMode+"\n"+demoModeSub+"\ntime:"+(int)(gameTimer/1000),50,570);
    
  }
}



// --------------------------------------
// TENNIS 4 TWO
// --------------------------------------
// THE WORLDS FIRST RADICAL GAME
// TRY OUT: SMALLER AND FASTER

/*
  0 wait for start
 1 in the
 2 interactionDone
 
 */

int tennisForTwoMode = 0; // 0: 1/1 1:only one joystick 2: vs 'ai'

int playerStart = 1;

float ballVxSpeed = 0.40;
float ballVySpeed = 0.001; // graviation

float ballVx = ballVxSpeed; // default
float ballVy = 0.003;

float ballVyGravitation = 0.015;

float breakIt = 0.001f; //  0.001f; // slow down / air friction

float player0Alpha = 0.0f; // ---> 0 / <0 \ >0 rad
float player1Alpha = 0.0f; // ---> 0 / <0 \ >0 rad


int tennisForTwoAxisX[] = {0,0};
int tennisForTwoAxisY[] = {0,0};
int tennisForTwoButtonAction[] = {0,0};
int tennisForTwoButton[] = {0,0};
int tennisForTwoButtonOld[] = {0,0};

// ball

int ballWait = 0;
int ballStart = 0;

int ballSide = 0;
int ballSideOld = 0;

int ballSideInteraction = 0;

int ballSideChange = 0;

int ballOnGroundThisSide = 0;

boolean ballLocked = false;




// 0-1.0
PVector getVectorFromAlpha( float alpha ) {

  PVector pv = new PVector();

  float alphaRad = alpha; // older idea of 0-1 alpha * 6.28f;

  // sin(0)

  pv.x = cos(alphaRad);
  pv.y = sin(alphaRad);

  return pv;
}

void lostBall() {

  ballVx = 0.0f;
  ballVy = 0.0f;

  ballSideChange = 0;
  ballOnGroundThisSide = 0;

  ballSideInteraction = 0;

  ballLocked = true;

  if (playerStart==0) {
    playerStart=1;
  } else {
    playerStart = 0;
  }


  // go to the other side

  // start again ...
  if (playerStart==0) {
    avatarPosition.x = playfieldWith/8;
    avatarPosition.y = playfieldHeight*7/8; // playfieldHeight/2;

    moveTo(avatarPosition.x, avatarPosition.y);
  }
  if (playerStart==1) {
    avatarPosition.x = playfieldWith*7/8;
    avatarPosition.y = playfieldHeight*7/8; // playfieldHeight/2;

    moveTo(avatarPosition.x, avatarPosition.y);
  }
}


public void updateInGameTennisForTwo() {

  // println("updateInGameTennisForTwo()");
  
  // use osc
  updateOSCTennisForTwo(); 
  
  // special gui
  textSize(14);
  
  fill(0);
  
  String str = "# OSC (UDP) \n";

  str += "\nSetup: 2 DualSense Sony. ";
  str += "\nSending on Mac with JOYOSC";
  str += "\n\n# oscport 127.0.0.1 9007";
  str += "\n#  the osc port in is 9007. send your data here. ";
  str += "\n";
  for (int z=0;z<2;z++) {
    str += "\n \nController "+(z+1)+": (redirected here)";
    str += "\n/joyosc/devices/ps0/ 'leftx',100 "+tennisForTwoAxisX[z]+" // -32000-32000";
    str += "\n/joyosc/devices/ps0/ 'lefty',100 "+tennisForTwoAxisY[z]+"";
    str += "\n/joyosc/devices/ps0/ 'a',0 "+tennisForTwoButton[z]+" // 0||1";
  }
  str += "\n";

  text(""+str, 820, 420);

// start up / set graphics
  if (gameStateSubRunning.equals("")) {
    gameStateSubRunning="plotting";

    println("updateInGameTennisForTwo()");

    resetLines();

    // bigger field
    playfieldWith = 16;
    playfieldHeight = 10; // 8 - less distance less drawtime

    level = 0;
    life = 0;
    score = 0;

    jplayfieldOffsetX = 1;
    jplayfieldOffsetY = 1;

    // playfield "tennis"

    if (!versionPrePrintedLevels) {

      // drawTextAt("AB CD EF ",1.0f, 1.5f, 0.5f);
      
      drawTextAt("TENNIS4TWO",0.0f, playfieldHeight+0.5f, 0.5f);
      
      // who is playing? federer vs nadal? 
      
      // bottom
      moveTo(0, playfieldHeight);
      lineTo(playfieldWith/2, playfieldHeight);
      lineTo(playfieldWith/2, playfieldHeight-1.5f);
      lineTo(playfieldWith/2, playfieldHeight);
      lineTo(playfieldWith, playfieldHeight);


    }
    

    // playfieldRect("*",0,0,playfieldWith-1,playfieldHeight-1);
    // playfieldRect("a",0,0,playfieldWith-1,playfieldHeight-1);
    // draw houses !!!
    // drawPlayfield();

    // draw by hand
    /*
     float os = 0.0;
     float ps = playfieldTileSize;
     if (true) {
     drawLine( os, os, (playfieldWith-1)*ps+os, os );
     drawLine( os+(playfieldWith)*ps, os, os+(playfieldWith)*ps, (playfieldHeight)*ps+os );
     drawLine( (playfieldWith)*ps+os, (playfieldHeight)*ps+os, os, (playfieldHeight)*ps+os );
     drawLine( os, (playfieldHeight)*ps+os, os, os );
     }
     */

    actualLinePressedState = 0;

    // drawPlayfield();

    // todo: check if there is something
    // own home?

    // start position

    lostBall(); // start

    /*
     // random ... new objects ..
     avatarPosition.x = playfieldWith/4/2;
     avatarPosition.y = playfieldHeight*7/8; // playfieldHeight/2;
     
     moveTo(avatarPosition.x,avatarPosition.y);
     
     
     PVector dir = getVectorFromAlpha(0.25f+0.125f);
     ballVx = dir.x*ballVxSpeed;
     ballVy = dir.y*ballVxSpeed;
     */

    gameTimerStart = 0;

    // loading music ...
  }

  // finished
  //  gameStateSubRunning="run";
  if (gameStateSubRunning.equals("plotting")) {
    if (plotterReadForInput()) {
      gameStateSubRunning = "running";
      gameTimer = millis();
    }
  }


  if (gameStateSubRunning=="running") {

    // println("plotterNothingToDo "+plotterNothingToDo);


    boolean op = plotterReadForInput();
    if (op!=oldplotter) {
      // println("plotterready? "+op);
    }
    oldplotter = op;


    // debug
    String txt = "";

    txt += "\nballWait: "+ballWait;
    txt += "\nballStart: "+ballStart;
    txt += "\nballSide: "+ballSide;
    txt += "\nballSideOld: "+ballSideOld;
    txt += "\nballSideChange: "+ballSideChange;
    txt += "\nballOnGroundThisSide: "+ballOnGroundThisSide;
    txt += "\nballLocked: "+ballLocked;
    txt += "\nplayerStart: "+playerStart;
    txt += "\nballSideInteraction "+ballSideInteraction;

    // add 
    // tennisForTwoAxisX
    txt += "\n";
    for (int u=0;u<2;u++) {
      float xxt = 0.0f+ tennisForTwoAxisX[u];
      float yyt = 0.0f+ tennisForTwoAxisY[u];
      float alphacentauri = 0.0f;
      alphacentauri = atan2(yyt,xxt);
//      alphacentauri += 3.14f;
      
      // left ... 
      
      // correct for this project - 0 down
      // alphacentauri = +3.14f/2.0f;
      
      // 1: 6.28 ~ 2PI
      if (u==0) player0Alpha =alphacentauri; 
      if (u==1) player1Alpha =alphacentauri;
      
      txt += "\naction "+tennisForTwoButtonAction[u];      
      txt += "\nalpha"+u+" "+alphacentauri+"     "+(int)(degrees(alphacentauri))+"  ";

    }
    

    text("DEBUG T42"+txt, 820, 100);

    /*
   fill(30);
     line(0,0,400,400);
     for (var z=0;z<628/4;z++) {
     
     float zx = 350.0f;
     float zy = 350.0f;
     
     float zxx = zx+sin(z/100.0f)*100;
     float zyy = zy+cos(z/100.0f)*100;
     
     line(zx,zy,zxx,zyy);
     
     }
     */

    // -------------------------------
    // BALL SIDE
    // -------------------------------
    // ballSideChange = 0;
    if (avatarPosition.x<(playfieldWith/2)) {
      ballSide = 0;
    } else {
      ballSide = 1;
    }
    if (ballSide!=ballSideOld) {
      ballSideChange++;
      ballOnGroundThisSide = 0;
      ballSideInteraction = 0;
    }
    ballSideOld = ballSide;

// -------------------------------
    // JOYSTICKS
    // -------------------------------
    for (int hcc=0;hcc<2;hcc++) {
      tennisForTwoButtonAction[hcc] = 0;
      if (tennisForTwoButton[hcc]!=tennisForTwoButtonOld[hcc]) {
        tennisForTwoButtonAction[hcc] = 1;      
      }
      tennisForTwoButtonOld[hcc] = tennisForTwoButton[hcc];
    }

    // -------------------------------
    // KEYS
    // -------------------------------
    // control player 1 | player 2
    if (ballSideInteraction==0) {
      boolean doTheAction = false;

      // todo: on the right side?
      if (tennisForTwoMode==0) {
        if (ballSide==0) {
          if (tennisForTwoButtonAction[0]==1) doTheAction = true;      
        }
        if (ballSide==1) {
          if (tennisForTwoButtonAction[1]==1) doTheAction = true;      
        }
      }    

      if (tennisForTwoMode==1) {
           if (tennisForTwoButtonAction[0]==1) doTheAction = true;      
      }

      if (pressedKeyChar.equals(" ")) doTheAction = true;
      if (pressedKeyChar.equals("e")) doTheAction = true;
      if (pressedKeyChar.equals("r")) {
    
            println("t42 random smash");

            
      /*
            ^  <0 degree/rad (x-coords)
           / 
          /
          direction
          -----> 0 degree/rad .-)
      
      */
                        
            // automatic ... 
            // new direction
            float rnda = radians(-30) + radians(random(-30,20)); // radians(-30)+random(-radians(10), radians(40));
            float al = rnda;
            PVector dir = getVectorFromAlpha(al);
            ballVx = dir.x*ballVxSpeed;
            if (ballSide==1) ballVx *= -1.0f;                    
            ballVy = dir.y*ballVxSpeed;
    
            ballLocked = false;
            ballSideInteraction = 1;
       }  
    
      pressedKeyChar = "";
      
      if (doTheAction) {
    
            println("t42 smash");


      /*
            ^  <0 degree/rad (x-coords)
           / 
          /
          direction
          -----> 0 degree/rad .-)
      
      */
            float al = player0Alpha;            
            
            if (tennisForTwoMode==0) {
              if (ballSide==1) al = player1Alpha; 
            }
            // alpha from 
            println("al "+al+"    player0Alpha: "+player0Alpha+"");
            
            // todo: the other ...            
            PVector dir = getVectorFromAlpha(al);
            ballVx = dir.x*ballVxSpeed;
            ballVy = dir.y*ballVxSpeed;
            
            /*
            float demalpha = player1Alpha*6.28;
            fill(0);
            line(50,50,150,50);
            line (200,200,200+cos(demalpha)*30,200+sin(demalpha)*30);
            */
            
            ballLocked = false;
            ballSideInteraction = 1;
       }
    
    }

    // test aiming
    if (false) {

      float middleCourt = playfieldWith/2;
      float topNetX = playfieldHeight-1.5f;

      float diffX = middleCourt-avatarPosition.x;
      float diffY = (topNetX - 1.5f)-avatarPosition.y;

      fill(35);
      stroke(30);

      float mx = 200;
      float my = 200;

      line(avatarPosition.x, avatarPosition.y, middleCourt, topNetX);

      line(0, 0, 100, 200);
    }


    // use ai?
    if (op)
    if (false) {

      if (ballSideInteraction==0) {


        // random ai
        int rdx = (int)(random(0, 50));
        if (rdx==0) {

          println("shoot");

          // new direction
          float middleCourt = playfieldWith/2;
          float topNetX = playfieldHeight-1.5f;

          line(avatarPosition.x, avatarPosition.y, middleCourt, topNetX);

          float diffX = middleCourt-avatarPosition.x;
          float diffY = (topNetX - 1.5f)-avatarPosition.y;


          float alTarget = atan2(diffY, diffX);
          // println("alpha-target: "+ alTarget);

          // 1.0 = 6.28f
          // 1.0/6.28 = t
          alTarget = alTarget*1.0f/6.28f;
          println("alpha: "+ alTarget);
          if (alTarget<0.0f) alTarget += 1.0f;

          // alTarget = alTarget + 0.25f;

          PVector dir = getVectorFromAlpha(alTarget);
          ballVx = dir.x*ballVxSpeed;
          ballVy = dir.y*ballVxSpeed;

          ballLocked = false;

          // ballSideChange = 0;

          ballSideInteraction = 1;
        }
      }
    }

    // ------------------------------
    // ball locked?
    // > no mechanics
    // ------------------------------
    if (ballLocked) {
    
        ballSideChange = 0;
        ballOnGroundThisSide = 0;

      return;
    }
    
    // ------------------------------
    // mechanics
    // ------------------------------
    /*
          txt += "\nballWait: "+ballWait;
     txt += "\nballStart: "+ballStart;
     txt += "\nballSide: "+ballSide;
     txt += "\nballSideOld: "+ballSideOld;
     txt += "\nballSideChange: "+ballSideChange;
     txt += "\nballOnGroundThisSide: "+ballOnGroundThisSide;
     
     
     */

    // Start: Hit Ground in own side
    //    \       |
    // ____\/_____|_________

    if (ballSideChange==0) {
      if (ballOnGroundThisSide>0) {
        println("Forbidden first on the own ground! ");
        lostBall();
        return;
      }
    }



    // LostPoint
    //          |   ___
    // _________|_\/___\/___
    if (ballOnGroundThisSide>1) {
      println("lostBall");
      lostBall();
      return;
    }
    
    // after shot on the ground 
    //   ----o v
    //      /
    // ____/______
    if (ballSideInteraction==1) {
       // on the ground 
       if ((avatarPosition.y+ballVy)>playfieldHeight) {
          println("lostBall: ball most over the net now!");
         lostBall();          
         return;
       }
    }

    // Net!
    //          |
    // _________|_________

    float sizeNet = 0.3f;
    float topNet = playfieldHeight-1.5f;
    if (avatarPosition.y>topNet) {

      if (avatarPosition.x>(playfieldWith/2-sizeNet)) {
        if (avatarPosition.x<playfieldWith/2+sizeNet) {
          println("NET!");
          lostBall();
          return;
        }
      }
    }

    // BackLine
    //
    //   |
    //   |
    // directly into the off
    float courtBorder = 0.2f;
    if ((avatarPosition.x<courtBorder)||(avatarPosition.x>(playfieldWith-courtBorder))) {

      if (ballOnGroundThisSide>0) {
        println("hit ground & off");
        lostBall();
        return;
      }

      // direct
      if (ballOnGroundThisSide==0) {
        println(" off");
        lostBall();
        return;
      }
    }


    // ------------------------------
    // animating and painting
    // ------------------------------


    // only go if the plotter is ready

    // try here .-)


    if (op) {
      //    if (true) {

      // logic
      // Y - ground
      if ((avatarPosition.y+ballVy)>playfieldHeight) {
        ballVy *= -1.0f;
        avatarPosition.x += ballVx;
        avatarPosition.y += ballVy;
        ballOnGroundThisSide++;
      }


      // X
      if (avatarPosition.x>playfieldWith) {
        ballVx *= -1.0f;
        avatarPosition.x += ballVx;
        avatarPosition.y += ballVy;
      }

      if (avatarPosition.x<0.2) {
        ballVx *= -1.0f;
        avatarPosition.x += ballVx;
        avatarPosition.y += ballVy;
      }

      // slow down?
      ballVx *= 1.0f-breakIt;
      ballVy *= 1.0f-breakIt;



      // graviation
      ballVy += ballVyGravitation;

      // ball vx
      avatarPosition.x += ballVx;
      avatarPosition.y += ballVy;

      lineTo( avatarPosition.x, avatarPosition.y );

      avatarPositionOld.x = avatarPosition.x;
      avatarPositionOld.y = avatarPosition.y;
    }
  }

}

// --------------------------------------
// LINE RIDE PAINT
// --------------------------------------


public void updateInGameLineRidePaint() {

  
  // use osc
  updateOSCTennisForTwo(); 
  
  // special gui
  textSize(14);
  
  fill(0);
  
  String str = "# OSC (UDP) \n";

  str += "\nSetup: 1 DualSense Sony. ";
  str += "\nSending on Mac with JOYOSC";
  str += "\n\n# oscport 127.0.0.1 9007";
  str += "\n#  the osc port in is 9007. send your data here. ";
  str += "\n";
  for (int z=0;z<2;z++) {
    str += "\n \nController "+(z+1)+": (redirected here)";
    str += "\n/joyosc/devices/ps0/ 'leftx',100 "+tennisForTwoAxisX[z]+" // -32000-32000";
    str += "\n/joyosc/devices/ps0/ 'a',0 "+tennisForTwoButton[z]+" // 0||1";
  }
  str += "\n";

  text(""+str, 820, 420);

// start up / set graphics
  if (gameStateSubRunning.equals("")) {
    gameStateSubRunning="plotting";

    println("LineRidePaint()");

    resetLines();

    // bigger field
    playfieldWith = 16;
    playfieldHeight = 14; // 8 - less distance less drawtime

    level = 0;
    life = 0;
    score = 0;

    jplayfieldOffsetX = 1;
    jplayfieldOffsetY = 1;

    // playfield "tennis"

    if (!versionPrePrintedLevels) {

      // drawTextAt("AB CD EF ",1.0f, 1.5f, 0.5f);
      
//    drawTextAt("LINERIDEPAINT",0.0f, 0.5f, 0.25f);
      
      // who is playing? federer vs nadal? 
      
      // bottom
      moveTo(0, playfieldHeight);
/*      lineTo(playfieldWith/2, playfieldHeight);
      lineTo(playfieldWith/2, playfieldHeight-1.5f);
      lineTo(playfieldWith/2, playfieldHeight);
      lineTo(playfieldWith, playfieldHeight);
*/
    }
    

    // playfieldRect("*",0,0,playfieldWith-1,playfieldHeight-1);
    // playfieldRect("a",0,0,playfieldWith-1,playfieldHeight-1);
    // draw houses !!!
    // drawPlayfield();

    // draw by hand
    /*
     float os = 0.0;
     float ps = playfieldTileSize;
     if (true) {
     drawLine( os, os, (playfieldWith-1)*ps+os, os );
     drawLine( os+(playfieldWith)*ps, os, os+(playfieldWith)*ps, (playfieldHeight)*ps+os );
     drawLine( (playfieldWith)*ps+os, (playfieldHeight)*ps+os, os, (playfieldHeight)*ps+os );
     drawLine( os, (playfieldHeight)*ps+os, os, os );
     }
     */

    actualLinePressedState = 0;

    // drawPlayfield();

    // todo: check if there is something
    // own home?

    // start position

    // lostBall(); // start

    
     // random ... new objects ..
     avatarPosition.x = playfieldWith/2;
     avatarPosition.y = playfieldHeight/2; // playfieldHeight/2;
     
     moveTo(avatarPosition.x,avatarPosition.y);
     
     ballVx = 0.0f;
     ballVy = 0.0f;
     
     /*
     
     PVector dir = getVectorFromAlpha(0.25f+0.125f);
     ballVx = dir.x*ballVxSpeed;
     ballVy = dir.y*ballVxSpeed;
     */

    gameTimerStart = 0;

    // loading music ...
  }

  // finished
  //  gameStateSubRunning="run";
  if (gameStateSubRunning.equals("plotting")) {
    if (plotterReadForInput()) {
      gameStateSubRunning = "running";
      gameTimer = millis();
    }
  }


  if (gameStateSubRunning=="running") {
    
     // gravitiation add 
      
      // graviation
      // ballVy += ballVyGravitation;

      // ball vx
      avatarPosition.x += ballVx;
      avatarPosition.y += ballVy;

      // the cage
      // stop down there ... 
      if (avatarPosition.x>playfieldWith) {
          ballVx = 0.0f;
          ballVy = 0.0f;
          avatarPosition.x = playfieldWith-0.1f;
      }
      if (avatarPosition.x<0.0f) {
          ballVx = 0.0f;
          ballVy = 0.0f;
          avatarPosition.x = 0.1f;
      }       
      if (avatarPosition.y>playfieldHeight) {
          ballVx = 0.0f;
          ballVy = 0.0f;
          avatarPosition.y = playfieldHeight-0.1f;
      }
      if (avatarPosition.y<0.0f) {
          ballVx = 0.0f;
          ballVy = 0.0f;
          avatarPosition.y = 0.1f;
      }
      
                
      // the sprite ...
      float ballAccX = 0.0005f;
      float ballAccY = 0.0005f;


      // hit joystick .. 
      // control by small stick ... 
      if (getJoystickOrKeyboard("actiondirect")) {

        println("--\n\n");
        generateAnalogStickAlphas();
        println("player1Alpha "+player0Alpha);
        
        PVector dir = getVectorFromAlpha(player0Alpha);
        ballAccX = dir.x*ballAccX;
        ballAccY = dir.y*ballAccY;
        
        ballVx += ballAccX;
        ballVy += ballAccY;
      }
      
      float maxVx = 0.2f;
      float maxVy = 0.2f;
      
      if (getJoystickOrKeyboard("rightdirect")) { 
          if (speed(ballVx,ballVy)<maxVx) ballVx += ballAccX; 
      }
      if (getJoystickOrKeyboard("leftdirect")) { 
          if (speed(ballVx,ballVy)<maxVx) ballVx -= ballAccX; 
      }
      if (getJoystickOrKeyboard("updirect")) { 
          if (speed(ballVx,ballVy)<maxVx) ballVy -= ballAccY; 
      }
      if (getJoystickOrKeyboard("downdirect")) { 
          if (speed(ballVx,ballVy)<maxVx) ballVy += ballAccY; 
      }
      
      

      boolean op = plotterReadForInput();    
      if (op) {
        lineTo( avatarPosition.x, avatarPosition.y );
      }
      
      
  }

}

// --------------------------------------
// Racing | FORMTAXI
// --------------------------------------
public void updateInGameRacing() {

  // println("updateInGameRacing()");
  
  // use osc
  updateOSCTennisForTwo(); 
  
  // special gui
  textSize(14);
  
  fill(0);
  
  String str = "# OSC (UDP) \n";

  str += "\nSetup: 1 DualSense Sony. ";
  str += "\nSending on Mac with JOYOSC";
  str += "\n\n# oscport 127.0.0.1 9007";
  str += "\n#  the osc port in is 9007. send your data here. ";
  str += "\n";
  for (int z=0;z<2;z++) {
    str += "\n \nController "+(z+1)+": (redirected here)";
    str += "\n/joyosc/devices/ps0/ 'leftx',100 "+tennisForTwoAxisX[z]+" // -32000-32000";
    str += "\n/joyosc/devices/ps0/ 'a',0 "+tennisForTwoButton[z]+" // 0||1";
  }
  str += "\n";

  text(""+str, 820, 420);

// start up / set graphics
  if (gameStateSubRunning.equals("")) {
    gameStateSubRunning="plotting";

    println("updateInGameTennisForTwo()");

    resetLines();

    // bigger field
    playfieldWith = 16;
    playfieldHeight = 13; // 8 - less distance less drawtime

    level = 0;
    life = 0;
    score = 0;

    jplayfieldOffsetX = 1;
    jplayfieldOffsetY = 1;

    // playfield "tennis"

    if (!versionPrePrintedLevels) {

      // drawTextAt("AB CD EF ",1.0f, 1.5f, 0.5f);
      
//      drawTextAt("GRAPHICTAXI",0.0f, playfieldHeight+0.5f, 0.5f);
      
      // who is playing? federer vs nadal? 
      
      // bottom
      moveTo(0, playfieldHeight);
/*      lineTo(playfieldWith/2, playfieldHeight);
      lineTo(playfieldWith/2, playfieldHeight-1.5f);
      lineTo(playfieldWith/2, playfieldHeight);
      lineTo(playfieldWith, playfieldHeight);
*/
    }
    

    // playfieldRect("*",0,0,playfieldWith-1,playfieldHeight-1);
    // playfieldRect("a",0,0,playfieldWith-1,playfieldHeight-1);
    // draw houses !!!
    // drawPlayfield();

    // draw by hand
    /*
     float os = 0.0;
     float ps = playfieldTileSize;
     if (true) {
     drawLine( os, os, (playfieldWith-1)*ps+os, os );
     drawLine( os+(playfieldWith)*ps, os, os+(playfieldWith)*ps, (playfieldHeight)*ps+os );
     drawLine( (playfieldWith)*ps+os, (playfieldHeight)*ps+os, os, (playfieldHeight)*ps+os );
     drawLine( os, (playfieldHeight)*ps+os, os, os );
     }
     */

    actualLinePressedState = 0;

    // drawPlayfield();

    // todo: check if there is something
    // own home?

    // start position

    // lostBall(); // start

    
     
     
     ballVx = 0.0f;
     ballVy = 0.0f;
     
     /*
     
     PVector dir = getVectorFromAlpha(0.25f+0.125f);
     ballVx = dir.x*ballVxSpeed;
     ballVy = dir.y*ballVxSpeed;
     */

    gameTimerStart = 0;
    
    // add level
    GameObject startObj = addGameObject("track","0","",3.0f, 1.5f,0.25f);
    addGameObject("track","1","",7.0f, 1.0f,0.25f);
    addGameObject("track","2","",10.0f, 7.0f,0.25f);
    addGameObject("track","3","",3.0f, 10.0f,0.25f);
    drawGameObjects();

     avatarPosition.x = startObj.position.x;
     avatarPosition.y = startObj.position.y;
     moveTo(avatarPosition.x,avatarPosition.y);

    // loading music ...
  }

  // finished
  //  gameStateSubRunning="run";
  if (gameStateSubRunning.equals("plotting")) {
    if (plotterReadForInput()) {
      gameStateSubRunning = "running";
      gameTimer = millis();
    }
  }


  if (gameStateSubRunning=="running") {
    
     // gravitiation add 
      
      // graviation
      // ballVy += ballVyGravitation;

      // ball vx
      avatarPosition.x += ballVx;
      avatarPosition.y += ballVy;

      // the cage
      // stop down there ... 
      if (avatarPosition.x>playfieldWith) {
          ballVx = 0.0f;
          ballVy = 0.0f;
          avatarPosition.x = playfieldWith-0.1f;
      }
      if (avatarPosition.x<0.0f) {
          ballVx = 0.0f;
          ballVy = 0.0f;
          avatarPosition.x = 0.1f;
      }       
      if (avatarPosition.y>playfieldHeight) {
          ballVx = 0.0f;
          ballVy = 0.0f;
          avatarPosition.y = playfieldHeight-0.1f;
      }
      if (avatarPosition.y<0.0f) {
          ballVx = 0.0f;
          ballVy = 0.0f;
          avatarPosition.y = 0.1f;
      }
           
      
      // the sprite ...
      float ballAccX = 0.0005f;
      float ballAccY = 0.0005f;

      // up / down 
      if (getJoystickOrKeyboard("action")) {
          taxiOnPaper = !taxiOnPaper;
      }
      
      // hit joystick .. 
      // control by small stick ... 
      if (getJoystickOrKeyboard("actiondirect")) {

        println("--\n\n");
        generateAnalogStickAlphas();
        println("player1Alpha "+player0Alpha);
        
        PVector dir = getVectorFromAlpha(player0Alpha);
        ballAccX = dir.x*ballAccX;
        ballAccY = dir.y*ballAccY;
        
        ballVx += ballAccX;
        ballVy += ballAccY;
      }
      
      
      float maxVx = 0.2f;
      float maxVy = 0.2f;
      
      if (getJoystickOrKeyboard("rightdirect")) { 
          if (speed(ballVx,ballVy)<maxVx) ballVx += ballAccX; 
      }
      if (getJoystickOrKeyboard("leftdirect")) { 
          if (speed(ballVx,ballVy)<maxVx) ballVx -= ballAccX; 
      }
      if (getJoystickOrKeyboard("updirect")) { 
          if (speed(ballVx,ballVy)<maxVx) ballVy -= ballAccY; 
      }
      if (getJoystickOrKeyboard("downdirect")) { 
          if (speed(ballVx,ballVy)<maxVx) ballVy += ballAccY; 
      }

      boolean op = plotterReadForInput();    
      if (op) {
        if (taxiOnPaper) lineTo( avatarPosition.x, avatarPosition.y );
        if (!taxiOnPaper) moveTo( avatarPosition.x, avatarPosition.y );
      }
      
      
  }

}


// --------------------------------------
// SPACETAXI | FORMTAXI
// --------------------------------------

/*
  0 wait for start
  1 in the
 2 interactionDone
 
 */
 
boolean debugSpaceTaxi = false;
 
boolean taxiOnPaper = false; 

int maxStations = 0;

public void generateAnalogStickAlphas(  ) {

     for (int u=0;u<2;u++) {
      float xxt = 0.0f+ tennisForTwoAxisX[u];
      float yyt = 0.0f+ tennisForTwoAxisY[u];
      float alphacentauri = 0.0f;
//      println(u+" generatA: "+xxt+" "+yyt);
      alphacentauri = atan2(yyt,xxt);
//      alphacentauri += 3.14f;
      
      // left ... 
      println(u+" generatA: "+xxt+" "+yyt+"   "+alphacentauri);
      
      // correct for this project - 0 down
      // alphacentauri = +3.14f/2.0f;
      
      // 1: 6.28 ~ 2PI
      if (u==0) player0Alpha = alphacentauri; 
      if (u==1) player1Alpha = alphacentauri;
      
    
    }
    
}

GameObject fromObject;
GameObject toObject; 

int todoState = 0; // 0 go to take it 1 go to ... 

public void updateInGameSpaceTaxi() {

  // println("updateInGameSpaceTaxi()");
  
  // use osc
  updateOSCTennisForTwo(); 
  
  // special gui
  textSize(14);
  
  fill(0);
  
  String str = "# OSC (UDP) \n";

  str += "\nSetup: 1 DualSense Sony. ";
  str += "\nSending on Mac with JOYOSC";
  str += "\n\n# oscport 127.0.0.1 9007";
  str += "\n#  the osc port in is 9007. send your data here. ";
  str += "\n";
  for (int z=0;z<2;z++) {
    str += "\n \nController "+(z+1)+": (redirected here)";
    str += "\n/joyosc/devices/ps0/ 'leftx',100 "+tennisForTwoAxisX[z]+" // -32000-32000";
    str += "\n/joyosc/devices/ps0/ 'a',0 "+tennisForTwoButton[z]+" // 0||1";
  }
  str += "\n";

  text(""+str, 820, 420);

// start up / set graphics
  if (gameStateSubRunning.equals("")) {
    gameStateSubRunning="plotting";

    println("updateInGameTennisForTwo()");

    arrGameObjects = new ArrayList<GameObject>();

    resetLines();

    // bigger field
    playfieldWith = 16;
    playfieldHeight = 13; // 8 - less distance less drawtime

    level = 0;
    life = 0;
    score = 0;

    jplayfieldOffsetX = 1;
    jplayfieldOffsetY = 1;

    // playfield "tennis"

    if (!versionPrePrintedLevels) {

      // drawTextAt("AB CD EF ",1.0f, 1.5f, 0.5f);
      
//      drawTextAt("GRAPHICTAXI",0.0f, playfieldHeight+0.5f, 0.5f);
      
      // who is playing? federer vs nadal? 
      
      // bottom
      moveTo(0, playfieldHeight);
/*      lineTo(playfieldWith/2, playfieldHeight);
      lineTo(playfieldWith/2, playfieldHeight-1.5f);
      lineTo(playfieldWith/2, playfieldHeight);
      lineTo(playfieldWith, playfieldHeight);
*/
    }
    

    // playfieldRect("*",0,0,playfieldWith-1,playfieldHeight-1);
    // playfieldRect("a",0,0,playfieldWith-1,playfieldHeight-1);
    // draw houses !!!
    // drawPlayfield();

    // draw by hand
    /*
     float os = 0.0;
     float ps = playfieldTileSize;
     if (true) {
     drawLine( os, os, (playfieldWith-1)*ps+os, os );
     drawLine( os+(playfieldWith)*ps, os, os+(playfieldWith)*ps, (playfieldHeight)*ps+os );
     drawLine( (playfieldWith)*ps+os, (playfieldHeight)*ps+os, os, (playfieldHeight)*ps+os );
     drawLine( os, (playfieldHeight)*ps+os, os, os );
     }
     */

    actualLinePressedState = 0;

    // drawPlayfield();

    // todo: check if there is something
    // own home?

    // start position

    // lostBall(); // start

    
     
     
     ballVx = 0.0f;
     ballVy = 0.0f;
     
     /*
     
     PVector dir = getVectorFromAlpha(0.25f+0.125f);
     ballVx = dir.x*ballVxSpeed;
     ballVy = dir.y*ballVxSpeed;
     */

float sizeStationsE = 1.0;

    gameTimerStart = 0;
    
    // add level
    GameObject startObj = addGameObject("track","-","",4.0f, 1.5f,sizeStationsE);
    addGameObject("track","-","",7.0f, 1.0f,sizeStationsE);
    addGameObject("track","-","",10.0f, 7.0f,sizeStationsE);
    addGameObject("track","-","",3.0f, 10.0f,sizeStationsE);
    
    // max stations ...
    maxStations = arrGameObjects.size();
    
    // specials     
    
    

    addGameObject("dead","X","",8.0f, 4.0f,sizeStationsE);

    addGameObject("dead","X","",5.0f, 5.0f,sizeStationsE);
    addGameObject("dead","X","",8.0f, 8.0f,sizeStationsE);
    
    addGameObject("dead","X","",1.0f, 5.0f,sizeStationsE);
    addGameObject("dead","X","",5.0f, 1.5f,sizeStationsE);

    addGameObject("a","V","",0.5f, 3.0f,sizeStationsE);
    addGameObject("a","V","",1.5f, 3.0f,sizeStationsE);
    addGameObject("a","V","",2.5f, 3.0f,sizeStationsE);
    
    addGameObject("a","V","",4.5f, 6.0f,sizeStationsE);
    addGameObject("a","V","",5.5f, 6.0f,sizeStationsE);
    addGameObject("a","V","",6.5f, 6.0f,sizeStationsE);
    
    drawGameObjects();

    startObj.position.x = 1.0f;
    startObj.position.y = 1.0f;

     avatarPosition.x = startObj.position.x;
     avatarPosition.y = startObj.position.y;
     moveTo(avatarPosition.x,avatarPosition.y);

    // loading music ...
  }

  // finished
  //  gameStateSubRunning="run";
  if (gameStateSubRunning.equals("plotting")) {
    if (plotterReadForInput()) {
  //    gameStateSubRunning = "running";
      println("SpaceTaxi: runningdone");
      gameStateSubRunning="todo";
      gameTimer = millis();
    }
    
    
  }

  // todo > dofirst > do second  
  
  // todo
  if (gameStateSubRunning.equals("todo")) {
    
    println("SpaceTaxi: todo");

    // get ...
    fromObject = arrGameObjects.get( (int)random(0,maxStations) );      
    
    // do as long as possible ...
    do {
      toObject = arrGameObjects.get( (int)random(0,maxStations) );      
    } while(fromObject.id==toObject.id);
    
    println("SpaceTaxi A: "+fromObject.id+" "+fromObject.position.x);
    println("SpaceTaxi B: "+toObject.id+" "+toObject.position.x);
    
    // now go to show from to
    
if (debugSpaceTaxi) {    
   lineTo(fromObject.position.x,fromObject.position.y);
   lineTo(toObject.position.x,toObject.position.y);
}
if (!debugSpaceTaxi) {    
   moveTo(fromObject.position.x,fromObject.position.y);
   moveTo(toObject.position.x,toObject.position.y);
}

   todoState = 0;  
   
    // wait do 
    gameStateSubRunning = "waitdo";
  }

  // waitdo
  if (gameStateSubRunning.equals("waitdo")) {
    if (plotterReadForInput()) {
      gameStateSubRunning = "running";
        println("SpaceTaxi: waitdone");
      gameTimer = millis();
    }
  }

  if (gameStateSubRunning=="running") {
    
      // --------------------
      // gravitiation add 
      // --------------------
     
      GameObject landTo = fromObject;
      if (todoState==1) landTo = toObject;
      
      // todo
      // ballVx / ballVy
      // dist(
      text("nv: "+todoState+" //// ["+landTo.id+"] "+
                   landTo.dist(avatarPosition.x, avatarPosition.y)+
                   
                   "   "+sqrt(ballVx*ballVx+ballVy*ballVy)+"  plotterready: "+plotterReadForInput(),
                   150,150
                 );
      // ballVx
      if (sqrt(ballVx*ballVx+ballVy*ballVy)<0.1f)
      if (landTo.dist(avatarPosition.x, avatarPosition.y)<0.5f) {
          // show now ...
          text("TAKE! ",100,100);
          
          // MOVE TO !!!! 
          if (todoState==0) {
            todoState=1;          
            // drawText("OUT!",landTo.position.x,landTo.position.y);
             playPing();
             ballVx = 0.0f;
             ballVy = 0.0f;
          }
          else 
          {
            todoState=1;          
            // drawText("OUT!",landTo.position.x,landTo.position.y);
             playPing();
             // show the form 
             // & go to the next ...
             int d = (int) random(0,10);
             String showClient = "m";
             if (d==1) showClient = "T";
             if (d==2) showClient = "O";
             if (d==3) showClient = "I";
             if (d==4) showClient = "L";
             if (d==5) showClient = "S";
             if (d==6) showClient = "N";
             drawTextAt(showClient,landTo.position.x+random(-0.5,0.5),landTo.position.y+random(-0.5,0.5),random(0.5f,1.5f));
          
             // show next ... 
             gameStateSubRunning = "todo";
        }
          
                  
          
      }
      
      
      // some graviation
      // ballVy += 0.0001f; 
      
      
      // some objects in the way
      // TRIGGERS
      String strXYZ = "";
      float distA = 0.0f;
      for (int z=0;z<arrGameObjects.size();z++) {        
         tmpGO = arrGameObjects.get(z);
         
         // distance
         distA = tmpGO.dist(avatarPosition.x-0.1f, avatarPosition.y-0.1f);
         
         if (distA<0.3f) {
            // something happens ... 

            strXYZ += "\n   "+tmpGO.name+" "+tmpGO.name;
            
            // die? ...
            if (tmpGO.name.equals("dead")) {
              
              
              // 'death'              
              // move to ...
              avatarPosition.x = 1.0f;
              avatarPosition.y = 2.0f;
              ballVx = 0.0f;
              ballVy = 0.0f;              
              moveTo(avatarPosition.x,avatarPosition.y);

              playPing();
              
              gameStateSubRunning = "todo";
              
              
            }
            
            // V 
            if (tmpGO.visual.equals("V")) {
              
              // 'death'              
              // move to ...
   //           ballVx += 0.01f;
              ballVy += 0.002f;              

            }            
            
         }
         
        
      }      
      
       text("TRIGGERS! "+strXYZ,200,100);
      
      
      // controll "ball"
      
      // graviation
      // ballVy += ballVyGravitation;

      // ball vx
      avatarPosition.x += ballVx;
      avatarPosition.y += ballVy;

      // the cage
      // stop down there ... 
      if (avatarPosition.x>playfieldWith) {
          ballVx = 0.0f;
          ballVy = 0.0f;
          avatarPosition.x = playfieldWith-0.1f;
      }
      if (avatarPosition.x<0.0f) {
          ballVx = 0.0f;
          ballVy = 0.0f;
          avatarPosition.x = 0.1f;
      }       
      if (avatarPosition.y>playfieldHeight) {
          ballVx = 0.0f;
          ballVy = 0.0f;
          avatarPosition.y = playfieldHeight-0.1f;
      }
      if (avatarPosition.y<0.0f) {
          ballVx = 0.0f;
          ballVy = 0.0f;
          avatarPosition.y = 0.1f;
      }
           
      
      // the sprite ...
      float ballAccX = 0.0005f;
      float ballAccY = 0.0005f;

      // up / down 
      if (getJoystickOrKeyboard("action")) {
          taxiOnPaper = !taxiOnPaper;
      }
      
      // hit joystick .. 
      // control by small stick ... 
      if (getJoystickOrKeyboard("actiondirect")) {

        println("--\n\n");
        generateAnalogStickAlphas();
        println("player1Alpha "+player0Alpha);
        
        PVector dir = getVectorFromAlpha(player0Alpha);
        ballAccX = dir.x*ballAccX;
        ballAccY = dir.y*ballAccY;
        
        ballVx += ballAccX;
        ballVy += ballAccY;
      }
      
      
      float maxVx = 0.2f;
      float maxVy = 0.2f;
      
      if (getJoystickOrKeyboard("rightdirect")) { 
          if (speed(ballVx,ballVy)<maxVx) ballVx += ballAccX; 
      }
      if (getJoystickOrKeyboard("leftdirect")) { 
          if (speed(ballVx,ballVy)<maxVx) ballVx -= ballAccX; 
      }
      if (getJoystickOrKeyboard("updirect")) { 
          if (speed(ballVx,ballVy)<maxVx) ballVy -= ballAccY; 
      }
      if (getJoystickOrKeyboard("downdirect")) { 
          if (speed(ballVx,ballVy)<maxVx) ballVy += ballAccY; 
      }

      boolean op = plotterReadForInput();    
      if (op) {
        if (taxiOnPaper) lineTo( avatarPosition.x, avatarPosition.y );
        if (!taxiOnPaper) moveTo( avatarPosition.x, avatarPosition.y );
      }
      
      
  }

}


public float speed( float x, float y) {
   return sqrt(x*x+y*y);
}

// --------------------------------------
// PLOTSHOT ALIAS POTSHOT
// --------------------------------------
//
// REMAKE OF THE CLASSIC (LUEHRMANN)
//
ArrayList<PVector>  playerPositions = new ArrayList<PVector>();
ArrayList<PVector> playerDirectionAlphaSpeed = new ArrayList<PVector>();
ArrayList<PVector> arrLandscape =  new ArrayList();

/*
   #TurnBased
   
    0 Player1Alpha
    1 Player1Speed > Shoot
    2 Player2Alpha
    3 Player2Speed > Shoot

*/
String playerInput = "";

int playerActive = 0;

int interactionPoint = 0; 
PVector psx = new PVector(2.0f, 1.0f);

float playerUp = 2.0f;


public void updateInGamePotshot() {

  // start up / set graphics
  if (gameStateSubRunning.equals("")) {
    
    gameStateSubRunning="plotting";
    
    println("ingamepotshot");
    
    playerPositions.add(new PVector());
    playerPositions.add(new PVector());

    playerDirectionAlphaSpeed.add(new PVector());
    playerDirectionAlphaSpeed.add(new PVector());


    resetLines();
    
    playerUp = 2.0f;

    // bigger field
    playfieldWith = 22;
    playfieldHeight = 15; // 8 - less distance less drawtime

    
    avatarPosition.x = 4;
    avatarPosition.y = 1;

    // moveTo(avatarPosition.x+playfieldTileSize/2, avatarPosition.y+playfieldTileSize/2);

    // plot the playfield
    // drawTextAt("POTSHOT",0.1f,0.1f,0.4f);

    avatarPosition.x = 1;
    avatarPosition.y = 8;
    moveTo(avatarPosition.x, avatarPosition.y);
    
    // DEMOSCENE STYLE .-)
    // ALL IN ONE
     int player1 = (int)random(0,70);
     int player2 =  (int)random(149-70,149);
    
    // randomize
    float heightJura = random(1.5,2.5);
    float heightPeak = random(0.01f,0.1f);
    
    // DRAW NOW THE PLOT
    for (int z=0;z<150;z++) {
      float px = z/10.0f;
      float r = 1.5f;
      float xpeak = 7.0f;
      float py =  sin(px+3.5f)*heightJura + 1.5f + (px-xpeak)*(px-xpeak)*heightPeak; // jura + peak 
      if (z==0) moveTo(avatarPosition.x+px, avatarPosition.y+py); 
      lineTo(avatarPosition.x+px, avatarPosition.y+py);
      arrLandscape.add(new PVector(avatarPosition.x+px,avatarPosition.y+py));
 
      if (z==player1) {
         // draw now there the 'pot'
        PVector playerXT = playerPositions.get(0);
        playerXT.x = avatarPosition.x+px;
        playerXT.y = avatarPosition.y+py-0.25f;
        // show ...
        // moveTo(playerXT.x-0.25f,playerXT.y-0.25f);
        drawTextAt("O",playerXT.x-0.25f,playerXT.y-0.25f,0.5);        
        // moveTo(avatarPosition.x+px,avatarPosition.x+py);
        moveTo(avatarPosition.x+px, avatarPosition.y+py);
      }
      if (z==player2) {
         // draw now there the 'pot'
        PVector playerXT = playerPositions.get(1);
        playerXT.x = avatarPosition.x+px;
        playerXT.y = avatarPosition.y+py-0.5f;
        // show ...
        drawTextAt("O",playerXT.x-0.25f,playerXT.y-0.25f,0.5); 
         moveTo(avatarPosition.x+px, avatarPosition.y+py);
     }
 
   }
   
   avatarPosition.x = 1.0f;
   avatarPosition.y = 1.0f;
   
   interactionPoint = 2;
   
   // playerUp
   PVector playerXTT = playerPositions.get(1);  
   avatarPosition.x = playerXTT.x;
   avatarPosition.y = playerXTT.y-(playerUp+1)*0.25f;  
   moveTo(avatarPosition.x,avatarPosition.y);

  }

  // finished
  //  gameStateSubRunning="run";
  if (gameStateSubRunning.equals("plotting")) {
    if (plotterReadForInput()) {
      gameStateSubRunning = "running";
      gameTimer = millis();
    }
  }


  if (gameStateSubRunning=="running") {
    
       // key ...
       if (!pressedKeyChar.equals("")) {
          boolean keyOk = false;
          
          // primitive but hey!
          if (pressedKeyChar.equals("0")) keyOk=true;
          if (pressedKeyChar.equals("1")) keyOk=true;
          if (pressedKeyChar.equals("2")) keyOk=true;
          if (pressedKeyChar.equals("3")) keyOk=true;
          if (pressedKeyChar.equals("4")) keyOk=true;
          if (pressedKeyChar.equals("5")) keyOk=true;
          if (pressedKeyChar.equals("6")) keyOk=true;
          if (pressedKeyChar.equals("7")) keyOk=true;
          if (pressedKeyChar.equals("8")) keyOk=true;
          if (pressedKeyChar.equals("9")) keyOk=true;
          if (pressedKeyChar.equals("-")) keyOk=true;
          if (playerInput.indexOf(".")==-1 && playerInput.indexOf(",")==-1) {
            if (pressedKeyChar.equals(",")) keyOk=true;
            if (pressedKeyChar.equals(".")) keyOk=true;
          }
          
          if (keyOk) {
            float fontSizeInput = 0.25;
            playerInput += pressedKeyChar;
            // print new key 0-9 oder . oder ,
            float posix = avatarPosition.x+(playerInput.length()-1)*(fontSizeInput*2/3);
            drawTextAt(pressedKeyChar,posix,avatarPosition.y,fontSizeInput); 
            moveTo(posix+fontSizeInput,avatarPosition.y);
            // def .. 
          }
          
          if (pressedKeyChar.equals("\n")) {
   
              float val = 0.0f;
              try {
                val = Float.parseFloat(playerInput);
                println("val: "+val);
              } catch( Exception e ) {
                 val = 0.0f;
                 println("val "+e); 
              }
              
              // wait here for plotter!!
              // own ... state! 
              
              // ---------------
              // player0
              // ---------------
              if (interactionPoint==0) {
                  playerActive = 0;
                 // shoot now ... 
                 PVector sp = playerDirectionAlphaSpeed.get(playerActive);                 
                 sp.x = val;
                 avatarPosition.x += 1.0f;
                 // moveTo(avatarPosition.x,avatarPosition.y);
                 
                 // playerUp
                 PVector playerXTT = playerPositions.get(0);   
                 avatarPosition.x = playerXTT.x+1.0f;
                 avatarPosition.y = playerXTT.y-(playerUp+1)*0.25f;  
                 moveTo(avatarPosition.x,avatarPosition.y);

              }
              
              if (interactionPoint==1) {
                  playerActive = 0;
                 PVector sp = playerDirectionAlphaSpeed.get(playerActive);
                 sp.y = val;
                 
                 // shootHere();
                 
                 avatarPosition.x += 3.0f;  
                              
                 shoot();
//                 moveTo(avatarPosition.x,avatarPosition.y);

                 // playerUp
                 PVector playerXTT = playerPositions.get(1);   
                 avatarPosition.x = playerXTT.x;
                 avatarPosition.y = playerXTT.y-(playerUp+1)*0.25f;  
                 moveTo(avatarPosition.x,avatarPosition.y);
                
              }
              
              // ---------------
              // player1
              // ---------------
              if (interactionPoint==2) {
                  playerActive = 1;

                   // playerUp
                   PVector playerXTT = playerPositions.get(1);   
                   avatarPosition.x = playerXTT.x+1.0f;
                   avatarPosition.y = playerXTT.y-(playerUp+1)*0.25f;  
                   moveTo(avatarPosition.x,avatarPosition.y);

                  PVector sp = playerDirectionAlphaSpeed.get(playerActive);
                  sp.x = val;
              }

              // ---------------
              // player 1
              // ---------------
              if (interactionPoint==3) {
                 playerActive = 1;
                 avatarPosition.x = 3.0f;     
                 avatarPosition.y += 1.0f;     
                  PVector sp = playerDirectionAlphaSpeed.get(playerActive);
                  sp.y = val; // -(90-val);

                 shoot();
                 
                 playerUp +=1.5f;

                 // playerUp
                 PVector playerXTT = playerPositions.get(0);   
                 avatarPosition.x = playerXTT.x;
                 avatarPosition.y = playerXTT.y-(playerUp+1)*0.25f;  
                 moveTo(avatarPosition.x,avatarPosition.y);

              }
 
              ++interactionPoint;
              if (interactionPoint>3) interactionPoint = 0;
              
              
              playerInput = "";
              
          }
          
          pressedKeyChar = "";
        }
        text("interactionPoint: "+interactionPoint+"\nPLAYERINPUT: "+playerInput,50,150);

        text("PLAY WITH KEYBOARD (-[0-9]*.,)",50,250);
    
  }
  
}

// shoot
public void shoot( ) {
    
    // shoot now ... 
    PVector pPp = playerPositions.get(playerActive);  
    PVector sp = playerDirectionAlphaSpeed.get(playerActive);
                 
    // do it now ...
    float postitX = pPp.x;
    float postitY = pPp.y;

    println("shoot "+postitX+" "+postitY);

    moveTo(postitX,postitY);
   
    float alpha = sp.x;
    float speed = sp.y;

// alpha = 45;
// speed = 10.0f;
   
   float gravitation = 0.01f;

    if (playerActive==0) {
      alpha += 90;
    }

    if (playerActive==1) {
      alpha *= -1;
      alpha -= 90;
    }

    alpha = radians(alpha);
    
    float fact = 1.0f;
    
    float speedef = speed/10.0f; // 1 0.1 speed 
    float projectilVx = sin(alpha)*0.1f*fact; // speedef
    float projectilVy = cos(alpha)*0.1f*fact;
       
    boolean brno = false;   
    
    float wind = random(-0.5f,0.5f) ;
    
    wind = 0.5f; 
    
    print("wind: "+wind);

           // speedef
      int btx = (int) (speedef*10.0f);

      float btxF = speedef*10.0f;
         println("speed iterations: "+btx);
         
      float microGravitation = gravitation/btxF;
      float microWind = wind/btxF;

    for (int i=0;i<1800;i++) {
 


      
       
      for (int n=0;n<btx;n++) {

          projectilVy += microWind;
          projectilVy +=microGravitation;

        
          // how often ? 
          postitX += projectilVx;
          postitY += projectilVy;
          
         
          // println("*** "+postitX+" "+postitY);
          
          if (postitX<1.0f) {        
            println("break playfield "+postitX+" "+postitY);
            brno = true; 
            break;
          }
          if (postitX>(playfieldWith-1.0f)) {        
            println("break playfield "+postitX+" "+postitY+"  "+i);
             brno = true; 
             break;
          }
          if (postitY>(playfieldHeight-1.0f)) {        
            println("break playfield "+postitX+" "+postitY+" "+i);
             brno = true;
             break;
          }
    
          lineTo(postitX,postitY);     
          
          // ---------------------
          // TEST THE GROUND
          // ---------------------
          // moreThanDistance = false;
          boolean moreThanDistance = false;

          // Hit the ground?
          PVector vc = new PVector();
          float dx = 0.0f;
          for (int z=0;z<arrLandscape.size();z++) {
            vc = arrLandscape.get(z);
            dx = sqrt((vc.x-postitX)*(vc.x-postitX)+(vc.y-postitY)*(vc.y-postitY));

           // println("distance: "+dx);
           /*
           if (dx>4.0f) {
              moreThanDistance = true; 
              println("enough distance");
           }
           */
           // if (moreThanDistance) 
            if (dx<0.1f) {
               brno = true;
               println("shot into the ground!");
                break;
              }
           // }
          }
          
          if ( brno ) break;
          
          
          // -----------------------------
          // game over (someone died)
          // -----------------------------
          // fuck to code something like this in the days of the gaza and ukraine war!
          // at least here someone can shoot back
          //
          
          
          // enemies ?           
          // won? 
          // also possible to kill yourself
          for (int o=0;o<2;o++) {
            // move up .. 
            PVector sph = playerPositions.get(o);
            dx = sqrt((sph.x-postitX)*(sph.x-postitX)+(sph.y-postitY)*(sph.y-postitY));
            if (playerActive!=o) {
            if (dx<0.3f) {
               // draw an x!
               moveTo(postitX,postitY);
               drawTextAt("X",postitX,postitY,0.5f);
               brno = true;
               println("gameover: hit someone");
             break;
            }
            } 
          }
          
       }
      
       if ( brno ) break; 
    }
  
    // wait for next 
    
  
}


// ----------------------
// JumpAndRun 3D
// ----------------------


int gameJumpAndRunDirectionX = 1;
int gameJumpAndRunDirectionY = 0;
int gameJumpAndRunJumpState = 0;

int gameTimerJump = 0;
int gameJumpState = 0; // on ground

public void updateInGameJumpAndRun() {

  // start up / set graphics
  if (gameStateSubRunning.equals("")) {
    gameStateSubRunning="plotting";

    setGameVisualRatio(1.0f);

    resetLines();

    // bigger field
    playfieldWith = 16;
    playfieldHeight = 12;
    playfieldTileSize = 1.0f;

    level = 0;
    life = 0;
    score = 0;

    // loadLevel
    String lv = "          \n"+
      " fffffff \n"+
      " f     f  \n"+
      " f     f  \n"+
      " ff-ffffffffffff \n"+
      " f        f    f \n"+
      " ff-f-ffffffffff \n"+
      "          f  f   \n"+
      "          ffff   \n";
    insertLevel( lv );

    avatarPosition.x = 4;
    avatarPosition.y = 1;


    drawPlayfield();

    moveTo(avatarPosition.x+playfieldTileSize/2, avatarPosition.y+playfieldTileSize/2);
  }

  // finished
  //  gameStateSubRunning="run";
  if (gameStateSubRunning.equals("plotting")) {
    if (plotterReadForInput()) {
      gameStateSubRunning = "running";
      gameTimer = millis();
      gameTimerJump = millis();
      gameJumpState = 0;
    }
  }


  if (gameStateSubRunning=="running") {


    // println("-"+pressedKeyChar);

    // -----------
    //  random
    //  movement
    // -----------
    if (gameTimer<millis()) {
      gameTimer = millis()+500;
      // println("NEXT EVENT");
      // int irnd = (int) random(10);
      // if (irnd==0) avatarPosition.x += 1;
      PVector avatarPositionOld = new PVector();
      avatarPositionOld.x = avatarPosition.x;
      avatarPositionOld.y = avatarPosition.y;

      avatarPosition.x += gameJumpAndRunDirectionX;
      avatarPosition.y += gameJumpAndRunDirectionY;

      // ...
      // position check ...
      int pX16 = (int)avatarPosition.x;
      int pY16 = (int)avatarPosition.y;



      /*   W
       AMD
       S
       */
      String actualPlayfieldM = getPlayfield(pX16, pY16);

      boolean randomDirection = false;

      // RANDOM DIRECTION?
      if (true) {


        int direction = getMovementType();

        int actualDirection = direction;

        int count = 0;
        int[] allDirections = {0, 0, 0, 0};
        for (int h=0; h<4; h++) {
          direction = h;
          setMovementType(direction);
          //             if (h!=antiDirection(actualDirection)) {
          if (true) {
            int pX16N = (int)avatarPosition.x+gameJumpAndRunDirectionX;
            int pY16N = (int)avatarPosition.y+gameJumpAndRunDirectionY;
            String actualPlayfieldNext = getPlayfield(pX16N, pY16N);
            if (!actualPlayfieldNext.equals(" ")) {
              count++;
              allDirections[h] = 1;
            }
          }
        }

        allDirections[antiDirection(actualDirection)] = 0;
        direction = actualDirection;
        setMovementType(actualDirection);

        if (count>2) {
          String ost = "";
          for (int z=0; z<allDirections.length; z++) {
            ost += ""+allDirections[z];
          }
          // println("decision point! "+ost);
        }

        // println("count "+count);
        if (true) {
          if (count>2) {
            // println("decision point!");
            boolean ft = true;
            do {
              int ind = (int) random(4);
              if (allDirections[ind]==1) {
                ft=false;
                setMovementType(ind);
                randomDirection = true;
                direction = ind;
              }
            } while (ft);
          }
          direction = getMovementType();
        }
      }


      if (!randomDirection) {

        // NEXT STEP
        int pX16N = (int)avatarPosition.x+gameJumpAndRunDirectionX;
        int pY16N = (int)avatarPosition.y+gameJumpAndRunDirectionY;
        String actualPlayfieldNext = getPlayfield(pX16N, pY16N);
        if (!actualPlayfieldNext.equals(" ")) {
          // Random check here ...

          // random check ...
          // 3?
        } else {
          // stop
          int direction = getMovementType();
          int firstDirection = direction;
          // println("STOP "+direction);
          for (int h=0; h<4; h++) {
            if (antiDirection(firstDirection)==h) continue;
            direction++;
            direction = direction % 4;
            setMovementType(direction);
            pX16N = (int)avatarPosition.x+gameJumpAndRunDirectionX;
            pY16N = (int)avatarPosition.y+gameJumpAndRunDirectionY;
            actualPlayfieldNext = getPlayfield(pX16N, pY16N);
            if (!actualPlayfieldNext.equals(" ")) {
              // println("BREAK "+direction);
              break;
            }
          }
        } // else
      } // not random direction

      //
      //
      //
      // tot?
      //
      // boden springen?
      //

      // end ..
    }

    // life <1 black trail!

    // -----------
    // keys
    // -----------

    if (gameJumpState==1) {
      if (gameTimerJump<millis()) {
        gameJumpState = 0;
        penDown();
        println("COMING DOWN");
      }
    }

    // -----------
    // keys
    // -----------
    // key / controls

    /*
      if (pressedKeyChar.equals("d")) {
     avatarPosition.x += 1;
     pressedKeyChar = "";
     }
     if (pressedKeyChar.equals("a")) {
     avatarPosition.x -= 1;
     pressedKeyChar = "";
     }
     if (pressedKeyChar.equals("w")) {
     avatarPosition.y -= 1;
     pressedKeyChar = "";
     }
     if (pressedKeyChar.equals("s")) {
     avatarPosition.y += 1;
     pressedKeyChar = "";
     }
     */

    if (pressedKeyChar.equals(" ")) {
      // avatarPosition.x += 1;

      // jump ...
      // jump here ...
      // jump distance ...
      // on a
      String actualPlayfieldX = getPlayfield((int)avatarPosition.x, (int)avatarPosition.y);
      // gameover !!!
      if (actualPlayfieldX.equals("f")) {
        if (gameJumpState==0) {
          gameTimerJump = millis()+2000;
          gameJumpState = 1;
          println("JUMP!JUMP!");
          penUp();
        }
      }

      pressedKeyChar = "";
    }

    //  print("("+pen.x+"/"+pen.y+")");

    // change pen
    if (avatarPosition.x!=avatarPositionOld.x || avatarPosition.y!=avatarPositionOld.y) {

      // default pen down!!
      moveFreeTo(avatarPosition.x+0.5f, avatarPosition.y+0.5f);
    }


    avatarPositionOld.x = avatarPosition.x;
    avatarPositionOld.y = avatarPosition.y;
  }
}

public int getMovementType() {

  if (gameJumpAndRunDirectionX==1) return 0;
  if (gameJumpAndRunDirectionY==1) return 1;
  if (gameJumpAndRunDirectionX==-1) return 2;
  if (gameJumpAndRunDirectionY==-1) return 3;

  return 0;
}

public int antiDirection( int direct ) {

  if (direct==0) return 2;
  if (direct==1) return 3;
  if (direct==2) return 0;
  if (direct==3) return 1;

  return 0;
}

public void setMovementType( int mv ) {

  if (mv==0) {
    gameJumpAndRunDirectionX = 1;
    gameJumpAndRunDirectionY = 0;
  }
  if (mv==1) {
    gameJumpAndRunDirectionX = 0;
    gameJumpAndRunDirectionY = 1;
  }
  if (mv==2) {
    gameJumpAndRunDirectionX = -1;
    gameJumpAndRunDirectionY = 0;
  }

  if (mv==3) {
    gameJumpAndRunDirectionX = 0;
    gameJumpAndRunDirectionY = -1;
  }
}


// ----------------------
// WON AND GAMEOVER
// ----------------------

public void updateGameWon() {
  println("updateGameWon()");
}


public void updateGameOver() {
  println("updateGameOver()");
}


// ----------------------
// updateGUI()
// ----------------------
// update the
// processing gui
// != game gui
//

int guiFieldX = 0;
int guiFieldY = 50;

int guiFieldTextSize = 14;


color colorGUIWhite = color(255, 255, 255);
color colorGUI = color(0, 0, 0);  // BLACK
color colorGUIPen = color(155, 155, 155);  // BLACK
color colorGUIFrame = color(255, 155, 155);  // BLACK

// ON PAPER

int offsetPaperX = 10;
int offsetPaperY = 50;
float guiPaperScale = 50.0f;

// POSITION
Line penPosition = new Line();
Line penPositionX = new Line();



public void updateGUI() {

  // header
  background(colorGUIWhite);
  fill(colorGUI);
  textSize(guiFieldTextSize*2);
  text(""+gameName, 0, guiFieldTextSize*2);

  // state
  textSize(guiFieldTextSize);
  text(""+gameStateRunning+"/"+gameStateSubRunning, guiFieldTextSize*2, guiFieldTextSize*3);

  // stats
  textSize(guiFieldTextSize);
  text("stats ls: "+processLineIndex+"/"+arrLines.size()+" p:"+penState, 600, guiFieldTextSize*3);

  text("level "+level+" score: "+score+" life: "+life, 250, guiFieldTextSize*3);

  // state plotter and co
  textSize(guiFieldTextSize*3/2);
  if (!plotterConnected) {
    text("PLOTTER NOT CONNECTED! SIMULATION!", width*1/3, guiFieldTextSize*2);
  }

  // playground
  // simulation of all !!!
  stroke(colorGUIFrame);
  line(offsetPaperX, offsetPaperY, offsetPaperX+width, offsetPaperY);
  line(offsetPaperX, offsetPaperY, offsetPaperX, offsetPaperY+height);

  // draw Pen
  penPosition.p1.x = pen.x-0.1;
  penPosition.p1.y = pen.y-0.1;
  penPosition.p2.x = pen.x+0.1;
  penPosition.p2.y = pen.y+0.1;

  penPosition.plotted = false;

  if (plotterNothingToDo) penPosition.plotted = true;


  penPosition.colR = 255;
  penPosition.colG = 0;
  penPosition.colB = 0;
  penPosition.colA = 255;

  penPositionX.p1.x = pen.x+0.1;
  penPositionX.p1.y = pen.y-0.1;
  penPositionX.p2.x = pen.x-0.1;
  penPositionX.p2.y = pen.y+0.1;

  penPositionX.colR = 255;
  penPositionX.colG = 0;
  penPositionX.colB = 0;
  penPositionX.colA = 255;

  penPositionX.plotted = false;

  // only true if awa
  if (plotterNothingToDo) penPositionX.plotted = true;

  // tmp
  // shape(tmpShape);

  // debugVectorGraphics
  if (debugVectorGraphics) {
    if (vectorgraphics!=null) {
      shape(vectorgraphics, 10, 10);
    }
  }

  if (simulatePenLinesGUI) {

    // position pointer (virtual!)
    drawGUILine(penPosition);
    drawGUILine(penPositionX);

    // draw all lines
    Line xl;
    for (int z=0; z<arrLines.size(); z++) {
      xl = (Line) arrLines.elementAt(z);
      // check line type ..
      // move vs line ...
      drawGUILine(xl);
    }
  }
  //
}

// -----------------------
// PLAYFIELD
// -----------------------
String[][] arrPlayfield = new String[100][100];
int[][] arrPlayfieldVar = new int[100][100];

int playfieldWithMax = 100;
int playfieldHeightMax = 100;

// generate all to " "
public void resetPlayfield() {
  resetPlayfield(" ");
}

public void resetPlayfield( String str ) {


  try {
    for (int u=0; u<playfieldWithMax; u++) {
      for (int uu=0; uu<playfieldWithMax; uu++) {
        arrPlayfield[u][uu] = str;
      }
    }
  }
  catch( Exception e ) {
    println("resetPlayfield() ERROR! "+e);
  }

  try {
    for (int u=0; u<playfieldWithMax; u++) {
      for (int uu=0; uu<playfieldWithMax; uu++) {
        arrPlayfieldVar[u][uu] = 0;
      }
    }
  }
  catch( Exception e ) {
    println("resetPlayfield() ERROR! "+e);
  }
}

// --------------------
// playfield
// --------------------
// playable
int playfieldWith = 10;
int playfieldHeight = 10;

// " abc d \n"+
// "   def \n";
public void insertLevel( String v ) {

  int p=0;
  int pp = 0;
  for (int i=0; i<v.length(); i++) {
    String chs = ""+v.charAt(i);
    if (chs.equals("\n")) {
      pp++;
      p=0;
    } else {
      arrPlayfield[p][pp] = chs;
      p++;
    }
  }
}

public int checkPlayfieldFor( String val ) {

  int count = 0;

  for (int u=0; u<playfieldWith; u++) {
    for (int uu=0; uu<playfieldHeight; uu++) {
      if (arrPlayfield[u][uu].equals(val)) {
        count++;
      }
    }
  }

  return count;
}

public void randomPlayfield( String[] arrRandom ) {

  for (int u=0; u<playfieldWith; u++) {
    for (int uu=0; uu<playfieldHeight; uu++) {
      int index = (int) random(arrRandom.length);
      arrPlayfield[u][uu] = arrRandom[index];
    }
  }
}

public void playfieldRect(String val, int x, int y, int xx, int yy ) {
  for (int i=x; i<xx+1; i++) {
    arrPlayfield[i][y] = val;
  }

  for (int i=x; i<xx+1; i++) {
    arrPlayfield[i][yy] = val;
  }

  for (int i=y; i<yy+1; i++) {
    arrPlayfield[x][i] = val;
  }

  for (int i=y; i<yy+1; i++) {
    arrPlayfield[xx][i] = val;
  }
}

// offset? / size
float playfieldTileSize = 1.0f;

public void drawPlayfield() {

  for (int u=0; u<playfieldWith+1; u++) {
    for (int uu=0; uu<playfieldHeight+1; uu++) {
      try {
        drawPlayfieldGraphic( u, uu );
      }
      catch (Exception e) {
        println("drawPlayfield() "+e);
      }
    }
  }
}

String debugPlayfield(int startXT, int startYT, int sizeXL, int sizeYL) {


  String vax = "debugPlayfield()\n";
  for (int iy=startYT; iy<(startYT+sizeYL); iy++) {
    vax += iy+" ";
    for (int ix=startXT; ix<(startXT+sizeXL); ix++) {
      vax += ""+getPlayfield(ix, iy);
    }
    vax += "  "+startXT+"  "+(sizeYL)+"\n";
  }

  return vax;
}

// --------------------
// playfield one field
// --------------------

public String getPlayfield( int px, int py ) {
  return arrPlayfield[px][py];
}

// will not draw it!
public void setPlayfield( String val, int px, int py ) {
  // println("setPlayfield() "+val+" "+px+" "+py);
  arrPlayfield[px][py] = val;
}

public void drawPlayfieldGraphic( int u, int uu ) {

  String pf = ""+arrPlayfield[u][uu];
  drawTextAt(pf, u*playfieldTileSize, uu*playfieldTileSize);
}

public void drawPlayfieldGraphicNameAt( String name, float u, float uu ) {

  String pf = ""+name;
  drawTextAt(pf, u*playfieldTileSize, uu*playfieldTileSize);
}

// --------------------
// playfield vars
// --------------------
// for example mines etc
//

public int getPlayfieldVar( int px, int py ) {
  return arrPlayfieldVar[px][py];
}

// will not draw it!
public void setPlayfieldVar( int val, int px, int py ) {
  arrPlayfieldVar[px][py] = val;
}

// -----------------------
// JOYSTICK - DEFAULT
// -----------------------
// 4 directions
// action
int joystickXAxis = 0;
int joystickYAxis = 0;
int joystickXAxisOld = 0;
int joystickYAxisOld = 0;
int joystickXAxisDo = 0;
int joystickYAxisDo = 0;
int joystickAction = 0;
int joystickActionOld = 0;
int joystickActionDo = 0; 

int joystickXAxisDirect = 0;
int joystickYAxisDirect = 0;
int joystickActionDirect = 0;

// getJoystickOrKeyboard("left") onclickevent
// getJoystickOrKeyboard("leftstate") actual state (onpressed)

public boolean getJoystickOrKeyboard( String actionkey ) {

    return getJoystickOrKeyboard( actionkey, true );
}

// onlyOneDirection only one direction ... 
public boolean getJoystickOrKeyboard( String actionkey, boolean onlyOneDirection ) {
   
  // action
  if (actionkey.equals("action")) {
      
    if ((pressedKeyChar.equals(" "))||(pressedKeyChar.equals("e"))) {
       pressedKeyChar = "";
       return true;    
    }
    if (joystickAction==1) {
       joystickAction = 0;
       return true; 
    }
  }
  
  // left
  if (actionkey.equals("left")) {    
    if (pressedKeyChar.equals("a")) {
       pressedKeyChar = "";
       return true;    
    }
    if (joystickXAxisDo==-1) {
       joystickXAxisDo = 0;
       if (onlyOneDirection) joystickYAxisDo = 0;
       return true; 
    }
  }  
  
  // right
  if (actionkey.equals("right")) {    
    if (pressedKeyChar.equals("d")) {
       pressedKeyChar = "";
       return true;    
    }
    if (joystickXAxisDo==1) {
       joystickXAxisDo = 0;
       if (onlyOneDirection) joystickYAxisDo = 0;
       return true; 
    }
  }  

  // up
  if (actionkey.equals("up")) {    
    if (pressedKeyChar.equals("w")) {
       pressedKeyChar = "";
       return true;    
    }
    if (joystickYAxisDo==-1) {
       joystickYAxisDo = 0;
       if (onlyOneDirection) joystickXAxisDo = 0;
       return true; 
    }
  }  
  
  // down
  if (actionkey.equals("down")) {    
    if (pressedKeyChar.equals("s")) {
       pressedKeyChar = "";
       return true;    
    }
    if (joystickYAxisDo==1) {
       joystickYAxisDo = 0;
       if (onlyOneDirection) joystickXAxisDo = 0;
       return true; 
    }
  }  
  
  // direct ...
  
  // actiondirect
  if (actionkey.equals("actiondirect")) {
      
    if ((checkKeyState(" "))||(checkKeyState("e"))) {
       pressedKeyChar = "";
       return true;    
    }
    if (joystickAction==1) {
       return true; 
    }
  }
  
  // leftdirect
  if (actionkey.equals("leftdirect")) {    
    if (checkKeyState("a")) {
       return true;    
    }
    if (joystickXAxis==-1) {
       // if (onlyOneDirection) joystickYAxisDirect = 0;
       return true; 
    }
  }  
  
  // rightdirect
  if (actionkey.equals("rightdirect")) {    
    if (checkKeyState("d")) {
       return true;    
    }
    if (joystickXAxis==1) {
       // if (onlyOneDirection) joystickYAxisDirect = 0;
       return true; 
    }
  }  

  // up
  if (actionkey.equals("updirect")) {    
    if (checkKeyState("w")) {
       pressedKeyChar = "";
       return true;    
    }
    if (joystickYAxis==-1) {
       // if (onlyOneDirection) joystickXAxisDirect = 0;
       return true; 
    }
  }  
  
  // down
  if (actionkey.equals("downdirect")) {    
    if (checkKeyState("s")) {
       pressedKeyChar = "";
       return true;    
    }
    if (joystickYAxis==1) {
       // if (onlyOneDirection) joystickXAxisDirect = 0;
       return true; 
    }
  }    
  
  
  return false;
  
}

// -----------------------
// DRAW
// -----------------------

boolean nextMoveAvailable = true;

boolean mousepressedOn = false;
boolean mouseclicked = false;

int moveStatusO = 0;

void draw() {


  //  if (moveStatusO!=moveStatus) println("moveStatus "+moveStatus);
  //  moveStatus = moveStatusO;

  // check if move is finished!
  int waitTime = nextMoveTime - millis();
  // nextMoveAvailable = false;
  // println("waitTime "+waitTime);
  if (waitTime < 0)
  {
    // moveStatus = 1;  // Flag this move as not yet completed.
    nextMoveAvailable = true;
  }

  if (pressedKeyChar.equals("h")) {
    waitForThePlotter = false;
  }

  // println("nextMoveAvailable "+nextMoveAvailable);

  // println("nextMoveAvailable "+nextMoveAvailable+"  "+floor(millis()/1000));

  // detect click here
  mouseclicked = false;
  if (mousepressedOn==false) {
    if (mousePressed == true) {
      mouseclicked = true;
    }
  }
  mousepressedOn = mousePressed;

  // connect now ...
  if (doSerialConnect)
  {
    // FIRST RUN ONLY:  Connect here, so that
    connectToAxiDraw();
  }

  // startup
  // gamestate ...
  if (SerialOnline)
  {
    if (gameState==0) {
      initGame();
    }
  }


  // update ui
  updateGUI();

  /*
  // simple solution ...
   // wait till end of movement !!!
   int diff = millis() - nextMoveTime;
   //   println(diff);
   //  println("available: "+nextMoveAvailable);
   // nextMoveAvailable = true;
   if (diff>10) {
   nextMoveAvailable = false;
   // return;
   }
   
   if (processLineIndex==-1) {
   nextMoveAvailable = true;
   }
   */

  // process one by one ...
  processLines();

  // println(diff+" available: "+nextMoveAvailable+"   index: "+processLineIndex+"/"+arrLines.size());

  // println("gameStateRunning: -"+gameStateRunning+"-"+gameStateSubRunning+"-");

  // update ingame
  if (gameStateRunning.equals("osc")) {
    updateOSC();

    // stupid things ...


    textSize(14);

    // special gui
    String str = "# OSC (UDP) \n";

    str += "# oscport 127.0.0.1 9007\n";
    str += "#  the osc port in is 9007. send your data here. \n";
    str += "\n";
    str += "  # recording\n";
    str += "  recording: movetoprocess and text will be recorded and executed\n";
    str += "  # commands\n";
    str += "  /clear              simulation only\n";
    str += "  /penup           \n";
    str += "  /pendown\n";
    str += "  /movetox 0.0-1.0    xpos\n";
    str += "  /movetoy 0.0-1.0    ypos\n";
    str += "  /movetoprocess      goto xpos/ypos\n";
    str += "  /square             creates a 1x1 square\n";
    str += "  /cross              creates a 1x1 cross\n";
    str += "  /text BLA           draw text BLA at xpos/ypos\n";

    str += "  \n# message back, if plotter is free\n";
    str += "  server/host: 127.0.0.1\n";
    str += "  port: 9008 \n";
    str += "  /ready\n";
    str += "  // send the command and wait for /ready\n";


    text(str, width/2, 70);


    // move there
    if (mouseclicked) {
      float gfx = (mouseX-offsetPaperX)/guiPaperScale;
      float gfy = (mouseY-offsetPaperY)/guiPaperScale;
      oscX = gfx;
      oscY = gfy;
      lineTo(gfx, gfy);
    }
  }

  // add gui for not osc
  // controls
  if (!gameStateRunning.equals("osc")) {

    textSize(18);
    text("USE wasd + e FOR CONTROL THIS GAMES OR JOYSTICK / DUALSENSE (JOYOSC)\n(TENNIZFORTWO use Dualsense-Analog-controllers with joyosc) \n\nKEY 'm' FOR SELECTION: Start game xyz\nKEY 'm' FOR FIX or restart game\n\nYou can SET startup game/preprinted-mode in setting.txt", 50, 700);
  }
  
  // check for hotkey "menu"
  if (pressedKeyChar.equals("m")) {
    pressedKeyChar = "";
    oldgameStateRunning = gameStateRunning; 
    gameStateRunning = "selection";
    gameStateSubRunning = "";
    
    println("m - menu > resetLines() ");
    resetLines();
  }

  // ---------------------------------
  // default controls ... 
  // ---------------------------------
  // check all osc incomings
  // osc ... 
  
  if (joystickAction!=joystickActionOld) {
    if (joystickAction==1) joystickActionDo = 1; 
  } else {
    joystickActionDo = 0;
  }
  joystickActionOld = joystickAction;

  if (joystickXAxis!=joystickXAxisOld) {
     joystickXAxisDo = joystickXAxis; 
  } else {
    joystickXAxisDo = 0;
  }
  joystickXAxisOld = joystickXAxis;

  if (joystickYAxis!=joystickYAxisOld) {
     joystickYAxisDo = joystickYAxis; 
  } else {
    joystickYAxisDo = 0;
  }
  joystickYAxisOld = joystickYAxis;

  
  // joystick
  String strJoystick = "";
  textSize(14);
  strJoystick += "\nX: "+joystickXAxis+" "+joystickXAxisOld+" Action: "+joystickXAxisDo;
  strJoystick += "\nY: "+joystickYAxis+" "+joystickYAxisOld+" Action: "+joystickYAxisDo;
  strJoystick += "\nB: "+joystickAction+" "+joystickActionOld+" Action: "+joystickActionDo;
  text("#Joystick CompetitionPro/DualSense (JOYOSC)\n"+strJoystick,820,760);

/*
int joystickXAxis = 0;
int joystickYAxis = 0;
int joystickXAxisOld = 0;
int joystickYAxisOld = 0;
int joystickXAxisDo = 0;
int joystickYAxisDo = 0;
int joystickAction = 0;
int joystickActionOld = 0;
int joystickActionDo = 0; 
*/

  // update ingame
  if (gameStateRunning.equals("selection")) updateSelection();

  // update ingame
  if (gameStateRunning.equals("title")) updateGameTitle();

  // update ingame
  if (gameStateRunning.equals("menu")) updateGameMenu();

  // update ingame
  if (gameStateRunning.equals("ingame")) updateInGame();

  // collection ...

  // update ingame madpen
  if (gameStateRunning.equals("ingamemadpen")) updateInGameMadPen();

  // update ingame tron / baracade
  if (gameStateRunning.equals("ingametron")) updateInGameTron();

  // update mines
  if (gameStateRunning.equals("ingamemines")) updateInGameMines();

  // update mines
  if (gameStateRunning.equals("ingamelinejewels")) updateInGameLineJewels();

  // update mines
  if (gameStateRunning.equals("ingametennisfortwo")) updateInGameTennisForTwo();

  // update demo
  if (gameStateRunning.equals("ingamedemotypes")) updateInGameTennisForDemoTypes();

  // update role play
  if (gameStateRunning.equals("ingamerp")) updateInGameRolePlay();

  // update game potshot
  if (gameStateRunning.equals("ingamepotshot")) updateInGamePotshot();

  // update game line ride paint
  if (gameStateRunning.equals("ingamelineridepaint")) updateInGameLineRidePaint();

  // update game space taxi
  if (gameStateRunning.equals("ingamespacetaxi")) updateInGameSpaceTaxi();

  // update game racing
  if (gameStateRunning.equals("ingameracing")) updateInGameRacing();

  // update game ingamerealtime
  if (gameStateRunning.equals("ingamerealtime")) updateInGameRealtime();

  // update game ingamerealtime
  if (gameStateRunning.equals("ingamejump")) updateInGameJump();


  // update ingame tron / baracade
  if (gameStateRunning.equals("ingamejumpandrun")) updateInGameJumpAndRun();

  // update ingame
  if (gameStateRunning=="won") updateGameWon();

  // update ingame
  if (gameStateRunning=="gameover") updateGameOver();
}

// -----------------------
// DRAW
// -----------------------

boolean plotterNothingToDo = false;
int processLineIndex = -1;

int processLineStep = 0;

public void processLines() {

  // if (moveStatus==1) {
    
  try {    

    if (nextMoveAvailable) {
  
      // if (nextMoveAvailable || processLineIndex==-1) {
  
      plotterNothingToDo = false;
  
      if (processLineIndex<arrLines.size()) {
        if (processLineIndex==-1) processLineIndex = 0;
  
  
        Line li = (Line) arrLines.elementAt(processLineIndex);
        
        // optimize: remove moveto / moveto
        if (li.lineType==1) {
// todo disabled linemove          
         if (optimizeLineMove) {
//          if (true) {
            Line liNext = null;
            
            if ((processLineIndex+1)<arrLines.size()) {
              liNext = (Line) arrLines.elementAt(processLineIndex+1);
              if (liNext.lineType==1) {
                processLineIndex = processLineIndex+1;
                li = liNext;
                // println("optimized");
              }  
            }
            
          
          }
        }
        
        
        
        // optimizeLineMove
  
        // line to second
        if (processLineIndex<arrLines.size()) {
  
          li.plotted = true;
  
          if (li.lineType==0) {
            plotterLineTo(li.p2.x, li.p2.y);
          }
          if (li.lineType==1) {
            plotterMoveTo(li.p2.x, li.p2.y);
          }
  
          if (li.lineType==2) {
            plotterMoveFreeTo(li.p2.x, li.p2.y);
          }
  
          // pendown no wait
          if (li.lineType==3) {
             penDownNoWaitPlotter();
          }
          
          // penup no wait
          if (li.lineType==4) {
             penUpNoWaitPlotter();            
          }
          
  
          processLineIndex++;
        }
      } else {
        plotterNothingToDo = true;
      }
  
      //    }
    }
  } catch( Exception e ) {
     
    println("ProcessLines() Exception ");
    println(""+e);
  }
}



// --------------------
// draw
// --------------------
// > will be added
// to lowlevel addLine()
//

// move line
public Line addMoveLine( float x, float y, float xx, float yy ) {
  Line lxz = addLine( new PVector(x, y), new PVector(xx, yy));
  lxz.colR = 0;
  lxz.colG = 255;
  lxz.colB = 0;
  lxz.colA = 64;
  lxz.lineType = 1; // move only
  
  return lxz;
}

public void addMoveFreeLine( float x, float y, float xx, float yy ) {
  Line lxz = addLine( new PVector(x, y), new PVector(xx, yy));
  lxz.colR = 0;
  lxz.colG = 255;
  lxz.colB = 255;
  lxz.colA = 128;
  lxz.lineType = 2; // free move only  - not clear if pen / up down actual !!!
}


public void drawLine( float x, float y, float xx, float yy ) {
  // println("drawLine() "+x+"/"+y+"   "+xx+"/"+yy);
  moveTo(x, y);
  lineTo(xx, yy);
}


public void drawXAt( float xx, float yy ) {
  addShapeXAt(  xx, yy);
}


/*
    -------------------------------------------
    drawTextLINESAt
    -------------------------------------------
    
   
*/

float dlineX = 0.0f;
float dlineY = 0.0f;
int charLAt = 0;

public void drawTextLINESAt( String text, float x, float y, float sizeS ) {
  
    
    for (int z=0;z<text.length();z++) {
       drawCharLINESAt( ""+text.charAt(z), x, y, sizeS );
       // move to up ... 
       // moveTo(x+1.0f*sizeS,y);
        x += 1.0f*sizeS;
       
    }
  
}
   /*
      _______________
        0.0   1.0
    
    
        1.0
        
        > BETTER START . < HERE!
   */
   public void drawCharLINESAt( String ch, float x, float y, float sizeS ) {
    
       boolean found = false;
     
       // go to the start ... 
       moveTo(x,y);
       
       // leftside
       float leftside = sizeS*0.2f;
       
       float maxFontX = sizeS-leftside;
       float maxFontIntX = sizeS-sizeS*0.5f;
     
       // A
       if (ch.equals("A")) {
           lineTo(x,y+sizeS);
           lineTo(x,y);           
           lineTo(x+maxFontX,y);
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x+maxFontX,y+sizeS*0.5f);
           lineTo(x,y+sizeS*0.5f);
           lineTo(x+maxFontX,y+sizeS*0.5f);
           lineTo(x+maxFontX,y);
            found = true;
      }
       // B
       if (ch.equals("B")) {
           lineTo(x,y+sizeS);
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x+maxFontX*0.5f,y+sizeS*0.5f);
           lineTo(x+maxFontX,y);
           lineTo(x,y);
           found = true;
       }
       // C
       if (ch.equals("C")) {
           lineTo(x+maxFontX,y);
           lineTo(x,y);
           lineTo(x,y+sizeS);
           lineTo(x+maxFontX,y+sizeS);
            found = true;
      }
       // D
       if (ch.equals("D")) {
           lineTo(x,y+sizeS);
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x+maxFontX*0.9f,y);
           lineTo(x,y);
            found = true;
      }
       // E
       if (ch.equals("E")) {
           lineTo(x+maxFontX,y);
           lineTo(x,y);
           lineTo(x,y+sizeS*0.5f);
           lineTo(x+maxFontX,y+sizeS*0.5f);
           lineTo(x,y+sizeS*0.5f);
           lineTo(x,y+sizeS);
           lineTo(x+maxFontX,y+sizeS);
            found = true;
      }
       // F
       if (ch.equals("F")) {
           lineTo(x+maxFontX,y);
           lineTo(x,y);
           lineTo(x,y+sizeS*0.5f);
           lineTo(x+maxFontX,y+sizeS*0.5f);
           lineTo(x,y+sizeS*0.5f);
           lineTo(x,y+sizeS);
            found = true;
      }        
       // G
       if (ch.equals("G")) {
           lineTo(x+maxFontX,y);
           lineTo(x,y);
           lineTo(x,y+sizeS);
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x+maxFontX,y+sizeS*0.5f);
           lineTo(x+maxFontX*0.5f,y+sizeS*0.5f);
            found = true;
      } 
       // H
       if (ch.equals("H")) {
           lineTo(x,y+sizeS);
           lineTo(x,y+sizeS*0.5f);
           lineTo(x+maxFontX,y+sizeS*0.5f);
           lineTo(x+maxFontX,y+sizeS);           
           lineTo(x+maxFontX,y);           
            found = true;
      } 
       // I
       if (ch.equals("I")) {
           moveTo(x+maxFontX*0.5f,y);
           lineTo(x+maxFontX*0.5f,y+sizeS);
            found = true;
      } 
       // J
       if (ch.equals("J")) {
           moveTo(x,y+sizeS);
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x+maxFontX,y);
             found = true;
     } 
       // K
       if (ch.equals("K")) {
           lineTo(x,y+sizeS);
           lineTo(x,y+sizeS*0.5f);
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x,y+sizeS*0.5f);
           lineTo(x+maxFontX,y);
            found = true;
      } 
       // L
       if (ch.equals("L")) {
           lineTo(x,y+sizeS);
           lineTo(x+maxFontX,y+sizeS);
            found = true;
      } 
       // M
       if (ch.equals("M")) {
           lineTo(x,y+sizeS);
           lineTo(x,y);
           lineTo(x+maxFontX*0.5f,y+sizeS*0.2);
           lineTo(x+maxFontX,y);
           lineTo(x+maxFontX,y+sizeS);
            found = true;
      } 
       // N
       if (ch.equals("N")) {
           lineTo(x,y+sizeS);
           lineTo(x,y);
           lineTo(x+maxFontX,y);
           lineTo(x+maxFontX,y+sizeS);
            found = true;
      } 
       // O
       if (ch.equals("O")) {
           lineTo(x,y+sizeS);
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x+maxFontX,y);
           lineTo(x,y);
           found = true;
       }
       // P
       if (ch.equals("P")) {
           lineTo(x,y+sizeS);
           lineTo(x,y+sizeS*0.5f);
           lineTo(x+maxFontX,y);
           lineTo(x,y);
           found = true;
       }
       // Q
       if (ch.equals("Q")) {
           lineTo(x,y+sizeS);
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x+maxFontX*0.5f,y+sizeS*0.5f);           
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x+maxFontX,y);
           lineTo(x,y);
           found = true;
       }
       // R
       if (ch.equals("R")) {
           lineTo(x,y+sizeS);
           lineTo(x,y+sizeS*0.5f);
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x,y+sizeS*0.5f);
           lineTo(x+maxFontX,y);
           lineTo(x,y);
           found = true;
       }
       // S
       if (ch.equals("S")) {
           lineTo(x+maxFontX,y);
           lineTo(x,y);
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x,y+sizeS);
           found = true;
       }      
       // T
       if (ch.equals("T")) {
           lineTo(x+maxFontX*0.5,y);
           lineTo(x+maxFontX*0.5,y+sizeS);
           lineTo(x+maxFontX*0.5,y);
           lineTo(x+maxFontX,y);
           found = true;
       } 
       // U
       if (ch.equals("U")) {
           lineTo(x,y+sizeS);
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x+maxFontX,y);
           found = true;
       }       
       // V
       if (ch.equals("V")) {
           lineTo(x+maxFontX*0.5f,y+sizeS);
           lineTo(x+maxFontX,y);
           found = true;
       }       
       // W
       if (ch.equals("W")) {
           lineTo(x,y+sizeS);
           lineTo(x+maxFontX*0.5f,y+sizeS*0.5f);
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x+maxFontX,y);
           found = true;
       }       
       // X
       if (ch.equals("X")) {
           lineTo(x+maxFontX*0.5f,y+sizeS*0.5f);
           lineTo(x,y+sizeS);
           lineTo(x+maxFontX*0.5f,y+sizeS*0.5f);
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x+maxFontX*0.5f,y+sizeS*0.5f);
           lineTo(x+maxFontX,y);
           found = true;
       }
       // Y
       if (ch.equals("Y")) {
           lineTo(x,y+sizeS*0.5f);
           lineTo(x+maxFontX,y+sizeS*0.5f);
           lineTo(x+maxFontX,y+sizeS);
           lineTo(x+maxFontX,y);
           found = true;
       }       
       // Z
       if (ch.equals("Z")) {
           lineTo(x+maxFontX,y);
           lineTo(x,y+sizeS);
           lineTo(x+maxFontX,y+sizeS);
           found = true;
       }     
       
       // !
       if (ch.equals("!")) {
           moveTo(x+maxFontX*0.5f,y);
           lineTo(x+maxFontX*0.5f,y+sizeS*0.7f);
           moveTo(x+maxFontX*0.5f,y+sizeS*0.9f);
           lineTo(x+maxFontX*0.5f,y+sizeS*1.0f);           
           found = true;
      } 
      // ? 
      if (ch.equals("?")) {
           moveTo(x+maxFontX,y);
           lineTo(x+maxFontX*0.5f,y+sizeS*0.5f);
           lineTo(x+maxFontX*0.5f,y+sizeS*0.5f);
           lineTo(x+maxFontX*0.5f,y+sizeS*0.6f);
           moveTo(x+maxFontX*0.5f,y+sizeS*0.9f);
           moveTo(x+maxFontX*0.5f,y+sizeS*1.0f);
           found = true;
      }
      
      // . 
      if (ch.equals(".")) {
           moveTo(x,y+sizeS);
           lineTo(x+maxFontX*0.4f,y+sizeS);
           found = true;
      }
      

       // 0
       if (ch.equals("0")) {
           lineTo(x,y+sizeS);
           lineTo(x+maxFontIntX,y+sizeS);
           lineTo(x+maxFontIntX,y);
           lineTo(x,y);
           found = true;
       } 
       // 1
       if (ch.equals("1")) {
           lineTo(x+maxFontIntX,y);
           lineTo(x+maxFontIntX,y+sizeS);
           found = true;
       } 
       // 2
       if (ch.equals("2")) {
           lineTo(x+maxFontIntX,y);
           lineTo(x,y+sizeS);
           lineTo(x+maxFontIntX,y+sizeS);
           found = true;
       } 
       // 3
       if (ch.equals("3")) {
           lineTo(x+maxFontIntX,y);
           lineTo(x+maxFontIntX*0.5f,y+sizeS*0.5f);
           lineTo(x+maxFontIntX,y+sizeS);
           lineTo(x,y+sizeS);
           found = true;
       } 
      // 4
       if (ch.equals("4")) {
           lineTo(x,y+sizeS*0.5f);
           lineTo(x+maxFontIntX,y+sizeS*0.5f);
           lineTo(x+maxFontIntX,y+sizeS);
           found = true;
       }        
       // 5
       if (ch.equals("5")) {
           lineTo(x+maxFontIntX,y);
           lineTo(x,y);
           lineTo(x,y+sizeS*0.5f);
           lineTo(x+maxFontIntX,y+sizeS*0.5f);
           lineTo(x+maxFontIntX,y+sizeS);
           lineTo(x,y+sizeS);
           found = true;
       } 
       // 6
       if (ch.equals("6")) {
           lineTo(x,y+sizeS*1.0f);
           lineTo(x+maxFontIntX,y+sizeS);
           lineTo(x+maxFontIntX,y+sizeS*0.5f);
           lineTo(x,y+sizeS*0.5f);
           found = true;
       }        
        // 7
       if (ch.equals("7")) {
            lineTo(x+maxFontIntX,y);
            lineTo(x,y+sizeS);
           found = true;
       }               
       if (ch.equals("8")) {
            lineTo(x+maxFontIntX,y);
            lineTo(x,y+sizeS);
            lineTo(x+maxFontIntX,y+sizeS);
            lineTo(x,y);
            lineTo(x+maxFontIntX,y);            
           found = true;
       }        
       if (ch.equals("9")) {
            lineTo(x+maxFontIntX,y);
            lineTo(x+maxFontIntX,y+sizeS);
            lineTo(x+maxFontIntX,y+sizeS*0.5f);
            lineTo(x,y);           
           found = true;
       } 
       
      // linejewels
      // xyz
      // x
      if (ch.equals("x")) {
           lineTo(x+sizeS*0.5f,y+sizeS*0.5f);
           lineTo(x,y+sizeS);
           lineTo(x+sizeS*0.5f,y+sizeS*0.5f);
           lineTo(x+sizeS,y+sizeS);
           lineTo(x+sizeS*0.5f,y+sizeS*0.5f);
           lineTo(x+sizeS,y);
           found = true;
      }
      
      // - 
      if (ch.equals("z")) {
           moveTo(x,y+sizeS*0.5f);
           lineTo(x+sizeS,y+sizeS*0.5f);
           found = true;
      }
      
       // v
       if (ch.equals("y")) {
           lineTo(x+sizeS*0.5f,y+sizeS);
           lineTo(x+sizeS,y);
           found = true;
       }       
      

       
       // not found - search in illustrator .. 
       if (!found) {
          shapeScale = sizeS;
          drawGraphicAt(  ch,  x,  y, true );          
       }
   }

/*
    -------------------------------------------
    drawTextAt() - SVG/Illustrator-drawText
    -------------------------------------------

*/

/*
    higher case: B chars
 lower case specials chars
 f: field
 b: bug
 
 */

public void drawTextAt( String text, float x, float y) {

  drawTextAt(  text, x, y, 1.0f );
}

public void drawTextAt( String text, float x, float y, float sizex ) {
  
  // version 1.0
  // drawTextAtExt(  text,  x,  y,  sizex );
  
  drawTextLINESAt( text,  x,  y,  sizex );
  
}

public void drawTextAtExt( String text, float x, float y, float sizex ) {


  // so much easiert than in assembly .-)
  for (int z=0; z<text.length(); z++) {
    String c = ""+text.charAt(z);

    shapeScale = sizex;
    drawGraphicAt( c, x, y );
    x += 1.0f*shapeScale*sizex;
  }

  // auto go back to 1.0f
  // shapeScale = 1.0f;
}

public void drawLayerAt( String name, float xx, float yy) {
  drawGraphicAt(  name, xx, yy);
}

public void drawGraphicAt( String name, float xx, float yy) {
  drawGraphicAt(  name, xx, yy, true);
}

public void drawGraphicAt( String name, float xx, float yy, boolean moveBack) {

  if (name.charAt(0)!=32) {
    // if (name!=" ") {

    tmpShape = vectorgraphics.getChild(name);
    // addPShapeAt(tmpShape,pen.x,pen.y);
    // println("fire");
    //addLine( new PVector(0,0), pen );
    if (tmpShape!=null) {
      addPShapeAt(tmpShape, xx, yy, moveBack);
    } else {

      println("drawLayerAt() not found: "+name);
      tmpShape = vectorgraphics.getChild("?");
      if (tmpShape!=null) addPShapeAt(tmpShape, xx, yy, moveBack);
    }
  }
}

// from vectorgraphics
public void drawVectorGraphicsLayerAt( String name, float x, float y ) {
}


// ----------------------
// simulated lines
// ----------------------
Vector<Line> arrLines= new Vector<Line>();

public void resetLines() {

  arrLines.clear();

  processLineIndex = -1;
  processLineStep = 0;
  nextMoveAvailable = false;

// arrLines.size()

}

// -------------------------------
// process != add !!
// -------------------------------

public void addLine( Line li ) {
  arrLines.add(li);

  // println("   "+(arrLines.size()-1)+": addLine("+li.p1+"/"+li.p2+") "+((int)li.p1.x)+"/"+((int)li.p1.y));
  // process line !!!!
  // move to first

  // delay(100);
}


public Line addLine(PVector p1, PVector p2) {
  Line lv = new Line();
  lv.p1 = new PVector(p1.x, p1.y);
  lv.p2 = new PVector(p2.x, p2.y);
  addLine(lv);
  return lv;
}

public Line addLine(float x, float y, float xx, float yy) {
  Line lv = new Line();
  lv.p1 = new PVector(x, y);
  lv.p2 = new PVector(xx, yy);
  addLine(lv);
  return lv;
}

public void addShapeXAt( float xx, float yy) {

  Line lv = new Line();
  lv.p1 = new PVector(xx-0.25f, yy-0.25f);
  lv.p2 = new PVector(xx+0.25f, yy+0.25f);
  moveTo(lv.p1.x, lv.p1.y);
  lineTo(lv.p2.x, lv.p2.y);

  // delay(1000);

  Line lx = new Line();
  lx.p1 = new PVector(xx-0.25, yy+0.25);
  lx.p2 = new PVector(xx+0.25, yy-0.25);
  moveTo(lx.p1.x, lx.p1.y);
  lineTo(lx.p2.x, lx.p2.y);

  // delay(1000);

  moveTo( xx, yy );
}



// addShapeAt > addPShapeAt

float shapeScale = 1.0f;

public void addPShapeAt( PShape psenough, float x, float y ) { // .-)

  addPShapeAt( psenough, x, y, true );
}

public void addPShapeAt( PShape psenough, float x, float y, boolean moveBack ) { // .-)

  for (int zz=0; zz<psenough.getChildCount(); zz++) {
    PShape childchild = psenough.getChild(zz);

    // println( " "+zz+". kind: "+childchild.getKind());
    // println( " "+zz+". children "+childchild.getChildCount());
    if (childchild.getKind()==4) { // Lines

      // SVG - lines ins params !!!! not correct in the processing datastructure
      float[] arrF = childchild.getParams();
      if (arrF!=null) {
        if (arrF.length>3) {
          // println( "   "+zz+". element "+r+".param:  "+arrF[r]);
          Line lv = new Line();
          lv.p1 = new PVector();
          lv.p1.x = arrF[0]*importScale*shapeScale+x;
          lv.p1.y = arrF[1]*importScale*shapeScale+y;

          // todo: check if needed ! 
          moveTo(lv.p1.x, lv.p1.y);

          lv.p2 = new PVector();
          lv.p2.x = arrF[2]*importScale*shapeScale+x;
          lv.p2.y = arrF[3]*importScale*shapeScale+y;

          lineTo(lv.p2.x, lv.p2.y);

          // println(zz+": addPShapeAt("+lv.p1+"/"+lv.p2+")");
        }
      }
    } else {
      println("Sorry only supporting LINES");
      // look into processing source code
      // PConstants
      /*
       
       int POINT           = 2;   // primitive
       int POINTS          = 3;   // vertices
       
       int LINE            = 4;   // primitive
       int LINES           = 5;   // beginShape(), createShape()
       int LINE_STRIP      = 50;  // beginShape()
       int LINE_LOOP       = 51;
       
       int TRIANGLE        = 8;   // primitive
       int TRIANGLES       = 9;   // vertices
       int TRIANGLE_STRIP  = 10;  // vertices
       int TRIANGLE_FAN    = 11;  // vertices
       
       int QUAD            = 16;  // primitive
       int QUADS           = 17;  // vertices
       int QUAD_STRIP      = 18;  // vertices
       
       int POLYGON         = 20;  // in the end, probably cannot
       int PATH            = 21;  // separate these two
       
       int RECT            = 30;  // primitive
       int ELLIPSE         = 31;  // primitive
       int ARC             = 32;  // primitive
       
       int SPHERE          = 40;  // primitive
       int BOX             = 41;  // primitive
       */
    }
  }


  shapeScale = 1.0f;

  // todo: problem ...
  if (moveBack) moveTo(x, y);
}


public void drawGUILine(Line li) {

  int colorA = li.colA;

  if (!li.plotted) {
    colorA = 32;
    if (realTimeSimulation) colorA = 0;
  }
  if (colorA<20) colorA = 35;

  stroke(li.colR, li.colG, li.colB, colorA);

  // free pen up/down
  if (li.lineType==2) {
    if (penState==1) stroke(0, 0, 0, 0);
    if (penState==0) stroke(0, 0, 0, 255);
  }

  boolean showF = true;

  if (li.lineType==1) {
    if (!showPenUpLines) showF = false;
  }

  if (showF)
  line(offsetPaperX+li.p1.x*guiPaperScale, offsetPaperY+li.p1.y*guiPaperScale,
    offsetPaperX+li.p2.x*guiPaperScale, offsetPaperY+li.p2.y*guiPaperScale);
}

public class Line {

  // Types?

  int lineType = 0; // 0: normal line  1: just move ..  2: life - pen can be up or down

  boolean plotted = false;

  int colR = 0;
  int colG = 0;
  int colB = 0;
  int colA = 128;


  PVector p1 = new PVector();
  PVector p2 = new PVector();
}


// ----------------------------
// GameObjectFramework
// ----------------------------

public int gameObjectId = 1;

class GameObject {
 
   int id = -1;
    String name = ""; 
    String visual = "X"; // icon 
    String visualBox = "O"; // icon 
    boolean active = true;
    PVector position = new PVector(10.0f,10.0f);
    PVector size = new PVector(1.0f,1.0f);

    PVector sizeBox = new PVector(1.5f,1.5f);
    
    public float dist( float x, float y ) {
      
      float dx = position.x-x;
      float dy = position.y-y;
      
      return sqrt(dx*dx+dy*dy);
    }

}

ArrayList<GameObject> arrGameObjects = new ArrayList<GameObject>();

// draw them all
public void drawGameObjects() {
  // show the structure ... 
  
  println("GameObjects: "+arrGameObjects.size());
  
   for (int z=0;z<arrGameObjects.size();z++) {        
     tmpGO = arrGameObjects.get(z);
     drawGameObject( tmpGO );
   }
  
}

  public void drawGameObject( GameObject obj ) {
      // go there and show
      if (obj.active) {
         
        // println("obj: "+obj.position.x+" "+obj.position.y);
        // moveTo
        moveTo(obj.position.x,obj.position.y);
        // draw
        drawTextAt(""+obj.visual, obj.position.x,obj.position.y, obj.size.x);
        

        
      }
  }

public GameObject addGameObject( String name, String visual, String visualBox, float x, float y, float size) {

  GameObject news = new GameObject();
  news.name = name;
  news.visual = visual;
  news.visualBox = visualBox;
  news.position.x = x;
  news.position.y = y;  
  news.size.x = size;
  news.size.y = size;  
  addGameObject(  news );
  
  return news;

}


public GameObject addGameObject(  GameObject news ) {
  news.id = gameObjectId;
  arrGameObjects.add(news);
  gameObjectId++;
  return news;
}

GameObject tmpGO;

public GameObject getGameObject( String searchfor ) {

   
  for (int z=0;z<arrGameObjects.size();z++) {
     tmpGO = arrGameObjects.get(z);
     if (tmpGO.name.equals(searchfor)) {
        return tmpGO;
     }
  }
  
  return null;
  
}


public boolean getGameObjectState( String keyStr ) {
    
   GameObject kpd = getGameObject( keyStr );
   if (kpd!=null) {
      return kpd.active;
   }
  
   return false;
}

// ----------------------
// SOUND
// ----------------------

public void playPing() {

  if (soundOn)
  gamePing.play();
}

// -----------------------
// PLOTTER HARDWARE
// PEN LINE MOVE
// -----------------------
public void connectToAxiDraw() {

  doSerialConnect = false;

  scanSerial();

  // now online ...
  if (SerialOnline)
  {

    playPing();

    println("# ---------------------------------------------");
    println("# INIT: DoSerialConnect. Send SetUp");
    println("# ---------------------------------------------");
    myPort.write("EM,2\r");  //Configure both steppers to 1/8 step mode

    // Configure brush lift servo endpoints and speed
    myPort.write("SC,4," + str(ServoPaint) + "\r");  // Brush DOWN position, for painting
    myPort.write("SC,5," + str(ServoUp) + "\r");  // Brush UP position

    myPort.write("SC,10,1024\r"); // Set brush raising and lowering speed.

    // delay(1000);

    println("# ---------");
    println("# Init DONE");
    println("# ---------");

    playPing();

    plotterConnected = true;

    initGame();
  } else
  {
    println("\n\nNow entering offline simulation mode.\n\n");
    // audio tune ..
    plotterConnected = false;
    initGame();
  }
}


// ---------------
// pen
// ---------------
int penState = 1; // down ...


public void penUp() {
  offsetDelay = 0;


  if (penState==1) {
    if (myPort!=null)
    myPort.write("SP,0\r");
    // check if up!
    offsetDelay = 0;
    if (waitForThePlotter) {
      offsetDelay = upDownDelay;
      delay(upDownDelay); // todo: dirty solution!!! > draw()
    }
  }
  penState = 0;

  // println(penState+" penState.up");
}

public void penDown() {
  offsetDelay = 0;



  // check if down!
  if (penState==0) {
    if (myPort!=null)
    myPort.write("SP,1\r");

    if (waitForThePlotter) {
      delay(upDownDelay+100);
      offsetDelay = upDownDelay+100;
    }
  }
  penState = 1;
  // println(penState+" penState.down");
}


public void penDownNoWaitPlotter() {
  if (myPort!=null)
  myPort.write("SP,1\r");
  delay(600);
  penState = 1;
  // println(penState+" penState.down");
}
public void penUpNoWaitPlotter() {
  if (myPort!=null)
    myPort.write("SP,0\r");
    delay(600);
    penState = 0;
}



// ----------------------------
// plotter record
// ----------------------------
// record
//



public void lineTo(float x, float y) {
  // println("lineTo() "+x+"/"+y);

  addLine(pen.x, pen.y, x, y);
  pen.x = x;
  pen.y = y;
}

public void moveTo(float x, float y) {

  addMoveLine( pen.x, pen.y, x, y );
  // println("moveTo() "+x+"/"+y);
  pen.x = x;
  pen.y = y;
}

// line without clear state up or down!!!
// jump and run
public void moveFreeTo(float x, float y) {

  addMoveFreeLine( pen.x, pen.y, x, y );
  // println("moveTo() "+x+"/"+y);
  pen.x = x;
  pen.y = y;
}

// in theque!!! pen up/down no wait!
// if you want to use this direct: use penDownNoWaitPlotter() !!!! 

public void penDownNoWait( ) {
  Line pline = addMoveLine( pen.x, pen.y, pen.x, pen.y);
  pline.lineType = 3;
}

public void penUpNoWait() {
  Line pline = addMoveLine( pen.x, pen.y, pen.x, pen.y );
  pline.lineType = 4;
}



// ----------------------------
// plotter primitives
// ----------------------------
// really plot it
//


public void plotterLineTo(float x, float y) {
  // println("lineTo() "+x+"/"+y);

  penDown();

  float pmx = (x+offsetX)*plotterScale;
  float pmy = (y+offsetY)*plotterScale;

  if ((pmx!=x)||(pmy!=y)) {
    MoveToXY( (int) pmx, (int) pmy);
  }
  // delay(100);

  plotterPen.x = x;
  plotterPen.y = y;
}

public void plotterMoveTo(float x, float y) {

  // println("moveTo() "+x+"/"+y);

  // todo: only if before it was down !!!
  // delayAfterRaisingBrush
  
  penUp();

  float pmx = (x+offsetX)*plotterScale;
  float pmy = (y+offsetY)*plotterScale;

  if ((pmx!=x)||(pmy!=y)) {
    MoveToXY( (int) pmx, (int) pmy);
  }
  // delay(100);

  plotterPen.x = x;
  plotterPen.y = y;
}

public void plotterMoveFreeTo(float x, float y) {

  // println("moveTo() "+x+"/"+y);

  float pmx = (x+offsetX)*plotterScale;
  float pmy = (y+offsetY)*plotterScale;

  if ((pmx!=x)||(pmy!=y)) {
    MoveToXY( (int) pmx, (int) pmy);
  }
  // delay(100);

  plotterPen.x = x;
  plotterPen.y = y;
}



public void moveToNullPoint() {
  moveTo(0, 0);
}

// ----------------------------
// Plotter ready?
// ----------------------------


public boolean plotterReadForInput() {

  return plotterNothingToDo;
}

// ----------------------------
// QUIT
// ----------------------------

// go back to 0 ...
// ----------------------------
// back to zero
// back to garage
// ----------------------------
public void backToGarage() {

  if (soundOn) {
    playPing();
  }

  penUp();

  MoveToXY( 0, 0 );
}

// ------------------------
// key events on / off
// ------------------------

class KeyPressedState {
 
    String strKey = "";
    boolean active = false;
  
}

ArrayList<KeyPressedState> arrKeysStateActive = new ArrayList<KeyPressedState>();

public void setKeyState( String keyStr, boolean active ) {
  
   // debugging here 
   String txt = "KeyStates: "+arrKeysStateActive.size();
   
    for (int z=0;z<arrKeysStateActive.size();z++) {
     tmp = arrKeysStateActive.get(z);
     txt += "\n "+tmp.strKey+" : "+tmp.active;
  }
   
  // text(txt,400,200);
  
   KeyPressedState kpd = getPressedKeyState( keyStr );
   if (kpd!=null) {
      kpd.active = active;
      return; 
   }
   
   KeyPressedState news = new  KeyPressedState();
   news.active = active;
   news.strKey = keyStr;
   arrKeysStateActive.add(news);
   
}

KeyPressedState tmp;

public KeyPressedState getPressedKeyState( String searchfor ) {

   
  for (int z=0;z<arrKeysStateActive.size();z++) {
     tmp = arrKeysStateActive.get(z);
     if (tmp.strKey.equals(searchfor)) {
        return tmp;
     }
  }
  
  return null;
  
}


public boolean checkKeyState( String keyStr ) {
    
   KeyPressedState kpd = getPressedKeyState( keyStr );
   if (kpd!=null) {
      return kpd.active;
   }
  
   return false;
}


// --------------------------------------
// Default "notifications" ... 
// --------------------------------------

void keyReleased()
{

  // pressedKeyChar = "";

  if (key == CODED) {

    if (keyCode == UP) keyup = false;
    if (keyCode == DOWN) keydown = false;
    if (keyCode == LEFT) keyleft = false;
    if (keyCode == RIGHT) keyright = false;
  } else {
    key = Character.toLowerCase(key);
    pressedKeyChar = ""+key;
    
    setKeyState(""+key,false);
    
  }
}

String pressedKeyChar = "";

void keyPressed()
{

  //String keyString = new String({key});

  //  keyString.toLowerCase();
  //key = keyString.charAt(0);

  pressedKeyChar = "";

  if (key == CODED) {

    // Arrow keys are used for nudging, with or without shift key.

    if (keyCode == UP)
    {
      keyup = true;
    }
    if (keyCode == DOWN)
    {
      keydown = true;
    }
    if (keyCode == LEFT) keyleft = true;
    if (keyCode == RIGHT) keyright = true;
    if (keyCode == SHIFT) shiftKeyDown = true;
  } else
  {
    key = Character.toLowerCase(key);
    // println("Key pressed " + key);

    // pressedKeyChar = ""+key;

    // ----------------
    // check keys
    // ----------------
    
    setKeyState(""+key,true);


    if ( key == 'b')   // Toggle brush up or brush down with 'b' key
    {
      if (BrushDown) {
        println("RaiseBrush");
        raiseBrush();
      } else {
        println("LowerBrush");
        lowerBrush();
      }
    }

    if ( key == 'z')  // Zero motor coordinates
    zero();

    if ( key == ' ')  //Space bar: Pause
    pause();

    if ( key == 'q')  // Move home (0,0)
    {
      raiseBrush();
      MoveToXY(0, 0);
    }


    if ( key == 't')  // Disable motors, to manually move carriage.
    MotorsOff();

    if ( key == '1')
    MotorSpeed = 500;
    if ( key == '2')
    MotorSpeed = 1000;
    if ( key == '3')
    MotorSpeed = 1500;
    if ( key == '4')
    MotorSpeed = 2000;
    if ( key == '5')
    MotorSpeed = 2500;
    if ( key == '6')
    MotorSpeed = 2900;
    if ( key == '7')
    MotorSpeed = 3200;
    if ( key == '8')
    MotorSpeed = 3500;
    if ( key == '9')
    MotorSpeed = 4000;
  }
}

// ------------------------
// exit
// ------------------------
public void exit() {

  print("exit()");

  backToGarage();

  super.exit();
}

// --------------------------------
// IMPORTANT SETTINGS
// --------------------------------
public void initHardwareSettings() {

  MotorMinX = 0;
  MotorMinY = 0;
  MotorMaxX = int(floor(float(MousePaperRight - MousePaperLeft) * MotorStepsPerPixel)) ;
  MotorMaxY = int(floor(float(MousePaperBottom - MousePaperTop) * MotorStepsPerPixel)) ;

  lastPosition = -1;

  //  if (debugMode) {
  //    println("MotorMinX: " + MotorMinX + "  MotorMinY: " + MotorMinY);
  //    println("MotorMaxX: " + MotorMaxX + "  MotorMaxY: " + MotorMaxY);
  //  }


  ServoUp = 7500 + 175 * ServoUpPct;    // Brush UP position, native units
  ServoPaint = 7500 + 175 * ServoPaintPct;   // Brush DOWN position, native units.

  MotorX = 0;
  MotorY = 0;

  raiseBrushStatus = -1;
  lowerBrushStatus = -1;
  moveStatus = -1;
  MoveDestX = -1;
  MoveDestY = -1;


  Paused = false;
  BrushDownAtPause = false;

  zero();
}


// User Settings:
float MotorSpeed = 4000; // 2500.0;  // Steps per second, 1500 default

// PEN UP AND DOWN!
int ServoUpPct =   80;    // Brush UP position, %  (higher number lifts higher).
int ServoPaintPct = 10;    // Brush DOWN position, %  (higher number lifts higher).

boolean reverseMotorX = false;
boolean reverseMotorY = false;

int upDownDelay = 700; // 800 good ! 

// not used or only used for direct
int delayAfterRaisingBrush = 400; //ms
int delayAfterLoweringBrush = 400; //ms // grafitiy?

// 

int minDist = 4; // Minimum drag distance to record

//boolean debugMode = true;
boolean debugMode = false;


float MotorStepsPerPixel = 16.05;// Good for 1/8 steps-- standard behavior.
float PixelsPerInch = 63.3;

// Hardware resolution: 1016 steps per inch @ 50% max resolution
// Horizontal extent in this window frame is 740 px.
// 1016 steps per inch * (11.69 inches (i.e., A4 length)) per 740 px gives 16.05 motor steps per pixel.
// Vertical travel for 8.5 inches should be  (8.5 inches * 1016 steps/inch) / (16.05 steps/px) = 538 px.
// PixelsPerInch is given by (1016 steps/inch) / (16.05 steps/px).


// Positions of screen items

// -----------------------------
// papersize - virtual!!!
// -----------------------------

int MousePaperLeft =  0;
int MousePaperRight =  1400;
int MousePaperTop =  0;
int MousePaperBottom =  1200;

int yBrushRestPositionPixels = 6;


int ServoUp;    // Brush UP position, native units
int ServoPaint;    // Brush DOWN position, native units.

int MotorMinX;
int MotorMinY;
int MotorMaxX;
int MotorMaxY;

color Black = color(25, 25, 25);  // BLACK
color PenColor = Black;

boolean firstPath;
boolean doSerialConnect = true;
boolean SerialOnline;
Serial myPort;  // Create object from Serial class
int val;        // Data received from the serial port

boolean BrushDown;
boolean BrushDownAtPause;
boolean DrawingPath = false;

int xLocAtPause;
int yLocAtPause;

int MotorX;  // Position of X motor
int MotorY;  // Position of Y motor
int MotorLocatorX;  // Position of motor locator
int MotorLocatorY;
int lastPosition; // Record last encoded position for drawing

int selectedColor;
int selectedWater;
int highlightedWater;
int highlightedColor;


boolean recordingGesture;
boolean forceRedraw;
boolean shiftKeyDown;
boolean keyup = false;
boolean keyright = false;
boolean keyleft = false;
boolean keydown = false;
boolean hKeyDown = false;
int lastButtonUpdateX = 0;
int lastButtonUpdateY = 0;

boolean lastBrushDown_DrawingPath;
int lastX_DrawingPath;
int lastY_DrawingPath;


int nextMoveTime = 0;          //Time we are allowed to begin the next movement (i.e., when the current move will be complete).
int SubsequentWaitTime = -1;    //How long the following movement will take.
int UIMessageExpire;
int raiseBrushStatus;
int lowerBrushStatus;
int moveStatus;
int MoveDestX;
int MoveDestY;
int PaintDest;

boolean Paused;
