/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.ColorPreviewPanel;
import g4p_controls.FilenameChooserFilter;
import g4p_controls.GAbstractControl;
import g4p_controls.GConstants;
import g4p_controls.GControlMode;
import g4p_controls.GWindow;
import g4p_controls.GWindowImpl;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import processing.awt.PSurfaceAWT;
import processing.core.PApplet;
import processing.core.PConstants;

public class G4P
implements GConstants,
PConstants {
    static PApplet sketchWindow = null;
    static GWindowImpl sketchWindowImpl = null;
    static List<GWindow> allWindows = new LinkedList<GWindow>();
    static List<GWindow> windowsForClosing = new LinkedList<GWindow>();
    static boolean announced = false;
    static int globalColorScheme = 6;
    static int globalAlpha = 255;
    static Font inputFont = new Font("Arial", 0, 12);
    static Font displayFont = new Font("Arial", 0, 12);
    static Font sliderFont = new Font("Arial", 1, 11);
    static GAbstractControl.Z_Order zorder = new GAbstractControl.Z_Order();
    static boolean cursorChangeEnabled = false;
    static int mouseOff = 0;
    static boolean showMessages = true;
    static GControlMode control_mode = GControlMode.CORNER;
    static LinkedList<G4Pstyle> styles = new LinkedList();
    static JColorChooser chooser = null;
    static Color lastColor = Color.white;
    static int wheelForSlider = 1;
    static int wheelForScrollbar = 1;
    static int wheelForSpinner = 1;
    private static String PANE_TEXT_STYLE_MACOS = "<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" } p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head> <b>@@TITLE@@</b> <p>@@MESSAGE@@</p>";
    private static String PANE_TEXT_STYLE_OTHER = "<html> <head> <style type=\"text/css\">b { font: 12pt \"Lucida Grande\" } p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head> <b>@@MESSAGE@@ </b>";

    public static String getPrettyVersion() {
        return "4.3.8";
    }

    public static String getVersion() {
        return "47";
    }

    static void registerWindow(GWindow gWindow) {
        if (!allWindows.contains(gWindow)) {
            allWindows.add(gWindow);
        }
    }

    static void deregisterWindow(GWindow gWindow) {
        allWindows.remove(gWindow);
    }

    static void registerControl(GAbstractControl gAbstractControl) {
        PApplet pApplet = gAbstractControl.getPApplet();
        if (pApplet == sketchWindow) {
            sketchWindowImpl.addToWindow(gAbstractControl);
        } else if (pApplet instanceof GWindow) {
            ((GWindow)pApplet).addToWindow(gAbstractControl);
        }
    }

    public static void registerSketch(PApplet pApplet) {
        if (sketchWindow == null && pApplet != null) {
            sketchWindow = pApplet;
            sketchWindowImpl = new GWindowImpl(sketchWindow);
            G4P.announceG4P();
        }
    }

    static void invalidateBuffers() {
        for (GWindow gWindow : allWindows) {
            gWindow.invalidateBuffers();
        }
        if (sketchWindowImpl != null) {
            sketchWindowImpl.invalidateBuffers();
        }
    }

    public static void setGlobalColorScheme(int n) {
        if (globalColorScheme != (n = Math.abs(n) % 16)) {
            globalColorScheme = n;
            for (GWindow gWindow : allWindows) {
                gWindow.setColorScheme(globalColorScheme);
            }
            if (sketchWindowImpl != null) {
                sketchWindowImpl.setColorScheme(globalColorScheme);
            }
        }
    }

    public static void usePre35Fonts() {
        displayFont = new Font("Dialog", 0, 10);
        sliderFont = new Font("DialogInput", 1, 12);
    }

    public static void setInputFont(String string, int n, int n2) {
        inputFont = new Font(string, n, Math.max(n2, 6));
    }

    public static void setDisplayFont(String string, int n, int n2) {
        displayFont = new Font(string, n, Math.max(n2, 6));
    }

    public static void setSliderFont(String string, int n, int n2) {
        sliderFont = new Font(string, n, Math.max(n2, 6));
    }

    public static void setWindowColorScheme(PApplet pApplet, int n) {
        n = Math.abs(n) % 16;
        if (pApplet == sketchWindow) {
            if (sketchWindowImpl != null) {
                sketchWindowImpl.setColorScheme(n);
            }
        } else if (pApplet instanceof GWindow) {
            ((GWindow)pApplet).setColorScheme(n);
        }
    }

    public static void setGlobalAlpha(int n) {
        if (globalAlpha != (n = Math.abs(n) % 256)) {
            globalAlpha = n;
            for (GWindow gWindow : allWindows) {
                gWindow.setAlpha(globalAlpha);
            }
            if (sketchWindowImpl != null) {
                sketchWindowImpl.setAlpha(globalAlpha);
            }
        }
    }

    public static void setWindowAlpha(PApplet pApplet, int n) {
        n = Math.abs(n) % 256;
        if (pApplet == sketchWindow) {
            if (sketchWindowImpl != null) {
                sketchWindowImpl.setAlpha(n);
            }
        } else if (pApplet instanceof GWindow) {
            ((GWindow)pApplet).setAlpha(n);
        }
    }

    static void announceG4P() {
        if (!announced) {
            System.out.println("=======================================================");
            System.out.println("   G4P V4.3.8 created by Peter Lager");
            System.out.println("=======================================================");
            announced = true;
        }
    }

    static boolean removeControl(GAbstractControl gAbstractControl) {
        PApplet pApplet = gAbstractControl.getPApplet();
        if (pApplet == sketchWindow) {
            if (sketchWindowImpl != null) {
                sketchWindowImpl.removeFromWindow(gAbstractControl);
                return true;
            }
            return false;
        }
        if (pApplet instanceof GWindow) {
            ((GWindow)pApplet).removeFromWindow(gAbstractControl);
            return true;
        }
        return false;
    }

    public static void setCtrlMode(GControlMode gControlMode) {
        if (gControlMode != null) {
            control_mode = gControlMode;
        }
    }

    public static GControlMode getCtrlMode() {
        return control_mode;
    }

    public static void messagesEnabled(boolean bl) {
        showMessages = bl;
    }

    public static void setMouseOverEnabled(boolean bl) {
        cursorChangeEnabled = bl;
    }

    public static void mouseWheelSliderDirection(int n) {
        if (n == 1 || n == -1) {
            wheelForSlider = n;
        }
    }

    public static void mouseWheelScrollbarDirection(int n) {
        if (n == 1 || n == -1) {
            wheelForScrollbar = n;
        }
    }

    public static void mouseWheelSpinnerDirection(int n) {
        if (n == 1 || n == -1) {
            wheelForSpinner = n;
        }
    }

    @Deprecated
    public static void setCursorOff(int n) {
        mouseOff = n;
    }

    public static void setCursor(int n) {
        mouseOff = n;
        for (GWindow gWindow : allWindows) {
            gWindow.cursor(n);
        }
        if (sketchWindow != null) {
            sketchWindow.cursor(n);
        }
    }

    public static int getCursor() {
        return mouseOff;
    }

    @Deprecated
    public static int getCursorOff() {
        return mouseOff;
    }

    static void pushStyle() {
        G4Pstyle g4Pstyle = new G4Pstyle();
        g4Pstyle.ctrlMode = control_mode;
        g4Pstyle.showMessages = showMessages;
        styles.addLast(g4Pstyle);
    }

    static void popStyle() {
        G4Pstyle g4Pstyle = styles.removeLast();
        control_mode = g4Pstyle.ctrlMode;
        showMessages = g4Pstyle.showMessages;
    }

    public static ArrayList<GWindow> getOpenWindowsAsList(ArrayList<GWindow> arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        } else {
            arrayList.clear();
        }
        for (GWindow gWindow : allWindows) {
            arrayList.add(gWindow);
        }
        return arrayList;
    }

    public static GWindow[] getOpenWindowsAsArray() {
        ArrayList<GWindow> arrayList = G4P.getOpenWindowsAsList(null);
        return arrayList.toArray(new GWindow[arrayList.size()]);
    }

    public static boolean isWindowOpen(GWindow gWindow) {
        return gWindow != null && allWindows.contains(gWindow);
    }

    public static int selectColor() {
        return G4P.selectColorImpl(null);
    }

    public static int selectColor(Color color) {
        return G4P.selectColorImpl(color);
    }

    public static int selectColor(int n) {
        return G4P.selectColorImpl(new Color(n));
    }

    public static int selectColor(int n, int n2, int n3) {
        return G4P.selectColorImpl(new Color(n &= 0xFF, n2 &= 0xFF, n3 &= 0xFF));
    }

    protected static int selectColorImpl(Color color) {
        Object object;
        Color color2 = lastColor = color == null ? Color.WHITE : color;
        if (chooser == null) {
            chooser = new JColorChooser(lastColor);
            object = chooser.getChooserPanels();
            LinkedList<AbstractColorChooserPanel> linkedList = new LinkedList<AbstractColorChooserPanel>();
            for (AbstractColorChooserPanel abstractColorChooserPanel : object) {
                String string = abstractColorChooserPanel.getDisplayName().toLowerCase();
                if (string.equals("swatches")) {
                    linkedList.addLast(abstractColorChooserPanel);
                    continue;
                }
                if (string.equals("rgb")) {
                    linkedList.addFirst(abstractColorChooserPanel);
                    continue;
                }
                if (!string.startsWith("hs")) continue;
                linkedList.addFirst(abstractColorChooserPanel);
            }
            AbstractColorChooserPanel[] abstractColorChooserPanelArray = linkedList.toArray(new AbstractColorChooserPanel[linkedList.size()]);
            chooser.setChooserPanels(abstractColorChooserPanelArray);
            ColorPreviewPanel colorPreviewPanel = new ColorPreviewPanel(lastColor);
            chooser.getSelectionModel().addChangeListener(colorPreviewPanel);
            chooser.setPreviewPanel(colorPreviewPanel);
        }
        ((ColorPreviewPanel)chooser.getPreviewPanel()).setPrevColor(lastColor);
        chooser.setColor(lastColor);
        object = JColorChooser.createDialog(null, "Color picker", true, chooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                lastColor = chooser.getColor();
            }
        }, null);
        ((Dialog)object).setVisible(true);
        return lastColor.getRGB();
    }

    public static String selectFolder(String string) {
        String string2 = null;
        Frame frame = G4P.getFrame(sketchWindow);
        if (PApplet.platform == 2) {
            FileDialog fileDialog = new FileDialog(frame, string, 0);
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fileDialog.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            String string3 = fileDialog.getFile();
            if (string3 != null) {
                try {
                    string2 = new File(fileDialog.getDirectory(), fileDialog.getFile()).getCanonicalPath();
                }
                catch (IOException iOException) {
                    string2 = null;
                }
            }
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(string);
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(frame);
            if (n == 0) {
                try {
                    string2 = jFileChooser.getSelectedFile().getCanonicalPath();
                }
                catch (IOException iOException) {
                    string2 = null;
                }
            }
        }
        return string2;
    }

    public static String selectInput(String string) {
        return G4P.selectImpl(string, 0, null, null, null);
    }

    public static String selectInput(String string, String string2) {
        return G4P.selectImpl(string, 0, null, null, string2);
    }

    public static String selectInput(String string, String string2, String string3) {
        return G4P.selectImpl(string, 0, string2, string3, null);
    }

    public static String selectInput(String string, String string2, String string3, String string4) {
        return G4P.selectImpl(string, 0, string2, string3, string4);
    }

    public static String selectOutput(String string) {
        return G4P.selectImpl(string, 1, null, null, null);
    }

    public static String selectOutput(String string, String string2) {
        return G4P.selectImpl(string, 1, null, null, string2);
    }

    public static String selectOutput(String string, String string2, String string3) {
        return G4P.selectImpl(string, 1, string2, string3, null);
    }

    public static String selectOutput(String string, String string2, String string3, String string4) {
        return G4P.selectImpl(string, 1, string2, string3, string4);
    }

    private static String selectImpl(String string, int n, String string2, String string3, String string4) {
        String string5 = null;
        Frame frame = G4P.getFrame(sketchWindow);
        if (PApplet.platform == 2 || PApplet.useNativeSelect) {
            FileDialog fileDialog = new FileDialog(frame, string, n);
            FilenameChooserFilter filenameChooserFilter = null;
            if (string2 != null && string2.length() > 0) {
                filenameChooserFilter = new FilenameChooserFilter(string2);
                fileDialog.setFilenameFilter(filenameChooserFilter);
            }
            fileDialog.setDirectory(string4);
            fileDialog.setVisible(true);
            String string6 = fileDialog.getDirectory();
            if (string6 != null && (string5 = fileDialog.getFile()) != null) {
                try {
                    string5 = new File(string6, string5).getCanonicalPath();
                }
                catch (IOException iOException) {
                    string5 = null;
                }
            }
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(string);
            if (string2 != null && string2.length() > 0) {
                String[] stringArray = PApplet.split((String)string2.toLowerCase(), (char)',');
                jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter(string3, stringArray));
            }
            jFileChooser.setAcceptAllFileFilterUsed(true);
            try {
                jFileChooser.setCurrentDirectory(new File(string4));
            }
            catch (NullPointerException nullPointerException) {
                jFileChooser.setCurrentDirectory(null);
            }
            int n2 = -1;
            if (n == 1) {
                n2 = jFileChooser.showSaveDialog(frame);
            } else if (n == 0) {
                n2 = jFileChooser.showOpenDialog(frame);
            }
            if (n2 == 0) {
                try {
                    string5 = jFileChooser.getSelectedFile().getCanonicalPath();
                }
                catch (IOException iOException) {
                    string5 = null;
                }
            }
        }
        return string5;
    }

    public static void showMessage(PApplet pApplet, String string, String string2, int n) {
        String string3;
        if (PApplet.platform == 2) {
            string3 = PANE_TEXT_STYLE_MACOS.replaceAll("@@TITLE@@", string2);
            string2 = "";
            string3 = string3.replaceAll("@@MESSAGE@@", string);
        } else {
            string3 = PANE_TEXT_STYLE_OTHER.replaceAll("@@MESSAGE@@", string);
        }
        JOptionPane.showMessageDialog(null, string3, string2, n);
    }

    public static int selectOption(PApplet pApplet, String string, String string2, int n, int n2) {
        String string3;
        if (PApplet.platform == 2) {
            string3 = PANE_TEXT_STYLE_MACOS.replaceAll("@@TITLE@@", string2);
            string2 = "";
            string3 = string3.replaceAll("@@MESSAGE@@", string);
        } else {
            string3 = PANE_TEXT_STYLE_OTHER.replaceAll("@@MESSAGE@@", string);
        }
        return JOptionPane.showOptionDialog(null, string3, string2, n2, n, null, null, null);
    }

    private static Frame getFrame(PApplet pApplet) {
        Frame frame = null;
        try {
            frame = ((PSurfaceAWT.SmoothCanvas)pApplet.getSurface().getNative()).getFrame();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return frame;
    }

    static class G4Pstyle {
        GControlMode ctrlMode;
        boolean showMessages;

        G4Pstyle() {
        }
    }
}

