/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GAlign;
import g4p_controls.GIcon;
import g4p_controls.HotSpot;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PImage;
import processing.event.MouseEvent;

public class GControlPalette
extends GAbstractControl {
    protected static int PALETTE = 1;
    protected static int TAB = 0;
    protected GIcon icon;
    protected GAlign prefAlign;
    protected GAlign currAlign;
    protected int padding = 3;
    protected float bdrWeight = 1.0f;
    protected float bdrCorner = 4.0f;
    protected float rX;
    protected float rY;
    protected float rW;
    protected float rH;
    protected boolean rVisible = false;
    protected boolean beingDragged = false;
    private float pLengthEW;
    private float pLengthNS;
    private float maxWidth = 0.0f;
    private float maxHeight = 0.0f;

    public GControlPalette(PApplet pApplet, GIcon gIcon, GAlign gAlign, float f, float f2) {
        super(pApplet);
        this.children = new LinkedList();
        this.icon = gIcon.owner != null ? gIcon.copy() : gIcon;
        this.icon.owner = this;
        this.cx = f;
        this.cy = f2;
        this.width = this.icon.width();
        this.height = this.icon.height();
        this.halfWidth = this.width / 2.0f;
        this.halfHeight = this.height / 2.0f;
        this.x = this.cx - this.halfWidth;
        this.y = this.cy - this.halfHeight;
        this.makeBuffer();
        this.prefAlign = this.currAlign = gAlign;
        this.calcHotSpots();
        this.z = 1024;
        this.registeredMethods = 3;
        this.cursorOver = 12;
        this.bufferInvalid = true;
        G4P.registerControl(this);
    }

    protected void updateControlPositions() {
        this.maxHeight = 0.0f;
        this.maxWidth = 0.0f;
        this.pLengthNS = 0.0f;
        this.pLengthEW = 0.0f;
        for (GAbstractControl gAbstractControl : this.children) {
            if (gAbstractControl.getWidth() > this.maxWidth) {
                this.maxWidth = gAbstractControl.getWidth();
            }
            if (gAbstractControl.getHeight() > this.maxHeight) {
                this.maxHeight = gAbstractControl.getHeight();
            }
            this.pLengthEW += gAbstractControl.getWidth() + (float)(2 * this.padding);
            this.pLengthNS += gAbstractControl.getHeight() + (float)(2 * this.padding);
        }
        switch (this.currAlign) {
            case EAST: {
                this.makeAlignEAST(this.maxWidth, this.maxHeight);
                break;
            }
            case WEST: {
                this.makeAlignWEST(this.maxWidth, this.maxHeight);
                break;
            }
            case SOUTH: {
                this.makeAlignSOUTH(this.maxWidth, this.maxHeight);
                break;
            }
            case NORTH: {
                this.makeAlignNORTH(this.maxWidth, this.maxHeight);
                break;
            }
        }
    }

    public void setAlign(GAlign gAlign) {
        if (this.isValid(gAlign) && gAlign != this.currAlign) {
            this.currAlign = gAlign;
            this.updateControlPositions();
        }
    }

    public void setPrefAlign(GAlign gAlign) {
        if (this.isValid(gAlign) && gAlign != this.prefAlign) {
            this.prefAlign = gAlign;
            this.adjustAlignment();
        }
    }

    protected void adjustAlignment() {
        if (this.currAlign != this.prefAlign) {
            if (this.fitsScreen(this.prefAlign)) {
                this.currAlign = this.prefAlign;
                this.updateControlPositions();
            }
        } else if (!this.fitsScreen(this.prefAlign) && this.fitsScreen(this.opposite(this.prefAlign))) {
            this.currAlign = this.opposite(this.prefAlign);
            this.updateControlPositions();
        }
    }

    private GAlign opposite(GAlign gAlign) {
        switch (gAlign) {
            case NORTH: {
                return GAlign.SOUTH;
            }
            case SOUTH: {
                return GAlign.NORTH;
            }
            case EAST: {
                return GAlign.WEST;
            }
            case WEST: {
                return GAlign.EAST;
            }
        }
        return null;
    }

    protected boolean isValid(GAlign gAlign) {
        switch (gAlign) {
            case EAST: 
            case WEST: 
            case SOUTH: 
            case NORTH: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addControl(GAbstractControl gAbstractControl) {
        if (this.addControlImpl(gAbstractControl)) {
            this.updateControlPositions();
        }
    }

    public void addControl(int n, GAbstractControl gAbstractControl) {
        if (this.addControlImpl(n, gAbstractControl)) {
            this.updateControlPositions();
        }
    }

    @Override
    public void addControls(GAbstractControl ... gAbstractControlArray) {
        boolean bl = false;
        for (GAbstractControl gAbstractControl : gAbstractControlArray) {
            bl |= this.addControlImpl(gAbstractControl);
        }
        if (bl) {
            this.updateControlPositions();
        }
    }

    public void addControls(int n, GAbstractControl ... gAbstractControlArray) {
        boolean bl = false;
        for (GAbstractControl gAbstractControl : gAbstractControlArray) {
            if (!this.addControlImpl(n, gAbstractControl)) continue;
            ++n;
            bl = true;
        }
        if (bl) {
            this.updateControlPositions();
        }
    }

    private boolean addControlImpl(GAbstractControl gAbstractControl) {
        if (!this.children.contains(gAbstractControl)) {
            this.prepareControl(gAbstractControl);
            this.children.addLast(gAbstractControl);
            return true;
        }
        return false;
    }

    private boolean addControlImpl(int n, GAbstractControl gAbstractControl) {
        if (!this.children.contains(gAbstractControl) && n >= 0 && n <= this.children.size()) {
            this.prepareControl(gAbstractControl);
            this.children.add(n, gAbstractControl);
            return true;
        }
        return false;
    }

    private GAbstractControl prepareControl(GAbstractControl gAbstractControl) {
        gAbstractControl.parent = this;
        gAbstractControl.setZ(this.z);
        gAbstractControl.registeredMethods &= 0x1E;
        gAbstractControl.addToParent(this);
        return gAbstractControl;
    }

    public boolean remove(GAbstractControl gAbstractControl) {
        if (this.children.remove(gAbstractControl)) {
            gAbstractControl.parent = null;
            gAbstractControl.setVisible(false);
            this.updateControlPositions();
            this.children.remove(gAbstractControl);
            return true;
        }
        return false;
    }

    public GAbstractControl remove(int n) {
        try {
            GAbstractControl gAbstractControl = (GAbstractControl)this.children.remove(n);
            gAbstractControl.parent = null;
            gAbstractControl.setVisible(false);
            this.updateControlPositions();
            return gAbstractControl;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public boolean fitsScreen(GAlign gAlign) {
        boolean bl = false;
        if (this.isValid(gAlign)) {
            switch (gAlign) {
                case NORTH: {
                    bl = this.cy - this.halfHeight - this.pLengthNS > 0.0f;
                    break;
                }
                case SOUTH: {
                    bl = this.cy + this.halfHeight + this.pLengthNS < (float)this.winApp.height;
                    break;
                }
                case EAST: {
                    bl = this.cx + this.halfWidth + this.pLengthEW < (float)this.winApp.width;
                    break;
                }
                case WEST: {
                    bl = this.cx - this.halfWidth - this.pLengthEW > 0.0f;
                    break;
                }
            }
        }
        return bl;
    }

    @Override
    public void addControl(GAbstractControl gAbstractControl, float f, float f2) {
    }

    @Override
    public void addControl(GAbstractControl gAbstractControl, float f, float f2, float f3) {
    }

    private void calcHotSpots() {
        this.hotspots = new HotSpot[]{new HotSpot.HSrect(TAB, -1.0f, -1.0f, this.width + 1.0f, this.height + 1.0f), new HotSpot.HSrect(PALETTE, 0.0f, 0.0f, 0.0f, 0.0f)};
    }

    public void setPadding(int n) {
        if (n >= 2) {
            this.padding = n;
        }
    }

    public void setBorder(float f, float f2) {
        this.bdrWeight = f;
        this.bdrCorner = f2;
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot == 0 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (focusIsWith == this || this.currSpot != 0 || this.z < this.focusObjectZ()) break;
                this.takeFocus();
                this.beingDragged = false;
                break;
            }
            case 3: {
                if (focusIsWith != this) break;
                this.rVisible = false;
                this.bufferInvalid = true;
                this.beingDragged = false;
                this.loseFocus(this.parent);
                break;
            }
            case 2: {
                if (focusIsWith != this || !this.beingDragged) break;
                this.rVisible = false;
                this.beingDragged = false;
                this.loseFocus(this.parent);
                break;
            }
            case 5: {
                if (focusIsWith != this && this.currSpot == 0) {
                    this.rVisible = true;
                    this.takeFocus();
                }
                if (focusIsWith != this || this.currSpot >= 0) break;
                this.rVisible = false;
                this.loseFocus(this.parent);
                break;
            }
            case 4: {
                if (focusIsWith != this) break;
                this.cx += (float)(this.winApp.mouseX - this.winApp.pmouseX);
                this.cy += (float)(this.winApp.mouseY - this.winApp.pmouseY);
                this.x = this.cx - this.width / 2.0f;
                this.y = this.cy - this.height / 2.0f;
                this.beingDragged = true;
                this.adjustAlignment();
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.updateBuffer();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.imageMode(3);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        if (this.rVisible) {
            this.winApp.stroke(this.palette[3].getRGB());
            this.winApp.strokeWeight(this.bdrWeight);
            if (this.opaque) {
                this.winApp.fill(this.palette[6].getRGB());
            } else {
                this.winApp.noFill();
            }
            this.winApp.rect(this.rX, this.rY, this.rW, this.rH, this.bdrCorner);
            for (GAbstractControl gAbstractControl : this.children) {
                gAbstractControl.draw();
            }
        }
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            this.buffer.clear();
            if (this.opaque) {
                this.buffer.fill(this.palette[6].getRGB());
                this.buffer.noStroke();
                this.buffer.rect(0.0f, 0.0f, this.width, this.height);
            }
            this.buffer.image(this.icon.getFrame(), 0.0f, 0.0f);
            this.buffer.endDraw();
        }
    }

    private void makeAlignNORTH(float f, float f2) {
        float f3;
        float f4 = this.halfWidth + 1.0f;
        float f5 = f3 = 0.0f;
        for (GAbstractControl gAbstractControl : this.children) {
            float f6 = f4 - gAbstractControl.getWidth() / 2.0f;
            gAbstractControl.moveTo(f6, f5 -= (float)this.padding + gAbstractControl.getHeight());
            f5 -= (float)this.padding;
        }
        this.rW = f + (float)(2 * this.padding);
        this.rH = f3 - f5;
        this.rX = -this.rW / 2.0f;
        this.rY = -this.halfHeight - this.rH;
        this.hotspots[1] = new HotSpot.HSrect(PALETTE, this.rX + this.halfWidth, this.rY + this.halfHeight, this.rW, this.rH);
    }

    private void makeAlignSOUTH(float f, float f2) {
        float f3;
        float f4 = this.halfWidth + 1.0f;
        float f5 = f3 = this.height;
        for (GAbstractControl gAbstractControl : this.children) {
            float f6 = f4 - gAbstractControl.getWidth() / 2.0f;
            gAbstractControl.moveTo(f6, f5 += (float)this.padding);
            f5 += gAbstractControl.getHeight() + (float)this.padding;
        }
        this.rW = f + (float)(2 * this.padding);
        this.rH = f5 - f3;
        this.rX = -this.rW / 2.0f;
        this.rY = this.halfHeight;
        this.hotspots[1] = new HotSpot.HSrect(PALETTE, this.rX + this.halfWidth, this.rY + this.halfHeight, this.rW, this.rH);
    }

    private void makeAlignEAST(float f, float f2) {
        float f3 = this.width;
        float f4 = this.halfHeight + 1.0f;
        float f5 = f3;
        for (GAbstractControl gAbstractControl : this.children) {
            float f6 = f4 - gAbstractControl.getHeight() / 2.0f;
            gAbstractControl.moveTo(f5 += (float)this.padding, f6);
            f5 += gAbstractControl.getWidth() + (float)this.padding;
        }
        this.rW = f5 - f3;
        this.rH = f2 + (float)(2 * this.padding);
        this.rX = this.halfWidth;
        this.rY = -this.rH / 2.0f;
        this.hotspots[1] = new HotSpot.HSrect(PALETTE, this.rX + this.halfWidth, this.rY + this.halfHeight, this.rW, this.rH);
    }

    private void makeAlignWEST(float f, float f2) {
        float f3 = 0.0f;
        float f4 = this.halfHeight + 1.0f;
        float f5 = f3;
        for (GAbstractControl gAbstractControl : this.children) {
            float f6 = f4 - gAbstractControl.getHeight() / 2.0f;
            gAbstractControl.moveTo(f5 -= (float)this.padding + gAbstractControl.getWidth(), f6);
            f5 -= (float)this.padding;
        }
        this.rW = f3 - f5;
        this.rH = f2 + (float)(2 * this.padding);
        this.rX = -this.halfWidth - this.rW;
        this.rY = -this.rH / 2.0f;
        this.hotspots[1] = new HotSpot.HSrect(PALETTE, this.rX + this.halfWidth, this.rY + this.halfHeight, this.rW, this.rH);
    }
}

