/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GEvent;
import g4p_controls.GLinearTrackControl;
import g4p_controls.GValueControl;
import g4p_controls.HotSpot;
import g4p_controls.StyledString;
import java.awt.Graphics2D;
import processing.core.PApplet;

public class GSlider
extends GLinearTrackControl {
    static int BACK = 6;
    static int TOFF = 3;
    static int TOVER = 11;
    static int TDOWN = 14;
    static int TDRAG = 15;

    public GSlider(PApplet pApplet, float f, float f2, float f3, float f4, float f5) {
        super(pApplet, f, f2, f3, f4);
        this.makeBuffer();
        this.trackWidth = f5;
        this.trackDisplayLength = this.width - 2.0f * TINSET;
        this.trackLength = this.trackDisplayLength - this.trackWidth;
        this.trackOffset = this.calcTrackOffset();
        this.hotspots = new HotSpot[]{new HotSpot.HScircle(THUMB_SPOT, this.width / 2.0f + (this.parametricPos - 0.5f) * this.trackLength, this.height / 2.0f, this.trackWidth / 2.0f), new HotSpot.HSrect(TRACK_SPOT, (this.width - this.trackLength) / 2.0f, (this.height - this.trackWidth) / 2.0f, this.trackLength, this.trackWidth)};
        this.z = 24;
        epsilon = 0.98f / this.trackLength;
        this.ssStartLimit = new StyledString("0.00");
        this.ssEndLimit = new StyledString("1.00");
        this.ssValue = new StyledString("0.50");
        this.createEventHandler(G4P.sketchWindow, "handleSliderEvents", new Class[]{GValueControl.class, GEvent.class}, new String[]{"slider", "event"});
        this.registeredMethods = 7;
        this.cursorOver = 12;
        this.localFont = G4P.sliderFont;
        this.bufferInvalid = true;
        G4P.registerControl(this);
    }

    @Override
    protected void updateDueToValueChanging() {
        this.hotspots[0].x = this.width / 2.0f + (this.parametricPos - 0.5f) * this.trackLength;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.status = 0;
        }
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            Graphics2D graphics2D = this.buffer.g2;
            graphics2D.setFont(this.localFont);
            this.buffer.rectMode(3);
            this.buffer.ellipseMode(3);
            this.buffer.background(this.opaque ? this.palette[6].getRGB() : this.palette[2].getRGB() & 0xFFFFFF | 0x10101);
            this.buffer.pushMatrix();
            this.buffer.translate(this.width / 2.0f, this.height / 2.0f);
            if (this.showTicks) {
                float f = 1.0f / (float)(this.nbrTicks - 1);
                for (int i = 0; i < this.nbrTicks; ++i) {
                    float f2 = ((float)i * f - 0.5f) * this.trackLength;
                    this.buffer.strokeWeight(2.0f);
                    this.buffer.stroke(this.palette[4].getRGB());
                    this.buffer.line(f2, -this.trackWidth, f2, this.trackWidth);
                    this.buffer.strokeWeight(1.2f);
                    this.buffer.stroke(this.palette[1].getRGB());
                    this.buffer.line(f2, -this.trackWidth, f2, this.trackWidth);
                }
            }
            this.buffer.fill(this.palette[5].getRGB());
            this.buffer.stroke(this.palette[3].getRGB());
            this.buffer.strokeWeight(2.0f);
            this.buffer.rect(0.0f, 0.0f, this.trackDisplayLength, this.trackWidth, this.trackWidth);
            switch (this.status) {
                case 0: {
                    this.buffer.fill(this.palette[TOFF].getRGB());
                    break;
                }
                case 1: {
                    this.buffer.fill(this.palette[TOVER].getRGB());
                    break;
                }
                case 2: {
                    this.buffer.fill(this.palette[TDOWN].getRGB());
                    break;
                }
                case 3: {
                    this.buffer.fill(this.palette[TDRAG].getRGB());
                }
            }
            this.buffer.noStroke();
            this.buffer.ellipse((this.parametricPos - 0.5f) * this.trackLength, 0.0f, this.trackWidth, this.trackWidth);
            graphics2D.setColor(this.palette[2]);
            if (this.labels != null) {
                this.drawLabels(graphics2D);
            } else {
                if (this.showLimits) {
                    this.drawLimits(graphics2D);
                }
                if (this.showValue) {
                    this.drawValue(graphics2D);
                }
            }
            this.buffer.popMatrix();
            this.buffer.endDraw();
        }
    }
}

