/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.GAlign;
import g4p_controls.GAnimIcon;
import g4p_controls.GIcon;
import g4p_controls.GTextBase;
import g4p_controls.ImageManager;
import g4p_controls.StyledString;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PImage;

public abstract class GTextIconBase
extends GTextBase {
    protected float PAD = 2.0f;
    protected float GUTTER = 4.0f;
    protected Zone textZone = new Zone();
    protected GAlign textAlignH = GAlign.LEFT;
    protected GAlign textAlignV = GAlign.MIDDLE;
    protected Zone iconZone = new Zone();
    protected GAlign iconAlignH = GAlign.CENTER;
    protected GAlign iconAlignV = GAlign.MIDDLE;
    protected GIcon icon = null;
    protected int iconW = 0;
    protected int iconH = 0;
    protected float iconX;
    protected float iconY;
    protected GAlign iconPos = GAlign.WEST;

    public GTextIconBase(PApplet pApplet, float f, float f2, float f3, float f4) {
        super(pApplet, f, f2, f3, f4);
    }

    protected void calcZones() {
        boolean bl = this.icon != null;
        boolean bl2 = this.stext.length() != 0;
        this.calcZones(bl, bl2);
    }

    protected void calcZones(boolean bl) {
        boolean bl2 = this.icon != null;
        this.calcZones(bl2, bl);
    }

    protected void calcZones(boolean bl, boolean bl2) {
        this.fixIconZone(bl, bl2);
        this.fixTextZone(bl, bl2);
        this.bufferInvalid = true;
    }

    public void setIconPos(GAlign gAlign) {
        if (gAlign != null && gAlign.isPosAlign()) {
            this.iconPos = gAlign;
            this.calcZones();
        }
    }

    public void setIconAlign(GAlign gAlign, GAlign gAlign2) {
        if (this.icon != null) {
            if (gAlign != null && gAlign.isHorzAlign()) {
                this.iconAlignH = gAlign;
            }
            if (gAlign2 != null && gAlign2.isVertAlign()) {
                this.iconAlignV = gAlign2;
            }
            this.calcIconPosInZone();
            this.bufferInvalid = true;
        }
    }

    public void setIcon(String string, int n) {
        PImage pImage = ImageManager.loadImage(this.winApp, string);
        GIcon gIcon = new GIcon(this.winApp, pImage, n, 1);
        this.setIconImpl(gIcon, null, null, null);
    }

    public void setIcon(String string, int n, GAlign gAlign, GAlign gAlign2) {
        PImage pImage = ImageManager.loadImage(this.winApp, string);
        GIcon gIcon = new GIcon(this.winApp, pImage, n, 1);
        this.setIconImpl(gIcon, null, gAlign, gAlign2);
    }

    public void setIcon(String string, int n, GAlign gAlign, GAlign gAlign2, GAlign gAlign3) {
        PImage pImage = ImageManager.loadImage(this.winApp, string);
        GIcon gIcon = new GIcon(this.winApp, pImage, n, 1);
        this.setIconImpl(gIcon, gAlign, gAlign2, gAlign3);
    }

    public void setIcon(PImage pImage, int n, GAlign gAlign, GAlign gAlign2) {
        GIcon gIcon = new GIcon(this.winApp, pImage, n, 1);
        this.setIconImpl(gIcon, null, gAlign, gAlign2);
    }

    public void setIcon(PImage pImage, int n, GAlign gAlign, GAlign gAlign2, GAlign gAlign3) {
        GIcon gIcon = new GIcon(this.winApp, pImage, n, 1);
        this.setIconImpl(gIcon, gAlign, gAlign2, gAlign3);
    }

    public void setIcon(GIcon gIcon, GAlign gAlign, GAlign gAlign2, GAlign gAlign3) {
        this.setIconImpl(gIcon, gAlign, gAlign2, gAlign3);
    }

    protected void setIconImpl(GIcon gIcon, GAlign gAlign, GAlign gAlign2, GAlign gAlign3) {
        this.icon = gIcon.owner != null ? gIcon.copy() : gIcon;
        this.icon.owner = this;
        this.iconW = this.icon.width;
        this.iconH = this.icon.height;
        if (gAlign2 != null && gAlign2.isHorzAlign()) {
            this.iconAlignH = gAlign2;
        }
        if (gAlign3 != null && gAlign3.isVertAlign()) {
            this.iconAlignV = gAlign3;
        }
        if (gAlign != null && gAlign.isPosAlign()) {
            this.iconPos = gAlign;
        }
        this.calcZones();
        this.bufferInvalid = true;
    }

    public GAnimIcon getIcon() {
        return this.icon instanceof GAnimIcon ? (GAnimIcon)this.icon : null;
    }

    public void setTextAlign(GAlign gAlign, GAlign gAlign2) {
        if (gAlign != null && gAlign.isHorzAlign()) {
            this.textAlignH = gAlign;
            this.stext.setJustify(this.textAlignH == GAlign.JUSTIFY);
        }
        if (gAlign2 != null && gAlign2.isVertAlign()) {
            this.textAlignV = gAlign2;
        }
        this.bufferInvalid = true;
    }

    public void setText(String string, GAlign gAlign, GAlign gAlign2) {
        if (string == null) {
            string = "";
        }
        if (this.stext.length() == 0) {
            this.calcZones(true);
        }
        this.stext.setText(string, (int)this.textZone.w);
        if (this.stext.length() == 0) {
            this.calcZones();
        }
        this.setTextAlign(gAlign, gAlign2);
        this.bufferInvalid = true;
    }

    @Override
    public void setText(String string) {
        this.setText(string, null, null);
    }

    protected void displayText(Graphics2D graphics2D, LinkedList<StyledString.TextLayoutInfo> linkedList) {
        float f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        switch (this.textAlignV) {
            case TOP: {
                f = 0.0f;
                break;
            }
            case BOTTOM: {
                f = this.textZone.h - this.stext.getTextAreaHeight();
                break;
            }
            default: {
                f = (this.textZone.h - this.stext.getTextAreaHeight()) / 2.0f;
            }
        }
        this.buffer.translate(this.textZone.x, this.textZone.y + f);
        for (StyledString.TextLayoutInfo textLayoutInfo : linkedList) {
            TextLayout textLayout = textLayoutInfo.layout;
            this.buffer.translate(0.0f, textLayout.getAscent());
            switch (this.textAlignH) {
                case CENTER: {
                    f3 = textLayout.getVisibleAdvance();
                    f3 = f3 > this.textZone.w ? f3 - this.textZone.w : f3;
                    f2 = (this.textZone.w - f3) / 2.0f;
                    break;
                }
                case RIGHT: {
                    f3 = textLayout.getVisibleAdvance();
                    f3 = f3 > this.textZone.w ? f3 - this.textZone.w : f3;
                    f2 = this.textZone.w - f3;
                    break;
                }
                default: {
                    f2 = 0.0f;
                }
            }
            graphics2D.setColor(this.palette[2]);
            textLayout.draw(graphics2D, f2, 0.0f);
            this.buffer.translate(0.0f, textLayout.getDescent() + textLayout.getLeading());
        }
    }

    private void calcIconPosInZone() {
        switch (this.iconAlignH) {
            case LEFT: {
                this.iconX = this.iconZone.x;
                break;
            }
            case CENTER: {
                this.iconX = this.iconZone.x + (this.iconZone.w - (float)this.iconW) / 2.0f;
                break;
            }
            default: {
                this.iconX = this.iconZone.x + this.iconZone.w - (float)this.iconW;
            }
        }
        switch (this.iconAlignV) {
            case TOP: {
                this.iconY = this.iconZone.y;
                break;
            }
            case BOTTOM: {
                this.iconY = this.iconZone.y + this.iconZone.h - (float)this.iconH;
                break;
            }
            default: {
                this.iconY = this.iconZone.y + (this.iconZone.h - (float)this.iconH) / 2.0f;
            }
        }
        this.bufferInvalid = true;
    }

    private void fixTextZone(boolean bl, boolean bl2) {
        if (!bl) {
            this.textZone.x = this.PAD;
            this.textZone.y = this.PAD;
            this.textZone.w = this.width - 2.0f * this.PAD;
            this.textZone.h = this.height - 2.0f * this.PAD;
            this.stext.setWrapWidth((int)this.textZone.w);
        } else {
            switch (this.iconPos) {
                case WEST: {
                    this.textZone.x = this.iconZone.w + this.PAD + this.GUTTER;
                    this.textZone.y = this.PAD;
                    this.textZone.w = this.width - this.iconZone.w - 2.0f * this.PAD - this.GUTTER;
                    this.textZone.h = this.height - 2.0f * this.PAD;
                    break;
                }
                case EAST: {
                    this.textZone.x = this.PAD;
                    this.textZone.y = this.PAD;
                    this.textZone.w = this.width - this.iconZone.w - 2.0f * this.PAD - this.GUTTER;
                    this.textZone.h = this.height - 2.0f * this.PAD;
                    break;
                }
                case SOUTH: {
                    this.textZone.x = this.PAD;
                    this.textZone.y = this.PAD;
                    this.textZone.w = this.width - 2.0f * this.PAD;
                    this.textZone.h = this.height - this.iconZone.h - 2.0f * this.PAD - this.GUTTER;
                    break;
                }
                case NORTH: {
                    this.textZone.x = this.PAD;
                    this.textZone.y = this.iconZone.h + this.PAD + this.GUTTER;
                    this.textZone.w = this.width - 2.0f * this.PAD;
                    this.textZone.h = this.height - this.iconZone.h - 2.0f * this.PAD - this.GUTTER;
                    break;
                }
            }
        }
        if (bl2) {
            this.stext.setWrapWidth((int)this.textZone.w);
        }
    }

    private void fixIconZone(boolean bl, boolean bl2) {
        if (!bl) {
            this.iconZone.clear();
            return;
        }
        if (bl2) {
            switch (this.iconPos) {
                case WEST: {
                    this.iconZone.x = this.PAD;
                    this.iconZone.y = this.PAD;
                    this.iconZone.w = this.iconW;
                    this.iconZone.h = PApplet.max((float)this.iconH, (float)(this.height - 2.0f * this.PAD));
                    break;
                }
                case EAST: {
                    this.iconZone.x = this.width - (float)this.iconW - this.PAD;
                    this.iconZone.y = this.PAD;
                    this.iconZone.w = this.iconW;
                    this.iconZone.h = PApplet.max((float)this.iconH, (float)(this.height - 2.0f * this.PAD));
                    break;
                }
                case SOUTH: {
                    this.iconZone.x = this.PAD;
                    this.iconZone.y = this.height - (float)this.iconH - this.PAD;
                    this.iconZone.w = PApplet.max((float)this.iconW, (float)(this.width - 2.0f * this.PAD));
                    this.iconZone.h = this.iconH;
                    break;
                }
                case NORTH: {
                    this.iconZone.x = this.PAD;
                    this.iconZone.y = this.PAD;
                    this.iconZone.w = PApplet.max((float)this.iconW, (float)(this.width - 2.0f * this.PAD));
                    this.iconZone.h = this.iconH;
                    break;
                }
            }
        } else {
            this.iconZone.x = this.PAD;
            this.iconZone.y = this.PAD;
            this.iconZone.w = this.width - 2.0f * this.PAD;
            this.iconZone.h = this.height - 2.0f * this.PAD;
        }
        this.calcIconPosInZone();
    }

    class Zone {
        public float x;
        public float y;
        public float w;
        public float h;

        public Zone() {
            this.h = 0.0f;
            this.w = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
        }

        public Zone(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.w = f3;
            this.h = f4;
        }

        public void clear() {
            this.h = 0.0f;
            this.w = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
        }

        public String toString() {
            return "Zone " + this.x + "  " + this.y + "  " + this.w + "  " + this.h;
        }
    }
}

