;======================================================================================================================
; Universal Sprite Positioning routine
;
; Praramets
; A1 = Sprite Address
; D0 = Vertical Poistion of Sprite on the screen (0-255)
; D1 = Horizontal position of the sprite on the screen (0-320)
; D2 = Height of sprite
;
;======================================================================================================================
; VSTART - Byte 0                  | HSTART - Byte 1
; 15	14	13	12	11	10	09	08	07	06	05	04	03	02	01	00
; V7	V6	V5	V4	V3	V2	V1	V0	H8	H7	H6	H5	H4	H3	H2	H1
;
; VSTOP - Byte 2                   | Control Byte - Byte 3
; 15	14	13	12	11	10	09	08	07	06	05	04	03	02	01	00
; S7	S6	S5	S4	S3	S2	S1	S0	A					V8	S8	H0
;======================================================================================================================

MoveSprite:
		; Vertical position
		add.w	#$2c,d0				; Add screen offset

		; A1 contain sprite address
		move.b	d0,(a1)				; Copy the byte in VSTART
		btst.l	#8,d0				; Check if Bit 8 of D0 is set
		beq.s	.NoVstartSet		; It is not then we clear bit 2 of Byte 3 (Control Byte)
		bset.b	#2,3(a1)			; Set bit 8 of VSTART (number > $ff)
		bra.s	.ToVstop			; Now lets do VSTOP

	.NoVstartSet:
		bclr.b	#2,3(a1)			; Clear bit 8 of VSTART (number < $ff)

	.ToVstop:
		add.w	d2,d0				; add the height of the sprite to determine VSTOP
		move.b	d0,2(a1)			; Move the right value in Vstop
		btst.l	#8,d0				; Check if Bit 8 of D0 is set	
		beq.s	.NoVstopSet			; It is not then we clear bit 1 of Byte 3 (Control Byte)
		bset.b	#1,3(a1)			; Set bit 8 of VSTOP (number > $ff)
		bra.w	.SetX				; Finish Y Pos lets do X POS

	.NoVstopSet:
		bclr.b	#1,3(a1)			; Clear bit 8 of VSTOP (number < $ff)

	.SetX:
		; Horizontal Position
		add.w	#128,d1				; 128 - to center sprite on screen
		btst	#0,d1				; Check low bit of X, is it an ODD (1) or EVEN (0) position
		beq.s	.LowBitZero			; Is it Even
		bset	#0,3(a1)			; Is it ODD then Set the low bit of HStart to 1
		bra.s	.PlaceCoordinates

	.LowBitZero:
		bclr	#0,3(a1)			; Clear low bit of HStart to 0

	.PlaceCoordinates:
		lsr.w	#1,d1				; Shift Right - Shift by 1 to the right the value of HSTART without the low bit
		move.b	d1,1(a1)			; Set the value in D1 to the byte HSTART
		rts