



;======================================================================================================================
; Requires Chip Mememory
;======================================================================================================================

		SECTION	Copper,DATA_C

;======================================================================================================================
; Main Game Screen - Copper List
;======================================================================================================================

CopperList:

SpritePointers:
SpritePointer0:
		dc.w	$0120,$0000,$0122,$0000		; Sprite 0
SpritePointer1:
		dc.w	$0124,$0000,$0126,$0000		; Sprite 1
SpritePointer2:
		dc.w	$0128
EnemySpritePtr:
		dc.w	$0000,$012a,$0000			; Sprite 2
SpritePointer3:
		dc.w	$012c,$0000,$012e,$0000		; Sprite 3
SpritePointer4:
		dc.w	$0130,$0000,$0132,$0000		; Sprite 4
SpritePointer5:
		dc.w	$0134,$0000,$0136,$0000		; Sprite 5
SpritePointer6:
		dc.w	$0138,$0000,$013a,$0000		; Sprite 6
SpritePointer7:
		dc.w	$013c,$0000,$013e,$0000		; Sprite 7

ScreenDefinition:
		; Screen Definition
		dc.w	$008e,$2c81					; DiwStrt
		dc.w	$0090,$2cc1					; DiwStop
		dc.w	$0092,$0038					; DdfStart LoRes
		dc.w	$0094,$00d0					; DdfStop LoRes
		dc.w	$0102,$0000					; BplCon1
		dc.w	$0104,$003f					; BplCon2 - Sprite on top of Both Playfields (%0000 0000 0011 1111)
		dc.w	$0108,$0000					; Bpl1Mod
		dc.w	$010a,$0000					; Bpl2Mod

		;15	HIRES	    HIRES = High resolution (640*200/640*400 interlace) mode
		;14	BPUx	    Bit planes use
		;13	BPUx	    Bit planes use
		;12	BPUx	    Bit planes use
		;11	HAM	        Hold and modify mode, now using either 6 or 8 bit planes.
		;10	DPF	        Double playfield (PF1 = odd & PF2 = even bit planes) now available in all resolutions.
		;               If BPU = 6 and HAM = 0 and DPF = 0 a special mode is defined that allows bitplane
		;               6 to cause an intensity reduction of the other 5 bitplanes. 
		;               The color register output selected by 5 bitplanes is shifted to half intensity by the 6th bit plane.
		;               This is called EXTRA-HALFBRITE Mode.
		;09	COLOR	    Enables color burst output signal
		;08	GAUD	    Genlock audio enable. This level appears on the ZD pin on denise during all blanking periods, unless ZDCLK bit is set.
		;07	UHRES	    Ultrahi res enables the UHRES pointers (for 1k*1k) also needs bits in DMACON (hires chips only).
		;               Disables hard stops for vert, horiz display windows.
		;06	SHRES	    Super hi-res mode (35ns pixel width)
		;05	BYPASS=0	Bit planes are scrolled and prioritized normally, but bypass color table and 8 bit wide data appear on R(7:0).
		;04	BPU3=0	    See above (BPUx)
		;03	LPEN	    Light pen enable (reset on power up)
		;02	LACE	    Interlace enable (reset on power up)
		;01	ERSY	    External resync (HSYNC, VSYNC pads become inputs) (reset on power up)
		;00	ECSENA=0	When low (default), the following bits in BPLCON3 are disabled: BRDRBLNK,BRDNTRAN,ZDCLKEN,BRDSPRT, and EXTBLKEN.
		;               These 5 bits can always be set by writing to BPLCON3, however there effects are inhibited until ECSENA goes high.
		;               This allows rapid context switching between pre-ECS viewports and new ones.

	BPLCON0:
					;  5432109876543210
		dc.w	$0100,%0100001000000000		; bit 13 - 4 bitplanes, 16 colors, Lo-Res

		;15	ENSP7	Enable Sprite 7 (ORed with Sprite 6)
		;14	ENSP5	Enable Sprite 5 (ORed with Sprite 4)
		;13	ENSP3	Enable Sprite 3 (ORed with Sprite 2)
		;12	ENSP1	Enable Sprite 1 (ORed with Sprite 0)
		;11	ENSP6	Enable bit plane 6 (match reqd. for collision)
		;10	ENSP5	Enable bit plane 5 (match reqd. for collision)
		;09	ENSP4	Enable bit plane 4 (match reqd. for collision)
		;08	ENSP3	Enable bit plane 3 (match reqd. for collision)
		;07	ENSP2	Enable bit plane 2 (match reqd. for collision)
		;06	ENSP1	Enable bit plane 1 (match reqd. for collision)
		;05	ENSP6	Match value for bit plane 6 collision
		;04	ENSP5	Match value for bit plane 5 collision
		;03	ENSP4	Match value for bit plane 4 collision
		;02	ENSP3	Match value for bit plane 3 collision
		;01	ENSP2	Match value for bit plane 2 collision
		;00	ENSP1	Match value for bit plane 1 collision

				;      5432109876543210
		dc.w	$0098,%1111000000000000		; CLXCON  $dff098
; 		dc.w	$0098,%1110000000000000		; CLXCON  $dff098

		dc.w	$00e0
GameBitplanePointers:
		dc.w	$0000,$00e2,$0000			; bitplane 1
		dc.w	$00e4,$0000,$00e6,$0000		; bitplane 2
		dc.w	$00e8,$0000,$00ea,$0000		; bitplane 3
		dc.w	$00ec,$0000,$00ee,$0000		; bitplane 4

InGameColors:
    dc.w    $0180
GameScreenColours:

color_0:
    dc.w    $0000                       ; color00 - plane 1
    dc.w    $0182
color_1:
	dc.w $0444                 ; color01 - plane 1 
    dc.w    $0184
color_2:	
	dc.w $0888                 ; color02 - plane 2
    dc.w    $0186
color_3:	
	dc.w $0ccc                 ; color03 - plane 2
    dc.w    $0188
color_4:		
	dc.w $0fff                 ; color04 - plane 3
    dc.w    $018A
color_5:			
	dc.w $0400                 ; color05 - plane 3
    dc.w    $018C
color_6:
	dc.w $0800                 ; color06 - plane 3
    dc.w    $018E
color_7:
	dc.w $0c00                 ; color07 - plane 3
    dc.w    $0190
color_8:	
	dc.w $0040                 ; color08 - plane 4
    dc.w    $0192
color_9:
	dc.w $0080                 ; color09 - plane 4
    dc.w    $0194
color_10:
	dc.w $00c0                 ; color10 - plane 4
    dc.w    $0196
color_11:
	dc.w $0004                 ; color11 - plane 4
    dc.w    $0198
color_12:	
	dc.w $0008                 ; color12 - plane 4
    dc.w    $019A
color_13:	
	dc.w $000c                 ; color13 - plane 4
    dc.w    $019C
color_14:
	dc.w $0cb2                 ; color14 - plane 4
    dc.w    $019E
color_15:	
	dc.w $0295                 ; color15 - plane 4
 
;    dc.w    $0000                       ; color00 - plane 1
;    dc.w    $0182,$0fff                 ; color01 - plane 1 
;    dc.w    $0184,$0fff                 ; color02 - plane 2
;    dc.w    $0186,$0fff                 ; color03 - plane 2
;    dc.w    $0188,$0fff                 ; color04 - plane 3
;    dc.w    $018A,$0fff                 ; color05 - plane 3
;    dc.w    $018C,$0fff                 ; color06 - plane 3
;    dc.w    $018E,$0fff                 ; color07 - plane 3
;    dc.w    $0190,$0fff                 ; color08 - plane 4
;    dc.w    $0192,$0fff                 ; color09 - plane 4
;    dc.w    $0194,$0fff                 ; color10 - plane 4
;    dc.w    $0196,$0fff                 ; color11 - plane 4
;    dc.w    $0198,$0fff                 ; color12 - plane 4
;    dc.w    $019A,$0fff                 ; color13 - plane 4
;    dc.w    $019C,$0fff                 ; color14 - plane 4
;    dc.w    $019E,$0fff                 ; color15 - plane 4


; 0 always transprent
; _1,2,3 for two sprites !

SpritesColours:
		; Sprite 0 and 1 Colours
		dc.w	$01A0
spritecolor_01_0:		
		dc.w	$0000					; color16 - Transparent
		dc.w	$01A2
spritecolor_01_1:				
		dc.w 	$0fff					; color17 - Sprite Colour 1 - White 
		dc.w	$01A4
PlayerColour:
spritecolor_01_2:		
		dc.w	$0fff							; color18 - Sprite Colour 2 - Brown
		dc.w	$01A6
spritecolor_01_3:		
		dc.w 	$0fff					; color19 - Sprite Colour 3 - Black

		; Sprite 2 and 3 Colours
spritecolor_4:
		dc.w	$01A8
spritecolor_23_0:		
		dc.w    $0000					; color20 - Transparent
		dc.w	$01AA
spritecolor_23_1:				
		dc.w 	$00c0					; color21 - Sprite Colour 1
		dc.w	$01AC
spritecolor_23_2:						
		dc.w 	$0080					; color22 - Sprite Colour 2
		dc.w	$01AE
spritecolor_23_3:						
		dc.w 	$0040					; color23 - Sprite Colour 3

		; Sprite 4 and 5 Colours
		dc.w	$01b0
spritecolor_45_0:				
		dc.w 	$0000					; color20 - Transparent
		dc.w	$01b2
spritecolor_45_1:						
		dc.w 	$0c00					; color21 - Sprite Colour 1
		dc.w	$01b4
spritecolor_45_2:					
		dc.w 	$0800					; color22 - Sprite Colour 2
		dc.w	$01b6
spritecolor_45_3:
		dc.w 	$0400					; color23 - Sprite Colour 3

		; Sprite 6 and 7 Colours
		dc.w	$01b8
spritecolor_67_0:		
		dc.w 	$0000					; color20 - Transparent
		dc.w	$01b
spritecolor_67_1:		
		dc.w 	$00cc					; color21 - Sprite Colour 1
		dc.w	$01bC
spritecolor_67_2:		
		dc.w 	$0088					; color22 - Sprite Colour 2
		dc.w	$01bE
spritecolor_67_3:
		dc.w    $0044					; color23 - Sprite Colour 3


; cryAEngine Copper stuff
		; water ... 
		; data, command
		; will be always executed
		; YY01 
;		DC.W    $FFA1,$FF00 	; wait 
		; http://amigadev.elowar.com/read/ADCD_2.1/Hardware_Manual_guide/node004B.html
;		dc.w	$0180,$0200   ; set color

;		DC.W    $FFA8,$FF00 	; wait 
;		dc.w	$0180,$0900   ; set color

; /cryEngine Copper stuff
		
		dc.w	$ffdf,$fffe		; ?
		dc.w	$FFFF,$FFFE					; End of copperlist


;======================================================================================================================
; Intro and Game Over use this Copper List
;======================================================================================================================

GenericScreen:

SprPtrs:
		dc.w	$0120,$0000,$0122,$0000		; Sprite 0
		dc.w	$0124,$0000,$0126,$0000		; Sprite 1
		dc.w	$0128,$0000,$012a,$0000		; Sprite 2
		dc.w	$012c,$0000,$012e,$0000		; Sprite 3
		dc.w	$0130,$0000,$0132,$0000		; Sprite 4
		dc.w	$0134,$0000,$0136,$0000		; Sprite 5
		dc.w	$0138,$0000,$013a,$0000		; Sprite 6
		dc.w	$013c,$0000,$013e,$0000		; Sprite 7

ScrDef:
		; Screen Definition
		dc.w	$008e,$2c81					; DiwStrt
		dc.w	$0090,$2cc1					; DiwStop
		dc.w	$0092,$0038					; DdfStart LoRes
		dc.w	$0094,$00d0					; DdfStop LoRes
		dc.w	$0102,$0000					; BplCon1
		dc.w	$0104,$003f					; BplCon2 - Sprite on top of Both Playfields (%0000 0000 0011 1111)
		dc.w	$0108,$0000					; Bpl1Mod
		dc.w	$010a,$0000					; Bpl2Mod

					;  5432109876543210
		dc.w	$0100,%0100001000000000		; bit 13 - 4 bitplanes, 16 colors, Lo-Res

				;      5432109876543210
		dc.w	$0098,%1110000000000000		; CLXCON  $dff098

		dc.w	$00e0
GenericBPL:
		dc.w	$0000,$00e2,$0000			; bitplane 1
		dc.w	$00e4,$0000,$00e6,$0000		; bitplane 2
		dc.w	$00e8,$0000,$00ea,$0000		; bitplane 3
		dc.w	$00ec,$0000,$00ee,$0000		; bitplane 4


GenericColsBase:

		; COLORS STARTUP
		dc.w	$0180
		; 0X027,0X711,0X72a,0X554,0X16c,0Xb51,0X190,0X4b6,
		; 0Xf8e,0X1cd,0Xfa0,0Xcbb,0Xad0,0Xaf7,0X7fd,0Xff5,0Xfff


		
GenericCols:    
		dc.w    $0000						; color00 - plane 1
		dc.w	$0182,$0410					; color01 - plane 1 
		dc.w	$0184,$0222					; color02 - plane 2
		dc.w	$0186,$0444					; color03 - plane 2
		dc.w	$0188,$0820					; color04 - plane 3
		dc.w	$018A,$0650					; color05 - plane 3
		dc.w	$018C,$0060					; color06 - plane 3
		dc.w	$018E,$0888					; color07 - plane 3
		dc.w	$0190,$0f40					; color08 - plane 4
		dc.w	$0192,$00a0					; color09 - plane 4
		dc.w	$0194,$0ccc					; color10 - plane 4
		dc.w	$0196,$0fc0					; color11 - plane 4
		dc.w	$0198,$00f0					; color12 - plane 4
		dc.w	$019A,$0ff0					; color13 - plane 4
		dc.w	$019C,$0fff					; color14 - plane 4
		dc.w	$019E,$0000					; color15 - plane 4

; {0X000,0X410,0X222,0X444,0X820,0X650,0X060,0X888,0Xf40,0X0a0,0Xccc,0Xfc0,0X0f0,0Xff0,0Xfff,0X000}


		dc.w	$ffdf,$fffe

		dc.w	$FFFF,$FFFE					; End of copperlist

