;======================================================================================================================
; Requires PUBLIC Code
;======================================================================================================================

		SECTION	GameCode,CODE_P

;======================================================================================================================
; Init Game Bitplanes
;======================================================================================================================
InitBitPlanes:
		move.l	#GameScreenBitplanes,d0		; Source Image Address that is the address of Bitplane 1
		lea		GameBitplanePointers,a0		; Bitplane Pointers in the Copper
		moveq.l	#NoOfBpls-1,d1				; Number of Bitplanes
		move.l	#BitplaneSize,d2			; Add the bitplane size to the source start Image Address
		bsr.w	SetBitPlanes				; Set the Bitplane Pointers
		rts

;======================================================================================================================
; Init Colours
;======================================================================================================================

InitColours:
		move.l	#GameScreenBitplanes,a0			; Source Image Address
		add.l	#BitplaneSize*NoOfBpls,a0		; Add a bitplane size * number of bitplanes to get First Colour Address

		lea		GameScreenColours,a1			; Get the Address of where the colours are in the Copper list
		moveq.l	#NoOfColours-1,d0				; Number of Colours
		bsr.w	SetColours						; Set the Bitplane Colours
		rts

;======================================================================================================================
; Universal Sprite Positioning routine
;
; Praramets
; A1 = Sprite Address
; D0 = Vertical Poistion of Sprite on the screen (0-255)
; D1 = Horizontal position of the sprite on the screen (0-320)
; D2 = Height of sprite
;
;======================================================================================================================
; VSTART - Byte 0                  | HSTART - Byte 1
; 15	14	13	12	11	10	09	08	07	06	05	04	03	02	01	00
; V7	V6	V5	V4	V3	V2	V1	V0	H8	H7	H6	H5	H4	H3	H2	H1
;
; VSTOP - Byte 2                   | Control Byte - Byte 3
; 15	14	13	12	11	10	09	08	07	06	05	04	03	02	01	00
; S7	S6	S5	S4	S3	S2	S1	S0	A					V8	S8	H0
;======================================================================================================================

MoveSprite:
		; Vertical position
		add.w	#$2c,d0				; Add screen offset

		; A1 contain sprite address
		move.b	d0,(a1)				; Copy the byte in VSTART
		btst.l	#8,d0				; Check if Bit 8 of D0 is set
		beq.s	.NoVstartSet		; It is not then we clear bit 2 of Byte 3 (Control Byte)
		bset.b	#2,3(a1)			; Set bit 8 of VSTART (number > $ff)
		bra.s	.ToVstop			; Now lets do VSTOP

	.NoVstartSet:
		bclr.b	#2,3(a1)			; Clear bit 8 of VSTART (number < $ff)

	.ToVstop:
		add.w	d2,d0				; add the height of the sprite to determine VSTOP
		move.b	d0,2(a1)			; Move the right value in Vstop
		btst.l	#8,d0				; Check if Bit 8 of D0 is set	
		beq.s	.NoVstopSet			; It is not then we clear bit 1 of Byte 3 (Control Byte)
		bset.b	#1,3(a1)			; Set bit 8 of VSTOP (number > $ff)
		bra.w	.SetX				; Finish Y Pos lets do X POS

	.NoVstopSet:
		bclr.b	#1,3(a1)			; Clear bit 8 of VSTOP (number < $ff)

	.SetX:
		; Horizontal Position
		add.w	#128,d1				; 128 - to center sprite on screen
		btst	#0,d1				; Check low bit of X, is it an ODD (1) or EVEN (0) position
		beq.s	.LowBitZero			; Is it Even
		bset	#0,3(a1)			; Is it ODD then Set the low bit of HStart to 1
		bra.s	.PlaceCoordinates

	.LowBitZero:
		bclr	#0,3(a1)			; Clear low bit of HStart to 0

	.PlaceCoordinates:
		lsr.w	#1,d1				; Shift Right - Shift by 1 to the right the value of HSTART without the low bit
		move.b	d1,1(a1)			; Set the value in D1 to the byte HSTART
		rts

;======================================================================================================================
; Init Respawn Timer
; The value we get is between 17 and 127
; The value represent the number of frames
; 50 frames is 1 second since the game is written for PAL
; 127 it is 2.5 seconds +
; 17 is because every sprites moves 1 pixel per frame hence we need 17 frames to make sure the sprites won't overlap
;======================================================================================================================

InitRespawnTimer:
		bsr.w	RndB				; get a Random Value
		cmp.b	MaxTimerRespawn,d0	; Whatever the value is make sure it is not greater than 127
		bhi.s	InitRespawnTimer	; Make Sure is less than 127
		cmp.b	#MinRespawm,d0		; Also make sure it is greater than 17
		bcs.s	InitRespawnTimer	; If the above are not satisfied Get Anotehr Random number
		move.b	d0,Respawn			; Store the Value in Respawn
		rts

;======================================================================================================================
; Update Respawn Timer
; Decrement the Respawn timer
; When finished generate a sprite to be shown later on the game screen
;======================================================================================================================

UpdateRespawn:
		subq.b	#1,Respawn
		bne.s	.Exit
		bsr.w	InitRespawnTimer	; Initialise the number of frames again till respawn
		bsr.w	PopulateEnemyTable	; Generates a sprites by updating the Enemy table structure
	.Exit:
		rts

; When we're doing comparisons, the commands we use depend on whether our data should be treated as signed or unsigned.
;
; CMP D0,D1		Signed		Unsigned
; D1 <  D0		BLT			BCS
; D1 <= D0	    BLE			BLS
; D1 =  D0		BEQ			BEQ
; D1 <> D0		BNE			BNE
; D1 >  D0		BGT			BHI
; D1 >= D0		BGE			BCC

;======================================================================================================================
; Decide Sprite X position (Enemies Sprites)
; Return position in D0
;======================================================================================================================

SetSpriteXPos:
		bsr.w	RndB			; Get a Random number and store it in D0
		and.b	#%00000011,d0	; WE only want from 0 to 2 (3 Combinations)

		beq.s	.Middle			; If Random is a 0 then Enemy is in the middle of the pipe
		cmp.b	#1,d0

		beq.s	.Left			; If Random is a 1 then Enemy is on the Left side of the pipe
		cmp.b	#2,d0

		beq.s	.Right			; If Random is a 2 then Enemy is on the Right side of the pipe
		bra.s	SetSpriteXPos	; Anything else get another random number

	.Middle:
		move.w	#Middle,d0	
		bra.s	.Exit

	.Left:
		move.w	#Left,d0	
		bra.s	.Exit

	.Right:
		move.w	#Right,d0	

	.Exit:
		rts

;======================================================================================================================
; Init Game Variables
;======================================================================================================================

InitGameVars:
		move.w  #PlayerY,Player_Y
		move.w	#PlayerX,Player_X
		move.b	#0,Respawn
		move.b	#AnimFrameDelay,PlyAnimDelay
		move.b	#0,AnimLeft
		move.b	#0,AnimMiddle
		move.b	#0,AnimRight
		move.w	#NormalFall,FallSpeed
		move.w	#0,MiddleFallCounter
		move.b	#JoystickFrames,JoyDelay
		move.w	#0,Collision
		move.b	#MaxRespawm,MaxTimerRespawn
		move.l	#EnergyStrength,Energy
		move.w	#DepthLevel,Depth
		move.w	#DepthTimer,DepthLevelTimer
		move.l	#0,Score
		move.l	#$ffffffff,EnergyBar
		move.l	#$ffffffff,EnergyBar+4
		move.l	#$80000000,DepthBar
		move.l	#$0,DepthBar+4
		move.l	#PointsPerEnemy,EnemyPoints	

		rts

;======================================================================================================================
; Version 2 of the above - This is faster and shorter in memory
; Might not have all constants above so make sure to copy all
; if you decide to use this one
;======================================================================================================================

;InitGameVars:
;		lea		Vars(pc),a0
;		move.w  #PlayerY,Player_Y-Vars(a0)
;		move.w	#PlayerX,Player_X-Vars(a0)
;		move.b	#0,Respawn-Vars(a0)
;		move.b	#AnimFrameDelay,PlyAnimDelay-Vars(a0)
;		move.b	#0,AnimLeft-Vars(a0)
;		move.b	#0,AnimMiddle-Vars(a0)
;		move.b	#0,AnimRight-Vars(a0)
;		move.w	#NormalFall,FallSpeed-Vars(a0)
;		move.w	#0,MiddleFallCounter-Vars(a0)
;		move.b	#JoystickFrames,JoyDelay-Vars(a0)
;		move.w	#0,Collision-Vars(a0)
;		move.b	#MaxRespawm,MaxTimerRespawn-Vars(a0)
;		move.l	#EnergyStrength,Energy-Vars(a0)
;		move.w	#DepthLevel,Depth-Vars(a0)
;		move.w	#DepthTimer,DepthLevelTimer-Vars(a0)
;		move.l	#0,Score-Vars(a0)
;		move.l	#$ffffffff,EnergyBar-Vars(a0)
;		move.l	#$ffffffff,EnergyBar+4-Vars(a0)
;		move.l	#$80000000,DepthBar-Vars(a0)
;		move.l	#$0,DepthBar+4-Vars(a0)
;		move.l	#PointsPerEnemy,EnemyPoints-Vars(a0)
;		rts
