;======================================================================================================================
; Requires PUBLIC Code
;======================================================================================================================

		SECTION	GameCode,CODE_P

;======================================================================================================================
; Init Game Bitplanes
;======================================================================================================================

InitGameOverScr:
		move.l	#GameOverScreen,d0			; Source Image Address that is the address of Bitplane 1
		lea		GenericBPL,a0				; Bitplane Pointers in the Copper

		moveq.l	#NoOfBpls-1,d1				; Number of Bitplanes
		move.l	#BitplaneSize,d2			; Add the bitplane size to the source start Image Address
		bsr.w	SetBitPlanes
		rts

;======================================================================================================================
; Init Game Over Screen Colours
;======================================================================================================================

SetGameOverCol:
		move.l	#GameOverScreen,a0				; Source Image Address
		add.l	#BitplaneSize*NoOfBpls,a0		; Add a bitplane size * number of bitplanes to get First Colour Address

		lea		GenericCols,a1					; Get the Address of where the colours are in the Copper list
		moveq	#NoOfColours-1,d0				; Number of Colours
		bsr.w	SetColours
		rts

