;======================================================================================================================
; Requires PUBLIC Code
;======================================================================================================================

		SECTION	GameCode,CODE_P

;======================================================================================================================
; Init Player Sprite
;======================================================================================================================

InitSprite:
		; Set the Sprite Pointers in the Copper list
		move.l	#Spr0,d0
		lea		SpritePointers,a1
		move.w	d0,6(a1)
		swap	d0
		move.w	d0,2(a1)

		; Update Player Sprite X and Y coordinates
		lea		Spr0,a1
		move.w	#80,d0 ; #PlayerY
		move.w	#80,d1 ; #PlayerX
		move.w	#SpritesHeight,d2
		bsr.w	MoveSprite


		rts

;======================================================================================================================
; Reads Joysticks
; It updates the values in variables Player_X & Player_Y
; Joystick Port 0 (mouse port) - $DFF00A (JOY0DAT)
; Joystick Port 1 (Joystick) - $DFF00C (JOY1DAT)
;
; Reading The Joystick Port
; Bit 1 Set - Move Right
; Bit 9 Set - Move Left
; Bit 8 EOR Bit 9 Result 1 - Move Up
; Bit 0 EOR Bit 1 Result 1 - Move Down
;======================================================================================================================

ReadJoystick:
		subq.b	#1,JoyDelay					; The joystick doesnt need to be read every Frame
		bne.s	.EndJoy						; So we have exit if counter not 0

		move.b	#JoystickFrames,JoyDelay	; Reset the Counter

		move.w	Player_X,d1					; Read Current X position
		move.w	JOYPort2,d3					; Read Joy1dat

	.Left2Right:
		btst.l	#1,d3        				; If bit 1 is 1 player moves to the Right
		beq.s	.Right2Left    				; else check for moving left

		; Player on far Right Side?
		cmp.w	#Right,d1    				; Already on the Right Side?
		beq.s	.EndJoy						; If So exit

		add.w	#16,d1        				; Add 16 to the X Pos of Player since moving from left to right
		bra.s	.CheckMiddle				; If not jump

	.Right2Left:
		btst.l	#9,d3        				; If bit 9 is 1 then we go to the left
		beq.s	.EndJoy      				; If not exit

		; Player on far Left Side?
		cmp.w	#Left,d1    				; Check to see if we are at the extreme left position
		beq.s	.EndJoy						; Exit if we are at the extreme left position

		sub.w	#16,d1						; Sub 16 to the X Pos of Player since moving from Right to Left

	.CheckMiddle:
		; Check for Middle
		cmp.w	#Middle,d1                	; Check to see if we are in the middle of screen
		beq.s	.FastFall	             	; If NOT, then we are on the Side

	.NormalFall:
		move.w	d1,Player_X					; Set the Player X Pos
		move.w	#NormalFall,FallSpeed    	; Go Slower on the side.
		move.w	#0,MiddleFallCounter		; Reset Fall counter

		; Update Player
		lea		Spr0,a1
		move.w	Player_Y,d0
		move.w	#SpritesHeight,d2
		bsr.w	MoveSprite

	.EndJoy:
		rts

	.FastFall:
		; We are in the Middle, increase speed
		move.w	d1,Player_X							; Set the Player X Pos
		move.w	#FastFall,FallSpeed					; Go Faster in the middle
		move.w	#MiddleFallTimer,MiddleFallCounter	; Amount of Frames to Wait before player dies


		; Update Player
		lea		Spr0,a1
		move.w	Player_Y,d0
		move.w	#SpritesHeight,d2
		bsr.w	MoveSprite

		rts

;======================================================================================================================
; Update Player
; A1 = Sprite Address
; D0 = Vertical Poistion of Sprite on the screen (0-255)
; D1 = Horizontal position of the sprite on the screen (0-320)
; D2 = Height of sprite
;======================================================================================================================

UpdatePlayer:
		lea		Spr0,a1
		move.w	Player_Y,d0
		move.w	Player_X,d1
		move.w	#$10,d2
		bsr.w	MoveSprite
		rts

;======================================================================================================================
; Update Animation of Player
;======================================================================================================================

UpdateAnimPlayer:
		subq.b	#1,PlyAnimDelay
		bne.w	.Exit

		move.b	#AnimFrameDelay,PlyAnimDelay

		move.w	Player_X,d0
		and.l	#$000000ff,d0

	;------------------------------------------------------------------------------------------------------------------
	;Check if we are on the left Postion
	.LeftPos:
		cmp.b	#Left,d0
		bne.s	.MiddlePos

		cmp.b	#1,AnimLeft
		bne.s	.Frame2

	.Frame1:
		clr.b	AnimLeft
		lea		PlayerAnim1(pc),a0
		bsr.w	CopyPlySpriteData
		bra.s	.Exit

	.Frame2:
		move.b	#1,AnimLeft
		lea		PlayerAnim2(pc),a0
		bsr.w	CopyPlySpriteData
		bra.s	.Exit

	;------------------------------------------------------------------------------------------------------------------
	;Check if we are in the Middle Postion
	.MiddlePos:
		cmp.b	#Middle,d0
		bne.s	.RightPos

		cmp.b	#1,AnimMiddle
		bne.s	.Frame4

	.Frame3:
		clr.b	AnimMiddle
		lea		PlayerAnim3(pc),a0
		bsr.w	CopyPlySpriteData
		bra.s	.Exit

	.Frame4:
		move.b	#1,AnimMiddle
		lea		PlayerAnim4(pc),a0
		bsr.w	CopyPlySpriteData
		bra.s	.Exit

	;------------------------------------------------------------------------------------------------------------------
	;Check if we are on the left Postion
	.RightPos:
		cmp.b	#Right,d0
		bne.s	.Exit

		cmp.b	#1,AnimRight
		bne.s	.Frame6

	.Frame5:
		clr.b	AnimRight
		lea		PlayerAnim5(pc),a0
		bsr.w	CopyPlySpriteData
		bra.s	.Exit

	.Frame6:
		move.b	#1,AnimRight
		lea		PlayerAnim6(pc),a0
		bsr.w	CopyPlySpriteData

	.Exit:
		rts

;======================================================================================================================
; Player Collision
;======================================================================================================================

CheckCollision:
		clr.l	d0
		move.w	CLXDAT,d0

		btst.l	#9,d0				; Did player Collide with Sprite Pair 2 and 3?
		bne.s	.col

		btst.l	#10,d0				; Did player Collide with Sprite Pair 4 and 5?
		bne.s	.col

		btst.l	#11,d0				; Did player Collide with Sprite Pair 6 and 7?
		beq.s	.Nocol

	.col:
		move.w	#1,Collision		; Set the collision variable to 1 or ON
		bsr.w	HandleCollision		; Handle the collision
	.Nocol:	
		rts

;======================================================================================================================
; Handle Collision
;======================================================================================================================

HandleCollision:
		bsr.w	DecEnergyBar		; Decrement Energy Bar
;		bsr.w	IncDepthBar			; Increment Depth Bar (this is just to test the Depth Bar)
		move.w	#$0aa0,$dff1a4		; While Colliding change colour

		sub.l	#1,Energy
		beq.s	.Exit
		move.w	#0,Collision

	.Exit:
		move.w	CLXDAT,d0			; Clear the Collision Resgister
		rts

;======================================================================================================================
; Player In the middle - Checking Falling Timer
;======================================================================================================================

CheckMiddleFall:
		move.w	Player_X,d1
		cmp.w	#Middle,d1					; Check if Player X is in the Middle
		bne.s	.Exit						; Exit if not

		move.w	#$00aa,$dff1a4				; Change Colour while in the middle
		subq.w	#1,MiddleFallCounter		; Sub 1 top the Counter timer that allows us to stay in the middle
		bne.s	.Exit						; If player hasn't been in the middle for a long time exit

		move.w	#1,Collision				; Set Collision to 1 - This is temporary. Right now this varaible it used for Game Over
		bsr.w	ResetEnemies				; Remove all the sprites from teh screen, clear the structure, set their Y postion to the end of the screen
		move.w	CLXDAT,d0					; Clear the Collision Detection Register

	.Exit:
		rts

;======================================================================================================================
; Copy Player Sprite Data 
; A0 - Source
;======================================================================================================================

CopyPlySpriteData:
		move.l	#Spr0_Data,a1			; Address of Sprite Data

		moveq.l	#16-1,d0				; Height of sprite
	.CopyImgSprData:
		move.l	(a0)+,(a1)+				; Copy the 2 words that form 1 line of a sprite
		dbra	d0,.CopyImgSprData

		rts

