;======================================================================================================================
;                         _____                        .__               
;    ___________ ___.__. /  _  \   ____   ____    ____ |__| ____   ____  
;  _/ ___\_  __ <   |  |/  /_\  \_/ __ \ /    \  / ___\|  |/    \_/ __ \ 
;  \  \___|  | \/\___  /    |    \  ___/|   |  \/ /_/  >  |   |  \  ___/ 
;   \___  >__|   / ____\____|__  /\___  >___|  /\___  /|__|___|  /\___  >
;       \/       \/            \/     \/     \//_____/         \/     \/
;
; cryAEngine - a small (assembler) gameengine for the Amiga
;
; GameObjects, LevelPlayfields, Structure with Title,Menu,About and Ingame 
; 
; part of the CHLUDENS.ch project by gamelab.zhdk.ch
; code by rene.bauer AT zhdk.ch
;
; Some Code from  Massimo Bonnucchi
;======================================================================================================================


; AMIGA EMULATORS: 
; JOYSTICK: cursors AND command/option as fire
; space: amiga space!!!

;======================================================================================================================
; made with and for VisualStudioCode and Amiga-Assembly-Modul 
; (FS-LUAE: Ctrl+w > fast forward)
;======================================================================================================================

;======================================================================================================================
; Features:
;
; Frame with
; - Titlescreen
; - Menuscreen
; - About etc.
; All editable in the BlockLevelEditor
;
; Blocks:
; - LevelField 16x16 Blocks = 20X16 Blocks
; - drawLevel
; - setBlock
; - getBlock (xy)
; - BlockLevelEditor in Processing (Export to your System)
;   Exports .json & .asm (direct integretable)
;
; SmallBlocks (Only Rendering):
; drawSmallBlock
; 
; 
; Text:
; - Integrated Font (16x16 & 8x8)
; - drawBlockText
; - drawText
; 
;======================================================================================================================

; ---------------------
; TITLE-SCREEN
; ---------------------
; Image-Data
; C_DATA.s
; - exported by https://www.stef.be/dpaint/ > Save as > planes
; colors:
; C_COPPER.S
; - exported by https://www.stef.be/dpaint/ > Save as > planes > .palette.xt
; > GenericCols:

; ---------------------
; BLOCKS
; ---------------------
; use Processing-Tool

; ---------------------
; SPRITE
; ---------------------
; use Processing-Tool

; ---------------------
; CODING
; ---------------------
; ATTENTION: DONT USE D7,D6,A7,A& 
; IS SOMEHOW NEEDED BY MUSIC AND MOUSE

; ------------------------------
; 68000 KNOWHOW
; ------------------------------

; 68k online ausprobieren
; https://asm-editor.specy.app/projects/GuILvBB

; CLR.[B/W/L]
; ADD.[B/W/L]
; SUB.[B/W/L]
; MOVE.[B/W/L]
; SWAP.[B/W/L]

; WITHOUT .B/W/L > WORD
; MOVE #4,d0 MEANS MOVE.W #4,d0!!!

; MULTIPLY:
; ROL ETC 
; DIV[U|S] / (int)   W1: RESULT  W2: REST %
; MUL[U|S] * (int)
;
; Data-Register: d0-d7
; Adress-Register: a0-a7
; 
; CMP.[B/W/L]
; BNE/BEQ etc.
;
; UNSIGMED
; BHI.w >
; BCS.w <
;
; SIGNED
; BGT.w >
; BLT.w <
;

;         even
; label:  must be even for 68k!

; DBRA: FOR-NEXT
;    move.l #10
; lab:
;    dbra d0,lab


;
; COPPER - graphic processor binded to crt-raster
;
; If you install a copper list, this will be executed forever! 
; but you can put labels and write direct there !
;
; commands WAIT,MOVE,SKIP
;  
;
; water ... 
;		; data, command
;		; will be always executed
;		DC.W    $9601,$FF00 	; wait for line 150
;		dc.w	$0180,$0fff   ; set color

; ---------------------------------
; GAMEENGINE PRESETS
; ---------------------------------

; debug - no go to black
ModeBlack equ 1 ; debug set to 0

; menu active in menu?
MouseMenuActive equ 0

; cheat
cheatIngame equ 0

; ingame
gui_score_x equ 16
gui_hscore_x equ 4

; end level 
game_won_level equ 28  ; 37-8 = 29

; ---------------------------------
; GAMEENGINE DOUBLE BUFFERING
; ---------------------------------

; simple version without bobs: experiment
;
; double-buffering-version:
; idea: change playfield > update playfield-change-map or two! 
;       repaint then before next
;       perhaps a version behind always up to date - render to frontend   
;       1 change     playfield
;       2 change bob remove again           
;


	section	GameCode,CODE_P

;======================================================================================================================
; Startup File
; Makes sure we take control of the OS the proper way
;======================================================================================================================

	include	"lib/startup.s"

;======================================================================================================================
; Which DMAs we will enable
;
; 15	SET/CLR	Set/Clear control bit.
;				Determines if bits written with a 1 get set or cleared
;			    Bits written with a zero are unchanged
; 14	BBUSY	Blitter busy status bit (read only)
; 13	BZERO	Blitter logic zero status bit (read only)
; 12	X	
; 11	X	
; 10	BLTPRI	Blitter DMA priority (also called "blitter nasty" for stealing from CPU)
; 09	DMAEN	Enable all DMA below (also UHRES DMA)
; 08	BPLEN	Bit plane DMA enable
; 07	COPEN	Coprocessor DMA enable
; 06	BLTEN	Blitter DMA enable
; 05	SPREN	Sprite DMA enable
; 04	DSKEN	Disk DMA enable
; 03	AUD3EN	Audio channel 3 DMA enable
; 02	AUD2EN	Audio channel 2 DMA enable
; 01	AUD1EN	Audio channel 1 DMA enable
; 00	AUD0EN	Audio channel 0 DMA enable
;======================================================================================================================

								;5432109876543210
DMASET					equ		%1000001110101111	; Enable Copper, Bitplane DMA, Sprite DMA, Sound DMA

WaitDisk				equ		30		; Defined in Startup.s : Time to wait 50-150 to save/load (50 = 1 second in Pal system)

;======================================================================================================================
; Game Source Files + Data Files
;======================================================================================================================

; Game Constants
		include	"Source/HWConstants.s"
		include	"Source/Constants.s"

; Game Core Files
		include	"Source/Utils.s"
		include	"Source/Player.s"
		include	"Source/Enemies.s"
		include	"Source/GameOver.s"
		include	"Source/Intro.s"
		include	"Source/Hud.s"
		include	"Source/GameCore.s"
		include	"Lib/music.s"

; Game Data Files
		include	"Source/VarTables.s"
		include	"Source/Data.s"

;======================================================================================================================
; Main Program Start
;======================================================================================================================

START:

		;--------------------------------------------------------------------------------------------------------------
		; Cracers
		;--------------------------------------------------------------------------------------------------------------

		jmp nocrackers
dearcrackers:
		dc.b "dear crackers, if you find the time than please create also a version for our friends from us - except the trump-fans! we (europeans) should bring back our not modern settlers from us after 500 years! and if you have the time make 16colors sprites .-) and if your read this - write me a mail at rene.bauer AT zhdk.ch see you! "
nocrackers:

		;--------------------------------------------------------------------------------------------------------------
		; Saving everything for startup file
		;--------------------------------------------------------------------------------------------------------------

		movem.l	d0-d7/a0-a6,-(SP)

		bsr.w	WaitForRaster

		;--------------------------------------------------------------------------------------------------------------
		; The following is more setup to complete the startup file 
		;--------------------------------------------------------------------------------------------------------------

		; Custom Chips HW Base Address
		lea		$dff000,a5

		; DMA Set / Enable
		move.w	#DMASET,$96(a5)		; DMACON - Enable Bitplane, Copper DMA, Sprties

		; Disable AGA for compatibility
		move.w	#0,$1fc(a5)			; Disable AGA
		move.w	#$c00,$106(a5)		; Disable AGA
		move.w	#$11,$10c(a5)		; Disable AGA

		;--------------------------------------------------------------------------------------------------------------
		; Init Music
		;--------------------------------------------------------------------------------------------------------------

	

		move.l	#GameScreenBitplanes,d0		; Source Image Address that is the address of Bitplane 1
		lea		GameBitplanePointers,a0		; Bitplane Pointers in the Copper
		moveq.l	#NoOfBpls-1,d1				; Number of Bitplanes
		move.l	#BitplaneSize,d2			; Add the bitplane size to the source start Image Address
		bsr.w	SetBitPlanes				; Set the Bitplane Pointers

;		bsr.w	CheckForJoystickFire

		bsr.w	mt_init


		; ----------------------
		; BLITTER ENABLING
		; ----------------------
		move.w #$8040,$dff096 ; enable blitter
		; move.w #$87e0,$dff096
		
		;--------------------------------------------------------------------------------------------------------------
		; Init Main Game Screen
		; This only need to be initialised once
		;--------------------------------------------------------------------------------------------------------------

		bsr.w	InitBitPlanes
		bsr.w	InitColours

		;--------------------------------------------------------------------------------------------------------------
		; Init the Intro Screen
		;--------------------------------------------------------------------------------------------------------------


	.Intro:
		; Init the Intro Screen Bitplanes and Colours
		bsr.w	InitIntroScr  ; wird nachträglich gemacht!
		; bsr.w	SetIntroCol	

		;--------------------------------------------------------------------------------------------------------------
		; The following is more setup to complete the startup file 
		;--------------------------------------------------------------------------------------------------------------

		; Custom Chips HW Base Address
		lea		$dff000,a5

		; Init Copper
		move.l	#GenericScreen,$80(a5)	; Point to our copper
		move.w	d0,$88(a5)			; Init our copper

		;--------------------------------------------------------------------------------------------------------------
		; Play Music while we wait for the user to press the fire button
		; and also till the player releases the fire button
		;--------------------------------------------------------------------------------------------------------------

		bsr.w	mt_music

	 	; jmp ingame

		;--------------------------------------------------------------------------------------------------------------
		; TITLESCREEN
		;--------------------------------------------------------------------------------------------------------------

		; ------------------------
		; change-scroll-text-init
		; ------------------------
		; scrolling text
		move.l #0,text_title_counter
		lea.l text_title_screen,a4
		move.l a4,text_title_address
titleloop:
		bsr.w	WaitForRaster
		bsr.w	mt_music

		; display a bob (blitterobject)
		jsr BlitWait
		; kills the rastereffect!
		jsr BlitSomething
		
		; ------------------
		; blinking-scroll-text
		; ------------------
		add.l #1,text_title_counter
		cmp.l #100,text_title_counter
		bne   title_text
			move.l #0,text_title_counter
			; find next 0 
			move.l text_title_address,a4
			move.w #6,text_x
			move.w #28,text_y
			move.w #1,smallblockscreentarget
			
			move.w #1,titlescreenrenderer
			jsr drawText
			move.w #0,titlescreenrenderer

			move.w #0,smallblockscreentarget
			add.l #text_title_size,text_title_address
			clr.l d0
			move.b (a4),d0
			cmp.b #42,d0
			bne.b   allis42
			lea.l  text_title_screen,a4
			move.l a4,text_title_address
allis42:		
title_text:		

		; --------------------------------------
;		; TITLE KEYBOARD TEST 
;		; --------------------------------------
		jmp nokeyboard
		jsr _keyboard		
		move.w keyPressed,d1
		cmp.w #64,d1		
		bne no_titlekeyboard
if_titleloop_waitkeyboard:
			jsr _keyboard
			jsr WaitForRaster
			jsr 	mt_music	
			move.w keyPressed,d1
			cmp.w #64,d1		
			beq if_titleloop_waitkeyboard
no_titlekeyboard:
		nokeyboard:

		; --------------------------
		; TITLE JOYSTICK TEST 
		; --------------------------
		; joystick go ... 
		jsr ReadJoystickDirect
		; jump --------------
		  cmp.w #1,joystick_PressedDirect
		  bne if_gamefire_nows_x
if_titleloop_waitjoystick:
			jsr ReadJoystickDirect
			jsr WaitForRaster
			jsr 	mt_music	
			cmp.w #1,joystick_PressedDirect
			BEQ   if_titleloop_waitjoystick
			jmp endtitleloop
if_gamefire_nows_x:


		; --------------------------------------
		; TITLE MOUSE TEST  & WAIT 
		; --------------------------------------
  	    BTST   #6,$BFE001      ; Test left mouse button
		BNE   if_titleloop
if_titleloop_wait:
			jsr WaitForRaster
			jsr 	mt_music		
			BTST   #6,$BFE001      ; Test left mouse button
			BEQ   if_titleloop_wait
			jmp endtitleloop
if_titleloop:

; --------------------------------------
;		LOOP
   		BNE   titleloop
; --------------------------------------

	
endtitleloop:

	move.w #0,keyPressed
	; wait some time ... 

		jsr colorsToBlack



		; jsr WaitForMouseUp

		jsr colorsTitleToBlack

		jsr colorsToBlack

;		jsr colorsToGameColors

		;--------------------------------------------------------------------------------------------------------------
		; MENU & GAMELOOP
		;--------------------------------------------------------------------------------------------------------------
menustart:

		; copy new background

		move.l	#GameOverScreen,d0			; Source Image Address that is the address of Bitplane 1
		lea		GenericBPL,a0				; Bitplane Pointers in the Copper

		moveq.l	#NoOfBpls-1,d1				; Number of Bitplanes
		move.l	#BitplaneSize,d2			; Add the bitplane size to the source start Image Address
		bsr.w	SetBitPlanes


		; Init Copper
		; move.l	#CopperList,$80(a5)	; Point to our copper
		; move.w	d0,$88(a5)			; Init our copper

		; init sprites
		bsr.w	InitSprite ; player
;		bsr.w   InitGameVars
;		bsr.w	ResetEnemies

		; ------------------------------
		; SPRITE INIT VISUAL POINTERS
		; ------------------------------		
		move.l	#Spr0,d0
		lea		SpritePointer0,a1
		move.w	d0,6(a1)
		swap	d0
		move.w	d0,2(a1)

		move.l	#Spr1,d0
		lea		SpritePointer1,a1
		move.w	d0,6(a1)
		swap	d0
		move.w	d0,2(a1)

		move.l	#Spr2,d0
		lea		SpritePointer2,a1
		move.w	d0,6(a1)
		swap	d0
		move.w	d0,2(a1)

		move.l	#Spr3,d0
		lea		SpritePointer3,a1
		move.w	d0,6(a1)
		swap	d0
		move.w	d0,2(a1)

		move.l	#Spr4,d0
		lea		SpritePointer4,a1
		move.w	d0,6(a1)
		swap	d0
		move.w	d0,2(a1)

		move.l	#Spr5,d0
		lea		SpritePointer5,a1
		move.w	d0,6(a1)
		swap	d0
		move.w	d0,2(a1)

		move.l	#Spr6,d0
		lea		SpritePointer6,a1
		move.w	d0,6(a1)
		swap	d0
		move.w	d0,2(a1)

		move.l	#Spr7,d0
		lea		SpritePointer7,a1
		move.w	d0,6(a1)
		swap	d0
		move.w	d0,2(a1)

		lea.l gameobjects,a6
		move.l #8,d3
resetallx:	
		move.w #objectstate_inactive,gameobject_state(a6)
		move.w #-32,gameobject_x(a6)
		move.w #-32,gameobject_y(a6)
		move.w #behavior_standstill,gameobject_behaviour(a6)		
		move.w #type_effect_once,gameobject_type(a6)
		move.w #atype_once_destroy,gameobject_animtype(a6)

		move.w #0,gameobject_arg(a6)		

		add.l #gameobject_size_bytes,a6
		dbra d3,resetallx		

		; render visual data
		jsr setSpriteVisuals
		
		; render positions
		jsr renderGameObjects

		jsr colorsToGameColors

		; ----------------
		; copy colors
		; ----------------
		; jmp nocopycolors

; colors manual 
		jmp no_manualcolors
		; monochrom
		move.w #$0000,color_0
		move.w #$0111,color_1
		move.w #$0222,color_2
		move.w #$0333,color_3
		move.w #$0444,color_4
		move.w #$0555,color_5
		move.w #$0666,color_6
		move.w #$0777,color_7
		move.w #$0888,color_8
		move.w #$0999,color_9
		move.w #$0aaa,color_10
		move.w #$0bbb,color_11
		move.w #$0ccc,color_12
		move.w #$0ddd,color_13
		move.w #$0eee,color_14
		move.w #$0fff,color_15

		; red
		move.w #$0000,color_0
		move.w #$0100,color_1
		move.w #$0200,color_2
		move.w #$0300,color_3
		move.w #$0400,color_4
		move.w #$0500,color_5
		move.w #$0600,color_6
		move.w #$0700,color_7
		move.w #$0800,color_8
		move.w #$0900,color_9
		move.w #$0a00,color_10
		move.w #$0b00,color_11
		move.w #$0c00,color_12
		move.w #$0d00,color_13
		move.w #$0e00,color_14
		move.w #$0f00,color_15
no_manualcolors:		
		
		
;		jsr colorsToGameColors

;		jsr colorsToBlack

		


		; move.l	#GenericScreen,$80(a5)	; Point to our copper
		; move.w	d0,$88(a5)			; Init our copper
		bsr.w	WaitForRaster
		move.l	#CopperList,$80(a5)	; Point to our copper
		move.w	d0,$88(a5)			; Init our copper

		; ----------------------------
		; setup
		; ----------------------------

		; numbers only
;		move.l #0,number_showzero

		; behavior
		
;		lea.l gameobjects,a6
;		move.l #8,d5
;bvx:
;		move.w #behavior_4dir_random,gameobject_behaviour(a6)
;;		move.w #behavior_standstill,gameobject_behaviour(a6)
;		move.w #type_enemy,gameobject_type(a6)
;		add.l #gameobject_size_bytes,a6		
;		dbra d5,bvx
;
;		; bonus / boni
;		lea.l gameobjects,a6
;		add.l #1*gameobject_size_bytes,a6
;		move.w #type_bonus,gameobject_type(a6)
;		add.l #gameobject_size_bytes,a6
;		move.w #type_bonus,gameobject_type(a6)
;		add.l #gameobject_size_bytes,a6
;		move.w #type_bonus,gameobject_type(a6)
;
;		; avatar
;		lea.l gameobjects,a6
;		; add.l #1*gameobject_size_bytes,a6
;		move.w #behavior_mouse_direct,gameobject_behaviour(a6)
;		move.w #type_avatar,gameobject_type(a6)
;	

		

		; init types
		lea.l gameobjects,a6
		move.l #8,d7
bvxt:	
		move.l a6,a0	; pointers forever
		jsr initType
		move.w #objectstate_inactive,gameobject_state(a6)
		add.l #gameobject_size_bytes,a6
		dbra d7,bvxt

		; ---------------------------
		; VISUALS SPRITE DATA
		; XETUP
		; ---------------------------
		; copy bitplanes

		; setupSpritesMouseMode
		; jsr  setupSpritesMouseMode

		; -----------------------------------------------
		; MENU & SUBMENU
		; -----------------------------------------------

menu_awake:

		move.l #statesub_play,menupoint_game_state_sub
		move.l #42,menupoint_game_state_sub_old

menu:   
		move.l #state_menu,game_state
		move.l #statesub_main,game_state_sub
		 
		; display mainmenu and submenus
submenu: 
		move.l game_state_sub,actualLevelIndex
		; move.l #1,actualLevelIndex
		
		cmp #statesub_main,game_state_sub
		beq notmain		
		; move.l game_state_sub,actualLevelIndex
notmain:
		; move.l #8,actualLevelIndex

		jsr colorsToBlack

		jsr loadActualLevel 
		; todo: blendin/out
		jsr drawLevel

		; disable all sprites from 1-7
		; set it to transparent

		; add some text here
		cmp.l #statesub_main,game_state_sub
		bne notmainx					
			; a text
			lea.l text_menu_main,a4
			move.w #8,text_x
			move.w #5,text_y
			jsr drawText	

		; lowscore
		;	move.l #15,number_x
		;	move.l #10,number_y
		;	move.l hscore,number_no
		;	jsr drawNumbers

notmainx:

		cmp.l #statesub_story,game_state_sub
		bne notmainxxx				
			; a text
			lea.l text_menusub_story,a4
			move.w #8,text_x
			move.w #5,text_y
			jsr drawText	
notmainxxx:

		cmp.l #statesub_howto,game_state_sub
		bne notmainxx				
			; a text
			lea.l text_menusub_howto,a4
			move.w #8,text_x
			move.w #5,text_y
			jsr drawText	
notmainxx:

		cmp.l #statesub_about,game_state_sub
		bne notmainxxxz			
			; a text
			lea.l text_menusub_about,a4
			move.w #8,text_x
			move.w #5,text_y
			jsr drawText	


notmainxxxz:

		; statesub_won
		cmp.l #statesub_won,game_state_sub
		bne notmainxxxzx			
			; a text
			lea.l text_menusub_won,a4
			move.w #4,text_x
			move.w #5,text_y
			jsr drawText	

			; lowest score
			move.l #15,number_x
			move.l #2,number_y
			move.l hscore,number_no
			jsr drawNumbers

			; your score
			move.l #15,number_x
			move.l #5,number_y
			move.l score,number_no
			jsr drawNumbers

notmainxxxzx:



		jsr colorsToGameColors

		; ...

		jsr resetSpritesToInactive

		; render visual data
		jsr setSpriteVisuals
		
		; render positions
		jsr renderGameObjects


		; handle menu
menuloop:


		jmp nosmallblocks_test
		
		move.w #10,smallblockx
		move.w #0,smallblocky
		move.w #5,smallblockno
		jsr drawSmallBlockXY


		move.w #11,smallblockx
		move.w #0,smallblocky
		move.w #9,smallblockno
		jsr drawSmallBlockXY

		move.w #10,smallblockx
		move.w #1,smallblocky
		move.w #10,smallblockno
		jsr drawSmallBlockXY

		move.w #11,smallblockx
		move.w #1,smallblocky
		move.w #11,smallblockno
		jsr drawSmallBlockXY

nosmallblocks_test:

		; --------------------------
		; block animations
		; --------------------------
		jsr BlockAnimation


		; --------------------------
		; VSYNC
		; --------------------------
		jsr WaitForRaster

		; --------------------------
		; "water simulation"
		; --------------------------
		; manipulate waves ...
		; effect_wave
		; jsr WaterEffect


		; --------------------------
		; random block animations
		; --------------------------
		; jsr RandomBlockAnimation

		; --------------------------
		; MUSIC
		; --------------------------
		; music 'thread'
		bsr.w	mt_music

		; --------------------------
		; SHOW MENU POINT HERE
		; --------------------------
		; statesub_main

		; highscore
		;move.l #3,number_x
		;move.l #0,number_y
		;move.l menupoint_game_state_sub,d0
		;move.l d0,number_no
		;jsr drawNumbers

		cmp.l #statesub_main,game_state_sub
		bne  new_state

		move.l menupoint_game_state_sub,d0
		cmp.w menupoint_game_state_sub_old,d0
		beq new_state
		; cmp.w #42,d0
		; beq new_state
		
			; ok remove old one
			move.l menupoint_game_state_sub_old,d0
			cmp.w #42,d0
			beq new_state_oxt

				clr.l d0
				move.l menupoint_game_state_sub_old,d0
				add.l  #4,d0 ; y-pos
				move.w #75,blockno 
				move.w #4,blockx
				move.w d0,blocky
				jsr drawBlockXY		
				
new_state_oxt:

			; add new one 
			clr.l d0
			move.l menupoint_game_state_sub,d0
			add.l  #4,d0 ; y-pos
			move.w #96,blockno 
			move.w #4,blockx
			move.w d0,blocky
			jsr drawBlockXY		

new_state:
		move.l menupoint_game_state_sub,menupoint_game_state_sub_old


		; ----------------------
		; INTERACTION MENU
		; ----------------------

		; ---------------------
		; MENU JOYSTICK
		; ---------------------
		jsr ReadJoystickDirect

		; mainmenu
		cmp.l #statesub_main,game_state_sub
		bne n_mainmenu_joystick

		cmp.w #1,joystick_Up_Clicked
		bne   j_up_y
		sub.l #1,menupoint_game_state_sub
j_up_y:		

		cmp.w #1,joystick_Down_Clicked
		bne   j_down_x
		add.l #1,menupoint_game_state_sub
j_down_x:	

		; all around the world
		cmp.l #0,menupoint_game_state_sub
		bne  awox
		move.l #4,menupoint_game_state_sub
awox:

		; all around the world
		cmp.l #5,menupoint_game_state_sub
		bne  awoxy
		move.l #1,menupoint_game_state_sub
awoxy:
		jmp no_mainmenu_sub
n_mainmenu_joystick:

		; main menu sub
		; about etc.

no_mainmenu_sub:		


		IF MouseMenuActive

			lea.l gameobjects,a6
			move.w MouseX,gameobject_x(a6)
			move.w MouseY,gameobject_y(a6)

			; mouse sprite
			; update it ... 
			lea		Spr0,a1
			move.w  gameobject_y(a6),d0
			move.w  gameobject_x(a6),d1
			move.w	#$10,d2
			bsr.w	MoveSprite

			; check hover?
			clr.l d0
			move.w gameobject_y(a6),d0
			cmp.l #82,d0
			blt menu_hover
			cmp.l #82+63,d0
			bgt menu_hover
			; jsr rainbow
			sub.l #82,d0
			divu #16,d0
			add.l #1,d0
			clr.l d1
			move.w d0,d1
			move.l d1,menupoint_game_state_sub
menu_hover:
		ENDIF

		;--------------------------------
		; PRESS ACITON
		;--------------------------------
		; JOYSTICK
		jsr ReadJoystickDirect
		; jump --------------
		  cmp.w #1,joystick_PressedDirect
		  bne if_gamefire_joystick_nows_x
if_menuloop_waitjoystick:
			jsr ReadJoystickDirect
			jsr WaitForRaster
			jsr mt_music	
			cmp.w #1,joystick_PressedDirect
			BEQ   if_menuloop_waitjoystick
			cmp.l #statesub_main,game_state_sub
			beq if_sub_joystick	
				 move.w #statesub_main,menupoint_game_state_sub
				; #statesub_main
				; MENU: ALL OTHERS
				; move.w    $DFF006,$DFF180 ; background
				move.l menupoint_game_state_sub,game_state_sub		
				move.l #state_menu,game_state
				move.l #statesub_main,game_state_sub	
				jmp menu				
if_sub_joystick:
			; move.w menupoint_game_state_sub,menupoint_game_state_sub
		jmp menuswitch
if_gamefire_joystick_nows_x:


		; MOUSE
  	    BTST   #6,$BFE001      ; Test left mouse button
   		BNE.S   if_mouseclicked
if_menuloop_wait:
			jsr WaitForRaster
			jsr 	mt_music		
			BTST   #6,$BFE001      ; Test left mouse button
			BEQ   if_menuloop_wait
			cmp.l #statesub_main,game_state_sub
			beq if_sub_mouse
				; #statesub_main
				; MENU: ALL OTHERS
				; move.w    $DFF006,$DFF180 ; background
				move.l menupoint_game_state_sub,game_state_sub		
				move.l #state_menu,game_state
				move.l #statesub_main,game_state_sub	
				jmp menu			
if_sub_mouse:
			; move.w menupoint_game_state_sub,menupoint_game_state_sub
		jmp menuswitch
if_mouseclicked:



		;--------------------------------
		; MENUSWITCH
		;--------------------------------
		jmp menuswitch_end
menuswitch:		

		; MENU START GAME
start_here:		
		cmp.l #statesub_play,menupoint_game_state_sub
		bne   startgame_now_xy
		jmp startgame
startgame_now_xy:

		; MENU: ALL OTHERS
		move.l menupoint_game_state_sub,game_state_sub		
		jmp submenu
notplay_howto:

		jmp submenu

menuswitch_end:

;--------------------------------
		; < MENU LOOP
		jmp menuloop
;--------------------------------

menuloop_end: 



		; ----------------------------
		; GAME STARTS HERE
		; ----------------------------
startgame:

		move.l #0,level
		; repaint
		move.l #1,level_old

		move.l #0,score

		move.l #0,timer
		move.l #0,timercounter

		jmp next_level
died_level:
				; add score
		add.l #1,score

		; next 
		cmp.l #99,score
		bne too_much
			jmp menustart
too_much:

next_level:

		jsr colorsToBlack




		; next level ... 
		move.l level,actualLevelIndex
		add.l  #8,actualLevelIndex

		; load actual level
		jsr loadActualLevel

		; gameobjects reset all 
		; jmp noresetall_sprites
		lea.l gameobjects,a6
		move.l #8,d3
resetall:	

		move.w #objectstate_inactive,gameobject_state(a6)
		move.w #-32,gameobject_x(a6)
		move.w #-32,gameobject_y(a6)
		move.w #behavior_standstill,gameobject_behaviour(a6)		

		move.w #type_effect_once,gameobject_type(a6)
		move.w #atype_once_destroy,gameobject_animtype(a6)

		move.w #0,gameobject_arg(a6)		

		add.l #gameobject_size_bytes,a6
		dbra d3,resetall		

noresetall_sprites:

		; -------------------
		; PARSE LEVEL
		; -------------------
		; parse level
		; jmp no_levelparsing


		; -------------------------------
		; attention: avatar is always
		; -------------------------------
		; first sprite (easier for direct values!)
		; sprite0: avatar
		; sprite1: ??? effect?

		lea.l gameobjects,a0
		add.l #4*gameobject_size_bytes,a0
		move.l a0,parselevel_address

		; fuck amiga %2 the same colors .-()

		;  green worlds
		;  0
		;  1 avatar

		;  gray worlds
		;  2 shadow effect
		;  3 halo


		; shadow ... [2]
		lea.l gameobjects,a6 ; sprite 0
		add.l #2*gameobject_size_bytes,a6
		; move.w #objectstate_active,gameobject_state(a6)
		move.w #160-8,gameobject_x(a6)
		move.w #0,gameobject_y(a6)
		move.w #type_effect_once,gameobject_type(a6)
		move.w #atype_once_destroy,gameobject_animtype(a6)

		; halo [0]
		lea.l gameobjects,a6 ; sprite 0
		add.l #3*gameobject_size_bytes,a6
		; move.w #objectstate_active,gameobject_state(a6)
		move.w #100,gameobject_x(a6)
		move.w #100,gameobject_y(a6)
		move.w #type_effect,gameobject_type(a6)


		; let's go now .. 
		move.l #0,d1
		lea.l actualLevel,a2
	scan:

		; generate analog x,y d3,d4
		move.l d1,d0
		divu #20,d0
		clr.l d4
		move.w d0,d4
		mulu.w #16,d4
		swap d0
		clr.l d3
		move.w d0,d3
		mulu.w #16,d3

		; 
		; STARTINGS BLOCKS FOR AVATAR
		; -------------
		; avatar left
		; -------------
		; sprite 1 !!!
		cmp.b #56,(a2)
		bne.b not_a_startleft		
		    move.b 1(a2),(a2)
			lea.l gameobjects,a6 ; sprite 0
			add.l #gameobject_size_bytes,a6
			move.w #objectstate_active,gameobject_state(a6)
			move.w d3,gameobject_x(a6)
			move.w d4,gameobject_y(a6)
			move.w #type_avatar,gameobject_type(a6)
			move.w #behavior_avatar_bounce_left,gameobject_behaviour(a6)
			jmp nothing_tofind
		not_a_startleft:

		; ----------------
		; avatar right
		; ----------------
		cmp.b #57,(a2)
		bne.b not_a_startright
			move.b 1(a2),(a2)
			lea.l gameobjects,a6 ; sprite 0
			add.l #gameobject_size_bytes,a6
			move.w #objectstate_active,gameobject_state(a6)
			move.w d3,gameobject_x(a6)
			move.w d4,gameobject_y(a6)
			move.w #type_avatar,gameobject_type(a6)
			move.w #behavior_avatar_bounce_right,gameobject_behaviour(a6)
			jmp nothing_tofind
		not_a_startright:

		; ----------------
		; stay 
		; ----------------
		cmp.b #58,(a2)
		bne.b if_effectstay
			move.b 1(a2),(a2)
			move.l parselevel_address,a6
			move.w #objectstate_active,gameobject_state(a6)
			move.w d3,gameobject_x(a6)
			move.w d4,gameobject_y(a6)
			move.w #type_effect,gameobject_type(a6)
			move.w #behavior_stay,gameobject_behaviour(a6)
			add.l #gameobject_size_bytes,a6
			move.l a6,parselevel_address
			jmp nothing_tofind
		if_effectstay:

	  ; ----------------------
	  ; enemyies left-right
	  ; ----------------------
		cmp.b #59,(a2)
		bne.b not_a_enemy
			move.b 1(a2),(a2)
			; enemy 
			move.l parselevel_address,a6
			move.w #objectstate_active,gameobject_state(a6)
			move.w d3,gameobject_x(a6)
			move.w d4,gameobject_y(a6)
			move.w #type_enemy,gameobject_type(a6)
			move.w #type_enemysub_leftright,gameobject_typesub(a6)
			move.w #behavior_onplatform_right_fall,gameobject_behaviour(a6)
			add.l #gameobject_size_bytes,a6
			move.l a6,parselevel_address
		jmp nothing_tofind
	not_a_enemy:

	  ; ----------------------
	  ; enemyies up-down
	  ; ----------------------
		cmp.b #60,(a2)
		bne.b not_a_enemyupdown
		move.b 1(a2),(a2)

			; enemy 
			move.l parselevel_address,a6
			move.w #objectstate_active,gameobject_state(a6)
			move.w d3,gameobject_x(a6)
			move.w d4,gameobject_y(a6)
			move.w #type_enemyupdown,gameobject_type(a6)
			move.w #type_enemysub_updown,gameobject_typesub(a6)
			move.w #behavior_down,gameobject_behaviour(a6)
			add.l #gameobject_size_bytes,a6
			move.l a6,parselevel_address

		jmp nothing_tofind
	not_a_enemyupdown:

	nothing_tofind:
		move.b (a2)+,d0
		
		add.l #1,d1
		cmp.l #20*16,d1
		bne scan



no_levelparsing:

		; -------------------------
		; init sprite types
		; -------------------------
		; jmp no_initspritetypes
		lea.l gameobjects,a6
		move.l #8,d7
abvxt:	
		move.l a6,a0	; pointers forever
		jsr initType
		add.l #gameobject_size_bytes,a6
		move.w #objectstate_inactive,gameobject_state(a6)
		dbra d7,abvxt
no_initspritetypes:

		; load actual level
		jsr drawLevel



		; ----------------------------
		; test
		; ----------------------------

		; move.w    $0,$DFF180 ; background
		; blocks
		move.w #19,blockx
		move.w #15,blocky
		move.w #5,blockno
		; jsr drawBlockXY

		; draw actual level
		; first level
		;move.l #8,actualLevelIndex
		;jsr loadActualLevel
		;jsr drawLevel

		; ----------------------------
		; snippets
		; ----------------------------
		; bsr.w	RndB						; Get a Random Number in D0
		; and.l	#$00000007,d0				; We are only interested in the first 8 (0 - 7)

		jmp nogui_here

		; highscore
		move.l #1,number_x
		move.l #0,number_y
		move.l hscore,number_no
		jsr drawNumbers

		move.l #19,number_x
		move.l #0,number_y
		move.l score,number_no
		; move.l #20,number_no
		jsr drawNumbers

nogui_here:

		lea.l demo_text,a4
		move.w #10,text_x
		move.w #5,text_y
		; jsr drawBlockText

		; --------------------
		; GUI
		; --------------------

		move.w #gui_hscore_x-2,blockx
		move.w #0,blocky
		move.w #128,blockno 
		jsr drawBlockXY	

		move.w #gui_score_x+1,blockx
		move.w #0,blocky
		move.w #129,blockno 
		jsr drawBlockXY	

		move.l #gui_hscore_x,number_x
		move.l #0,number_y
		move.l hscore,number_no
		jsr drawNumbers

		move.l #gui_score_x,number_x
		move.l #0,number_y
		move.l score,number_no
		jsr drawNumbers

		move.l #0,number_showzero
		move.l #10,number_x
		move.l #0,number_y
		move.l level,d0
		add.l  #1,d0
		move.l d0,number_no
		jsr drawNumbers
		move.l #1,number_showzero
		
		; ----------------------------
		; ingameloop
		; ----------------------------

		jsr colorsToGameColors

          move.w #0,fire0  

          move.w #0,fire1  
          move.w #0,up1  
          move.w #0,down1  
          move.w #0,left1  
          move.w #0,right1  

ingameloop:


		; wait for the raster ... 
		bsr.w	WaitForRaster

	
 
		; ---------------------------
		; level based on time
		; ---------------------------
		; in game mode?
;		cmp.l #state_gameover,game_state_sub
;		beq gameover_nonewlevel
;
;		move.l level,d0
;		move.l d0,level_old
;
;		; primitive counter
;		add.l #1,timercounter
;		move.l timercounter,d0
;		cmp.l timestep,d0
;		bcs lowerthantimer 
;
;		move.l #0,timercounter
;		add.l  #1,timer
;
;		add.l #1,level
;not_nextlevel:
;lowerthantimer:
;gameover_nonewlevel:

		; ---------------------------
		; BEHAVIOUR GAMEOBJECTS
		; ---------------------------

		; ---------------------------
		; MOVE SOMETHING
		; ---------------------------
;		lea		Spr3,a1
;		move.w	d5,d0
;		move.w	#90,d0
;		move.w	#90,d1
;		move.w	#$10,d2
;		bsr.w	MoveSprite


		move.l #8,d6 ; gameobjects_no
		lea.l gameobjects,a6
behave:		

	; object state?
		move.w gameobject_state(a6),d0
		cmp.w #objectstate_inactive,d0
		beq.w end_behavior

		clr d0

		; jmp nobehavior

		; ------------------------
		; mouse behavior 
		; ------------------------
		; mouse direct
		cmp.w #behavior_mouse_direct,gameobject_behaviour(a6)
		bne.w notmousedirect
		; move.w MouseX,gameobject_x(a6)
		; move.w MouseY,gameobject_y(a6)
		jmp end_behavior
notmousedirect:

		; avatar joystick


		; ----------------------------
		; HOLY CUBE
		; ----------------------------

    ; ---------------------
    ; object move down
    ; ---------------------
	  cmp.w #behavior_down,gameobject_behaviour(a6)
	  bne if_movedown
 			; move.w #57,gameobject_x(a6)
			add.w #1,gameobject_y(a6) 

			; check if there is a stone down there
			move.w gameobject_x(a6),levelBlockX
			add.w  #8,levelBlockX
			move.w gameobject_y(a6),levelBlockY
			add.w  #18,levelBlockY
			jsr getLevelBlock				      
			move.w levelBlockIndex,d0
			cmp.w #200-18,gameobject_y(a6)
			bgt if_movedown_up
			cmp.w #block_platform_start,d0
			blt.w if_movedown
			cmp.w #block_platform_stop+1,d0
			bgt.w if_movedown
if_movedown_up:					
				move.w #behavior_up,gameobject_behaviour(a6)
if_movedown:

    ; ---------------------
    ; object move up
    ; ---------------------
	  cmp.w #behavior_up,gameobject_behaviour(a6)
	  bne if_moveup
 			; move.w #57,gameobject_x(a6)
			sub.w #1,gameobject_y(a6) 

			; check if there is a stone down there
			move.w gameobject_x(a6),levelBlockX
			add.w  #8,levelBlockX
			move.w gameobject_y(a6),levelBlockY
			sub.w  #3,levelBlockY
			jsr getLevelBlock				      
			move.w levelBlockIndex,d0
			cmp.w #1,gameobject_y(a6)
			blt if_moveup_down
			cmp.w #block_platform_start,d0
			blt.w if_moveup
			cmp.w #block_platform_stop+1,d0
			bgt.w if_moveup		
if_moveup_down:			
			move.w #behavior_down,gameobject_behaviour(a6)
if_moveup:

	; ---------------------
    ; object move up top
    ; ---------------------
    ; ...

	  cmp.w #behavior_up_top,gameobject_behaviour(a6)
	  bne if_moveuptop
 			; move.w #57,gameobject_x(a6)
			sub.w #1,gameobject_y(a6) 
			cmp.w #10,gameobject_y(a6) 
			bgt if_moveuptop
			move.w #objectstate_inactive,gameobject_state(a6)
if_moveuptop:	 

		; ---------------
		; ENEMY FALL
		; > LEFT & RIGHT
		; ---------------

		; ---------------------
	    ; onplatform_down
	    ; ---------------------
	  cmp.w #behavior_onplatform_right_fall,gameobject_behaviour(a6)
	  bne if_movedown_leftright

 			; move.w #57,gameobject_x(a6)
			add.w #1,gameobject_y(a6) 

			; check if there is a stone down there
			move.w gameobject_x(a6),levelBlockX
			add.w  #8,levelBlockX
			move.w gameobject_y(a6),levelBlockY
			add.w  #16,levelBlockY
			jsr getLevelBlock				      
			move.w levelBlockIndex,d0
			cmp.w #200-18,gameobject_y(a6)
			bgt if_movedown_leftright_do
			cmp.w #block_platform_start,d0
			blt.w if_movedown_leftright
			cmp.w #block_platform_stop+1,d0
			bgt.w if_movedown_leftright
if_movedown_leftright_do:					
			move.w #behavior_onplatform_right,gameobject_behaviour(a6)
if_movedown_leftright:

		; ---------------------
	    ; onplatform_right
	    ; ---------------------
		cmp.w #behavior_onplatform_right,gameobject_behaviour(a6)
	    bne if_moveonplatform_leftright

 			; move.w #57,gameobject_x(a6)
			add.w #1,gameobject_x(a6) 

			; check if there is a stone down there
			move.w gameobject_x(a6),levelBlockX
			add.w  #16,levelBlockX
			move.w gameobject_y(a6),levelBlockY
			add.w  #18,levelBlockY
			jsr getLevelBlock				      
			move.w levelBlockIndex,d0
			cmp.w #block_platform_start,d0
			blt.w if_moveonplatform_leftright_do
			cmp.w #block_platform_stop+1,d0
			bgt.w if_moveonplatform_leftright_do
			jmp if_moveonplatform_leftright
if_moveonplatform_leftright_do:	
				move.w #behavior_onplatform_left,gameobject_behaviour(a6)				
if_moveonplatform_leftright:


		; ---------------------
	    ; onplatform_left
	    ; ---------------------
		cmp.w #behavior_onplatform_left,gameobject_behaviour(a6)
	    bne if_moveonplatform_leftright_nux

 			; move.w #57,gameobject_x(a6)
			sub.w #1,gameobject_x(a6) 

			; check if there is a stone down there
			move.w gameobject_x(a6),levelBlockX
			add.w  #-2,levelBlockX
			move.w gameobject_y(a6),levelBlockY
			add.w  #18,levelBlockY
			jsr getLevelBlock				      
			move.w levelBlockIndex,d0
			cmp.w #block_platform_start,d0
			blt.w if_moveonplatform_leftright_do_nux
			cmp.w #block_platform_stop+1,d0
			bgt.w if_moveonplatform_leftright_do_nux
			jmp if_moveonplatform_leftright_nux
if_moveonplatform_leftright_do_nux:	
				move.w #behavior_onplatform_right,gameobject_behaviour(a6)				
if_moveonplatform_leftright_nux:
		

		; ---------------
		; AVATAR
		; ---------------	

		; halo on top of the avatar
		lea.l gameobjects,a0 ; sprite 0
		add.l #gameobject_size_bytes,a0
		move.w gameobject_x(a0),gameobject_x+2*gameobject_size_bytes(a0)
		move.w gameobject_y(a0),gameobject_y+2*gameobject_size_bytes(a0)
		; move.w #32,gameobject_x+2*gameobject_size_bytes(a0)
		; move.w #32,gameobject_y+2*gameobject_size_bytes(a0)
		sub.w  #12,gameobject_y+2*gameobject_size_bytes(a0)

		; ---------------
		; AVATAR
		; ---------------	

		; ------------------------
		; avatar falling down
		; ------------------------
		cmp.w #behavior_avatar_bounce_left,gameobject_behaviour(a6)
		beq.w not_avatarfalling
		cmp.w #behavior_avatar_bounce_right,gameobject_behaviour(a6)
		beq.w not_avatarfalling
		jmp notfalling_avatar_x
not_avatarfalling:

		; ---------------------
		; boundaries
	  ; atari st
	  ; vs amiga
		; ---------------------
		cmp.w #1,gameobject_y(a6)
		bgt toohigh
		move.w #0,gameobject_y(a6)
toohigh:

		; ---------------------
		; die ?
		; boundaries?
		; ---------------------
		cmp.w #1,gameobject_x(a6)
		blt.w outside
		cmp.w #320-10,gameobject_x(a6)
		bgt.w outside
		cmp.w #180,gameobject_y(a6)
		bgt.w outside
		jmp not_outside
outside:
		jmp died_level
not_outside:


		; DIE
		; block_die_start		
		move.w gameobject_x(a6),levelBlockX
		add.w  #4,levelBlockX
		move.w gameobject_y(a6),levelBlockY
		add.w  #13,levelBlockY
		jsr getLevelBlock		 
		move.w levelBlockIndex,d0
		cmp.w #block_die_start-1,d0
		blt.w if_trap
		cmp.w #block_die_stop+1,d0
		bgt.w if_trap		
			jmp died_level
if_trap:



		; COLLECT 
		; [  A
		;    B
		;    C  ]

		; better ?
		;    A
		;   B C 

		; check 
		move.l #0,d5

		; something ... 

		; A		

		move.w gameobject_x(a6),levelBlockX
		add.w  #8,levelBlockX
		move.w gameobject_y(a6),levelBlockY
		sub.w  #2,levelBlockY
		jsr getLevelBlock		 
		move.w levelBlockIndex,d0
		cmp.w #block_collect_start-1,d0
		blt.w if_ulox_A
		cmp.w #block_collect_stop+1,d0
		bgt.w if_ulox_A		
		; collect now 


			jsr collectTheBlock
			

		  jmp if_ulox_B

if_ulox_A:

		; B	

		move.w gameobject_x(a6),levelBlockX
		add.w  #8,levelBlockX
		move.w gameobject_y(a6),levelBlockY
		sub.w  #8,levelBlockY
		jsr getLevelBlock		 
		move.w levelBlockIndex,d0
		cmp.w #block_collect_start-1,d0
		blt.w if_ulox_B
		cmp.w #block_collect_stop+1,d0
		bgt.w if_ulox_B		
		; collect now 

			jsr collectTheBlock

if_ulox_B:


		; C

		move.w gameobject_x(a6),levelBlockX
		add.w  #8,levelBlockX
		move.w gameobject_y(a6),levelBlockY
		add.w  #14,levelBlockY
		jsr getLevelBlock		 
		move.w levelBlockIndex,d0
		cmp.w #block_collect_start-1,d0
		blt.w if_ulox_C
		cmp.w #block_collect_stop+1,d0
		bgt.w if_ulox_C		
		; collect now 

			jsr collectTheBlock

if_ulox_C:


		; D

		move.w gameobject_x(a6),levelBlockX
		sub.w  #1,levelBlockX
		move.w gameobject_y(a6),levelBlockY
		add.w  #14,levelBlockY
		jsr getLevelBlock		 
		move.w levelBlockIndex,d0
		cmp.w #block_collect_start-1,d0
		blt.w if_ulox_D
		cmp.w #block_collect_stop+1,d0
		bgt.w if_ulox_D	
		; collect now 

			jsr collectTheBlock

if_ulox_D:

		; E

		move.w gameobject_x(a6),levelBlockX
		add.w  #14,levelBlockX
		move.w gameobject_y(a6),levelBlockY
		add.w  #14,levelBlockY
		jsr getLevelBlock		 

		move.w levelBlockIndex,d0
		cmp.w #block_collect_start-1,d0
		blt.w if_ulox_E
		cmp.w #block_collect_stop+1,d0
		bgt.w if_ulox_E	
		; collect now 

			jsr collectTheBlock

if_ulox_E:


	; move.l #1,d5

		; -------------------
		; level finished?
		; -------------------
		; check if level is finished!

		 cmp.l #1,d5	
		 beq if_a_not_collect		 
		 		jmp a_not_collect
if_a_not_collect:

		 cmp.l #1,d5	
		 bne a_not_collect		 

		
			move.l #20*12-1,d1
			move.l #0,d2
			lea.l actualLevel,a0
a_tlevel:
			clr.l d0
			move.b (a0)+,d0
			cmp.w #block_collect_start,d0
			blt.w a_nenotf
			cmp.w #block_collect_stop+1,d0
			bgt.w a_nenotf
			add.l #1,d2
a_nenotf:
			dbra d1,a_tlevel
			

			; show it somewhere ...
			move.l #10,number_x
			move.l #0,number_y
			move.l d2,number_no
;					jsr drawNumbers

			; is there in it a collectibale?
			; SHOW SOME ... YEAH ... 

			; next level
			cmp.w #0,d2
			bne.w   a_notnextlevel
			add.l #1,level

			; game over last level ... 
			move.l level,d0
			cmp.l #game_won_level,d0 
			blt weiterweiter
				move.l #state_menu,game_state
				move.l #statesub_won,game_state_sub		
				; move.w    $DFF006,$DFF180 ; background

				; new best score?
				move.l hscore,d0
				cmp.l score,d0
				blt if_newhighscore
					move.l score,hscore
if_newhighscore:

			jmp submenu

			; display mainmenu and submenus			
weiterweiter:

			jmp next_level
a_notnextlevel:

a_not_collect:


not_collect:



		; falling down or jump
		; gameobject_arg ==0 > fall
		; gameobject_arg ==1 > jump

		; on a platform?
		move.w #0,avatar_onplatform

		cmp.w #0,gameobject_arg(a6)
		bne.w avatar_jump_now		

				; fall - gravitation
				add.w #2,gameobject_y(a6)

				; points AA BB CC

				; AA
				move.w gameobject_x(a6),levelBlockX
				sub.w  #1,levelBlockX
				move.w gameobject_y(a6),levelBlockY
				add.w  #16,levelBlockY
				;move.w #16,levelBlockX
				;move.w #16,levelBlockY
				jsr getLevelBlock		
				move.w levelBlockIndex,d0
				cmp.w #block_platform_start,d0
				blt.w aa_not_falling_b
				cmp.w #block_platform_stop,d0
				bgt.w aa_not_falling_b
				; check for rest ...
				; move.w #behavior_standstill,gameobject_behaviour(a6)
				move.w levelBlock16YRest,d0
				sub.w d0,gameobject_y(a6)
				move.w #1,avatar_onplatform
		aa_not_falling_b:

				; BB
				move.w gameobject_x(a6),levelBlockX
				add.w  #8,levelBlockX
				move.w gameobject_y(a6),levelBlockY
				add.w  #16,levelBlockY
				;move.w #16,levelBlockX
				;move.w #16,levelBlockY
				jsr getLevelBlock		
				move.w levelBlockIndex,d0
				cmp.w #block_platform_start,d0
				blt.w bb_not_falling_b
				cmp.w #block_platform_stop,d0
				bgt.w bb_not_falling_b
				; check for rest ...
				; move.w #behavior_standstill,gameobject_behaviour(a6)
				move.w levelBlock16YRest,d0
				sub.w d0,gameobject_y(a6)
				move.w #1,avatar_onplatform
		bb_not_falling_b:

		; cc
				move.w gameobject_x(a6),levelBlockX
				add.w  #16,levelBlockX
				move.w gameobject_y(a6),levelBlockY
				add.w  #16,levelBlockY
				;move.w #16,levelBlockX
				;move.w #16,levelBlockY
				jsr getLevelBlock		
				move.w levelBlockIndex,d0
				cmp.w #block_platform_start,d0
				blt.w cc_not_falling_b
				cmp.w #block_platform_stop,d0
				bgt.w cc_not_falling_b
				; check for rest ...
				; move.w #behavior_standstill,gameobject_behaviour(a6)
				move.w levelBlock16YRest,d0
				sub.w d0,gameobject_y(a6)
				move.w #1,avatar_onplatform
		cc_not_falling_b:

				; is avatar on something?
				cmp.w #1,avatar_onplatform
				bne   not_avatar_on

				; jump here?
				; jump_algo

		not_avatar_on:

		jmp avatar_behave_end
	avatar_jump_now:

	; avatar is jumping
	clr.l d0
	move.w gameobject_arg(a6),d0

	lea.l jump_algo,a1
	clr.l d1
;	move.b d0(a1)+,d1
	add.l d0,a1
	move.b (a1),d1

	sub.w d1,gameobject_y(a6)

	cmp.b #42,1(a1)
	bne.b goon_jumping
	move.w #0,gameobject_arg(a6)
	jmp nomore_jumpingx
goon_jumping:
	 add.w #1,gameobject_arg(a6)
nomore_jumpingx:

	avatar_behave_end:

notfalling_avatar_x:

		; -------------------
		; AVATAR BOUNCE LEFT
		; ---------------

		; behavior_avatar_bounce_left
		cmp.w #behavior_avatar_bounce_left,gameobject_behaviour(a6)
		bne.w not_avatar_left_fall

			sub.w #1,gameobject_x(a6)


			; check here left down ...
			; get 
			move.w gameobject_x(a6),levelBlockX
			sub.w  #2,levelBlockX
			move.w gameobject_y(a6),levelBlockY
			add.w  #14,levelBlockY
			jsr getLevelBlock
			; check here
			; bounce
			move.w levelBlockIndex,d0
			cmp.w #block_bounce_start,d0
			blt not_avatar_left_1
			cmp.w #block_bounce_stop,d0
			bgt not_avatar_left_1
				jmp bounce_left_doit
	not_avatar_left_1:

			move.w gameobject_x(a6),levelBlockX
			sub.w  #2,levelBlockX
			move.w gameobject_y(a6),levelBlockY
			add.w  #7,levelBlockY
			jsr getLevelBlock
			; check here
			; bounce
			move.w levelBlockIndex,d0
			cmp.w #block_bounce_start,d0
			blt not_avatar_left_2
			cmp.w #block_bounce_stop,d0
			bgt not_avatar_left_2
				jmp bounce_left_doit
	not_avatar_left_2:

			jmp not_avatar_left_fall

			; do bounce left ===
			bounce_left_doit:
				
				move.w #behavior_avatar_bounce_right,gameobject_behaviour(a6)

				; destroy the last 
				cmp.w #90,levelBlockIndex
				bne   left_block_destroyxer

					; set level blocks
					move.w  levelBlock16X,levelBlockX
					move.w  levelBlock16Y,levelBlockY
					move.w #67,levelBlockIndex
					jsr setLevelBlockAndUpdate

					jmp left_block_destroy

		left_block_destroyxer:

				; destroy 89>90 - gold finger
				cmp.w #89,levelBlockIndex
				bne   left_block_destroy

				    ; set level blocks
					move.w  levelBlock16X,levelBlockX
					move.w  levelBlock16Y,levelBlockY
					move.w #90,levelBlockIndex
					jsr setLevelBlockAndUpdate

					; jsr copyscreenWorkbenchToFront	

		left_block_destroy:			




no_bounceleft:
		jmp end_behavior
not_avatar_left_fall:


		; -------------------
		; AVATAR BOUNCE RIGHT
		; ---------------

		; behavior_avatar_bounce_right
		cmp.w #behavior_avatar_bounce_right,gameobject_behaviour(a6)
		bne.w not_avatar_right_fall

			add.w #1,gameobject_x(a6)

			; check here left down ...
			; get 
			move.w gameobject_x(a6),levelBlockX
			add.w  #18,levelBlockX
			move.w gameobject_y(a6),levelBlockY
			add.w  #14,levelBlockY
			jsr getLevelBlock
			; check here
			; bounce
			move.w levelBlockIndex,d0
			cmp.w #block_bounce_start,d0
			blt not_avatar_right_1
			cmp.w #block_bounce_stop,d0
			bgt not_avatar_right_1
				jmp bounce_right_doit
	not_avatar_right_1:

			move.w gameobject_x(a6),levelBlockX
			add.w  #18,levelBlockX
			move.w gameobject_y(a6),levelBlockY
			add.w  #7,levelBlockY
			jsr getLevelBlock
			; check here
			; bounce
			move.w levelBlockIndex,d0
			cmp.w #block_bounce_start,d0
			blt not_avatar_right_2
			cmp.w #block_bounce_stop,d0
			bgt not_avatar_right_2
				jmp bounce_right_doit
	not_avatar_right_2:

			jmp not_avatar_right_fall

			; do bounce left ===
			bounce_right_doit:
				
				move.w #behavior_avatar_bounce_left,gameobject_behaviour(a6)

			; destroy the last 
				cmp.w #90,levelBlockIndex
				bne   right_block_destroyxer

					; set level blocks
					move.w  levelBlock16X,levelBlockX
					move.w  levelBlock16Y,levelBlockY
					move.w #67,levelBlockIndex
					jsr setLevelBlockAndUpdate

					jmp right_block_destroy

		right_block_destroyxer:

				; destroy 89>90 - gold finger
				cmp.w #89,levelBlockIndex
				bne   right_block_destroy

				    ; set level blocks
					move.w  levelBlock16X,levelBlockX
					move.w  levelBlock16Y,levelBlockY
					move.w #90,levelBlockIndex
					jsr setLevelBlockAndUpdate

					; jsr copyscreenWorkbenchToFront	

				
		right_block_destroy:		

		

		
no_bounceright:
		jmp end_behavior
not_avatar_right_fall:




not_holycubeavatar_left:
		

	



donot:

		; game over? 
		; out of frame?


; for behaviour from squarez look into squarez 
; and copy it here
 
end_behavior:

		add.l  #gameobject_size_bytes,a6 ; gameobject_size
		dbra d6,behave

nobehavior:

;	------------------------
;	/END BEHVAVIOUR
;	------------------------

		; ---------------------------
		;  COLLISION
		; ---------------------------
			; jmp nocollision


 ; ---------------------------
		;  COLLISION
		; ---------------------------
			; jmp nocollision


		; not game over!
		cmp.l #state_gameover,game_state_sub
		beq nocollision

				move.l #8,d5 ; gameobjects_no
				lea.l gameobjects,a3
		collision:		
				
				clr.l d3
				; innerCollision
				move.l #8,d4 ; gameobjects_no
				lea.l gameobjects,a2
		innerCollision:		

				clr.l d1
				clr.l d2

				; is one object not active?
				; gameobject_state
				move.w gameobject_state(a2),d0
				cmp.w #objectstate_inactive,d0
				beq.w thesame
				move.w gameobject_state(a3),d0
				cmp.w #objectstate_inactive,d0
				beq.w thesame


				; no collision against the same object
				cmp.l d4,d5
				beq thesame

				; box collision
				; with box colliders
				;   ______ 
				;  | a3  _|___
				;  |_____|a2 |
				;        |___|
				;

				clr.l d3
				clr.l d2
				clr.l d1
				move.w gameobject_y(a3),d3
		add.w #1,d3				
				move.w gameobject_y(a2),d2
		add.w #1,d2				
				move.w gameobject_height(a2),d1
				move.w #0,CCR
				add.w d1,d2
				cmp.w d2,d3
				bgt.w yhigher ; signed!
				;  a3.y > a2.y+a2.height

				clr.l d3
				clr.l d2
				clr.l d1
				move.w gameobject_y(a3),d3
		add.w #1,d3				
				move.w gameobject_y(a2),d2
		add.w #1,d2				
				move.w gameobject_height(a3),d1
		sub.w #3,d1			
				move.w #0,CCR
				sub.w d1,d2
				cmp.w d2,d3
				blt.w ylower ; signed <0
				;  a3.y < a2.y-a3.height

				clr.l d3
				clr.l d2
				clr.l d1
				move.w gameobject_x(a3),d3
		add.w #1,d3				
				move.w gameobject_x(a2),d2
		add.w #1,d2				
				move.w gameobject_width(a2),d1
		sub.w #3,d1			
				add.w d1,d2
				move.w #0,CCR
				cmp.w d2,d3
				bgt.w xhigher ; signed 
				;  a3.x > a2.x+a2.width

				clr.l d3
				clr.l d2
				clr.l d1
				move.w gameobject_x(a3),d3
		add.w #1,d3				
				move.w gameobject_x(a2),d2
		add.w #1,d2				
				move.w gameobject_width(a3),d1
		sub.w #3,d1			
				sub.w d1,d2
				move.w #0,CCR
				cmp.w d2,d3
				blt.w xlower
				;  a3.x < a2.x-a3.width

				; ------------------------
				; avatar
				; ------------------------
				cmp.w #type_avatar,gameobject_type(a3)
				bne.w   noavatar

							; not collision! here
							; effects
							move.w gameobject_type(a2),d0
							cmp.w #type_effect,d0
							beq noavatar
							cmp.w #type_effect_once,d0
							beq noavatar


								; game over .-) 
							;	; no cursor any more ... 
							;	lea.l text_gameover,a4
							;	move.w #5,text_x
							;	move.w #6,text_y
							;	jsr drawBlockText

								; wait
								move.l #1000,d4
				wait_dead:

								dbra d4,wait_dead
								; jsr levelEnd ; print and wait ... 


								jmp died_level

		noavatar:

				
				; rainbow
				; move.w    $DFF006,$DFF180 ; background

		xlower:
		xhigher:

		ylower: 
		yhigher:		

		thesame:

				add.l  #gameobject_size_bytes,a2 ; gameobject_size
				dbra d4,innerCollision
				; / innerCollision

				; collision
				add.l  #gameobject_size_bytes,a3 ; gameobject_size
				dbra d5,collision

		collision_done:

		nocollision:


		; ---------------------------
		; / END COLLISION
		; ---------------------------

		; ---------------------------
		; ANIMATE GAMEOBJECTS
		; ---------------------------
		add.l #1,animation
		move.l animation,d0
		cmp.l animation_step,d0
		blt.w no_newanimstep
		move.l #0,animation

		; animate all of them
		move.l #8,d6 ; gameobjects_no
		lea.l gameobjects,a6
animfor:

			; is one object not active?
		; gameobject_state
		move.w gameobject_state(a6),d0
		cmp.w #objectstate_inactive,d0
		beq.w fanim_loop

		; no anim
		cmp.w #atype_noanim,gameobject_animtype(a6)
		bne.w fanim_no
fanim_no:

		; animloop
		cmp.w #atype_loop,gameobject_animtype(a6)
		bne.w fanim_loop
		; move.w #type_avatar_animind,gameobject_animind(a0)
		add.w #1,gameobject_animind(a6)
		move.w gameobject_animind(a6),d0
		cmp.w gameobject_animmax(a6),d0
		bcs fanim_loop 
		move.w gameobject_animmin(a6),d0
		; move.w #168,d0
		move.w d0,gameobject_animind(a6)
fanim_loop:

		; animonce
		cmp.w #atype_once,gameobject_animtype(a6)
		bne.w fanim_once
		; move.w #type_avatar_animind,gameobject_animind(a0)
		add.w #1,gameobject_animind(a6)
		move.w gameobject_animind(a6),d0
		cmp.w gameobject_animmax(a6),d0
		bcs.w fanim_once 
			move.w gameobject_animmax(a6),d0
			move.w d0,gameobject_animind(a6)
fanim_once:

		; animoncedestroy
		cmp.w #atype_once_destroy,gameobject_animtype(a6)
		bne.w fanim_once_destroy
		; move.w #type_avatar_animind,gameobject_animind(a0)
		add.w #1,gameobject_animind(a6)
		move.w gameobject_animind(a6),d0
		cmp.w gameobject_animmax(a6),d0
		bcs.w fanim_once_destroy 
			move.w #objectstate_inactive,gameobject_state(a6)
fanim_once_destroy:

		add.l #gameobject_size_bytes,a6
		dbra d6,animfor

no_newanimstep:


		; ---------------------------
		; RENDER GAMEOBJECTS
		; ---------------------------
		; TO SPRITES (if there is a sprite representation)

		; ---------------------------
		; RENDER VISUALS 
		; UPDATE visual sprite data
		; ---------------------------
		; jmp notatall


		; render visual data
		jsr setSpriteVisuals
	

		; positions data 
		jsr renderGameObjects


notatall:


		; ---------------------------
		; GUI
		; ---------------------------
		; jsr DrawText
		move.l old_score,d0
        jmp no_newhighscore
		cmp.l score,d0
		beq.w no_newscore
		; write direct in the screen memory
		move.l #gui_score_x,number_x
		move.l #0,number_y
		move.l score,number_no
		; move.l #20,number_no
		jsr drawNumbers
		move.l score,d0
		move.l d0,old_score
no_newscore:

		; new real highscore
		move.l score,d0
		cmp.l hscore,d0
		blt.w no_newhighscore
		move.l score,hscore
		move.l #gui_hscore_x,number_x
		move.l #0,number_y
		move.l hscore,number_no
		jsr drawNumbers
no_newhighscore:

		; test
		;move.w #17,blockx
		;move.w #3,blocky
		;move.w #4+39,blockno
		;jsr drawBlockXY

		; ---------------------------
		; MUSIC
		; ---------------------------
		bsr.w	mt_music


		; --------------------------
		; mouse control
		; --------------------------
	    jsr ReadMouse

  	    btst   #6,$BFE001      ; Test left mouse button
   		bne.s  jumpMouse
		cmp.w #0,mousebuttonpressed
		bne jumpMouseNo
			move.w #1,mousebuttonpressed
			jmp firedo_now
jumpMouseNo:
			move.w #1,mousebuttonpressed	
			jmp jumpMouseEnd
jumpMouse:
			move.w #0,mousebuttonpressed			
jumpMouseEnd:


		; --------------------------
		; firex
		; --------------------------
          move.w #0,fire0  

          move.w #0,fire1  
          move.w #0,up1  
          move.w #0,down1  
          move.w #0,left1  
          move.w #0,right1 

		; --------------------------
		; keys
		; --------------------------
		; http://www.whdload.de/docs/en/rawkey.html

		; https://www.stashofcode.fr/code/routines-pour-demomaker-sur-amiga/keyboard%20(polling).s

		; use this not for debugging
		move.w #0,keyPressed

		jsr _keyboard

		; get keys
		jmp no_keysy
	 	move.l #5,number_x
		move.l #5,number_y
		clr.l d1
		move.w keyPressed,d1
		move.l d1,number_no
		jsr drawNumbers
no_keysy:

		; 
		; 69 escape
		; 64 space
		; 68 return
		;
		; cursors?
		;
		;
		;


		; escape
		clr.l d1
		move.w keyPressed,d1
		cmp.w #69,d1
		bne.w n_escapex
		; move.w    $DFF006,$DFF180 ; background
		move.l #100000,d4
waitx:
		dbra d4,waitx			
		jmp menu
n_escapex:



		; ---------------
		; jump keys
		; ---------------
		; space
		IF cheatIngame then
		clr.l d1
		move.w keyPressed,d1
		cmp.w #64,d1
		bne.w n_spacex
		; move.w    $DFF006,$DFF180 ; background
; no space jump 
;  		move.w #1,fire0		
		jmp n_sapcedone_x
n_spacex:
		
	      move.w #0,fire0		
n_sapcedone_x:

		; return
		clr.l d1
		move.w keyPressed,d1
		cmp.w #68,d1 ; $44
		bne.w n_return
		; move.w    $DFF006,$DFF180 ; background
		add.l #1,level
		jmp next_level
n_return:
		endif

	 


		
		; --------------------------
		; block animations
		; --------------------------
		jsr BlockAnimation


 	  ; ------------------------------------
	  ; JUMP INGAME
	  ; ------------------------------------

	jsr ReadJoystickDirect

	  ; jump --------------
	  ; one click
	  cmp.w #0,joystick_PressedDirect_old
	  bne if_gamefire_nows
	  cmp.w #1,joystick_PressedDirect
	  bne if_gamefire_nows
	    ; move.w    $DFF006,$DFF180 ; background
		 move.w joystick_PressedDirect,joystick_PressedDirect_old
	  	jmp firedo_now
if_gamefire_nows:	
	 move.w joystick_PressedDirect,joystick_PressedDirect_old




	  ; up 
;	  cmp.w #1,up1
;	  bne if_gamefire_nowsup1
;	    move.w    $DFF006,$DFF180 ; background
;	  	jmp firedo_now
;if_gamefire_nowsup1:	  

	  ; up 
	  cmp.w #0,joystick_Up_olddirect
	  bne if_gamefire_nowsup1x
	  cmp.w #1,joystick_Up
	  bne if_gamefire_nowsup1x
		 move.w joystick_Up,joystick_Up_olddirect
	  	jmp firedo_now
if_gamefire_nowsup1x:	  
	 move.w joystick_Up,joystick_Up_olddirect

	  ; button1 
;	  cmp.w #1,joystick_Pressed
;	  bne if_gamefire_nowsup1xbut1
;	    ; move.w    $DFF006,$DFF180 ; background
;	  	jmp firedo_now
;if_gamefire_nowsup1xbut1:	  


	  ; jump --------------
;	  cmp.w #0,ofire1
;	  bne if_gamefire_now
;	  cmp.w #1,fire1
;	  bne if_gamefire_now
;	  	jmp firedo_now
;if_gamefire_now:	  

	  ; jump --------------
;	  cmp.w #0,oup1
;	  bne if_gameup1
;	  cmp.w #1,up1
;	  bne if_gameup1

	  ; ------------------
	  ; jump 
	  ;-------------------

	  jmp firedo_now_no
firedo_now:

			lea.l gameobjects,a0
			add.l #gameobject_size_bytes,a0
			cmp.w #1,avatar_onplatform
			bne notonaplatform
			move.w #1,gameobject_arg(a0)
notonaplatform:
firedo_now_no:
		move.w fire0,ofire0

;	  if_gameup1:
; 		move.w up1,oup1


		; --------------------------
		; "water simulation"
		; --------------------------
		; manipulate waves ...
		; effect_wave
		; jsr WaterEffect

; press mouse

		; for what is this? 
		; press mouse
;  	    btst   #6,$BFE001      ; Test left mouse button
 ;  		bne.s  notpressedmouse
;		cmp.l #state_gameover,game_state_sub
;		bne notpressedmouse

		; back ...

;		move.l #state_menu,game_state_sub
;		jmp  menustart
;notpressedmouse:




		jmp ingameloop ; gameloop
		; ---------------------------
		; INGAME LOOP ^
		; ---------------------------


exit:	
		bsr.w	mt_end
		; ---------------------------
		; BACK TO AMIGADOS
		; ---------------------------

		movem.l	(SP)+,d0-d7/a0-a6

		rts

tryout:

		rts 


;======================================================================================================================
; gameobjects to visuals
;======================================================================================================================

resetSpritesToInactive:
		
		lea.l gameobjects,a6
		move.l #8,d3
resetallxx:	
		move.w #objectstate_inactive,gameobject_state(a6)
		move.w #-32,gameobject_x(a6)
		move.w #-32,gameobject_y(a6)
		move.w #behavior_standstill,gameobject_behaviour(a6)		
		move.w #type_effect_once,gameobject_type(a6)
		move.w #atype_once_destroy,gameobject_animtype(a6)

		move.w #0,gameobject_arg(a6)		

		add.l #gameobject_size_bytes,a6
		dbra d3,resetallxx	

		rts

; visuals
setSpriteVisuals:
		
		; ATTENTION
		; BITPLANES OF SPRITES ARE
		; 1 line : BITPLANE 0 + BITPLANE 1

		; following routine has two 
		; possiblities


		move.l #8,d6 ; gameobjects_no
		lea.l gameobjects,a6

rendervisualdata:		

		; dump switch		
		; is there a sprite? 

		; active?
		move.w gameobject_state(a6),d4
; put into the off! 
		cmp.w #objectstate_inactive,d4
		bne outoftheview		
			move.w #32,gameobject_x(a6)
			move.w #-32,gameobject_y(a6)
outoftheview:


		cmp.w #objectstate_active,d4
		bne.w nonewanim		

		; check oldind != actualind
;		clr.l d4
		move.w gameobject_animindold(a6),d4
		cmp.w gameobject_animind(a6),d4
		beq.w nonewanim

		; overwrite old version
		clr.l d3
		move.w gameobject_animind(a6),d3
		move.w d3,gameobject_animindold(a6)
		
		; create ...		
		; lea.l		Cotton,a2		; test

		; normal version ... 
		lea.l SpriteVisualData,a2 ; Source Address
		lea.l SpriteVisualData,a3 ; Source Address
		; very dark > todo: shift and shift or mulu

		lea.l spritecolor_01_0,a4

		clr.l d2
; problem here!
		move.w gameobject_animind(a6),d2
; test 		
;		move.w #1,d2
		; jmp nocounting
		; move.l d6,d2
		cmp.w #80,d2 ; what the hell ... 
		bhi.w nocounting
		cmp.w #0,d2
		beq.w nocounting
		sub.l #1,d2
counter: 
		; spritevisualdata_object_bytes equ 64+4*2
		add.l #spritevisualdata_object_bytes,a2
		add.l #spritevisualdata_object_bytes,a3
		dbra d2,counter
nocounting:

		; testing
		; lea.l SpriteVisualData,a2
		; lea.l Diaper,a2
		; add.l #2*spritevisualdata_object_bytes,a2

		clr.l d5
		move.w gameobject_spr(a6),d5
		cmp.w #0,d5
		bne.w vnot0
		lea		Spr0_Data,a1		; DESTINATION Address
		lea.l spritecolor_01_0,a4
		jmp vdoit
vnot0:
		cmp.w #1,d5
		bne.w vnot1
		lea		Spr1_Data,a1		; DESTINATION Address
		lea.l spritecolor_01_0,a4
		jmp vdoit
vnot1:
		cmp.w #2,d5
		bne.w vnot2
		lea		Spr2_Data,a1		; DESTINATION Address
		lea.l spritecolor_23_0,a4
		jmp vdoit
vnot2:
		cmp.w #3,d5
		bne.w vnot3
		lea		Spr3_Data,a1		; DESTINATION Address
		lea.l spritecolor_23_0,a4
		jmp vdoit
vnot3:
		cmp.w #4,d5
		bne.w vnot4
		lea		Spr4_Data,a1		; DESTINATION Address
		lea.l spritecolor_45_0,a4
		jmp vdoit
vnot4:
		cmp.w #5,d5
		bne.w vnot5
		lea		Spr5_Data,a1		; DESTINATION Address
		lea.l spritecolor_45_0,a4
		jmp vdoit
vnot5:
		cmp.w #6,d5
		bne.w vnot6
		lea		Spr6_Data,a1		; DESTINATION Address
		lea.l spritecolor_67_0,a4
		jmp vdoit
vnot6:
		cmp.w #7,d5
		bne.w vnot7
		lea		Spr7_Data,a1		; DESTINATION Address
		lea.l spritecolor_67_0,a4
		jmp vdoit
vnot7:
		jmp vedoit
vdoit:
		; bsr.w   copyVisualSpriteData

		; direct version with sprite data plane_0, plane_1
		; copy correct data
		; add.l   #2,a1
		moveq.l	#16,d2					; Sprite Image Data Lenght in Long Words
directData:
		move.l	(a2)+,(a1)+					; Copy from Source to destination in Long Words
		dbra	d2,directData			; Loop Till we Copy

		; copy now the color data
		; 2 sprites have 3 colors together 01,23,45,67
		; you could also ! attach them than you have 4 sprites ... dam nothing

		; a2 the end of sprite data
		; move now to 
		

		; manual
		jmp jackmet
		lea.l spritecolor_01_0,a1 
		move.w #$0fff,(a1)+
		lea.l spritecolor_01_1,a1 
		move.w #$0fff,(a1)
		lea.l spritecolor_01_2,a1 
		move.w #$0fff,(a1)
		lea.l spritecolor_01_3,a1 
		move.w #$0fff,(a1)

		lea.l spritecolor_01_0,a1 
		move.w #$0000,(a1)+
		lea.l spritecolor_01_1,a1 
		move.w #$0888,(a1)
		lea.l spritecolor_01_2,a1 
		move.w #$0aaa,(a1)
		lea.l spritecolor_01_3,a1 
		move.w #$0fff,(a1)
jackmet:
		

		; jmp nonono_notanymore
		; get color data
		add.l #spritevisualdata_object_bytes,a3
		sub.l #4*2,a3
		move.l a4,a1 
		move.w (a3)+,(a1)
		add.l #4,a1
		move.w (a3)+,(a1)
		add.l #4,a1
		move.w (a3)+,(a1)
		add.l #4,a1
		move.w (a3)+,(a1)
nonono_notanymore:		

no_directdata:



vedoit:

nonewanim:
		add.l #gameobject_size_bytes,a6
		dbra d6,rendervisualdata
		
		rts


; positions
renderGameObjects:

		; ---------------------------
		; RENDER GAMEOBJECTS X/Y
		; ---------------------------
		; xy to hardware sprites
		move.l #8,d6 ; gameobjects_no
		lea.l gameobjects,a6

render:		

		; dump switch		
		; is there a sprite? 
		move.w gameobject_spr(a6),d5

		cmp #0,d5
		bne not0
		lea		Spr0,a1
		jmp rendertospritenow	
not0:

		cmp #1,d5
		bne not1
		lea		Spr1,a1
		jmp rendertospritenow		
not1:
		cmp #2,d5
		bne not2
		lea		Spr2,a1
		jmp rendertospritenow
not2:
		cmp #3,d5
		bne not3
		lea		Spr3,a1
		jmp rendertospritenow
not3:
		cmp #4,d5
		bne not4
		lea		Spr4,a1
		jmp rendertospritenow
not4:
		cmp #5,d5
		bne not5
		lea		Spr5,a1
		jmp rendertospritenow
not5:
		cmp #6,d5
		bne not6
		lea		Spr6,a1
		jmp rendertospritenow
not6:
		cmp #7,d5
		bne not7
		lea		Spr7,a1
		jmp rendertospritenow
not7:
		; not found
		jmp norendertosprite

rendertospritenow:

		; render now to hardware sprites
		move.w  gameobject_y(a6),d0
		move.w  gameobject_x(a6),d1
		move.w	#$10,d2
		bsr.w	MoveSprite

norendertosprite:

		add.l  #gameobject_size_bytes,a6 ; gameobject_size
		dbra d6,render

		rts		

;======================================================================================================================
; Prints a Character to the screen
;======================================================================================================================

DrawText:
	MOVE.L	StrCodingPtr(PC),A0			; Text Address in a0
	MOVEQ	#0,D2					; Clear d2
	MOVE.B	(A0)+,D2				; Next Char d2
	CMP.B	#$ff,d2					; End of text? ($FF)
	beq.s	XText_Exit				; Yes - Exit
	TST.B	d2						; End of Line? ($00)
	bne.s	XNotEOL					; No Not End Of Line

	ADD.L	#20*7,XBitplanePtr		; Screen is 40 byte wide and the font is 8 bytes high
	ADDQ.L	#1,StrCodingPtr				; Hold the column on the on the screen or where we are on the current line
									; hence reset it to 1 since we are starting a new line
	move.b	(a0)+,d2				; First character on the line skipping 0

XNotEOL:
	SUB.B	#$20,D2					; Subtract 32 from the char ASCII value 
									; so that we can transform for example
									; if it was a space which is $20 to a $00
									; the asterics $21 to $01 etc etc
	LSL.W	#3,D2					; Multiply the same number by 8,
									; since the font is 8 pixels high
	MOVE.L	D2,A2					; move the multiplication result to A2
	ADD.L	#XFont,A2				; Add the value in A2 to the font Base address

	; Display char on bitplanes
	MOVE.L	XBitplanePtr(PC),A3		; Bitplane Address in a3
	MOVE.B	(A2)+,40*0(A3)			; Print Line 1 of char
	MOVE.B	(A2)+,40*1(A3)			; Print Line 2 of char
	MOVE.B	(A2)+,40*2(A3)			; Print Line 3 of char
	MOVE.B	(A2)+,40*3(A3)			; Print Line 4 of char
	MOVE.B	(A2)+,40*4(A3)			; Print Line 5 of char
	MOVE.B	(A2)+,40*5(A3)			; Print Line 6 of char
	MOVE.B	(A2)+,40*6(A3)			; Print Line 7 of char
	MOVE.B	(A2)+,40*7(A3)			; Print Line 8 of char

	ADDQ.L	#1,XBitplanePtr	 		; We need to move 8 bits or 1 byte for next character
	ADDQ.L	#1,StrCodingPtr				; Next character to print

XBitplanePtr:
	dc.l	GameScreenBitplanes

XText_Exit:
	RTS

StrCodingPtr:
	dc.l	StrCoding
StrCoding:
    dc.b    "sq"
    dc.b    $ff

XFont:
	incbin	"gfx/nice.fnt"

;======================================================================================================================
;  cryAengine
;======================================================================================================================
	even

gameobjects_no equ 3 //  

gameobject_size equ 18 ; members 
gameobject_size_bytes equ 36 ; gameobject_size * 2 ; word

gameobject_state equ 0
gameobject_x equ 1*2 
gameobject_y equ 2*2 
gameobject_width equ 3*2
gameobject_height equ 4*2 
gameobject_colwidth equ 5*2
gameobject_colheight equ 6*2 
gameobject_type equ 7*2
gameobject_typesub equ 8*2 
gameobject_art equ 9*2   ; 
gameobject_animtype equ 10*2  ; -- represented in a sprite
gameobject_animmin equ 11*2  ; -- represented in a sprite
gameobject_animmax equ 12*2  ; 
gameobject_animind equ 13*2 ;
gameobject_animindold equ 14*2 ;
gameobject_arg equ 15*2 ;
gameobject_behaviour equ 16*2 ;
gameobject_spr equ 17*2  ; -- represented in a sprite

; > update also length of a gameobject ^ up 

; object states 
objectstate_active equ 1
objectstate_inactive equ 0 ; moved to -16,-16 !


; behavior
behavior_standstill equ 0 ; stand still
behavior_mouse_direct equ 1 ; 
behavior_mouse_relative equ 2 ; 

; squarez behaviors
behavior_left equ 3 ; 
behavior_right equ 4 ; 
behavior_up equ 5 ; 
behavior_down equ 6 ; 
behavior_4dir_random equ 7 ; generates left>down and creates 
behavior_up_top equ 8 ; up to the top and disappear

; holy cube behaviours
behavior_onplatform_left_fall equ 8 ; 
behavior_onplatform_right_fall equ 9 ; 
; avatar
behavior_avatar_bounce_left equ 10
behavior_avatar_bounce_right equ 11

behavior_stay equ 12

behavior_onplatform_left equ 13 ; 
behavior_onplatform_right equ 14 ;  

; anim 
anim_indold_default equ 42000

atype_noanim equ 0
atype_loop equ 1
atype_once equ 2
atype_once_destroy equ 3

; type
type_neutral equ 0

type_transparent_animind equ 1; transparent

type_avatar equ 1

; avatar_mouse
type_avatar_mouse_atype equ atype_noanim
type_avatar_mouse_animind equ 0 ; anim

; avatar
type_avatar_atype equ atype_loop
type_avatar_animmin equ 8 ; anim
type_avatar_animind equ 9 ; anim
type_avatar_animmax equ 12 ; anim +1

type_bonus equ 2
type_bonus_atype equ atype_loop
type_bonus_animmin equ 16 ; anim
type_bonus_animind equ 17 ; anim
type_bonus_animmax equ 20 ; anim +1

; simple effect halo 
type_effect equ 2
type_effect_atype equ atype_loop
type_effect_animmin equ 20 ; anim 
type_effect_animind equ 21 ; anim
type_effect_animmax equ 23+1 ; anim +1

; left right enemy
type_enemy equ 3
type_enemy_animmin equ 12 ; anim
type_enemy_animind equ 13 ; anim
type_enemy_animmax equ 15+1 ; anim +1

; enemy up and down ... 
type_enemyupdown equ 4
type_enemyupdown_animmin equ 16 ; anim
type_enemyupdown_animind equ 17 ; anim
type_enemyupdown_animmax equ 19+1 ; anim +1

; simple effect - cube - shadow 
type_effect_once equ 5
type_effect_once_atype equ atype_once
type_effect_once_animmin equ 4 ; anim 
type_effect_once_animind equ 5 ; anim
type_effect_once_animmax equ 7+1 ; anim +1


; sub
type_enemysub_leftright equ 0
type_enemysub_updown equ 1

; ------------------------
; types
; ------------------------
; in a0 pointer to the gameobject
initType:

	cmp.w #type_avatar,gameobject_type(a0)
	bne.w init_nottheavatar
	move.w #objectstate_active,gameobject_state(a0)
	move.w #atype_loop,gameobject_animtype(a0)
	move.w #type_avatar_animmin,gameobject_animmin(a0)
	move.w #type_avatar_animmin,gameobject_animind(a0)
	move.w #type_avatar_animmax,gameobject_animmax(a0)
	move.w #anim_indold_default,gameobject_animindold(a0)
	move.w #0,gameobject_arg(a0)

	; dirty version - but sorry
	; halo
;	move.w gameobject_x(a0),gameobject_x-gameobject_size_bytes(a0)
;	move.w gameobject_y(a0),gameobject_y-gameobject_size_bytes(a0)
;	move.w #objectstate_active,gameobject_state-gameobject_size_bytes(a0)


	; behavior_avatar_bounce_left
	jmp  end_inittype
init_nottheavatar:

	cmp.w #type_effect,gameobject_type(a0)
	bne.w init_noteffect
	move.w #objectstate_active,gameobject_state(a0)
	move.w #atype_loop,gameobject_animtype(a0)
	move.w #type_effect_animmin,gameobject_animmin(a0)
	move.w #type_effect_animmin,gameobject_animind(a0)
	move.w #type_effect_animmax,gameobject_animmax(a0)
	move.w #anim_indold_default,gameobject_animindold(a0)
	move.w #0,gameobject_arg(a0)
	jmp  end_inittype
init_noteffect:


	cmp.w #type_enemy,gameobject_type(a0)
	bne.w init_nottheenemy
	move.w #objectstate_active,gameobject_state(a0)
	move.w #atype_loop,gameobject_animtype(a0)
	move.w #type_enemy_animmin,gameobject_animmin(a0)
	move.w #type_enemy_animmin,gameobject_animind(a0)
	move.w #type_enemy_animmax,gameobject_animmax(a0)
	move.w #anim_indold_default,gameobject_animindold(a0)
	move.w #behavior_onplatform_right_fall,gameobject_behaviour(a0)
	jmp  end_inittype
init_nottheenemy:

	cmp.w #type_enemyupdown,gameobject_type(a0)
	bne.w init_nottheenemyupdown
	move.w #objectstate_active,gameobject_state(a0)
	move.w #atype_loop,gameobject_animtype(a0)
	move.w #type_enemyupdown_animmin,gameobject_animmin(a0)
	move.w #type_enemyupdown_animmin,gameobject_animind(a0)
	move.w #type_enemyupdown_animmax,gameobject_animmax(a0)
	move.w #anim_indold_default,gameobject_animindold(a0)
	; move.w #behavior_updown,gameobject_behaviour(a0)
	jmp  end_inittype
init_nottheenemyupdown:

	cmp.w #type_effect_once,gameobject_type(a0)
	bne.w init_noteffect_once
	move.w #objectstate_active,gameobject_state(a0)
	move.w #atype_once_destroy,gameobject_animtype(a0)
	move.w #type_effect_once_animmin,gameobject_animmin(a0)
	move.w #type_effect_once_animmin,gameobject_animind(a0)
	move.w #type_effect_once_animmax,gameobject_animmax(a0)
	move.w #anim_indold_default,gameobject_animindold(a0)
	; up !!! 
	move.w #behavior_up_top,gameobject_behaviour(a6)

	; haha deactivate now ... not directly use .-)
	; move.w #objectstate_inactive,gameobject_state(a0)	

	move.w #0,gameobject_arg(a0)
	jmp  end_inittype
init_noteffect_once:


end_inittype:

	rts

; ------------------------
; important vars
; ------------------------
	even
game_state dc.l 0
game_state_sub dc.l 0
game_state_sub_old dc.l 0

state_intro equ 0  ; title too
state_menu equ 1
state_ingame equ 2
state_gameover equ 3

; menu
menupoint_game_state_sub dc.l 1
menupoint_game_state_sub_old dc.l 42

statesub_main equ 0
statesub_story equ 1
statesub_howto equ 2
statesub_play equ 3
statesub_about equ 4 ; or credits
statesub_higscore equ 5

statesub_gameover equ 6
statesub_won equ 7


timer dc.l   0

; for counts timer + 1
timercounter:
	 dc.l 0
timestep:
 dc.l 400


level: 	dc.l 	0
level_old: 	dc.l 	0
level_maxbonus: dc.l 4

parselevel_address: dc.l 1

score: 	dc.l 	1
old_score: dc.l  0
hscore: dc.l 	50
lifes: 	dc.l 	3
health: dc.l 	100

scoredefault: 	dc.l 	0
hscoredefault: dc.l 	100
lifesdefault: 	dc.l 	3
healthdefault: dc.l 	100

animation: dc.l 0
animation_step: dc.l 6; // 15 

; on platform
avatar_onplatform:
			dc.w  0

; ------------------
; VARIABELS
; ------------------

mousebuttonpressed: dc.w 0

fire0:   	dc.w 0,0


fire1:   	dc.w 0,0
up1:			dc.w 0,0
down1:		dc.w 0,0
left1:		dc.w 0,0
right1:   dc.w 0,0

	ofire0:   	dc.w 42,0

	ofire1:   	dc.w 42,0
	oup1:			dc.w 42,0
	odown1:		dc.w 42,0
	oleft1:		dc.w 42,0
	oright1:   dc.w 42,0

; some bytes to jump ... 
jump_algo:      
    dc.b 0,6,6,5,5,5,5,3,3,3,3,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,42
    dc.b 0,6,5,5,3,3,2,2,2,1,1,0,0,0,0,0,0,0,42,0,0,0,0,0


 
; ------------------------
; debug effect
; ------------------------
rainbow: 
		move.w    $DFF006,$DFF180 ; background
		rts

; ------------------------
; gameobjects
; ------------------------
	even
gameobjects:

gameobject0:
	dc.w 1    ; state
	gameobject0_x:
	dc.w 20   ; x
	gameobject0_y:
	dc.w 100   ; y
	dc.w 16   ; width
	dc.w 16   ; height
	dc.w 16   ; col width
	dc.w 16   ; col height
	dc.w 0   ; type
	dc.w 0   ; typesub
	dc.w 0   ; art
	dc.w 0   ; animtype
	dc.w 0   ; animmin
	dc.w 0   ; animmax
	dc.w 0   ; animind
	dc.w 21000   ; animindold
	dc.w 1   ; arg
	dc.w 0   ; behavior
	dc.w 0   ; spr

gameobject1:
	dc.w 1    ; state
	dc.w 40   ; x
	dc.w 100   ; y
	dc.w 16   ; width
	dc.w 16   ; height
	dc.w 16   ; col width
	dc.w 16   ; col height
	dc.w 0   ; type
	dc.w 0   ; typesub
	dc.w 0   ; art
	dc.w 0   ; animtype
	dc.w 0   ; animmin
	dc.w 0   ; animmax
	dc.w 1   ; animind
	dc.w 21000   ; animindold
	dc.w 2   ; arg
	dc.w 0   ; behavior
	dc.w 1   ; spr

gameobject2:
	dc.w 1    ; state
	dc.w 60   ; x
	dc.w 100   ; y
	dc.w 16   ; width
	dc.w 16   ; height
	dc.w 16   ; col width
	dc.w 16   ; col height
	dc.w 0   ; type
	dc.w 0   ; typesub
	dc.w 0   ; art
	dc.w 0   ; animtype
	dc.w 0   ; animmin
	dc.w 0   ; animmax
	dc.w 2   ; animind
	dc.w 21000   ; animindold
	dc.w 1   ; arg
	dc.w 0   ; behavior
	dc.w 2   ; spr

gameobject3:
	dc.w 1    ; state
	dc.w 80   ; x
	dc.w 100   ; y
	dc.w 16   ; width
	dc.w 16   ; height
	dc.w 16   ; col width
	dc.w 16   ; col height
	dc.w 0   ; type
	dc.w 0   ; typesub
	dc.w 0   ; art
	dc.w 0   ; animtype
	dc.w 0   ; animmin
	dc.w 0   ; animmax
	dc.w 3   ; animind
	dc.w 21000   ; animindold
	dc.w 3   ; arg
	dc.w 0   ; behavior
	dc.w 3   ; spr

gameobject4:
	dc.w 1    ; state
	dc.w 100   ; x
	dc.w 100   ; y
	dc.w 16   ; width
	dc.w 16   ; height
	dc.w 16   ; col width
	dc.w 16   ; col height
	dc.w 0   ; type
	dc.w 0   ; typesub
	dc.w 0   ; art
	dc.w 0   ; animtype
	dc.w 0   ; animmin
	dc.w 0   ; animmax
	dc.w 4   ; animind
	dc.w 21000   ; animindold
	dc.w 1   ; arg
	dc.w 0   ; behavior
	dc.w 4   ; spr

gameobject5:
	dc.w 1    ; state
	dc.w 120   ; x
	dc.w 100   ; y
	dc.w 16   ; width
	dc.w 16   ; height
	dc.w 16   ; col width
	dc.w 16   ; col height
	dc.w 0   ; type
	dc.w 0   ; typesub
	dc.w 0   ; art
	dc.w 0   ; animtype
	dc.w 0   ; animmin
	dc.w 0   ; animmax
	dc.w 5   ; animind
	dc.w 21000   ; animindold
	dc.w 2   ; arg
	dc.w 0   ; behavior
	dc.w 5   ; spr

gameobject6:
	dc.w 1    ; state
	dc.w 140   ; x
	dc.w 100   ; y
	dc.w 16   ; width
	dc.w 16   ; height
	dc.w 16   ; col width
	dc.w 16   ; col height
	dc.w 0   ; type
	dc.w 0   ; typesub
	dc.w 0   ; art
	dc.w 0   ; animtype
	dc.w 0   ; animmin
	dc.w 0   ; animmax
	dc.w 6   ; animind
	dc.w 21000   ; animindold
	dc.w 3   ; arg
	dc.w 0   ; behavior
	dc.w 6   ; spr

gameobject7:
	dc.w 1    ; state
	dc.w 160   ; x
	dc.w 100   ; y
	dc.w 16   ; width
	dc.w 16   ; height
	dc.w 16   ; col width
	dc.w 16   ; col height
	dc.w 0   ; type
	dc.w 0   ; typesub
	dc.w 0   ; art
	dc.w 0   ; animtype
	dc.w 0   ; animmin
	dc.w 0   ; animmax
	dc.w 7   ; animind
	dc.w 21000   ; animindold
	dc.w 1   ; arg
	dc.w 0   ; behavior
	dc.w 7   ; spr

gameobject8:
	dc.w 1    ; state
	dc.w 180   ; x
	dc.w 100   ; y
	dc.w 16   ; width
	dc.w 16   ; height
	dc.w 16   ; col width
	dc.w 16   ; col height
	dc.w 0   ; type
	dc.w 0   ; typesub
	dc.w 0   ; art
	dc.w 0   ; animtype
	dc.w 0   ; animmin
	dc.w 0   ; animmax
	dc.w 0   ; animind
	dc.w 21000   ; animindold
	dc.w 0   ; arg
	dc.w 0   ; behavior
	dc.w 42   ; spr

gameobject9:
	dc.w 1    ; state
	dc.w 200   ; x
	dc.w 100   ; y
	dc.w 16   ; width
	dc.w 16   ; height
	dc.w 16   ; col width
	dc.w 16   ; col height
	dc.w 0   ; type
	dc.w 0   ; typesub
	dc.w 0   ; art
	dc.w 0   ; animtype
	dc.w 0   ; animmin
	dc.w 0   ; animmax
	dc.w 0   ; animind
	dc.w 21000   ; animindold
	dc.w 0   ; arg
	dc.w 0   ; behavior
	dc.w 42   ; spr


	; space for more gameobject

	dcb.w	5*18*2,0

;======================================================================================================================
;  cryAengine: colors
;======================================================================================================================

colorsTitleToBlack:

		IF ModeBlack

		move.l #15,d1
		lea.l GenericColsBase,a0

colsTo:		
		move.w (a0)+,d0
		move.w #$0,(a0)
		move.w (a0)+,d0
		dbra d1,colsTo

		ENDIF

		rts

colorsToBlack:

		IF ModeBlack

		move.l #15,d1
		lea.l InGameColors,a0
colsToB:		
		move.w (a0)+,d0
		move.w #$0,(a0)
		move.w (a0)+,d0
		dbra d1,colsToB

		ENDIF 

		rts		


colorsToGameColors:

		; a list 
		lea.l colors,a0						; Move to A0 since we will work with Address Register

		lea		InGameColors,a1			; Get the Address of where the colours are in the Copper list
		moveq	#15,d1						; Number of Colours
		addq.l	#2,a1							; Add 4 to the Copper list Address
nextcol:
		; move.w	d1,(a1)						; Copy the Word to teh Copper list Address Word
		move.w	(a0),(a1)						; Copy the Word to teh Copper list Address Word
		add.l	#2,a0							; Add 4 to the Copper list Address
		add.l	#4,a1							; Add 4 to the Copper list Address
		dbra	d1,nextcol					; Loop
nocopycolors:

		rts


;======================================================================================================================
;  cryAengine: BOBs und BLOBS (copy into memory and redo)
;======================================================================================================================


BLTDDAT	=0	;result of the last word. used for bob collision detection and 
		;MFM decoding
DMACONR	=2	;bit 14=blitter busy flag

BLTCON0	=$40	;blitter operation setup
BLTCON1	=$42
BLTAFWM	=$44
BLTALWM	=$46

BLTCPTH	=$48	;sources, destination, and size
BLTCPTL	=$4a
BLTBPTH	=$4c
BLTBPTL	=$4e
BLTAPTH	=$50
BLTAPTL	=$52
BLTDPTH	=$54
BLTDPTL	=$56

BLTSIZE	=$58

BLTCON0L=$5a	;ECS/AGA registers
BLTSIZV	=$5c
BLTSIZH	=$5e

BLTCMOD	=$60	;modulos
BLTBMOD	=$62
BLTAMOD	=$64
BLTDMOD	=$66

BLTCDAT	=$70	;data to replace sources
BLTBDAT	=$72
BLTADAT	=$74

DMACON	=$96	;bit 6: enable blitter DMA. bit 10: give blitter priority over
		;the CPU.

BlitWait:
	tst DMACONR(a6)			;for compatibility
waitblit:
	btst #6,DMACONR(a6)
	bne.s waitblit
	rts

; https://www.youtube.com/watch?v=OLhhgfnNo9A

; solve a puzzle
 
w	=320 ; 320?
h	=256
; bplsize	=w*h/8 ; pl playfield? 
ScrBpl	=w/8

logow		=16; 320
logoh		=16; 99
logomargin	=(320-logow)/2
logobpl		=logow/8
logobwid	=logobpl*3

skybpl		=logobpl
skybwid		=logobwid

;;    ---  font dimensions  ---
fontw		=288
fonth		=100
fontbpls	=3
FontBpl		=fontw/8

plotY	=110
plotX	=w-32

logobgcol	=$44f
bgcol		=$225

row	=288*3*20/8
col	=4


BlitSomething:

		movem.l d0-a6,-(sp)


ww 		=320

bltx	=70
blty    =90
bltoffs =30*(w/8)+bltx/8

bltw	=224/16
blth 	=100
bltskip =(320-224)/8



		; enable blitter
		move.w #$8040,$dff096 ; enable blitter

		jmp blackSquare

		; https://www.youtube.com/watch?v=6LQ5xGnG6Fk
		; clear a part of the screen

		; 1. plane
		tst $dff002
waitblitx:
		btst #14-8,$dff002
		bne waitblitx:
		move.l #$01000000,$dff040		
	;	move.l #$01ffffff,$dff040		
		move.l #IntroScreen+bltoffs,$dff054
		move.w #bltskip,$dff066
		move.w #blth*64+bltw,$dff058 ; set size

		; 2. plane
		tst $dff002
waitblity:
		btst #14-8,$dff002
		bne waitblity:
		move.l #$01000000,$dff040		
	;	move.l #$01ffffff,$dff040		
		move.l #IntroScreen+40*256+bltoffs,$dff054
		move.w #bltskip,$dff066
		move.w #blth*64+bltw,$dff058 ; set size

		; 3. plane
		tst $dff002
waitblityy:
		btst #14-8,$dff002
		bne waitblityy:
		move.l #$01000000,$dff040		
	;	move.l #$01ffffff,$dff040		
		move.l #IntroScreen+40*256*2+bltoffs,$dff054
		move.w #bltskip,$dff066
		move.w #blth*64+bltw,$dff058 ; set size

		; 4. plane
		tst $dff002
waitblityyz:
		btst #14-8,$dff002
		bne waitblityyz:
		move.l #$01000000,$dff040		
	;	move.l #$01ffffff,$dff040		
		move.l #IntroScreen+40*256*3+bltoffs,$dff054
		move.w #bltskip,$dff066
		move.w #blth*64+bltw,$dff058 ; set size

blackSquare:


		jmp nodma

			; ----------------------
			; BLITTER FOR(N)EVER
			; DMA
			; ----------------------
			; https://www.amigarealm.com/computing/knowledge/hardref/ch6.htm
			; 
			; move.w #$8040,$dff096 ; enable blitter
			bsr BlitWait

			; pointer
			lea $dff000,a6 		  ; pointer to blitter
; AMod
; APath
; DMod
; DPath

			move.l #$09f00000,BLTCON0(a6) ; MODE/COMMAND
			move.l #$ffffffff,BLTAFWM(a6) ; overwrite or not
	
			move.l #bob_first_mask,d0
			lea.l  bob_first_mask,a0
			move.l a0,BLTAPTH(a6)			; SOURCE
			move.w #3,BLTAMOD(a6)	; ADDED TO SOURCE  FontBpl-col

			; adr + bytes * 3 * ploty + plotx ... 
			move.l #TitleScreenBitmap,BLTDPTH(a6) ; Destination  Source or Destinantion
			; #TitleScreenBitmap+ScrBpl*3*plotY+plotX/8
			move.w #(320-32)/8,BLTDMOD(a6)  ; ADDED TO DESTINATION ScrBpl-col
			move.w #32*64+31,BLTSIZE(a6) ; 20*3*64+2 // bytes

			;move.w #20*3*64+2,BLTSIZE(a6) 
			; start blitter !  size w1(height)w2(width)
			; is not 2*8 bit !!!! fuck dam - they have enough memory but use
			; bits bits and bits ... 
			;clr.l d0
			;move.w #16,d0
			;swap d0
			;move.w #16,d0
			;move.l d0,BLTSIZE(a6)  
;			move.w #16*4*64+2,BLTSIZE(a6) ; 20*3*64+2

		; jsr rainbow
nodma:

		movem.l (sp)+,d0-a6

		rts

		even


bob_first_mask:
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		
		dc.b %11111111,%11111111 
		; + 2 words
		dc.w 0,0		


bob_first:

		; plane_0
		dc.b %00000000,%00000000 
		; + 2 words
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000001,%11110000 
		dc.w 0,0		
		dc.b %00001001,%11110000 
		dc.w 0,0		
		dc.b %00001000,%00110000 
		dc.w 0,0		
		dc.b %00001100,%00110000 
		dc.w 0,0		
		dc.b %00001100,%00110000 
		dc.w 0,0		
		dc.b %00000100,%00110000 
		dc.w 0,0		
		dc.b %00000111,%11000000 
		dc.w 0,0		
		dc.b %00000001,%11100000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		
		; plane_1
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000001,%00000000 
		dc.w 0,0		
		dc.b %00000001,%11100000 
		dc.w 0,0		
		dc.b %00000000,%00100000 
		dc.w 0,0		
		dc.b %00000000,%00100000 
		dc.w 0,0		
		dc.b %00000000,%00110000 
		dc.w 0,0		
		dc.b %00000000,%00110000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		
		dc.b %00000000,%00000000 
		dc.w 0,0		

		; plane_2
		dc.b %00000000,%00000100
		dc.w 0,0		
		dc.b %00111000,%00000100
		dc.w 0,0		
		dc.b %00000011,%11100100
		dc.w 0,0		
		dc.b %00000000,%00000011
		dc.w 0,0		
		dc.b %00000001,%00000000
		dc.w 0,0		
		dc.b %00001001,%11100000
		dc.w 0,0		
		dc.b %00001000,%00100000
		dc.w 0,0		
		dc.b %00001100,%00100000
		dc.w 0,0		
		dc.b %00001100,%00110000
		dc.w 0,0		
		dc.b %11001100,%00110011
		dc.w 0,0		
		dc.b %00001111,%11000000
		dc.w 0,0		
		dc.b %00001111,%11100000
		dc.w 0,0		
		dc.b %01000000,%00000000
		dc.w 0,0		
		dc.b %00000000,%00000100
		dc.w 0,0		
		dc.b %00101110,%00000100
		dc.w 0,0		
		dc.b %00000000,%00000100
		dc.w 0,0		

		; plane_3
		dc.b %00000000,%00000000
		dc.w 0,0		
		dc.b %00000000,%00000000
		dc.w 0,0		
		dc.b %00000000,%00000000
		dc.w 0,0		
		dc.b %00000000,%00000000
		dc.w 0,0		
		dc.b %00001111,%00000000
 		dc.w 0,0		
		dc.b %00000111,%11100000
		dc.w 0,0		
		dc.b %00000100,%00100000
		dc.w 0,0		
		dc.b %00000000,%00100000
		dc.w 0,0		
		dc.b %00000000,%00110000
		dc.w 0,0		
		dc.b %00000000,%00110000
		dc.w 0,0		
		dc.b %00000000,%00110000
		dc.w 0,0		
		dc.b %00000000,%00010000
		dc.w 0,0		
		dc.b %00000000,%00000000
		dc.w 0,0		
		dc.b %00000000,%00000000
		dc.w 0,0		
		dc.b %00000000,%00000000
		dc.w 0,0		
		dc.b %00000000,%00000000
		dc.w 0,0		


;======================================================================================================================
;  cryAengine: levels
;======================================================================================================================

actualLevelIndex: dc.l 0


; load into the actual level
loadActualLevel:

	lea.l levels,a1
	move.l actualLevelIndex,d0
	cmp.l #0,d0
	beq nocounting_levels
	sub.l #1,d0
adac_counting:
	add.l #20*16+2,a1
	dbra d0,adac_counting 	
nocounting_levels:

;	lea.l levels,a1

	move.l #20*16,d1
	lea.l actualLevel,a2
cp:
	move.b (a1)+,(a2)+
	dbra d1,cp

	rts

	

; draw the actual level
drawLevel:

	move.l #15,d7
	
	lea.l actualLevel,a4

	move.l #0,d5
ly:
	move.w d5,blocky
	move.l #19,d6
	move.l #0,d4
lx:
	move.w d4,blockx
	clr.l  d0
	move.b (a4)+,d0
	move.w d0,blockno
	jsr drawBlockXY
	add.l #1,d4
	dbra d6,lx

	add.l #1,d5	
	dbra d7,ly

	rts


	even

;======================================================================================================================
;  cryAengine: get Level Block (XY) etc
;======================================================================================================================
	even

; input
levelBlockX:
	dc.w 0
levelBlockY:
	dc.w 0

; output
levelBlockIndex:
	dc.w 0

levelBlock16X:
	dc.w 0
levelBlock16XRest:
	dc.w 0

levelBlock16Y:
	dc.w 0
levelBlock16YRest:
	dc.w 0

levelBlockAddress:
	dc.l 0


; ======================================================================================================================
; set level block in memory !
;======================================================================================================================
setLevelBlock:
; bug found: d0 > instead of levelBlockIndex!

	movem.l	d0-d6/a0-a5,-(SP)

	lea.l actualLevel,a0
	clr.l d0
	move.w levelBlockY,d0
	mulu.w #20,d0
	clr.l d1
	move.w levelBlockX,d1
	add.w d1,d0
	add.l d0,a0
	clr.l d0
	move.w levelBlockIndex,d0
	move.b d0,(a0)

	movem.l	(SP)+,d0-d6/a0-a5

	rts
	
getLevelBlock:

	movem.l	d0-d6/a0-a5,-(SP)


		clr.l d0
		move.w levelBlockX,d0
		divu #16,d0
		move.w d0,levelBlock16X
		swap d0
		move.w d0,levelBlock16XRest

		clr.l d0
		move.w levelBlockY,d0
		divu #16,d0
		move.w d0,levelBlock16Y
		swap d0
		move.w d0,levelBlock16YRest

		; now create the address
		clr.l d0
		move.w levelBlock16Y,d0
		mulu #20,d0
		add.w levelBlock16X,d0

		lea.l actualLevel,a0
		add.l d0,a0

		clr.l d0
		move.b (a0),d0
		move.w d0,levelBlockIndex

		move.l a0,levelBlockAddress

	movem.l	(SP)+,d0-d6/a0-a5


		rts



;======================================================================================================================
;  cryAengine: block animations
;======================================================================================================================

				
activateMousePointer:

	lea.l gameobjects,a0
	move.w #type_avatar_mouse_atype,gameobject_animtype(a0)
	move.w #type_avatar_mouse_animind,gameobject_animind(a0)

	rts

;======================================================================================================================
;  cryAengine: block animations
;======================================================================================================================
; animate actual level 
; one animation 4 blocks
					even
block_anim_index: dc.l 0
block_anim_speed: dc.l 15

block_anim_startblock: dc.l 144 ; -1
block_anim_stopblock: dc.l 160 ;+1

block_bounce_start equ 88
block_bounce_stop equ 95

block_platform_start equ 79
block_platform_stop equ 87

block_collect_start equ 104
block_collect_stop equ 111
block_collect_replace equ 66 

block_die_start equ 98
block_die_stop equ 100

BlockAnimation:

	add.l  #1,block_anim_index
	move.l block_anim_speed,d0
	cmp.l  block_anim_index,d0
	bne no_blockanimation
	move.l #0,block_anim_index	

	move.l #15,d7
	
	lea.l actualLevel,a4

	move.l #0,d5
bly:
	move.w d5,blocky
	move.l #19,d6
	move.l #0,d4
blx:
	move.w d4,blockx
	clr.l  d0
	move.b (a4)+,d0
	
	move.l block_anim_startblock,d1
	cmp.b d0,d1
	bhi.b notimp
	move.l block_anim_stopblock,d1
	cmp.b d0,d1
	bcs.b notimp

	; animate now ...
	add.b #1,d0

	; %4 
	clr.l d1
	move.b d0,d1
	divu #4,d1
	swap d1 ; %
	cmp.w #0,d1
	bne.w not_4
	
	clr.l d0
	move.b -1(a4),d0
	divu #4,d0
	mulu #4,d0
	; move.b #120,d0

not_4: 
	move.b d0,-1(a4)
	move.w d0,blockno
	jsr drawBlockXY



notimp:

	add.l #1,d4
	dbra d6,blx

	add.l #1,d5	
	dbra d7,bly

no_blockanimation:

		rts 

;======================================================================================================================
;  cryAengine: numbers
;======================================================================================================================

number_no: dc.l 0
number_x: dc.l 0
number_y: dc.l 0
number_size: dc.l 1

number_showzero: dc.l 1 ; 1: show 001 or 1

; tmp
number_tmp_x: dc.l 0
number_tmp: dc.l 0

; print it revers    <-startx
drawNumbers:

		move.l number_size,d4
		move.l number_no,number_tmp 
		; move.l #123,number_tmp
		move.l number_y,d0
		move.w d0,blocky
		move.l number_x,number_tmp_x
dn:		

		move.l number_tmp_x,d0
		move.w d0,blockx
		move.l  number_tmp,d3
		divu #10,d3
		clr d0
		move.w d3,d0
		move.l d0,number_tmp
		clr d0
		swap d3
		move.w d3,d0
		add.l #39,d0
		move.w d0,blockno

		jsr drawBlockXY

		cmp.l #0,number_showzero
		bne   nnn
		cmp.l #0,number_tmp
		bne   nnn
		jmp   dna
nnn:

		sub.l #1,number_tmp_x
		dbra d4,dn

dna:    ; for all the false dna metaphorisms

		rts


;======================================================================================================================
;  cryAengine: blocks
;======================================================================================================================
			even
blockx: 	; * 16
	dc.w	5
blocky: 	; * 16
	dc.w    3
blockno:
	dc.w	1	


; drawBlockXY
drawBlockXY:
	; 2**16

	lea.l  blocks,a0
	; add.l  #(2*16)*12,a0 ; (2*16)*4 = 1line (2byte) * 16 *4  planes
	clr.l d0
	move.w blockno,d0
	cmp.w #0,d0
	beq   ncd
	sub.w #1,d0
cd: 
	add.l  #(2*16)*4,a0
	dbra d0,cd
ncd:
	; screen
	lea.l  GameScreenBitplanes,a1

	; + y*16*40
	clr.l d0
	move.w blocky,d0
	cmp.w #0,d0
	beq   yncd
	sub.w #1,d0
ycd: 
	add.l  #40*16,a1
	dbra d0,ycd
yncd:

	; x
	clr.l d0
	move.w blockx,d0
	cmp.w #0,d0
	beq   xncd
	sub.w #1,d0

xcd: 
	add.l  #2,a1
	dbra d0,xcd
xncd:


	; simpler
	move.l  a1,a2 ; backup

	; plane 0 
	move.l #16-1,d0
for_plane0:
	move.b (a0)+,(a1)+
	move.b (a0)+,(a1)+
	add.l #40-2,a1
;	move.b #255,(a1)+
;	move.b #255,(a1)+
;	add.l #20-2,a1
	dbra d0,for_plane0

	move.l a2,a1
	add.l #40*256,a1 ; a line 40b * 256 = screen	
	move.l #16-1,d0
for_plane1:
	move.b (a0)+,(a1)+
	move.b (a0)+,(a1)+
	add.l #40-2,a1
	dbra d0,for_plane1

	move.l a2,a1
	add.l #2*40*256,a1 ; a line 40b * 256 = screen	
	move.l #16-1,d0
for_plane2:
	move.b (a0)+,(a1)+
	move.b (a0)+,(a1)+
	add.l #40-2,a1
	dbra d0,for_plane2

	move.l a2,a1
	add.l #3*40*256,a1 ; a line 40b * 256 = screen	
	move.l #16-1,d0
for_plane3:
	move.b (a0)+,(a1)+
	move.b (a0)+,(a1)+
	add.l #40-2,a1
	dbra d0,for_plane3



	rts


; displayBlock
	even
number: 
	dc.l    1 

; display Block No > 1,2,4,5, 
displayBlockNumber:

		move.l number,d0
		add.l #39,d0	 
		move.w d0,blockno
		jsr drawBlockXY		

		rts

		even


; -------------------------
; texts
; -------------------------

text_menu_main: dc.b "FIGHT FOR THE VECTORS!+DEFEAT THE PIXEL WORLDS!+PRAY TO THE VECTORS!+++++++++++++ONE BUTTON ACTION PUZZLER+WIN WITH AS FEW ATTEMPTS+AS POSSIBLE",0

text_menusub_story: dc.b "THE EVIL FORCES OF COUNTER+ENLIGHTENMENT HAVE TAKEN OVER+THE WORLD!++THEIR MAGICIANS RULE WITH+PIXELS. COLOURS AND IMAGES.+THEY HATE ABSTRACTION.+ +STEAL THEIR EYE CANDY+DEATH TO THE PIXELERS!++PRAY TO GET BACK TO MENU!++++PRESS FIRE",0

text_menusub_howto: dc.b "TO SAVE THE WORLD FROM THESE+DAEMONS. COLLECT ALL THE+DEVILISH SHINY THINGS. ++PRAY IN JUMPING.+ + LET YOURSELF BE PUSHED+    BACK AND FORTH.++   DONT LET THE DAEMONS+       KILL YOU!++THE FEWER ATTEMPTS+THE BETTER++INGAME BACK TO MENU. +PRESS ESC++++PRESS FIRE",0

text_menusub_about: dc.b "ONE BUTTON ACTION PUZZLER.+BASED ON THE IDEA OF NSTOWER 97+TURNED INTO A LEVELBASED GAME.++RELEASES: ST!AM 2025 C64 2023++DEV: ASSEMBLY CRYAENGINE+CODE.GRAPHICS: T00CG+LEVELS:  T00CG.NULL00.HE02+MUSIC:   COMPUTERMUSIKER+CONTACT: INFO AT LA1N.CH++GREETINGS: BLOODY MARY CARINA+WAR HELI BIG APPLE SCA HALLER+JESPERSEN DEPECHE PRESOLE+DARIO JORDAN HRGIGER+BIGMACBROTHERS+SIMON JOHN PATRICK D+AMIGA BILL+++PRESS FIRE",0

; 19
text_menusub_won: dc.b "YOU DID IT. +YOU PUSHED THE LAME+PIXELS BACK!+COOL!++BUT THEY ARE STILL+OUT THERE. ++TRY TO GET TOUGH+AND BETTER+EVEN FEWER TRIES+NEXT TIME!+++THE FUTURE BELONGS+TO THE VECTORS. US. ++++PRESS FIRE",0

text_gameover: dc.b "GAME OVER",0 
		even

		even


; ----------------------
; drawBlockText
; ----------------------
; text in a4
;

demo_text: dc.b "CODE FOREVER",0
	even

text_x: dc.w 0
text_y: dc.w 0
text_x_max: dc.w 20

text_tmp_x: dc.w 0
text_tmp_y: dc.w 0

; usage:
; move.w #5,text_x
; move.w #,text_y
; ; move.lw text_x_max
; lea.l demo_text,a4
; jsr drawBlockText

drawBlockText:
	move.w text_x,text_tmp_x
	move.w text_y,text_tmp_y

;	lea.l demo_text,a4
while_text:

	clr.l d0
	move.b (a4),d0
	add.l  #1,a4

	cmp.b #0,d0
	beq.b drawEnd_def

	cmp.b #32,d0
	bne.b n_space
	move.b #12,d0
	jmp   drawNowDirect
n_space:

	sub.b #65,d0
	add.b #13,d0

drawNowDirect:

	move.w text_tmp_x,blockx
	move.w text_tmp_y,blocky
	move.w d0,blockno
	jsr drawBlockXY

	add.w #1,text_tmp_x
	move.w text_x_max,d1
	cmp.w text_tmp_x,d1
	bne.w text_x_maxtttt
	move.w text_x,text_tmp_x
	add.w  #1,text_tmp_y
text_x_maxtttt:

	jmp while_text

drawEnd_def:	

	rts




; ----------------------
; drawSmallBlockText
; ----------------------
; text in a4
;

demo_small_text: dc.b "THE WOLF IS GOING AROUND. HE WEARS A RED CAP",0

	even

; text_x: dc.w 0
; text_y: dc.w 0
; text_x_max: dc.w 20

; text_tmp_x: dc.w 0
; text_tmp_y: dc.w 0

; usage:
; move.w #5,text_x
; move.w #,text_y
; ; move.lw text_x_max
; lea.l demo_text,a4
; jsr drawText

textsmall_x_max: dc.w 40

; shift colors for title (different colors ingame - converter problems)
textcolorshift: 	dc.w 0
textcolorshiftcol: 	dc.w 0

; draw smaller text ... 

drawText:

	move.w text_x,text_tmp_x
	move.w text_y,text_tmp_y

;	lea.l demo_text,a4
while_text_small:

	clr.l d0
	move.b (a4),d0
	add.l  #1,a4

	cmp.b #58,d0
	bne.b n_double
	move.b #47,d0
	jmp   drawNowDirect_small
n_double:

; check numbers ... 
	cmp.b #48,d0
	blt.b nonumber
	cmp.b #57,d0
	bgt.b nonumber
	sub.b #48,d0
	add.b #8,d0

	jmp   drawNowDirect_small
nonumber:

	cmp.b #0,d0
	beq drawEnd_def_small

	; return + 
	cmp.b #43,d0 ; 13 return
	bne.b n_returnit
	
	move.w text_x,text_tmp_x
	add.w  #1,text_tmp_y
	; add.l  #1,a4

	jmp   norendering_smtext
n_returnit:


	cmp.b #32,d0
	bne.b n_space_small
	move.b #20,d0
	jmp   drawNowDirect_small
n_space_small:

	cmp.b #46,d0
	bne.b n_bindes
	move.b #18,d0
	jmp   drawNowDirect_small
n_bindes:

	cmp.b #45,d0
	bne.b n_point
	move.b #19,d0
	jmp   drawNowDirect_small
n_point:

	cmp.b #33,d0
	bne.b n_ausruf
	move.b #19,d0
	jmp   drawNowDirect_small
n_ausruf:



; 9 / 10

	sub.b #65,d0
	add.b #21,d0

drawNowDirect_small:

	move.w text_tmp_x,smallblockx
	move.w text_tmp_y,smallblocky
	move.w d0,smallblockno
	jsr drawSmallBlockXY 

	add.w #1,text_tmp_x
	move.w textsmall_x_max,d1
	cmp.w text_tmp_x,d1
	bne.w text_x_maxtttt_small
	move.w text_x,text_tmp_x
	add.w  #1,text_tmp_y
text_x_maxtttt_small:

norendering_smtext:

	jmp while_text_small

drawEnd_def_small:	

	rts

;================================================================================
;	collect the block
;================================================================================

collectTheBlock:

			; the new fieldvalue
			move.w levelBlock16X,levelBlockX
			move.w levelBlock16Y,levelBlockY
			move.w #block_collect_replace,levelBlockIndex
			jsr setLevelBlock

			move.w levelBlock16X,blockx
			move.w levelBlock16Y,blocky
			move.w #block_collect_replace,blockno
			jsr drawBlockXY

			; add to restore
			; jsr addBlockToRestore

			; pray effect ... 
			lea.l gameobjects,a6 ; sprite 0
			add.l #2*gameobject_size_bytes,a6
			; is always the same .. only for this
			move.w #objectstate_active,gameobject_state(a6)
			clr.l d0
			move.w levelBlock16X,d0
			mulu #16,d0
			move.w d0,gameobject_x(a6)			
			clr.l d0
			move.w levelBlock16Y,d0
			mulu #16,d0
			move.w d0,gameobject_y(a6)

			; very simple ... 
			move.w #type_effect_once_animmin,gameobject_animind(a6)
			move.w #atype_once_destroy,gameobject_animtype(a6)


			move.l a7,a0
;			jsr initType
;			move.l a0,a7

		 	 move.l #1,d5

		 	 rts

;======================================================================================================================
; set level block in memory and update visuals
; in ! double buffering
;======================================================================================================================

;			move.w  #10,levelBlockX
;			move.w  #10,levelBlockY
;			move.w #70,levelBlockIndex


; levelBlockY

setLevelBlockAndUpdate

			movem.l	d0-d6/a0-a5,-(SP)

			jsr setLevelBlock

			move.w levelBlockX,blockx
			move.w levelBlockY,blocky
			move.w levelBlockIndex,blockno
			jsr drawBlockXY

			; add to restore
;			jsr addBlockToRestore

			movem.l	(SP)+,d0-d6/a0-a5

			rts


;======================================================================================================================
;  cryAengine: draw changing/blinking text intro
;======================================================================================================================


			even
text_title_counter: dc.l 0
text_title_address: dc.l 0

text_title_size equ 31

			even
text_title_screen:
			; length clear
			; overwritting!
			dc.b "                              ",0
			dc.b "    THE HOLY CUBE 2023 C64    ",0
			dc.b "                              ",0
			dc.b "   NOW THE HOLY CUBE DELUXE   ",0
			dc.b "                              ",0
			dc.b "        THE GAME IS A         ",0
			dc.b "  ONE BUTTON JUMP AND RUN     ",0
			dc.b "           PUZZLER            ",0
			dc.b "                              ",0
			dc.b " 28 LEVELS 16 COLOR GRAPHICS  ",0
			dc.b "   NOT AS HARDCORE AS THE     ",0
			dc.b "        C64 VERSION           ",0
			dc.b "                              ",0
			dc.b "  THE GAMEMECHANIC IS SIMPLE  ",0
			dc.b "    COLLECT ALL THE VISUAL    ",0
			dc.b "      CANDY ON SCREEN         ",0
			dc.b "    WHILE MOVING FORWARD      ",0
			dc.b "   AND BOUNCED BY THE WALLS   ",0
			dc.b "   ONLY INTERACTION: JUMP!    ",0
			dc.b "                              ",0
			dc.b "  BASED ON THE GAME NSTOWER   ",0
			dc.b "  1997 BUT NOW WITH LEVELS    ",0
			dc.b "                              ",0
			dc.b "    IDEA AND CODE BY LA1N     ",0
			dc.b "                              ",0
			dc.b "          MUSIC BY            ",0
			dc.b "       COMPUTERMUSIKER        ",0
			dc.b "                              ",0
			dc.b "  ATARI ST AND AMIGA VERSION  ",0
			dc.b "           2025               ",0
			dc.b "                              ",0
			dc.b "   THE 68000 IS A COOL CPU    ",0
			dc.b "                              ",0
			dc.b "    THE PORT TO AMIGA WAS     ",0
			dc.b "     NOT SO COMPLICATED       ",0
			dc.b "    YOU COULD TAKE ALL THE    ",0
			dc.b "        LEVELDATA 1 TO 1      ",0
			dc.b "     AND USE SPRITES TOO      ",0
			dc.b "    THE SPRITES ARE GARBAGE   ",0
			dc.b "         ON THE AMIGA.        ",0
			dc.b "  ONLY 4 COLORS GODSASKE 1985 ",0
			dc.b "    IF YOU USE THE BLITTER    ",0
			dc.b " YOU HAVE MANAGEMENT VMEMORY  ",0
			dc.b "   HELL FOR DOUBLEBUFFERING   ",0
			dc.b " THEREFORE HERE ONLY SPRITES  ",0
			dc.b "                              ",0
			dc.b "     UPDATED THE CRYAENGINE   ",0
			dc.b "         AFTERWARDS           ",0
			dc.b "     WITH BLITTER-ADDON       ",0
			dc.b "      TRIPPLE BUFFERING       ",0
			dc.b "      FOR THE NEXT GAME       ",0
			dc.b "        PLANET COWARD         ",0
			dc.b "                              ",0
			dc.b "  BUT OF COURSE THE SOUND IS  ",0
			dc.b "   FANTASTIC - EVEN TODAY     ",0
			dc.b "                              ",0
			dc.b "                              ",0
			dc.b "      THE LAST YEARS ARE      ",0
			dc.b "        REALLY SHITTY         ",0
			dc.b "       PUTIN IN UKRAINE       ",0
			dc.b "    STUPID D. TRUMP IN US     ",0
			dc.b "  PLEASE VOTE FOR DEMOCRACY   ",0
			dc.b "   FACISM IS NOT AN OPTION!   ",0
			dc.b "       IT IS THE END!         ",0
			dc.b "                              ",0
			dc.b "                              ",0
			dc.b "      PRESS MOUSE BUTTON      ",0
			dc.b "         TO CONTINUE          ",0
			dc.b "                              ",0
			dc.b 42

;======================================================================================================================
;  cryAengine: smallblocks (8x8)
;======================================================================================================================
			even

smallblockx: 	; * 16
	dc.w	5
smallblocky: 	; * 16
	dc.w    3
smallblockno:
	dc.w	1	

smallblockno_big: dc.w 1
smallblockno_rest: dc.w 1

smallblockscreentarget: dc.w 0 ; 0 ingame screen 1: titlescreen

titlescreenrenderer: dc.w 0

	even

; drawsmallblockxY
drawSmallBlockXY:
	; 2**16

	lea.l  blocks,a0
	; add.l  #(2*16)*12,a0 ; (2*16)*4 = 1line (2byte) * 16 *4  planes

	clr.l d0
	move.w smallblockno,d0
	divu.w #4,d0 
	; 4
	move.w d0,smallblockno_big
	swap d0
	; 4 rest xyz
	move.w d0,smallblockno_rest

	clr.l d0
	move.w smallblockno_big,d0
	cmp.w #0,d0
	beq   s_ncd
	sub.w #1,d0
s_cd: 
	add.l  #(2*16)*4,a0
	dbra d0,s_cd
s_ncd:

	; now add rest
	; 0-3
	; 8 8 8 8 
	; 16 16 16 
	; 320 = 40 * 8bits
	; 20*16
	; 40*8
	; jmp end_cell
	; add rest * 8		
	clr.l d0
	move.w smallblockno_rest,d0
;	mulu.w #8,d0
;	add.l  d0,a0
	; add for 0,1,2,3
	cmp.w #0,d0
	bne cell0
	jmp end_cell
cell0:	
	cmp.w #1,d0
	bne cell1
	add.l #1,a0
	jmp end_cell
cell1:	
	cmp.w #2,d0
	bne cell2
	add.l #8*2,a0
	jmp end_cell
cell2:	
	cmp.w #3,d0
	bne cell3
	add.l #8*2+1,a0
	jmp end_cell
cell3:	


end_cell:
	

	; destination
	; draw to screen
	lea.l  GameScreenBitplanes,a1

	; smallblcokscreentarget
	cmp.w #1,smallblockscreentarget
	bne.w ntt
	lea.l  TitleScreenBitmap,a1
ntt:

	; + y*8*40
	clr.l d0
	move.w smallblocky,d0
	cmp.w #0,d0
	beq   s_yncd
	sub.w #1,d0
s_ycd: 
	add.l  #40*8,a1
	dbra d0,s_ycd
s_yncd:

	; x
	clr.l d0
	move.w smallblockx,d0
	add.l  d0,a1


	; -----------------------
	; now copy it all 
	; -----------------------
	; simpler
	move.l  a1,a2 ; backup

	; original "copier"!	
	cmp.w #0,titlescreenrenderer
	bne shiftcopier

	; plane 0 
	move.l #8-1,d0
s_for_plane0:
	move.b (a0)+,(a1)+
	;move.b #$ff,(a1)+
	add.l #40-1,a1
	add.l #1,a0
	dbra d0,s_for_plane0

;	add.l #1,a0

;
; p0
;  1 2  8+8  
;  3 4  8+8
; + 2*16
;
; p1
;  1 2  8+8  
;  3 4  8+8

; plane 1
	add.l #1*16,a0
	move.l  a2,a1 ; backup
	add.l #40*256,a1
	move.l #8-1,d0
s_for_plane1:
	move.b (a0)+,(a1)+
	;move.b #$ff,(a1)+
	add.l #40-1,a1
	add.l #1,a0
	dbra d0,s_for_plane1	


; plane 2
	add.l #1*16,a0
	move.l  a2,a1 ; backup
	add.l #40*256*2,a1
	move.l #8-1,d0
s_for_plane2:
	move.b (a0)+,(a1)+
	;move.b #$ff,(a1)+
	add.l #40-1,a1
	add.l #1,a0
	dbra d0,s_for_plane2	

; plane 3
	add.l #1*16,a0
	move.l  a2,a1 ; backup
	add.l #40*256*3,a1
	move.l #8-1,d0
s_for_plane3:
	move.b (a0)+,(a1)+
	;move.b #$ff,(a1)+
	add.l #40-1,a1
	add.l #1,a0
	dbra d0,s_for_plane3	

	jmp shiftcopyend

	; copy shift first bitplane to 2
	; (problem other palette in title than in menu/ingame)

shiftcopier:

	; planeTar 0 
	move.l #8-1,d0
	add.l #3*40*256,a1
s_for_planeTar0:
	move.b (a0)+,(a1)+
;	move.b #255,(a1)+
	;move.b #$ff,(a1)+
	add.l #40-1,a1
	add.l #1,a0
	dbra d0,s_for_planeTar0


shiftcopyend: 




	rts

; ----------------------
; draw changing text
; ----------------------


;======================================================================================================================
;  cryAengine: sprites mode 
;======================================================================================================================

setupSpritesMouseMode:

		lea		sprite0,a2		; Source Address
		lea		Spr0_Data,a1		; DESTINATION Address
		bsr.w   copyVisualSpriteData

		; colors
		lea	sprite0,a3		; Source Address		
		add.l #64,a3 
;		add.l #spritevisualdata_object_bytes,a3
		lea.l spritecolor_01_0,a1 		
		move.w (a3)+,(a1)
		add.l #4,a1
		move.w (a3)+,(a1)
		add.l #4,a1
		move.w (a3)+,(a1)
		add.l #4,a1
		move.w (a3)+,(a1)


		lea		sprite0,a2		; Source Address		
		add.l   #spritevisualdata_object_bytes,a2
		lea		Spr1_Data,a1		; DESTINATION Address
		bsr.w   copyVisualSpriteData

		lea		sprite0,a2		; Source Address
		add.l  #spritevisualdata_object_bytes,a2
		lea		Spr2_Data,a1		; DESTINATION Address
		bsr.w   copyVisualSpriteData

		lea		sprite0,a2		; Source Address
		add.l #spritevisualdata_object_bytes,a2
		lea		Spr3_Data,a1		; DESTINATION Address
		bsr.w   copyVisualSpriteData

		lea		sprite0,a2		; Source Address
		add.l #spritevisualdata_object_bytes,a2
		lea		Spr4_Data,a1		; DESTINATION Address
		bsr.w   copyVisualSpriteData

		lea		sprite0,a2		; Source Address
		add.l   #spritevisualdata_object_bytes,a2
		lea		Spr5_Data,a1		; DESTINATION Address
		bsr.w   copyVisualSpriteData

		lea		sprite0,a2		; Source Address
		add.l   #spritevisualdata_object_bytes,a2
		lea		Spr6_Data,a1		; DESTINATION Address
		bsr.w   copyVisualSpriteData

		lea		sprite0,a2		; Source Address
		add.l   #spritevisualdata_object_bytes,a2
		lea		Spr7_Data,a1		; DESTINATION Address
		bsr.w   copyVisualSpriteData



		rts

;======================================================================================================================
;  cryAengine: visual data 
;======================================================================================================================

		lea		sprite0,a2		; Source Address
		lea		Spr0_Data,a1		; DESTINATION Address
		; bsr.w   copyVisualSpriteData

	; image data
	; sprx_data

	copyVisualSpriteData:
		moveq.l	#16,d2					; Sprite Image Data Lenght in Long Words
	XCopyImgSprDatax:
		move.l	(a2)+,(a1)+					; Copy from Source to destination in Long Words
		dbra	d2,XCopyImgSprDatax			; Loop Till we Copy
	rts



;======================================================================================================================
;  cryAengine: game objects
;======================================================================================================================

; disable gameobjects
; - sprite - inactive and will be on -16,-16 (offscreen)

; gets the pointer / address of the object
getGameObject:

		rts

; no more collision, animation, behavior
disableGameObject:

		rts

 		; object state?
;		move.w gameobject_state(a6),d0
;		cmp.w #objectstate_inactive,d0
;		beq.w end_behavior

enableGameObject:

		rts 

;======================================================================================================================
;  cryAengine: WAVE-EFFECT
;======================================================================================================================
	even


WaterEffect:

		; version 1.0 
 	   ; plane 0
  	   lea.l effect_wave,a2
;	   move.l a2,effect_wave_pointer	   
	   lea.l GameScreenBitplanes,a0 ; start screen
	   lea.l GameScreenBitplanes,a1 ; start screen
	   add.l #40*(256-41),a0	   
	   add.l #40*(256-40),a1
	   move.l #38,d1
	   move.l #19,d1
cpy:	
		move.l (a2),d0
		mulu #40,d0
		sub.l d0,a0
	   move.l #19,d2
cpxor: 
		move.w (a0)+,(a1)+
		dbra d2,cpxor
	    sub.l #120,a0
	    add.l #40,a1
		dbra d1,cpy
		; /plane 0

	   ; plane 1
  	   lea.l effect_wave,a2
;	   move.l a2,effect_wave_pointer	   
	   lea.l GameScreenBitplanes,a0 ; start screen
	   lea.l GameScreenBitplanes,a1 ; start screen
	   add.l #40*(256-41),a0	   
	   add.l #40*(256-40),a1
	   add.l #40*256,a0
	   add.l #40*256,a1
	   move.l #38,d1
	   move.l #19,d1
cpy1:	
		move.l (a2),d0
		mulu #40,d0
		sub.l d0,a0
	   move.l #19,d2
cpxor1: 
		move.w (a0)+,(a1)+
		dbra d2,cpxor1
	    sub.l #120,a0
	    add.l #40,a1
		dbra d1,cpy1
		; /plane 1

		; plane 2
  	   lea.l effect_wave,a2
;	   move.l a2,effect_wave_pointer	   
	   lea.l GameScreenBitplanes,a0 ; start screen
	   lea.l GameScreenBitplanes,a1 ; start screen
	   add.l #40*(256-41),a0	   
	   add.l #40*(256-40),a1
	   add.l #80*256,a0
	   add.l #80*256,a1
	   move.l #38,d1
	   move.l #19,d1
cpy2:	
		move.l (a2),d0
		mulu #40,d0
		sub.l d0,a0
	   move.l #19,d2
cpxor2: 
		move.w (a0)+,(a1)+
		dbra d2,cpxor2
	    sub.l #120,a0
	    add.l #40,a1
		dbra d1,cpy2
		; /plane 2
		
	   ; -----------------------
	   ; move waves now
	   ; -----------------------
	   jmp nomore_x
	   add.l #1,effect_water_counter_uber
	   cmp.l #3,effect_water_counter_uber
	   bne effect_water_nolo_ost_tox
	   move.l #0,effect_water_counter_uber	

	   add.l #1,effect_water_counter
	   cmp.l #3,effect_water_counter
	   bne effect_water_nolo_ost
	   move.l #0,effect_water_counter	   
effect_water_nolo_ost:
effect_water_nolo_ost_tox:
nomore_x:


	   lea.l effect_wave,a2
  	   move.l #20,d4
	   move.l #0,d3
wavecontrol:
		move.l  #2,(a2)+
		dbra d4,wavecontrol
effect_water_nolo:

		rts

effect_water_counter: dc.l 0

effect_water_counter_uber: dc.l 0

effect_wave_pointer: dc.l 1

effect_wave: 
	dc.l 1
	dc.l 1
	dc.l 2
	dc.l 3
	dc.l 2
	dc.l 2
	dc.l 1
	dc.l 3
	dc.l 1
	dc.l 2
	dc.l 3
	dc.l 4
	dc.l 5
	dc.l 3
	dc.l 3
	dc.l 2
	dc.l 1
	dc.l 1
	dc.l 2
	dc.l 1
	dc.l 1
	dc.l 1
	dc.l 2
	dc.l 3
	dc.l 2
	dc.l 2
	dc.l 1
	dc.l 3
	dc.l 1
	dc.l 2
	dc.l 3
	dc.l 4
	dc.l 5
	dc.l 3
	dc.l 3
	dc.l 2
	dc.l 1
	dc.l 1
	dc.l 2
	dc.l 1
	dc.l 1
	dc.l 1
	dc.l 2
	dc.l 3
	dc.l 2
	dc.l 2
	dc.l 1
	dc.l 3
	dc.l 1
	dc.l 2
	dc.l 3
	dc.l 4
	dc.l 5
	dc.l 3
	dc.l 3
	dc.l 2
	dc.l 1
	dc.l 1
	dc.l 2
	dc.l 1
	dc.l 1
	dc.l 1
	dc.l 2
	dc.l 3
	dc.l 2
	dc.l 2
	dc.l 1
	dc.l 3
	dc.l 1
	dc.l 2
	dc.l 3
	dc.l 4
	dc.l 5
	dc.l 3
	dc.l 3
	dc.l 2
	dc.l 1
	dc.l 1
	dc.l 2
	dc.l 1
; -----------------------------
; COLORS
; -----------------------------
		even
colors: 
	include	"colors.s"

		even


; -----------------------------
; LEVELS
; -----------------------------
; levels from blockeditor
		even

			 ; buffer
             dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
             dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
             dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
             dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
             dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
             dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

		even
actualLevel:

	; demo level 
             dc.b 0,1,2,3,4,5,1,1,4,0,0,0,0,0,0,0,0,0,0,0
             dc.b 0,0,2,4,1,4,1,3,4,1,3,3,3,3,0,5,0,0,0,0
             dc.b 3,5,2,4,1,4,1,3,4,1,1,1,1,3,3,5,0,0,0,0
             dc.b 3,5,2,4,4,4,1,3,4,1,3,3,3,3,0,5,0,0,0,0
             dc.b 4,3,2,3,4,4,1,3,4,1,3,0,0,0,0,5,0,0,0,0
             dc.b 4,3,5,3,3,3,1,3,4,0,3,0,0,0,0,0,0,0,0,0
             dc.b 4,3,1,3,1,1,1,3,4,0,0,0,4,4,4,0,0,0,0,0
             dc.b 3,3,3,3,3,4,4,4,4,0,0,0,0,0,4,4,0,0,0,0
             dc.b 0,3,0,0,0,0,0,3,0,4,4,0,0,0,0,4,0,0,0,0
             dc.b 0,3,0,4,0,0,0,3,0,0,4,0,0,0,0,4,0,0,0,0
             dc.b 0,3,0,4,0,0,4,0,0,0,0,0,0,4,4,0,0,0,0,0
             dc.b 0,0,0,4,0,4,4,0,0,0,0,0,4,4,0,0,0,0,0,0
             dc.b 0,0,0,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0
             dc.b 1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
             dc.b 1,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0
             dc.b 1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

			 ; buffer
             dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
             dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
             dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
             dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
             dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
             dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


	even
levels:
	include	"level0.s"
	include	"level1.s"
	include	"level2.s"
	include	"level3.s"
	include	"level4.s"
	include	"level5.s"
	include	"level6.s"
	include	"level7.s"
	include	"level8.s"
	include	"level9.s"
	include	"level10.s"
	include	"level11.s"
	include	"level12.s"
	include	"level13.s"
	include	"level14.s"
	include	"level15.s"
	include	"level16.s"
	include	"level17.s"
;	include	"level18.s"
	include	"level19.s"
	include	"level20.s"
	include	"level21.s"
	include	"level22.s"
	include	"level23.s"
	include	"level24.s"
	include	"level25.s"
	include	"level26.s"
	include	"level27.s"
	include	"level28.s"
	include	"level29.s"
	include	"level30.s"
	include	"level31.s"
	include	"level32.s"
	include	"level33.s"
	include	"level34.s"
	include	"level35.s"
	include	"level36.s"
	include	"level37.s"
	include	"level38.s"
	include	"level39.s"


; -----------------------------
; BLOCKS
; -----------------------------
; blocks from blockeditor

		include	"blocksall.s"

; -----------------------------
; MOUSE HANDLING
; -----------------------------

WaitForMouseUp
xxxxt:
		jsr WaitForRaster
		jsr 	mt_music

;		jsr _keyboard
;		clr.l d1
;		move.w keyPressed,d1
;		cmp.w #32,d1
;		beq goonx
		

		; -------------------
		; joystick
		; -------------------
		jsr ReadJoystickDirect
		cmp.w #1,joystick_PressedDirect
		bne if_gamefire_nowsup1xbut1t
			; move.w    $DFF006,$DFF180 ; background
			jmp goonx
if_gamefire_nowsup1xbut1t:	

		; -------------------
		; mouse button
		; -------------------
  	    BTST   #6,$BFE001      ; Test left mouse button
   		BEQ.S   xxxxt
   
goonx: 
		jsr colorsToBlack
		; wait a second?
		move.l #10,d6
waitloopsx:
		jsr WaitForRaster
		jsr 	mt_music		
		dbra d6,waitloopsx

		jsr colorsToGameColors

		rts

		even 

; -----------------------------
 ; KEYBOARD
 ; -----------------------------

		even
keyPressed:
	dc.w 1

_keyboard:
	movem.l d0-d2,-(sp)

	;Vérifier dans ICR que la requête est bien générée par le CIA A aur l'événement SP (bascule des 8 bits reçus du clavier dans SDR)

	btst #3,$BFED01
	beq _keyboardNotKeyboard

	;Lire les 8 bits dans SDR et détecter s'il s'agit de la pression ou du relâchement d'une touche

	move.b $BFEC01,d0
	btst #0,d0
	bne _keyboardKeyDown
	move.w #$00F0,d1		;Touche relâchée : couleur vert
	bra _keyboardKeyUp
_keyboardKeyDown:
	move.w #$0F00,d1		;Touche pressée : couleur rouge
_keyboardKeyUp:

	;Changer la couleur de fond si la touche pressée est celle attendue (ESC)

	not.b d0
	lsr.b #1,d0

	; key pressed
	clr.l d2
	move.b d0,d2
	move.w d2,keyPressed

	cmpi.b #$45,d0
	bne _keyboardNotESC
	; move.w d1,COLOR00(a5)
	; move.w    $DFF006,$DFF180 ; background
_keyboardNotESC:

	;Acquitter auprès du clavier en maintenant à 0 le signal sur sa ligne KDAT durant 85 us, ce qui s'effectue en positionnant SPMODE à 1 dans CRA ("software must pulse the line low for 85 microseconds to ensure compatibility with all keyboard models" et "the KDAT line is active low [...] a low level (0V) is interpreted as 1"). Pour rappel, une ligne raster, c'est 227,5 cycles de 280 ns, donc 63,7 us, ce qui signifie qu'il faut attendre que le raster ait parcouru deux lignes. Maintenant, ce n'est pas très élégant d'attendre que le raster se balade en se tournant les pouces...

	bset #6,$BFEE01
	
	move.l $DFF004,d0
	lsr.l #8,d0
	and.w #$01FF,d0
	moveq #2-1,d1
_keyboardWait85us:
	move.l $DFF004,d2
	lsr.l #8,d2
	and.w #$01FF,d2
	cmp.w d0,d2
	beq _keyboardWait85us
	move.w d2,d0
	dbf d1,_keyboardWait85us

	bclr #6,$BFEE01

_keyboardNotKeyboard:
	movem.l (sp)+,d0-d2
	rts
 
; -----------------------------
 ; MOUSE CHECK
 ; -----------------------------
	even

joystick_PressedDirect: dc.w 0
joystick_PressedDirect_old: dc.w 0


; pressed
joystick_Left: 	dc.w 0
joystick_Right: 	dc.w 0
joystick_Down: 	dc.w 0
joystick_Up: 	dc.w 0
joystick_Pressed: dc.w 0


; clicked
joystick_Left_Clicked: 	dc.w 0
joystick_Right_Clicked: 	dc.w 0
joystick_Down_Clicked: 	dc.w 0
joystick_Up_Clicked: 	dc.w 0
joystick_Pressed_Clicked: dc.w 0

; tmp
joystick_Left_old: 	dc.w 0
joystick_Right_old: 	dc.w 0
joystick_Down_old: 	dc.w 0
joystick_Up_old: 	dc.w 0
joystick_Pressed_old: dc.w 0

joystick_Up_olddirect: 	dc.w 0

ReadJoystickDirect:

		move.w #0,joystick_Left_Clicked
		move.w #0,joystick_Right_Clicked
		move.w #0,joystick_Up_Clicked
		move.w #0,joystick_Down_Clicked
		move.w #0,joystick_Pressed_Clicked

		move.w #0,joystick_Left
		move.w #0,joystick_Right
		move.w #0,joystick_Up
		move.w #0,joystick_Down
		move.w #0,joystick_Pressed

		move.w #0,joystick_PressedDirect

	
		; joy1&joy2 buttons in one byte !

	    ;BTST   #6,$BFE001      ; Test left mouse button
   		;BEQ.S   yyyy
		
		; https://www.reaktor.com/articles/crash-course-to-amiga-assembly-programming
		; btst.b #7,CIAAPRA
		; beq exit  CIAAPRA

		btst    #7,$BFE001              ; Fire button pressed?
        bne.s   shot_done
			; move.w    $DFF006,$DFF180 ; background
			move.w #1,joystick_PressedDirect
shot_done:

		; joydata
		move.w	$dff00c,d3	; Read Joy1dat

		; left/right
		btst.l	#1,d3		; If bit 1 is 1 we move to the Right
		beq.s	j_right		; else check for left
		move.w #1,joystick_Right
		
j_right:
		btst.l	#9,d3		; If bit 9 is 1 then we so to the left
		beq.s	j_left		; If the bit is 0 then we don't go to the left
		move.w #1,joystick_Left
j_left:

		move.w	d3,d2		; Make a copy of D3 in D2
		lsr.w	#1,d2		; Shift word to the right by 1
		eor.w	d2,d3		; Xor the number
		btst.l	#8,d3		; Is bit 8 set
		beq.s	j_up			; If not check for going down
		move.w #1,joystick_Up
j_up:
		btst.l	#0,d3		; Test if we go Down
		beq.s	j_down		; End Joy routine if not
		move.w #1,joystick_Down

j_down:

		

		; check now ...

		cmp.w #0,joystick_Left_old
		bne   cl_left
		cmp.w #1,joystick_Left
		bne   cl_left
		move.w #1,joystick_Left_Clicked
cl_left:		

		cmp.w #0,joystick_Right_old
		bne   cl_right
		cmp.w #1,joystick_Right
		bne   cl_right
		move.w #1,joystick_Right_Clicked
cl_right:		


		cmp.w #0,joystick_Up_old
		bne   cl_up
		cmp.w #1,joystick_Up
		bne   cl_up
		move.w #1,joystick_Up_Clicked
cl_up:

		cmp.w #0,joystick_Down_old
		bne   cl_down
		cmp.w #1,joystick_Down
		bne   cl_down
		move.w #1,joystick_Down_Clicked
cl_down:


		; back in history
		move.w joystick_Left,joystick_Left_old
		move.w joystick_Right,joystick_Right_old
		move.w joystick_Up,joystick_Up_old
		move.w joystick_Down,joystick_Down_old
		move.w joystick_Pressed,joystick_Pressed_old

		rts



; -----------------------------
 ; MOUSE CHECK
 ; -----------------------------
 ; https://www.ikod.se/reading-the-mouse/

XScreenWidth             equ     320
XScreenHeight            equ     256
 
        IFND MouseLimit
                ; 0 = Mouse Limit InActive
                ; 1 = Mouse Limit Active (Default)
MouseLimit                      equ     1
        ENDC
 

ReadMouse:
 
                ; **** SOF Read Mouse Routine ****
         
                movem.l d0-d2/a0-a1,-(sp)
                lea.l   OldDeltaY,a0
                lea.l   $dff00a,a1
 
                moveq   #0,d0
                move.b  (a1),d0         ; Get New Y Mouse
                move.w  (a0),d1         ; Get Old Y Mouse
                move.w  d0,(a0)         ; Save New Y Mouse
                sub.w   d1,d0           ; Delta Y
 
                moveq   #0,d1
                move.b  1(a1),d1        ; Get New X Mouse
                move.w  2(a0),d2        ; Get Old X Mouse
                move.w  d1,2(a0)        ; Save New X Mouse
                sub.w   d2,d1           ; Delta X
                 
                ; **** Check Y Delta ****
 
                cmp.w   #-127,d0
                bge     noUnderFlowY
                move.w  #-255,d2
                sub.w   d0,d2           ; Delta Y = -255 - Delta Y
                bpl     noYPos
                moveq   #0,d2
 
noYPos:        move.w  d2,d0
                bra     rmSkipY
 
noUnderFlowY:  cmp.w   #127,d0
                ble     rmSkipY
                move.w  #255,d2
                sub.w   d0,d2           ; Delta X = 255 - Delta Y
                bmi     noYNeg
                moveq   #0,d2
noYNeg:        move.w  d2,d0
 
rmSkipY:
 
                ; **** Check X Delta ****
 
                cmp.w   #-127,d1
                bge     NoUnderFlowX
                move.w  #-255,d2
                sub.w   d1,d2           ; Delta X = -255 - Delta X
                bpl     noXPos
                moveq   #0,d2
 
noXPos:        move.w  d2,d1
                bra     rmSkipX
 
NoUnderFlowX:  cmp.w   #127,d1
                ble     rmSkipX
                move.w  #255,d2
                sub.w   d1,d2           ; Delta X = 255 - Delta X
                bmi     noXNeg
                moveq   #0,d2
noXNeg:        move.w  d2,d1
 
rmSkipX:
 
                lea.l   MouseY,a0
 
                move.w  (a0),d2         ; D2.W = Old Y Mouse 
                add.w   d0,d2           ; Y Mouse = Y Mouse + Y Delta
 
        IF MouseLimit
                bpl     yPositive
 
                moveq   #0,d2
yPositive:     cmp.w   #XScreenHeight-1,d2      ; Y Mouse > Screen Height?
                ble     yBelow
                move.w  #XScreenHeight-1,d2
yBelow:       
        ENDC
                move.w  d2,(a0)+        ; Save Y Mouse
 
                move.w  (a0),d2         ; D2.W = Old X Mouse
                add.w   d1,d2           ; X Mouse = X Mouse + X Delta
        IF MouseLimit
                bpl     xPositive
 
                moveq   #0,d2
xPositive:     cmp.w   #XScreenWidth-1,d2       ; X Mouse > Screen Width?
                ble     xBelow
                move.w  #XScreenWidth-1,d2
xBelow:       
        ENDC
                move.w  d2,(a0)+
 
                movem.l (sp)+,d0-d2/a0-a1
                rts
 
                ; **** EOF Read Mouse Routine ****
				EVEN
OldDeltaY:      dc.w    0
OldDeltaX:      dc.w    0
MouseY:         dc.w    0
MouseX:         dc.w    0


;======================================================================================================================
;  Chip Data Section
;======================================================================================================================

		include	"Source/C_SpriteStructs.s"
		include	"Source/C_Copper.s"
		include	"Source/C_Data.s"









