;======================================================================================================================
; Init Bitplanes
;======================================================================================================================

InitBitPlanes:
		move.l	#GameScreenBitplanes,d0		; Source Image Address that is the address of Bitplane 1
		lea		GameBitplanePointers,a1		; Bitplane Pointers in the Copper

		moveq	#4-1,d1						; Number of Bitplanes
	.NextBP:
		move.w	d0,4(a1)					; Take low word of Source Address and Store in the Bitplane Low Address Word
		swap	d0							; Swap the value (LW = HW and HW = LW)
		move.w	d0,0(a1)					; Take high word of Source Address and Store in the Bitplane High Address Word
		swap	d0							; Swap again to return as it was
		add.l	#40*256,d0					; Add the bitplane size to the source start Image Address
		addq.w	#8,a1						; Point A1 to next Bitplane Address
		dbra	d1,.NextBP					; Loop Till we do all Bitplanes

		rts