;======================================================================================================================
; Reads Joysticks
; It updates the values in variables sprite_x & sprite_y
; Joystick Port 0 (mouse port) - $DFF00A (JOY0DAT)
; Joystick Port 1 (Joystick) - $DFF00C (JOY1DAT)
;
; Reading The Joystick Port
; Bit 1 Set - Move Right
; Bit 9 Set - Move Left
; Bit 8 EOR Bit 9 Result 1 - Move Up
; Bit 0 EOR Bit 1 Result 1 - Move Down
;======================================================================================================================

ReadJoystick:
		move.w	$dff00c,d3	; Read Joy1dat
		btst.l	#1,d3		; If bit 1 is 1 we move to the Right
		beq.s	.Left		; else check for left
		addq.w	#1,Sprite_x	; Right - add 1 to the sprite x
		bra.s	.Check_y	; Check the Y now
	.Left:
		btst.l	#9,d3		; If bit 9 is 1 then we so to the left
		beq.s	.Check_y		; If the bit is 0 then we don't go to the left
		subq.w	#1,Sprite_x	; Left - sub 1 to sprite x
	.Check_y:
		move.w	d3,d2		; Make a copy of D3 in D2
		lsr.w	#1,d2		; Shift word to the right by 1
		eor.w	d2,d3		; Xor the number
		btst.l	#8,d3		; Is bit 8 set
		beq.s	.Up			; If not check for going down
		subq.w	#1,Sprite_y	; Up - Sub 1 to the Sprite Y
		bra.s	.EndJoy
	.Up:
		btst.l	#0,d3		; Test if we go Down
		beq.s	.EndJoy		; End Joy routine if not
		addq.w	#1,Sprite_y	; Down - Add 1 to the Sprite Y
	.EndJoy:
		rts

Sprite_y:
	dc.w	0	; Y movement
Sprite_x:
	dc.w	0	; X movement