;======================================================================================================================
; Requires PUBLIC Code
;======================================================================================================================

		SECTION	GameCode,CODE_P

;======================================================================================================================
; Populate Enemy Table Screen Structure And The Sprite Address Pointers
;
; Although it is one routine it is divided in sub tasks
; Each sub task could be a sub routine but no really needed
;======================================================================================================================

PopulateEnemyTable:
		;--------------------------------------------------------------------------------------------------------------
		; Loop through Enemy Table Structure
		;
		move.l	#0,d3						; Counter to the Structure Array Size
		lea		EnemyTableScreen(pc),a0		; Address of Structure Table 

	.NextStruct: 
		move.b	(a0),d0						; Is Enemy.Active?
		cmp.b	#$0,d0						; This compare is there to check for other states but as is can be removed
		bne.s	.NotEmptyStruct				; We have an Empty Position in the table		

		;--------------------------------------------------------------------------------------------------------------
		; Get A random Number
		; This will be the Enemy to Fill the structure
		; D0 - Which sprite Image Data to copy to the sprite Structure
		; We have 8 different Enemy Images but we can increate this to say 16 (AND.L #$0000000F)
		;
		bsr.w	RndB						; Get a Random Number in D0
		and.l	#$00000007,d0				; We are only interested in the first 8 (0 - 7)
											; It also clears other High Bits of D0

		;--------------------------------------------------------------------------------------------------------------
		; Get the Address of the Enemy Sprite Structure we want to display
		; Store the Address pointer in D1
		; D3 - Position in the Enemy Table Screen Structure
		;
		move.l	d3,d1						; D1 now hold which enemy we want to display
		lea		EnemySprTable(pc),a1		; Enemy Table holds a list of address for our enemies
		lsl.l	#2,d1						; D1 Holds the Offset of the sprite enemy address in table
		move.l	(a1,d1),d1					; D1 now holds the Enemy Sprite Structure address (Address stored @ SprX)

		;--------------------------------------------------------------------------------------------------------------
		; Set the Sprite Address Pointer in the Copper list with the Enemy SprX Data Structure
		; D1 - Hold the address of the Amiga Sprite Structure 
		; D3 - Position in the Enemy Table Screen Structure
		;
		lea		EnemySpritePtr,a1			; Enemy Sprite Data pointers in Copper List (Can't use (PC) cos it is cross section)
		move.l	d3,d2						; Make a copy of D3 and now D2 Holds the Sprite that needs sprite pointer updated in copper list
		lsl.l	#3,d2						; D2 multiplied by 8 holds the offset in the Copper list of Enemy Sprite Pointers
		move.w	d1,4(a1,d2)					; Store the low word of D1 in the Sprite Address Pointer
		swap	d1							; Swap Low Word with High word
		move.w	d1,0(a1,d2)					; Store the High Word of D1 in the Sprite Address Pointer
		swap	d1							; Get the value of D1 back to what is was

		;--------------------------------------------------------------------------------------------------------------
		; Copy the sprite Image data to the Sprite Structures of our enemies
		; D0 - Which sprite Image Data Number to copy Sprite data to the sprite Structure
		; D1 - Hold the address of the Amiga Sprite Structure 
		;
	;	lea		EnemyImgSprTable(pc),a2		; Source Address
		move.l	d0,d2						; Make a Copy of D0 in D2 which is used to calculate where the Sprite Data starts
		lsl.l	#2,d2						; Multiply by 4 (every address is 4 bytes) to get address offset from table in A2
		move.l	(a2,d2),a3					; A3 has address of Source Sprite Image Data

		move.l	d1,a1						; Destination where to copy the data to
		addq.l	#4,a1						; Skip the Sprites 4 special bytes

		moveq.l	#16-1,d2					; Sprite Image Data Lenght in Long Words
	.CopyImgSprData:
		move.l	(a3)+,(a1)+					; Copy from Source to destination in Long Words
		dbra	d2,.CopyImgSprData			; Loop Till we Copy

		;--------------------------------------------------------------------------------------------------------------
		;Populate the Enemies Table Structure
		;
		move.b	#$ff,(a0)					; $ff = Sprite is Active
		move.b	d0,1(a0)					; Set EnemyNumber
		move.w	#$FF+16+1,2(a0)				; Set Sprite Y position
		bsr.w	SetSpriteXPos				; D0 will hold the X Position for the sprite
		move.b	d0,4(a0)					; Set Sprite x position

		bra.s	.Exit

	.NotEmptyStruct:
		addq.l	#6,a0						; Next Struct - Each struct is 6 bytes
		addq.l	#1,d3						; Next Structure that hold info of Sprites on Screen
		cmp.l	#MaxEnemiesOnScreen,d3		; The structure can only be N long and in this case max number of sprites on screen
		bne.s	.NextStruct
	.Exit:
		rts

;======================================================================================================================
; Update Enemies On screen
;
;	dc.b	Enemy1.Active		; $0 - In Active, $FF - Active
;	dc.b	Enemy1.EnemyNo		; Which Enemry we are showing - Number based on table EnemyTable
;	dc.w	Enemy1.Y			; Y can be from 0 to 272
;	dc.b	Enemy1.X			; X can be only 96, 112, 128
;======================================================================================================================

UpdateEnemiesScr:
		move.l	#0,d4
		lea		EnemyTableScreen(pc),a0

	.NextEnemyUpdate:
		move.b	(a0),d0						; If Sprite Active > 0 ?
		beq.s	.NoUpdate					; We always exit when there is a 0 hence why the 0 at the end of the structure

		; These registers need to be cleared before settig them up and calling MoveSprite
		clr.l	d0
		clr.l	d1
		clr.l	d2

		; Y Axis of Sprite - In needs to be decremented by 1
		move.w	2(a0),d0					; D0 = Vertical Poistion of Sprite on the screen (0-255)
		sub.w	FallSpeed,d0				; Decrement according to the falling speed
		beq.s	.DeactivateSprite			; If 0 Deactive Sprite
		cmp.w	#$ffff,d0					; If -1 Deactivate Sprite
		beq.s	.DeactivateSprite			; If yes Deactive sprite
		move.w	d0,2(a0)					; Store D0 but we test to make sure it is not a 0
		bne.s	.Update						; If d0 is a 0 then no need not to move it anymore upwards

	.DeactivateSprite:
		move.l	EnemyPoints(pc),d0
		add.l	d0,Score
		move.b	#$0,(a0)					; Make the Sprite in Active
		move.w	#$ff+16+1,2(a0)				; Reset Y to 255 
		move.w	#$ff+16+1,d0						; Set all D0 to 255 for MoveSprite

	.Update:
		; Get the Enemy Sprite Structure Address
		move.b	d4,d1						; Get the sprite number 
		lea		EnemySprTable(pc),a2
		lsl.b	#2,d1
		move.l	(a2,d1),a1					; A1 = Sprite Address

		; X Axis of Sprite
		move.b	4(a0),d1					; D1 = Horizontal position of the sprite on the screen (0-320)

		move.b	#SpritesHeight,d2			; D2 = Height of sprite

		; A1.l = Sprite Address
		; D0.w = Vertical Poistion of Sprite on the screen (0-255)
		; D1.w = Horizontal position of the sprite on the screen (0-320)
		; D2.w = Height of sprite		
		bsr.w	MoveSprite
	.NoUpdate:
		addq.l	#6,a0
		addq.l	#1,d4
		cmp.l	#MaxEnemiesOnScreen,d4
		bne.s	.NextEnemyUpdate

	.Exit:
		rts

;======================================================================================================================
; Reset Sprites On the Screen
;
;	dc.b	Enemy1.Active		; $0 - In Active, $FF - Active
;	dc.b	Enemy1.EnemyNo		; Which Enemry we are showing - Number based on table EnemyTable
;	dc.w	Enemy1.Y			; Y can be from 0 to 272
;	dc.b	Enemy1.X			; X can be only 96, 112, 128
;======================================================================================================================

ResetEnemies:
		move.l	#0,d4
		lea		EnemyTableScreen(pc),a0

	.NextEnemyUpdate:
		move.b	(a0),d0						; If Sprite Active > 0 ?
		beq.s	.NoUpdate					; We always exit when there is a 0 hence why the 0 at the end of the structure

		; These registers need to be cleared before settig them up and calling MoveSprite
		clr.l	d0
		clr.l	d1
		clr.l	d2

	.DeactivateSprite:
		move.b	#$0,(a0)					; Make the Sprite in Active
		move.w	#$ff+16+1,2(a0)				; Reset Y to 255 
		move.w	#$ff+16+1,d0				; Set all D0 to 255 for MoveSprite

	.Update:
		; Get the Enemy Sprite Structure Address
		move.b	d4,d1						; Get the sprite number 
		lea		EnemySprTable(pc),a2
		lsl.b	#2,d1
		move.l	(a2,d1),a1					; A1 = Sprite Address

		; X Axis of Sprite
		move.b	4(a0),d1					; D1 = Horizontal position of the sprite on the screen (0-320)

		move.b	#SpritesHeight,d2			; D2 = Height of sprite

		; A1.l = Sprite Address
		; D0.w = Vertical Poistion of Sprite on the screen (0-255)
		; D1.w = Horizontal position of the sprite on the screen (0-320)
		; D2.w = Height of sprite		
		bsr.w	MoveSprite

	.NoUpdate:
		addq.l	#6,a0
		addq.l	#1,d4
		cmp.l	#MaxEnemiesOnScreen,d4
		bne.s	.NextEnemyUpdate

	.Exit:
		bsr.w	InitRespawnTimer		; Init Timer to respawn again
		rts



