;======================================================================================================================
; Requires PUBLIC Code
;======================================================================================================================

		SECTION	GameCode,CODE_P

;======================================================================================================================
; Update HUD
;======================================================================================================================

UpdateHUD:
		bsr.w	UpdateScore
		bsr.w	CheckHiScore
		bsr.w	UpdateHiScore
		rts

;======================================================================================================================
; Update Score
;======================================================================================================================

UpdateScore:
		move.l	Score,d0
		bsr.w	ConvertHexToDecimal

		lea		DecimalString(PC),a0		; Source - Address of Digit String
		lea		ScoreDigits,a1				; Destination Address on Hud Where we write the Digits

		move.l	#7,d0						; Number of Digits
	.loop:
		move.b	2(a0,d0),(a1,d0)
		dbra	d0,.loop
		rts

;======================================================================================================================
; Update HiScore
;======================================================================================================================
UpdateHiScore:
		move.l	HiScore,d0
		bsr.w	ConvertHexToDecimal

		lea		DecimalString(PC),a0		; Source - Address of Digit String
		lea		HiScoreDigits,a1			; Destination Address on Hud Where we write the Digits

		move.l	#7,d0						; Number of Digits
	.loop:
		move.b	2(a0,d0),(a1,d0)
		dbra	d0,.loop
		rts

;======================================================================================================================
; Update Bars
;======================================================================================================================

UpdateBars:
		; Energy Bar Meter
		lea		EnergyBar(pc),a0
		move.l	#EnergyBarPos,d0
		bsr.s	DrawBar

		; Depth Bar Meter
		lea		DepthBar(pc),a0
		move.l	#DepthBarPos,d0
		bsr.s	DrawBar
		rts


;======================================================================================================================
; Draw A Bar
;======================================================================================================================

DrawBar:

		; Calculate address on Bitplane
		lea		GameScreenBitplanes,a1	; Get Bitplane Base Address
		mulu	#NextCharRow,d0			; Multiply the line number by the Row byte Size for next line on Screen
		add.l	d0,a1					; Add the result offset to the Bitplane Base Address 
		add.l	#StartRowOffset,a1		; Since we do not print at position 0 on the X Axis but at postion 30 we add this too

		moveq.l	#BarLength-1,d1				; The Bar Length in Characters 

	.NextBarChar:

		; Display char on bitplanes
		move.b	(a0),40*0(a1)					; Print Line 1 of char
		move.b	(a0),40*1(a1)					; Print Line 2 of char
		move.b	(a0),40*2(a1)					; Print Line 3 of char
		move.b	(a0),40*3(a1)					; Print Line 4 of char
		move.b	(a0),40*4(a1)					; Print Line 5 of char
		move.b	(a0),40*5(a1)					; Print Line 6 of char
		move.b	(a0),40*6(a1)					; Print Line 7 of char
		move.b	(a0),40*7(a1)					; Print Line 8 of char

		addq.l	#1,a0
		addq.l	#1,a1

		dbra	d1,.NextBarChar

		rts

;======================================================================================================================
; Decrement The Energy Bar
;======================================================================================================================

DecEnergyBar:
		lea		EnergyBar(pc),a0
		lsl.w	6(a0)
		roxl.w	4(a0)
		roxl.w	2(a0)
		roxl.w	0(a0)
		rts

;======================================================================================================================
; Increment The Depth Bar
;======================================================================================================================

IncDepthBar:
		lea		DepthBar(pc),a0
		asr.w	0(a0)
		roxr.w	2(a0)
		roxr.w	4(a0)
		roxr.w	6(a0)
		rts

;======================================================================================================================
; Increment The Depth Level
;======================================================================================================================

UpdateLevel:
		sub.w	#1,DepthLevelTimer				; Subtract 1 from the current timer
		bne.s	.Exit							; Exit of not 0

		addq.w	#1,Depth						; Increment Level Depth
		move.w	#DepthTimer,DepthLevelTimer		; Reset timer for next level
		bsr.w	IncDepthBar						; Update the DepthBar

		; Add 10 Points to the Current Score
		lea		EnemyPoints(pc),a0
		add.l	#PointsPerEnemy,(a0)

		; Decrement the max timer 
		cmp.b	#MinRespawm,MaxTimerRespawn
		beq.s	.Exit
		sub.b	#5,MaxTimerRespawn				; Subtract 5 from the Respawn Timer

		; Check if it is less than MinReSpawn
		cmp.b	#MinRespawm,MaxTimerRespawn
		bhi.s	.Exit
		move.b	#MinRespawm,MaxTimerRespawn

	.Exit:
		rts

;======================================================================================================================
; Check if HighScore was achieved
;======================================================================================================================

CheckHiScore:
		move.l	HiScore(pc),d0
		move.l	Score(pc),d1
		cmp.l	d1,d0
		bcc.s	.Exit

		move.l	d1,HiScore
	.Exit:
		rts