;======================================================================================================================
; Requires PUBLIC Code
;======================================================================================================================

		SECTION	GameCode,CODE_P

;======================================================================================================================
; Wait For Raster the proper way
; This makes sure that the code is not execute twice between 0 - $38 and $100 - $138
;
; VHPOSR
; 15	14	13	12	11	10	09	08	07	06	05	04	03	02	01	00
; V7	V6	V5	V4	V3	V2	V1	V0	H8	H7	H6	H5	H4	H3	H2	H1
;
; VPOSR
; 15	14	13	12	11	10	09	08	07	06	05	04	03	02	01	00
; LOF	I6	I5	I4	I3	I2	I1	I0	LOL	xx	xx	xx	xx	V10	V9	V8
;======================================================================================================================
; VPOSR + VHPOSR 
; A "Y" Below means we want the value
; 31	30	29	28	27	26	25	24	23	22	21	20	19	18	17	16 15	14	13	12	11	10	09	08	07	06	05	04	03	02	01	00
; LOF	I6	I5	I4	I3	I2	I1	I0	LOL	xx	xx	xx	xx	V10	V9	V8 V7	V6	V5	V4	V3	V2	V1	V0	H8	H7	H6	H5	H4	H3	H2	H1
;                                                           	Y	Y	Y	Y	Y	Y	Y	Y	Y 
;======================================================================================================================

vsync:
VSYNC:
WaitForRaster:
		lea		$dff000,a5
		move.l	#$1ff00,d1		; Set D1 = $0001ff00
		move.l	#$00c00,d2		; Set D2 = $00012c00
	.Waity1:
		move.l	4(a5),d0		; Read both $DFF004 & $DFF006 - VPOSR + VHPOSR
		and.l	d1,d0			; And with $0001ff00
		cmp.l	d2,d0			; $00012c00 = 300 Raster at position 300?
		bne.s	.Waity1			; Loop

	;------------------------------------------------------------------------------------------------------------------
	; Make sure We are still not on the same Raster line
	.Waity2:
		lea		$dff000,a5
		move.l	4(a5),d0		; Read both $DFF004 & $DFF006 - VPOSR + VHPOSR
		and.l	d1,d0			; And with $0001ff00
		cmp.l	d2,d0			; $00012c00 = 300 Raster at position 300?
		beq.s	.Waity2			; Loop

		rts

;======================================================================================================================
; Prints a Character to the screen
;======================================================================================================================

PrintInfo:
		lea	HUDText(pc),a0				; Text Address in a0

	.ReadNextLine:
		moveq	#0,d2					; Clear d2
		move.b	(a0)+,d2				; Next Char d2

		lea		GameScreenBitplanes,a3	; Get Bitplane Base Address
		mulu	#NextCharRow,D2			; Multiply the line number by the Row byte Size for next line on Screen
		add.l	d2,a3					; Add the result offset to the Bitplane Base Address 
		add.l	#StartRowOffset,a3		; Since we do not print at position 0 on the X Axis but at postion 30 we add this too

	.NextChar:
		moveq	#0,d2					; Clear d2
		move.b	(a0)+,d2				; Next Char d2

		cmp.b	#$ff,d2					; End of text? ($FF)
		beq.s	.Text_Exit				; Yes - Exit

		cmp.b	#$fe,d2					; End of Line? ($FE)
		beq.s	.ReadNextLine			; Yes - Exit

		sub.b	#$20,d2					; Subtract 32 from the char ASCII value 
										; so that we can transform for example
										; if it was a space which is $20 to a $00
										; the asterics $21 to $01 etc etc
		lsl.w	#3,d2					; Multiply the same number by 8,
										; since the font is 8 pixels high
		move.l	d2,a2					; move the multiplication result to A2
		add.l	#Font,a2				; Add the value in A2 to the font Base address

		; Display char on bitplanes
		move.b	(a2)+,40*0(a3)					; Print Line 1 of char
		move.b	(a2)+,40*1(a3)					; Print Line 2 of char
		move.b	(a2)+,40*2(a3)					; Print Line 3 of char
		move.b	(a2)+,40*3(a3)					; Print Line 4 of char
		move.b	(a2)+,40*4(a3)					; Print Line 5 of char
		move.b	(a2)+,40*5(a3)					; Print Line 6 of char
		move.b	(a2)+,40*6(a3)					; Print Line 7 of char
		move.b	(a2)+,40*7(a3)					; Print Line 8 of char

		addq.l	#1,a3


		bra.s	.NextChar

	.Text_Exit:
		rts


;======================================================================================================================
; Random Number
; D0 - Byte containing Random Number
; https://eab.abime.net/showthread.php?t=53462
;======================================================================================================================

RndB:
		clr.l	d0
		clr.l	d1
		move.b	$dff007,d0		; Hpos
		move.b	$bfd800,d1		; Event counter - http://amiga-dev.wikidot.com/information:hardware#toc3
		eor.b	d1,d0
		rts

;======================================================================================================================
; Random Number Generator
; Written some 30 years ago by myself
; I have notes about it but don't ask me how it works right now
; It is following some University accademic thing that I used to understand back then :)
; D0 = Random Number between 0 and 255
;======================================================================================================================

RndA:

		movem.l	d1-d7/a0-a6,-(SP)



		clr.l	d0					;behaves as y-register
		clr.l	d1					;behaves as a-register
		clr.l	d2					;behaves as x-register
		clr.l	d3

		lea		rseed(pc),a0
		lea		const(pc),a1
	.rndst:
		moveq	#$08,d0
	.rndl1:
		and.b	#$fe,ccr			; ccr = Conditional Code Status Register
		move.w	$6(a0),d1
		bpl.s	.rndzb
		moveq	#$06,d2
	.rndl2:
		move.w	$0(a0,d2),d1
		move.w	$0(a1,d2),d3
		eor.w	d3,d1
		move.w	d1,$0(a0,d2)
		sub.b	#$02,d2
		bpl.s	.rndl2
		and.b	#$ff,ccr
	.rndzb:
		rol.w	$0(a0)
		rol.w	$2(a0)
		rol.w	$4(a0)
		rol.w	$6(a0)
		sub.b	#$01,d0
		bne.s	.rndl1
		move.b	$6(a0),d0

		movem.l	(SP)+,d1-d7/a0-a6

		rts

;Constants used by the RND routine
const:
		dc.w	$0053
		dc.w	$00b5
		dc.w	$0076

; Seeds Used by the RND routine
rseed:
		dc.w	$0001
		dc.w	$0002
		dc.w	$0003
		dc.w	$0004

;======================================================================================================================
; Convert Hex to Decimal
; Input
; D0 = Hex Number in a long word format
; Output
; Result in Memory location DecNum
; Dec Number is 10 Digits long but we do not always need 10 Digits
;======================================================================================================================

ConvertHexToDecimal:
		move.w	#9,DigitPos
		lea		DecimalString(PC),a0		; A0 - String with decimal digits
		lea		DigitPos(PC),a1				; A1 - Position of Digit in our string number
		lea		Power10(PC),a2				; A2 - List Decimal Numbers
		move.l	d0,d2						; Make a copy since it will change

	.NextDigit:
		; Reset D3 for next Digit
		move.l	#$0,d3
	.Loop:
		sub.l	(a2),d0
		bmi.s	.NegativeResult
		move.l	d0,d2						; D2 - Copy of last result before we go into the negative or better the remainder
		addq.l	#$01,d3
		bra.s	.Loop

	.NegativeResult:
		; Store ASCII of D3 as DigitPos in the string area
		add.b	#$30,d3
		move.b	d3,(a0)+

		; Restore D1 to last Positive
		move.l	d2,d0						; error - move.b

		; Add 4 to A2 for next to the Power decimal number in the table
		addq.l	#$4,a2

		; Decrement DigitPos
		subq.w	#$1,(a1)					; error - subq.l (A1 point to a word)
		bne.s	.NextDigit

		add.b	#$30,d2
		move.b	d2,(a0)

		rts

;======================================================================================================================
; Set Game Bitplanes
; D0 - Address of Bitplanes
; A0 - Address of the Bitplane Pointer in the Copperlist
; D1 - Number of Bitplanes
; D2 - Bitplane Size
;======================================================================================================================

SetBitPlanes:
	.NextBP:
		move.w	d0,4(a0)					; Take low word of Source Address and Store in the Bitplane Low Address Word
		swap	d0							; Swap the value (LW = HW and HW = LW)
		move.w	d0,0(a0)					; Take high word of Source Address and Store in the Bitplane High Address Word
		swap	d0							; Swap again to return as it was
		add.l	d2,d0						; Add the bitplane size to the source start Image Address
		addq.w	#8,a0						; Point A1 to next Bitplane Address
		dbra	d1,.NextBP					; Loop Till we do all Bitplanes
		rts

;======================================================================================================================
; Set Colours
;
; A0 - Address where the Colours are in memory
; A1 - Address where the Colour Registers are in the Copperlist
; D0 - Number of Colours on the Screen
;======================================================================================================================

SetColours:
	.NextColour:
		move.w	(a0)+,(a1)						; Copy the Word to teh Copper list Address Word
		addq.l	#4,a1							; Add 4 to the Copper list Address
		dbra	d0,.NextColour					; Loop
		rts

;======================================================================================================================
; Check for Joystick Fire Button
;======================================================================================================================

CheckForJoystickFire:
	.FirePress:
		bsr.w	WaitForRaster
		bsr.w	mt_music
		btst	#7,$bfe001		;Check for the Fire Button Joystick Port 2
		bne.s	.FirePress

	.FireRelease:
		bsr.w	WaitForRaster
		bsr.w	mt_music
		btst	#7,$bfe001		;Check for the Fire Button Joystick Port 2
		beq.s	.FireRelease

		rts
