;======================================================================================================================
; Requires PUBLIC Code
;======================================================================================================================

		SECTION	GameCode,CODE_P

;======================================================================================================================
; Game Variables
;======================================================================================================================

Vars:

;----------------------------------------------------------------------------------------------------------------------
; Sprite Player X, Y
Player_Y:
		dc.w	PlayerY			; Y movement
Player_X:
		dc.w	PlayerX			; X movement

;----------------------------------------------------------------------------------------------------------------------
; Respawn timer
Respawn:
		dc.b	$0
		even

;----------------------------------------------------------------------------------------------------------------------
; Play Animation Delay
PlyAnimDelay:
		dc.b	AnimFrameDelay
		even

;----------------------------------------------------------------------------------------------------------------------
; Animation Number Position
AnimLeft:
		dc.b	$0
		even

AnimMiddle:
		dc.b	$0
		even

AnimRight:
		dc.b	$0
		even

;----------------------------------------------------------------------------------------------------------------------
; Falling Speed
FallSpeed:
		dc.w	NormalFall				; Falling speed - 1 normal speed, 2 Fast Speed
		even

;----------------------------------------------------------------------------------------------------------------------
; Middle Falling Counter
MiddleFallCounter:
		dc.w	0						; Falling speed - 1 normal speed, 2 Fast Speed
		even

;----------------------------------------------------------------------------------------------------------------------
; Read Joystick so many Frames
JoyDelay:
		dc.b	JoystickFrames
		even

;----------------------------------------------------------------------------------------------------------------------
; Collision Flag
Collision:
		dc.w	$0
		even

;----------------------------------------------------------------------------------------------------------------------
; Max Respawm Frames
MaxTimerRespawn:
		dc.b	MaxRespawm
		even

;----------------------------------------------------------------------------------------------------------------------
; Energy Bar and Depth Bar

EnergyBar:
		dcb.b	8,255		; 8 bytes of 255
		even

DepthBar:
		dc.b	128
		dcb.b	7,0			; 8 Bytes of 0 
		even

;----------------------------------------------------------------------------------------------------------------------
; Scores, Energy and Depth
Energy:
		dc.l	EnergyStrength
		even

Depth:
		dc.w	DepthLevel
		even

DepthLevelTimer:
		dc.w	DepthTimer

Score:
		dc.l	$0
		even

HiScore:
		dc.l	$0
		even

;----------------------------------------------------------------------------------------------------------------------
; Points System
EnemyPoints:
		dc.l	PointsPerEnemy
		even

;----------------------------------------------------------------------------------------------------------------------
; Variables used by the Hex conversion Routine

Power10:
			;	1234567890  123456789  12345678  1234567  123456  12345  1234  123  12
		dc.l	1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10
		even

DigitPos:
		dc.w	$9
		even
		
DecimalString:
		dcb.b	10,0
		even

;======================================================================================================================
; Game Tables
;======================================================================================================================

;----------------------------------------------------------------------------------------------------------------------
; Table of Sprite enemies
EnemySprTable:
		dc.l	Spr2, Spr3, Spr4, Spr5, Spr6, Spr7

;----------------------------------------------------------------------------------------------------------------------
; Table of Sprite Image Data
; EnemyImgSprTable:
;		dc.l	Contra, Cotton, ToiletPaper, ToiletPaper2, Always, Cigarette, Diaper, Needle

;----------------------------------------------------------------------------------------------------------------------
; Enemy Structure
; 0	dc.b Enemy.Active	- Active = $FF, Inactive = $0
; 1	dc.b Enemy.Number	- Which Enemry Image Data we are showing
; 2	dc.w Enemy.Y		- 0 - 255
; 4	dc.b Enemy.X		- Left, Middle, Right
; 5 dc.b Enemy.Empty	- Not Used for Future Expansion 
; Total Structure Size is 6
EnemyTableScreen:
		dcb.b	6*MaxEnemiesOnScreen,0
		even

