; atan2: Returns the angle from origin to the given XY coordinate.
; Angle is from 0-255 (assume a 256-degree circle).
; d0: X value
; d1: Y value
atan2:
            moveq       #32,d3
            tst.w       d0
            blt         .xneg
.xpos:      tst.w       d1
            blt         .quad4
.quad1:     moveq       #0,d2
            bra         .0
.xneg:      tst.w       d1
            blt         .quad3
.quad2:     moveq       #64,d2
            neg.w       d0
            exg         d0,d1
            bra         .0
.quad3:     moveq       #-128,d2
            neg.w       d0
            neg.w       d1
            bra         .0
.quad4:     moveq       #-64,d2
            neg.w       d1
            exg         d0,d1
.0:         cmp.w       d3,d0
            blo         .1
.0b:        lsr.w       #1,d0
            lsr.w       #1,d1
            cmp.w       d3,d0
            bhs         .0b
.1:         cmp.w       d3,d1
            blo         .2
.1b:        lsr.w       #1,d0
            lsr.w       #1,d1
            cmp.w       d3,d1
            bhs         .1b
.2:         lsl.w       #5,d1
            add.w       d0,d1
            add.b       AtanTable(pc,d1.w),d2
            move.l      d2,d0
            rts

AtanTable:
;@generated-datagen-start----------------
; This code was generated by Amiga Assembly extension
;
;----- parameters : modify ------
;expression(x as variable): round(atan(floor(x/32)/(max(1, x)%32))/pi*128)
;variable:
;   name:x
;   startValue:0
;   endValue:1023
;   step:1
;outputType(B,W,L): B
;outputInHex: true
;valuesPerLine: 32
;--------------------------------
;- DO NOT MODIFY following lines -
            dc.b        $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
            dc.b        $40, $20, $13, $0d, $0a, $08, $07, $06, $05, $05, $04, $04, $03, $03, $03, $03, $03, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $01, $01, $01, $01
            dc.b        $40, $2d, $20, $18, $13, $10, $0d, $0b, $0a, $09, $08, $07, $07, $06, $06, $05, $05, $05, $05, $04, $04, $04, $04, $04, $03, $03, $03, $03, $03, $03, $03, $03
            dc.b        $40, $33, $28, $20, $1a, $16, $13, $10, $0f, $0d, $0c, $0b, $0a, $09, $09, $08, $08, $07, $07, $06, $06, $06, $06, $05, $05, $05, $05, $05, $04, $04, $04, $04
            dc.b        $40, $36, $2d, $26, $20, $1b, $18, $15, $13, $11, $10, $0e, $0d, $0c, $0b, $0b, $0a, $09, $09, $08, $08, $08, $07, $07, $07, $06, $06, $06, $06, $06, $05, $05
            dc.b        $40, $38, $30, $2a, $25, $20, $1c, $19, $17, $15, $13, $11, $10, $0f, $0e, $0d, $0c, $0c, $0b, $0a, $0a, $0a, $09, $09, $08, $08, $08, $07, $07, $07, $07, $07
            dc.b        $40, $39, $33, $2d, $28, $24, $20, $1d, $1a, $18, $16, $14, $13, $12, $10, $10, $0f, $0e, $0d, $0c, $0c, $0b, $0b, $0a, $0a, $0a, $09, $09, $09, $08, $08, $08
            dc.b        $40, $3a, $35, $30, $2b, $27, $23, $20, $1d, $1b, $19, $17, $16, $14, $13, $12, $11, $10, $0f, $0e, $0e, $0d, $0d, $0c, $0c, $0b, $0b, $0a, $0a, $0a, $09, $09
            dc.b        $40, $3b, $36, $31, $2d, $29, $26, $23, $20, $1e, $1b, $1a, $18, $16, $15, $14, $13, $12, $11, $10, $10, $0f, $0e, $0e, $0d, $0d, $0c, $0c, $0b, $0b, $0b, $0a
            dc.b        $40, $3b, $37, $33, $2f, $2b, $28, $25, $22, $20, $1e, $1c, $1a, $19, $17, $16, $15, $14, $13, $12, $11, $10, $10, $0f, $0f, $0e, $0e, $0d, $0d, $0c, $0c, $0c
            dc.b        $40, $3c, $38, $34, $30, $2d, $2a, $27, $25, $22, $20, $1e, $1c, $1b, $19, $18, $17, $16, $15, $14, $13, $12, $11, $11, $10, $10, $0f, $0e, $0e, $0e, $0d, $0d
            dc.b        $40, $3c, $39, $35, $32, $2f, $2c, $29, $26, $24, $22, $20, $1e, $1d, $1b, $1a, $19, $17, $16, $15, $14, $14, $13, $12, $12, $11, $10, $10, $0f, $0f, $0e, $0e
            dc.b        $40, $3d, $39, $36, $33, $30, $2d, $2a, $28, $26, $24, $22, $20, $1e, $1d, $1b, $1a, $19, $18, $17, $16, $15, $14, $14, $13, $12, $12, $11, $10, $10, $10, $0f
            dc.b        $40, $3d, $3a, $37, $34, $31, $2e, $2c, $2a, $27, $25, $23, $22, $20, $1e, $1d, $1c, $1b, $19, $18, $17, $17, $16, $15, $14, $14, $13, $12, $12, $11, $11, $10
            dc.b        $40, $3d, $3a, $37, $35, $32, $30, $2d, $2b, $29, $27, $25, $23, $22, $20, $1f, $1d, $1c, $1b, $1a, $19, $18, $17, $16, $16, $15, $14, $13, $13, $12, $12, $11
            dc.b        $40, $3d, $3b, $38, $35, $33, $30, $2e, $2c, $2a, $28, $26, $25, $23, $21, $20, $1f, $1d, $1c, $1b, $1a, $19, $18, $18, $17, $16, $15, $15, $14, $13, $13, $12
            dc.b        $40, $3d, $3b, $38, $36, $34, $31, $2f, $2d, $2b, $29, $27, $26, $24, $23, $21, $20, $1f, $1e, $1d, $1b, $1b, $1a, $19, $18, $17, $16, $16, $15, $15, $14, $13
            dc.b        $40, $3e, $3b, $39, $37, $34, $32, $30, $2e, $2c, $2a, $29, $27, $25, $24, $23, $21, $20, $1f, $1e, $1d, $1c, $1b, $1a, $19, $18, $18, $17, $16, $16, $15, $14
            dc.b        $40, $3e, $3b, $39, $37, $35, $33, $31, $2f, $2d, $2b, $2a, $28, $27, $25, $24, $22, $21, $20, $1f, $1e, $1d, $1c, $1b, $1a, $19, $19, $18, $17, $17, $16, $15
            dc.b        $40, $3e, $3c, $3a, $38, $36, $34, $32, $30, $2e, $2c, $2b, $29, $28, $26, $25, $23, $22, $21, $20, $1f, $1e, $1d, $1c, $1b, $1a, $1a, $19, $18, $18, $17, $16
            dc.b        $40, $3e, $3c, $3a, $38, $36, $34, $32, $30, $2f, $2d, $2c, $2a, $29, $27, $26, $25, $23, $22, $21, $20, $1f, $1e, $1d, $1c, $1b, $1b, $1a, $19, $19, $18, $17
            dc.b        $40, $3e, $3c, $3a, $38, $36, $35, $33, $31, $30, $2e, $2c, $2b, $29, $28, $27, $25, $24, $23, $22, $21, $20, $1f, $1e, $1d, $1c, $1c, $1b, $1a, $1a, $19, $18
            dc.b        $40, $3e, $3c, $3a, $39, $37, $35, $33, $32, $30, $2f, $2d, $2c, $2a, $29, $28, $26, $25, $24, $23, $22, $21, $20, $1f, $1e, $1d, $1d, $1c, $1b, $1a, $1a, $19
            dc.b        $40, $3e, $3c, $3b, $39, $37, $36, $34, $32, $31, $2f, $2e, $2c, $2b, $2a, $28, $27, $26, $25, $24, $23, $22, $21, $20, $1f, $1e, $1e, $1d, $1c, $1b, $1b, $1a
            dc.b        $40, $3e, $3d, $3b, $39, $38, $36, $34, $33, $31, $30, $2e, $2d, $2c, $2a, $29, $28, $27, $26, $25, $24, $23, $22, $21, $20, $1f, $1e, $1e, $1d, $1c, $1b, $1b
            dc.b        $40, $3e, $3d, $3b, $3a, $38, $36, $35, $33, $32, $30, $2f, $2e, $2c, $2b, $2a, $29, $28, $27, $26, $25, $24, $23, $22, $21, $20, $1f, $1e, $1e, $1d, $1c, $1c
            dc.b        $40, $3e, $3d, $3b, $3a, $38, $37, $35, $34, $32, $31, $30, $2e, $2d, $2c, $2b, $2a, $28, $27, $26, $25, $24, $23, $22, $22, $21, $20, $1f, $1e, $1e, $1d, $1c
            dc.b        $40, $3e, $3d, $3b, $3a, $39, $37, $36, $34, $33, $32, $30, $2f, $2e, $2d, $2b, $2a, $29, $28, $27, $26, $25, $24, $23, $22, $22, $21, $20, $1f, $1f, $1e, $1d
            dc.b        $40, $3f, $3d, $3c, $3a, $39, $37, $36, $35, $33, $32, $31, $30, $2e, $2d, $2c, $2b, $2a, $29, $28, $27, $26, $25, $24, $23, $22, $22, $21, $20, $1f, $1f, $1e
            dc.b        $40, $3f, $3d, $3c, $3a, $39, $38, $36, $35, $34, $32, $31, $30, $2f, $2e, $2d, $2b, $2a, $29, $28, $27, $26, $26, $25, $24, $23, $22, $21, $21, $20, $1f, $1f
            dc.b        $40, $3f, $3d, $3c, $3b, $39, $38, $37, $35, $34, $33, $32, $30, $2f, $2e, $2d, $2c, $2b, $2a, $29, $28, $27, $26, $25, $25, $24, $23, $22, $21, $21, $20, $1f
            dc.b        $40, $3f, $3d, $3c, $3b, $39, $38, $37, $36, $34, $33, $32, $31, $30, $2f, $2e, $2d, $2c, $2b, $2a, $29, $28, $27, $26, $25, $24, $24, $23, $22, $21, $21, $20
;@generated-datagen-end----------------
