; Fast 68k sin/cos function
; -------------------------------------
; This is a sin/cos function suitable to be used inline as a macro for
; maximum speed, using a 256-byte lookup table.
; Provides simultaneous signed sin and cos values of an angle from 0-255.
; The return range is from -256 (0xff00) to 255 (0x00ff).
; This works especially well if your position, velocity, etc. are word values,
; where the high byte is the pixel value, and the low byte is the
; fractional/subpixel value.
; The macro version of this function takes 44 cycles and 10 memory reads.
; Use SINCOS a0 after loading SinTable into a0, or jump to sincos for the
; non-inline version which preserves address registers.
; -------------------------------------

; SINCOS \1
; Provides the sin and cos of d0 (assuming a 256-degree circle).
; \1: address register pointing to SinTable
; Returns: sin in d0, cos in d1 (word, range -256 to 255)
SINCOS  MACRO
        moveq     #64,d1
        add.b     d0,d1
        ext.w     d1
        ext.w     d0
        move.b    (\1,d1.w),d1
        move.b    (\1,d0.w),d0
        ENDM

        CODE
; Provides the sin and cos of d0 (assuming a 256-degree circle).
; Returns: sin in d0, cos in d1 (word, range -256 to 255)
sincos:
        move.l    a0,-(sp)
        lea       SinTable,a0
        SINCOS    a0
        move.l    (sp)+,a0
        rts

        DATA
SinTable = _SinTable+128
_SinTable:
;@generated-datagen-start----------------
; This code was generated by Amiga Assembly extension
;
;----- parameters : modify ------
;expression(x as variable): max(0, min(255, round(sin((x%256)*pi/128)*256) + 255 * round((x%256)/256)))
;variable:
;   name:x
;   startValue:128
;   endValue:383
;   step:1
;outputType(B,W,L): B
;outputInHex: true
;valuesPerLine: 8
;--------------------------------
;- DO NOT MODIFY following lines -
        dc.b      $ff, $f9, $f2, $ec, $e6, $e0, $d9, $d3
        dc.b      $cd, $c7, $c1, $bb, $b5, $af, $a9, $a3
        dc.b      $9d, $97, $92, $8c, $86, $81, $7b, $76
        dc.b      $71, $6c, $67, $62, $5d, $58, $53, $4e
        dc.b      $4a, $46, $41, $3d, $39, $35, $31, $2e
        dc.b      $2a, $27, $23, $20, $1d, $1a, $18, $15
        dc.b      $12, $10, $0e, $0c, $0a, $08, $07, $05
        dc.b      $04, $03, $02, $01, $00, $00, $00, $00
        dc.b      $00, $00, $00, $00, $00, $01, $02, $03
        dc.b      $04, $05, $07, $08, $0a, $0c, $0e, $10
        dc.b      $12, $15, $18, $1a, $1d, $20, $23, $27
        dc.b      $2a, $2e, $31, $35, $39, $3d, $41, $46
        dc.b      $4a, $4e, $53, $58, $5d, $62, $67, $6c
        dc.b      $71, $76, $7b, $81, $86, $8c, $92, $97
        dc.b      $9d, $a3, $a9, $af, $b5, $bb, $c1, $c7
        dc.b      $cd, $d3, $d9, $e0, $e6, $ec, $f2, $f9
        dc.b      $00, $06, $0d, $13, $19, $1f, $26, $2c
        dc.b      $32, $38, $3e, $44, $4a, $50, $56, $5c
        dc.b      $62, $68, $6d, $73, $79, $7e, $84, $89
        dc.b      $8e, $93, $98, $9d, $a2, $a7, $ac, $b1
        dc.b      $b5, $b9, $be, $c2, $c6, $ca, $ce, $d1
        dc.b      $d5, $d8, $dc, $df, $e2, $e5, $e7, $ea
        dc.b      $ed, $ef, $f1, $f3, $f5, $f7, $f8, $fa
        dc.b      $fb, $fc, $fd, $fe, $ff, $ff, $ff, $ff
        dc.b      $ff, $ff, $ff, $ff, $ff, $fe, $fd, $fc
        dc.b      $fb, $fa, $f8, $f7, $f5, $f3, $f1, $ef
        dc.b      $ed, $ea, $e7, $e5, $e2, $df, $dc, $d8
        dc.b      $d5, $d1, $ce, $ca, $c6, $c2, $be, $b9
        dc.b      $b5, $b1, $ac, $a7, $a2, $9d, $98, $93
        dc.b      $8e, $89, $84, $7e, $79, $73, $6d, $68
        dc.b      $62, $5c, $56, $50, $4a, $44, $3e, $38
        dc.b      $32, $2c, $26, $1f, $19, $13, $0d, $06
;@generated-datagen-end----------------
