/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.PrintWriter;
import processing.core.PApplet;
import processing.data.JSONArray;
import processing.data.JSONObject;

public class sketch_AmigaBOB1616Editor
extends PApplet {
    float version = 0.77f;
    boolean importC64DataActive = false;
    boolean addByte = true;
    int blocksASMAmount = 98;
    int bitplanes = 4;
    int amountColors = 32;
    int bitsPerColor = 4;
    String[] arrTools = new String[]{"d", "f", "nl", "c", "r", "cp", "pa", "nl", "flx", "fly", "ml", "mu"};
    String[] arrToolsName = new String[]{"draw", "fill", "nl", "clear", "rnd", "copy", "paste", "nl", "<>", "^v", "|<", "^_"};
    int[] arrToolType;
    String toolSelected;
    int[] arrLevels;
    int[] arrPlayfield;
    int[] arrCopyPastePlayfield;
    Block[] arrBlocks;
    int selectedBlock;
    Block copypasteBlock;
    int selectedSegment;
    int paintColor;
    int backgroundColor;
    int borderColor;
    int ibackgroundColor;
    int iborderColor;
    int[][] arrColorfield;
    int editorMode;
    int startXFocus;
    int startYFocus;
    int offsetRightY;
    String msg;
    Color[] arrCol;
    int[] c64Colors;
    Color[] c64ColorRGB;
    int posX;
    int posY;
    boolean mousePressedHistory;
    int actualLevel;

    public sketch_AmigaBOB1616Editor() {
        int[] nArray = new int[14];
        nArray[0] = 1;
        nArray[1] = 1;
        this.arrToolType = nArray;
        this.toolSelected = "d";
        int[] nArray2 = new int[45];
        nArray2[0] = 43;
        nArray2[1] = 44;
        nArray2[2] = 45;
        nArray2[4] = 1;
        nArray2[5] = 2;
        nArray2[6] = 3;
        nArray2[7] = 4;
        nArray2[8] = 5;
        nArray2[9] = 6;
        nArray2[10] = 7;
        nArray2[11] = 8;
        nArray2[12] = 9;
        nArray2[13] = 10;
        nArray2[14] = 11;
        nArray2[15] = 12;
        nArray2[16] = 13;
        nArray2[17] = 14;
        nArray2[18] = 15;
        nArray2[19] = 16;
        nArray2[20] = 17;
        nArray2[21] = 18;
        nArray2[22] = 19;
        nArray2[23] = 20;
        nArray2[24] = 21;
        nArray2[25] = 22;
        nArray2[26] = 23;
        nArray2[27] = 24;
        nArray2[28] = 25;
        nArray2[29] = 26;
        nArray2[30] = 27;
        nArray2[31] = 28;
        nArray2[32] = 29;
        nArray2[33] = 30;
        nArray2[34] = 31;
        nArray2[35] = 32;
        nArray2[36] = 33;
        nArray2[37] = 34;
        nArray2[38] = 35;
        nArray2[39] = 36;
        nArray2[40] = 37;
        nArray2[41] = 38;
        nArray2[42] = 39;
        nArray2[43] = 40;
        nArray2[44] = 42;
        this.arrLevels = nArray2;
        this.arrPlayfield = new int[320];
        this.arrCopyPastePlayfield = new int[320];
        this.arrBlocks = new Block[256];
        this.selectedBlock = 1;
        this.copypasteBlock = new Block();
        this.selectedSegment = 0;
        this.paintColor = 1;
        this.backgroundColor = 0;
        this.borderColor = 0;
        this.ibackgroundColor = 0;
        this.iborderColor = 0;
        int[][] nArrayArray = new int[6][];
        int[] nArray3 = new int[5];
        nArray3[1] = 11;
        nArray3[2] = 12;
        nArray3[3] = 15;
        nArray3[4] = 1;
        nArrayArray[0] = nArray3;
        nArrayArray[1] = new int[]{-1, -1, 6, 14, 3};
        nArrayArray[2] = new int[]{-1, -1, 5, 13, 7};
        nArrayArray[3] = new int[]{-1, -1, 4, 10, 8};
        nArrayArray[4] = new int[]{-1, -1, -1, 2, 9};
        nArrayArray[5] = new int[]{-1, -1, -1, 4, -1};
        this.arrColorfield = nArrayArray;
        this.editorMode = 1;
        this.startXFocus = 3;
        this.startYFocus = 2;
        this.offsetRightY = 25;
        this.msg = "Started up";
        this.arrCol = new Color[0];
        int[] nArray4 = new int[32];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArray4[3] = 3;
        nArray4[4] = 4;
        nArray4[5] = 5;
        nArray4[6] = 6;
        nArray4[7] = 7;
        nArray4[8] = 8;
        nArray4[9] = 9;
        nArray4[10] = 10;
        nArray4[11] = 11;
        nArray4[12] = 12;
        nArray4[13] = 13;
        nArray4[14] = 14;
        nArray4[15] = 15;
        nArray4[16] = 16;
        nArray4[17] = 17;
        nArray4[18] = 18;
        nArray4[19] = 19;
        nArray4[20] = 20;
        nArray4[21] = 21;
        nArray4[22] = 22;
        nArray4[23] = 23;
        nArray4[24] = 24;
        nArray4[25] = 25;
        nArray4[26] = 26;
        nArray4[27] = 27;
        nArray4[28] = 28;
        nArray4[29] = 29;
        nArray4[30] = 30;
        nArray4[31] = 31;
        this.c64Colors = nArray4;
        this.c64ColorRGB = new Color[32];
        this.posX = 0;
        this.posY = 50;
        this.mousePressedHistory = false;
        this.actualLevel = 0;
    }

    public void setup() {
        int z = 0;
        while (z < 256) {
            Block blockO;
            this.arrBlocks[z] = blockO = new Block();
            this.initBlock(blockO);
            ++z;
        }
        this.initBlock(this.copypasteBlock);
        int o = 0;
        while (o < 320) {
            this.arrPlayfield[o] = 0;
            ++o;
        }
        this.c64ColorRGB[0] = new Color(0, 0, 0);
        this.c64ColorRGB[1] = new Color(4, 4, 4);
        this.c64ColorRGB[2] = new Color(8, 8, 8);
        this.c64ColorRGB[3] = new Color(12, 12, 12);
        this.c64ColorRGB[4] = new Color(16, 16, 16);
        this.c64ColorRGB[5] = new Color(4, 0, 0);
        this.c64ColorRGB[6] = new Color(8, 0, 0);
        this.c64ColorRGB[7] = new Color(12, 0, 0);
        this.c64ColorRGB[8] = new Color(16, 0, 0);
        this.c64ColorRGB[9] = new Color(0, 4, 0);
        this.c64ColorRGB[10] = new Color(0, 8, 0);
        this.c64ColorRGB[11] = new Color(0, 12, 0);
        this.c64ColorRGB[12] = new Color(0, 0, 4);
        this.c64ColorRGB[13] = new Color(0, 0, 8);
        this.c64ColorRGB[14] = new Color(0, 0, 12);
        this.c64ColorRGB[15] = new Color(12, 0, 12);
        this.c64ColorRGB[16] = new Color(90, 90, 90);
        this.c64ColorRGB[17] = new Color(90, 90, 90);
        this.c64ColorRGB[18] = new Color(90, 90, 90);
        this.c64ColorRGB[19] = new Color(90, 90, 90);
        this.c64ColorRGB[20] = new Color(90, 90, 90);
        this.c64ColorRGB[21] = new Color(90, 90, 90);
        this.c64ColorRGB[22] = new Color(90, 90, 90);
        this.c64ColorRGB[23] = new Color(90, 90, 90);
        this.c64ColorRGB[24] = new Color(90, 90, 90);
        this.c64ColorRGB[25] = new Color(90, 90, 90);
        this.c64ColorRGB[26] = new Color(90, 90, 90);
        this.c64ColorRGB[27] = new Color(90, 90, 90);
        this.c64ColorRGB[28] = new Color(90, 90, 90);
        this.c64ColorRGB[29] = new Color(90, 90, 90);
        this.c64ColorRGB[30] = new Color(90, 90, 90);
        this.c64ColorRGB[31] = new Color(90, 90, 90);
        this.loadBlocks();
        this.loadPlayfield();
    }

    public void initBlock(Block blockInstance) {
        blockInstance.arrSegments[0] = new Segment();
        blockInstance.arrSegments[0].initColors();
    }

    public Color getColor(int index) {
        if (index == 42) {
            index = 3;
        }
        return this.c64ColorRGB[index];
    }

    public void draw() {
        Color dcox = this.getColor(this.backgroundColor);
        this.fill(dcox.r, dcox.g, dcox.b);
        this.background(dcox.r, dcox.g, dcox.b);
        Color cox = this.getColor(this.backgroundColor);
        this.fill(cox.r, cox.g, cox.b);
        this.fill(0.0f, 0.0f, 0.0f);
        this.rect(0.0f, 0.0f, 500.0f, 50.0f);
        this.fill(255);
        this.textSize(40.0f);
        this.text("CBA CAMIGA_BOB_EDITOR " + this.version + " (BLITTEROBJECTS)", 0.0f, 40.0f);
        this.fill(0);
        this.rect(10.0f, 65.0f, 700.0f, 20.0f);
        this.fill(255);
        this.textSize(16.0f);
        this.text("BOB_EDITOR (COLOR 0: TRANS)                         BOBS                                                                            ", 10.0f, 80.0f);
        String[] arrToolsBlocks = new String[]{"load", "save"};
        int bsx = 450;
        int bsy = 62;
        int z = 0;
        while (z < arrToolsBlocks.length) {
            String namexyz = arrToolsBlocks[z];
            this.fill(80.0f, 80.0f, 80.0f);
            this.rect(bsx, bsy, 50.0f, 20.0f);
            this.fill(255);
            this.text(namexyz, bsx, bsy + 20);
            if (!this.mousePressedHistory && this.mousePressed && this.mouseX > bsx && this.mouseX < bsx + 40 && this.mouseY > bsy && this.mouseY < bsy + 20) {
                if (namexyz.equals("load")) {
                    this.loadBlocks();
                }
                if (namexyz.equals("save")) {
                    this.saveBlocks();
                }
            }
            bsx += 60;
            ++z;
        }
        this.textSize(10.0f);
        int blockX = this.posX + 298;
        int blockY = this.posY + 50;
        int blockSize = 32;
        this.fill(255.0f, 255.0f, 255.0f, 100.0f);
        this.rect(blockX - 1, blockY - 1, blockSize * 8 + 2, 500.0f);
        int x = 0;
        while (x < 256) {
            this.fill(255);
            int sizeBlockX = 8;
            int t = blockX + x % sizeBlockX * blockSize;
            int tt = blockY + PApplet.parseInt((float)(x / sizeBlockX)) * blockSize;
            Block ozy = this.arrBlocks[x];
            this.drawBlock(0, ozy, t, tt, blockSize / 8 / 2, blockSize / 16);
            if (x == this.selectedBlock) {
                this.fill(256.0f, 0.0f, 0.0f);
                this.rect(t, tt, 5.0f, 5.0f);
                this.rect(t + blockSize - 5, tt, 5.0f, 5.0f);
            }
            if (this.mousePressed && this.mouseX > t && this.mouseX < t + blockSize && this.mouseY > tt && this.mouseY < tt + blockSize) {
                this.selectedBlock = x;
            }
            ++x;
        }
        int selectedBlockX = 10;
        int selectedBlockY = this.posY + 50;
        this.fill(255);
        this.stroke(255);
        int sizeX = 256;
        int sizeY = 256;
        this.selectedSegment = 0;
        int segmentX = selectedBlockX;
        int segmentY = selectedBlockY;
        int esegmentSizeX = sizeX / 2 / 8 / 2 * 2;
        int esegmentSizeZ = sizeY / 2 / 16 * 2;
        Block blockXY = this.arrBlocks[this.selectedBlock];
        Segment cfr_ignored_0 = blockXY.arrSegments[this.selectedSegment];
        this.color(150, 150, 150, 100);
        this.rect(segmentX - 2, segmentY - 2, sizeX + 4, sizeY + 4);
        this.drawBlock(5, blockXY, segmentX, segmentY, esegmentSizeX, esegmentSizeZ);
        if (this.mouseX < 400 && this.mouseY < 400 && this.toolSelected == "f") {
            this.text("fill", this.mouseX + 20, this.mouseY + 10);
        }
        int ux = selectedBlockX;
        int uy = segmentY + 260;
        int z2 = 0;
        while (z2 < this.arrToolsName.length) {
            String toolx = this.arrToolsName[z2];
            String toolxcode = this.arrTools[z2];
            int toolsizeX = 50;
            int toolsizeY = 20;
            if (toolx == "nl") {
                ux = 10;
                uy += toolsizeY + 2;
            } else {
                if (!this.mousePressedHistory && this.mousePressed && this.mouseX > ux && this.mouseX < ux + toolsizeX && this.mouseY > uy && this.mouseY < uy + toolsizeY) {
                    int y;
                    int x2;
                    Block tempXY;
                    Block blockXYT;
                    sketch_AmigaBOB1616Editor.print((String)toolx);
                    if (toolxcode == "d") {
                        this.toolSelected = toolxcode;
                    }
                    if (toolxcode == "f") {
                        this.toolSelected = toolxcode;
                    }
                    if (toolxcode == "c") {
                        sketch_AmigaBOB1616Editor.print((String)"clear");
                        blockXYT = this.arrBlocks[this.selectedBlock];
                        blockXYT.clear();
                        this.changeDone();
                    }
                    if (toolxcode == "r") {
                        sketch_AmigaBOB1616Editor.print((String)"random");
                        blockXYT = this.arrBlocks[this.selectedBlock];
                        blockXYT.randIt();
                        this.changeDone();
                    }
                    if (toolxcode == "flx") {
                        sketch_AmigaBOB1616Editor.print((String)"flipx");
                        blockXYT = this.arrBlocks[this.selectedBlock];
                        tempXY = new Block();
                        this.initBlock(tempXY);
                        x2 = 0;
                        while (x2 < 16) {
                            y = 0;
                            while (y < 16) {
                                tempXY.setBlockPixel(x2, y, blockXYT.getBlockPixel(x2, y));
                                ++y;
                            }
                            ++x2;
                        }
                        x2 = 0;
                        while (x2 < 16) {
                            y = 0;
                            while (y < 16) {
                                blockXYT.setBlockPixel(15 - x2, y, tempXY.getBlockPixel(x2, y));
                                ++y;
                            }
                            ++x2;
                        }
                        this.changeDone();
                        this.delay(50);
                    }
                    if (toolxcode == "fly") {
                        sketch_AmigaBOB1616Editor.print((String)"flipy");
                        blockXYT = this.arrBlocks[this.selectedBlock];
                        tempXY = new Block();
                        this.initBlock(tempXY);
                        x2 = 0;
                        while (x2 < 16) {
                            y = 0;
                            while (y < 16) {
                                tempXY.setBlockPixel(x2, y, blockXYT.getBlockPixel(x2, y));
                                ++y;
                            }
                            ++x2;
                        }
                        x2 = 0;
                        while (x2 < 16) {
                            y = 0;
                            while (y < 16) {
                                blockXYT.setBlockPixel(x2, 15 - y, tempXY.getBlockPixel(x2, y));
                                ++y;
                            }
                            ++x2;
                        }
                        this.changeDone();
                        this.delay(50);
                    }
                    if (toolxcode == "ml") {
                        sketch_AmigaBOB1616Editor.print((String)"moveleft");
                        blockXYT = this.arrBlocks[this.selectedBlock];
                        tempXY = new Block();
                        this.initBlock(tempXY);
                        x2 = 0;
                        while (x2 < 16) {
                            y = 0;
                            while (y < 16) {
                                tempXY.setBlockPixel(x2, y, blockXYT.getBlockPixel(x2, y));
                                ++y;
                            }
                            ++x2;
                        }
                        x2 = 0;
                        while (x2 < 16) {
                            y = 0;
                            while (y < 16) {
                                if (x2 == 15) {
                                    blockXYT.setBlockPixel(15, y, tempXY.getBlockPixel(0, y));
                                } else {
                                    blockXYT.setBlockPixel(x2, y, tempXY.getBlockPixel(x2 + 1, y));
                                }
                                ++y;
                            }
                            ++x2;
                        }
                        this.delay(30);
                        this.changeDone();
                    }
                    if (toolxcode == "mu") {
                        sketch_AmigaBOB1616Editor.print((String)"moveup");
                        blockXYT = this.arrBlocks[this.selectedBlock];
                        tempXY = new Block();
                        this.initBlock(tempXY);
                        x2 = 0;
                        while (x2 < 16) {
                            y = 0;
                            while (y < 16) {
                                tempXY.setBlockPixel(x2, y, blockXYT.getBlockPixel(x2, y));
                                ++y;
                            }
                            ++x2;
                        }
                        x2 = 0;
                        while (x2 < 16) {
                            y = 0;
                            while (y < 16) {
                                if (y == 15) {
                                    blockXYT.setBlockPixel(x2, 15, tempXY.getBlockPixel(x2, 0));
                                } else {
                                    blockXYT.setBlockPixel(x2, y, tempXY.getBlockPixel(x2, y + 1));
                                }
                                ++y;
                            }
                            ++x2;
                        }
                        this.delay(30);
                        this.changeDone();
                    }
                    if (toolxcode == "cp") {
                        blockXYT = this.arrBlocks[this.selectedBlock];
                        this.copypasteBlock.updateFrom(blockXYT);
                        this.changeDone();
                    }
                    if (toolxcode == "pa") {
                        sketch_AmigaBOB1616Editor.print((String)"paste");
                        blockXYT = this.arrBlocks[this.selectedBlock];
                        blockXYT.updateFrom(this.copypasteBlock);
                        this.changeDone();
                    }
                    if (toolxcode == "ro") {
                        sketch_AmigaBOB1616Editor.print((String)"rotate");
                        blockXYT = this.arrBlocks[this.selectedBlock];
                        tempXY = new Block();
                        this.initBlock(tempXY);
                        x2 = 0;
                        while (x2 < 8) {
                            y = 0;
                            while (y < 16) {
                                tempXY.setBlockPixel(x2, y, blockXYT.getBlockPixel(x2, y));
                                ++y;
                            }
                            ++x2;
                        }
                        x2 = 0;
                        while (x2 < 8) {
                            y = 0;
                            while (y < 16) {
                                float t = x2 * 2 - 7;
                                float tt = y - 7;
                                float alpha = sketch_AmigaBOB1616Editor.atan2((float)tt, (float)t);
                                float r = sketch_AmigaBOB1616Editor.sqrt((float)(t * t + tt * tt));
                                float fx = r * sketch_AmigaBOB1616Editor.cos((float)(alpha += 1.5707964f)) + 8.0f;
                                float fy = r * sketch_AmigaBOB1616Editor.sin((float)alpha) + 8.0f;
                                if (fx < 0.0f) {
                                    fx = 0.0f;
                                }
                                if (fy < 0.0f) {
                                    fy = 0.0f;
                                }
                                if (fx > 16.0f) {
                                    fx = 15.0f;
                                }
                                if (fy > 16.0f) {
                                    fy = 15.0f;
                                }
                                int o = tempXY.getBlockPixel(x2, y);
                                blockXYT.setBlockPixel(PApplet.parseInt((float)(fx / 2.0f)), PApplet.parseInt((float)fy), o);
                                ++y;
                            }
                            ++x2;
                        }
                        this.changeDone();
                    }
                }
                this.fill(50);
                this.rect(ux, uy, toolsizeX, 20.0f);
                this.fill(255);
                if (this.toolSelected == toolxcode) {
                    this.fill(255.0f, 0.0f, 0.0f);
                }
                this.textSize(16.0f);
                this.text(toolx, ux, uy + 16);
                ux = ux + toolsizeX + 4;
            }
            ++z2;
        }
        int colorLine = 8;
        int h = 0;
        while (h < this.amountColors) {
            Color co = this.getColor(h);
            int colSizeX = 30;
            int colSizeY = 30;
            int colX = segmentX + h % colorLine * (colSizeX + 2);
            int colY = segmentY + esegmentSizeZ + 340 + PApplet.parseInt((float)(h / colorLine)) * (colSizeY + 2);
            if (this.mousePressed && this.mouseX > colX && this.mouseX < colX + colSizeX && this.mouseY > colY && this.mouseY < colY + colSizeY) {
                this.paintColor = h;
            }
            this.fill(co.r, co.g, co.b);
            if (h == this.paintColor) {
                this.fill(255.0f, 0.0f, 0.0f);
                this.rect(colX - 3, colY - 3, colSizeX + 6, colSizeY + 6);
            }
            this.fill(co.r, co.g, co.b);
            this.rect(colX, colY, colSizeX, colSizeY);
            ++h;
        }
        int colordefsx = 10;
        int colordefsy = 600;
        Color coz = this.c64ColorRGB[this.paintColor];
        int kraftwerk = 0;
        while (kraftwerk < 3) {
            int colSizeY = 20;
            int colY = colordefsy + kraftwerk * colSizeY;
            int z3 = 0;
            while ((double)z3 < Math.pow(2.0, this.bitsPerColor)) {
                int r = 128;
                int g = 0;
                int b = 0;
                if (kraftwerk == 1) {
                    r = 0;
                    b = 0;
                    g = 128;
                }
                if (kraftwerk == 2) {
                    r = 0;
                    b = 128;
                    g = 0;
                }
                this.fill(r, g, b);
                int max = coz.systemR;
                if (kraftwerk == 1) {
                    max = coz.systemG;
                }
                if (kraftwerk == 2) {
                    max = coz.systemB;
                }
                if (z3 > max) {
                    this.fill(20.0f, 20.0f, 20.0f);
                }
                int colSizeX = 15;
                int colX = colordefsx + z3 * colSizeX;
                if (this.mousePressed && this.mouseX > colX && this.mouseX < colX + colSizeX && this.mouseY > colY && this.mouseY < colY + colSizeY) {
                    if (kraftwerk == 0) {
                        coz.systemR = z3;
                    }
                    if (kraftwerk == 1) {
                        coz.systemG = z3;
                    }
                    if (kraftwerk == 2) {
                        coz.systemB = z3;
                    }
                    coz.updateGlobalColors();
                }
                this.rect(colX, colY, colSizeX - 1, colSizeY - 1);
                ++z3;
            }
            this.fill(255.0f, 255.0f, 255.0f);
            int val = coz.systemR;
            if (kraftwerk == 1) {
                val = coz.systemG;
            }
            if (kraftwerk == 2) {
                val = coz.systemB;
            }
            this.text(val, colordefsx + 240 + 10, colY + 12);
            ++kraftwerk;
        }
        this.fill(0);
        this.rect(0.0f, 700.0f, 300.0f, 200.0f);
        this.fill(255);
        String str = "INFO: " + this.selectedBlock + "\n\nEXPORTED BLOCKS: " + this.blocksASMAmount;
        Block cfr_ignored_1 = this.arrBlocks[this.selectedBlock];
        this.textSize(12.0f);
        this.text(str, 10.0f, 720.0f);
        int playfieldX = selectedBlockX + 600;
        int playfieldY = this.posY + 50;
        int playfieldSizeXSegment = 32;
        int playfieldSizeYSegment = 32;
        int fieldSize = 20;
        Color sdcox = this.getColor(this.borderColor);
        this.fill(sdcox.r, sdcox.g, sdcox.b);
        this.fill(255.0f, 255.0f, 255.0f, 100.0f);
        int iplayfieldX = selectedBlockX + 600;
        int iplayfieldY = this.posY + 580;
        int iplayifieldSizeXSegment = 48;
        int iplayifieldSizeYSegment = 48;
        int ifieldSize = 20;
        Color isdcox = this.getColor(this.borderColor);
        this.fill(isdcox.r, isdcox.g, isdcox.b);
        this.fill(255.0f, 255.0f, 255.0f, 100.0f);
        int offsetX = this.startXFocus;
        int offsetY = this.startYFocus;
        this.textSize(18.0f);
        this.fill(200.0f, 200.0f, 200.0f);
        this.text(this.msg, 1100.0f, 20.0f);
    }

    public void keyPressed() {
        if (this.keyCode == 37 || this.key == 'a') {
            --this.startXFocus;
        }
        if (this.keyCode == 39 || this.key == 'd') {
            ++this.startXFocus;
        }
        if (this.keyCode == 38 || this.key == 'w') {
            --this.startYFocus;
        }
        if (this.keyCode == 40 || this.key == 's') {
            ++this.startYFocus;
        }
    }

    public void drawBlock(int modex, Block blockXY, int segmentX, int segmentY, int segmentSizeX, int segmentSizeZ) {
        this.fill(255.0f, 255.0f, 255.0f);
        this.rect(segmentX, segmentY, 2.0f, 2.0f);
        this.drawSegment(modex, blockXY.arrSegments[0], segmentX, segmentY, segmentSizeX, segmentSizeZ);
        this.fill(200.0f, 0.0f, 0.0f);
        if (modex == 5) {
            this.color(30);
            this.fill(30);
            this.stroke(255.0f, 255.0f, 255.0f, 100.0f);
            this.line(segmentX + segmentSizeX * 8, segmentY, segmentX + segmentSizeX * 8, segmentY + segmentSizeZ * 16);
            this.line(segmentX, segmentY + segmentSizeZ * 8, segmentX + segmentSizeX * 16, segmentY + segmentSizeZ * 8);
            this.noStroke();
        }
        if (blockXY.index == 8) {
            this.stroke(255.0f, 0.0f, 0.0f);
        }
    }

    public void drawSegment(int modex, Segment segmentTmp, int segmentX, int segmentY, int segmentSizeX, int segmentSizeZ) {
        this.fill(255);
        int z = 0;
        while (z < 16) {
            int zz = 0;
            while (zz < 16) {
                C64Color col;
                int fx = segmentX + z * segmentSizeX;
                int fy = segmentY + zz * segmentSizeZ;
                if (modex == 5 && this.mousePressed && this.mouseX >= fx && this.mouseX < fx + segmentSizeX && this.mouseY >= fy && this.mouseY < fy + segmentSizeZ) {
                    sketch_AmigaBOB1616Editor.println((String)("draw() " + z + " " + zz + "   " + this.paintColor));
                    if (this.toolSelected == "d") {
                        segmentTmp.arrColors[zz * 16 + z].c64Color = this.paintColor;
                        sketch_AmigaBOB1616Editor.print((String)"draw");
                    }
                    if (this.toolSelected == "f" && !this.mousePressedHistory) {
                        int actColor = segmentTmp.getPixel(z, zz);
                        if (actColor == this.paintColor) {
                            return;
                        }
                        segmentTmp.setPixel(z, zz, 42);
                        boolean goon = true;
                        do {
                            int j = 0;
                            while (j < 16) {
                                int jj = 0;
                                while (jj < 16) {
                                    int v = segmentTmp.getPixel(j, jj);
                                    if (v == 42) {
                                        segmentTmp.setPixel(j, jj, this.paintColor);
                                        if (j > 0 && segmentTmp.getPixel(j - 1, jj) == actColor) {
                                            segmentTmp.setPixel(j - 1, jj, 42);
                                        }
                                        if (j < 15 && segmentTmp.getPixel(j + 1, jj) == actColor) {
                                            segmentTmp.setPixel(j + 1, jj, 42);
                                        }
                                        if (jj > 0 && segmentTmp.getPixel(j, jj - 1) == actColor) {
                                            segmentTmp.setPixel(j, jj - 1, 42);
                                        }
                                        if (jj < 15 && segmentTmp.getPixel(j, jj + 1) == actColor) {
                                            segmentTmp.setPixel(j, jj + 1, 42);
                                        }
                                    }
                                    ++jj;
                                }
                                ++j;
                            }
                            int count = 0;
                            int j2 = 0;
                            while (j2 < 16) {
                                int jj = 0;
                                while (jj < 16) {
                                    if (segmentTmp.getPixel(j2, jj) == 42) {
                                        ++count;
                                    }
                                    ++jj;
                                }
                                ++j2;
                            }
                            if (count != 0) continue;
                            goon = false;
                        } while (goon);
                        this.changeDone();
                    }
                }
                if ((col = segmentTmp.arrColors[zz * 16 + z]) != null) {
                    col.setFillColor();
                    this.color(col.c64Color * 10);
                    Color co = this.getColor(col.c64Color);
                    this.fill(co.r, co.g, co.b);
                    this.rect(fx, fy, segmentSizeX, segmentSizeZ);
                    this.noStroke();
                }
                ++zz;
            }
            int fxx = segmentX + 0 * segmentSizeX;
            int fyy = segmentY + 0 * segmentSizeZ;
            if (modex == 5) {
                this.fill(255);
                this.textSize(12.0f);
                int zx = -9;
                int zy = -5;
                if (segmentX > 100) {
                    zx = segmentSizeX * 4 + 5;
                }
                this.fill(255);
                if (segmentTmp.colorCounter > 3) {
                    this.fill(255.0f, 0.0f, 0.0f);
                }
                this.text("" + segmentTmp.colorCounter, fxx + zx, fyy + 12 + zy);
            }
            ++z;
        }
    }

    public void loadPlayfield() {
        sketch_AmigaBOB1616Editor.println((String)"loadPlayfield()");
        JSONArray arrValues = new JSONArray();
        File f = null;
        String filename = "level" + this.actualLevel + ".json";
        f = new File(filename);
        sketch_AmigaBOB1616Editor.println((String)("existing: " + f.exists()));
        if (!f.exists()) {
            sketch_AmigaBOB1616Editor.println((String)("sorry couldn't find file " + filename));
        }
        try {
            arrValues = this.loadJSONArray(filename);
            int tileIndex = 0;
            int i = 0;
            while (i < arrValues.size()) {
                JSONObject tile = arrValues.getJSONObject(i);
                int z = tile.getInt("attribute");
                if (z == 1) {
                    try {
                        this.backgroundColor = tile.getInt("background");
                    }
                    catch (Exception exception) {}
                    try {
                        this.borderColor = tile.getInt("border");
                    }
                    catch (Exception exception) {}
                }
                if (z == 0) {
                    this.arrPlayfield[tileIndex] = tile.getInt("tile");
                    if (this.importC64DataActive) {
                        int impD = this.arrPlayfield[tileIndex];
                        if (impD >= 14 && impD <= 39) {
                            this.arrPlayfield[tileIndex] = impD - 1;
                        }
                        if (impD >= 40 && impD <= 49) {
                            this.arrPlayfield[tileIndex] = impD - 1;
                        }
                    }
                    ++tileIndex;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            sketch_AmigaBOB1616Editor.println((String)"could not open file");
        }
    }

    public void clearPlayfield() {
        int z = 0;
        while (z < this.arrPlayfield.length) {
            this.arrPlayfield[z] = 0;
            ++z;
        }
    }

    public String digitUp(int z) {
        String res = "" + z;
        if (z < 10) {
            res = "0" + res;
        }
        return res;
    }

    public void storePlayfield() {
        this.msg = "Playfield stored " + sketch_AmigaBOB1616Editor.hour() + ":" + this.digitUp(sketch_AmigaBOB1616Editor.minute());
        sketch_AmigaBOB1616Editor.println((String)"storePlayField()");
        JSONArray arrValues = new JSONArray();
        int startIndex = 0;
        JSONObject background = new JSONObject();
        background.setInt("background", this.backgroundColor);
        background.setInt("attribute", 1);
        arrValues.setJSONObject(startIndex, background);
        ++startIndex;
        JSONObject border = new JSONObject();
        border.setInt("border", this.borderColor);
        border.setInt("attribute", 1);
        arrValues.setJSONObject(startIndex, border);
        ++startIndex;
        JSONObject wjson = new JSONObject();
        wjson.setInt("width", 20);
        wjson.setInt("attribute", 1);
        arrValues.setJSONObject(startIndex, wjson);
        ++startIndex;
        JSONObject wheight = new JSONObject();
        wheight.setInt("width", 13);
        wheight.setInt("attribute", 1);
        arrValues.setJSONObject(startIndex, wheight);
        ++startIndex;
        int i = 0;
        while (i < this.arrPlayfield.length) {
            JSONObject tile = new JSONObject();
            tile.setInt("tile", this.arrPlayfield[i]);
            tile.setInt("attribute", 0);
            arrValues.setJSONObject(startIndex + i, tile);
            ++i;
        }
        this.saveJSONArray(arrValues, "level" + this.actualLevel + ".json");
        PrintWriter output = this.createWriter("level" + this.actualLevel + ".s");
        output.println("level_" + this.actualLevel + ":");
        int i2 = 0;
        while (i2 < this.arrPlayfield.length) {
            if (i2 % 20 == 0) {
                output.print("\n             dc.b ");
            }
            output.print(this.arrPlayfield[i2]);
            if (i2 % 20 != 19) {
                output.print(",");
            }
            ++i2;
        }
        sketch_AmigaBOB1616Editor.println((String)("Data-Saved: " + this.arrPlayfield.length));
        output.println("\nlevel_" + this.actualLevel + "_colors:");
        output.println("\t\t      dc.b " + this.backgroundColor + "," + this.borderColor);
        output.flush();
        output.close();
    }

    public void loadBlocks() {
        this.msg = "Load blocks " + sketch_AmigaBOB1616Editor.hour() + ":" + this.digitUp(sketch_AmigaBOB1616Editor.minute());
        sketch_AmigaBOB1616Editor.println((String)"loadBlocks()");
        JSONArray arrValues = new JSONArray();
        File f = null;
        String filename = "bobs1616.json";
        try {
            f = new File(filename);
            if (!f.exists()) {
                sketch_AmigaBOB1616Editor.println((String)("sorry couldn't find file " + filename));
            }
            arrValues = this.loadJSONArray(filename);
            int z = 0;
            while (z < 256) {
                Block blo = this.arrBlocks[z];
                blo.index = z;
                int s = 0;
                Segment seg = blo.arrSegments[s];
                int c = 0;
                while (c < 256) {
                    JSONObject tile = arrValues.getJSONObject(z * 256 + s * 32 + c);
                    seg.arrColors[c].c64Color = tile.getInt("color");
                    ++c;
                }
                ++z;
            }
        }
        catch (Exception exception) {}
        this.loadColors();
    }

    public void saveBlocks() {
        this.msg = "Bobs stored " + sketch_AmigaBOB1616Editor.hour() + ":" + this.digitUp(sketch_AmigaBOB1616Editor.minute());
        JSONArray arrValues = new JSONArray();
        int z = 0;
        while (z < 256) {
            Block blo = this.arrBlocks[z];
            Segment seg = blo.arrSegments[0];
            int c = 0;
            while (c < 256) {
                int col = seg.arrColors[c].c64Color;
                JSONObject pixel = new JSONObject();
                pixel.setInt("color", col);
                arrValues.setJSONObject(z * 256 + c, pixel);
                ++c;
            }
            ++z;
        }
        this.saveJSONArray(arrValues, "bobs1616.json");
        PrintWriter output = this.createWriter("bobs1616all.s");
        output.println("bobs1616:");
        int z2 = 0;
        while (z2 < this.blocksASMAmount) {
            sketch_AmigaBOB1616Editor.println((String)("block " + z2 + ":"));
            output.println("\nbob1616_" + z2 + ":");
            Block blo = this.arrBlocks[z2];
            int s = 0;
            Segment seg = blo.arrSegments[s];
            output.print(seg.getColorNumbersAsm());
            output.println("bob1616_" + z2 + "_mask:");
            int i = 0;
            while (i < 16) {
                output.print("\n\t\t dc.w %");
                int ii = 0;
                while (ii < 16) {
                    if (seg.arrColors[i * 16 + ii].c64Color > 0) {
                        output.print("1");
                    } else {
                        output.print("0");
                    }
                    ++ii;
                }
                output.print(",0");
                ++i;
            }
            ++z2;
        }
        output.flush();
        output.close();
        this.saveColors();
    }

    public void saveColors() {
        JSONArray arrValues = new JSONArray();
        int o = 0;
        while (o < 32) {
            Color coz = this.c64ColorRGB[o];
            JSONObject colorX = new JSONObject();
            colorX.setInt("r", coz.systemR);
            colorX.setInt("g", coz.systemG);
            colorX.setInt("b", coz.systemB);
            arrValues.setJSONObject(o, colorX);
            ++o;
        }
        this.saveJSONArray(arrValues, "colors.json");
        PrintWriter output = this.createWriter("colors.s");
        String strAs = "";
        int o2 = 0;
        while (o2 < 32) {
            Color coz = this.c64ColorRGB[o2];
            new JSONObject();
            int val = coz.systemR;
            if (val > 15) {
                val = 0;
            }
            strAs = String.valueOf(strAs) + "$0" + Integer.toHexString(val);
            val = coz.systemG;
            if (val > 15) {
                val = 0;
            }
            strAs = String.valueOf(strAs) + Integer.toHexString(val);
            val = coz.systemB;
            if (val > 15) {
                val = 0;
            }
            strAs = String.valueOf(strAs) + Integer.toHexString(val);
            strAs = String.valueOf(strAs) + ",";
            ++o2;
        }
        output.println("\t\t      dc.w " + strAs + "$0");
        output.flush();
        output.close();
    }

    public void loadColors() {
        JSONArray arrValues = new JSONArray();
        File f = null;
        String filename = "colors.json";
        try {
            f = new File(filename);
            if (!f.exists()) {
                sketch_AmigaBOB1616Editor.println((String)("sorry couldn't find file " + filename));
                arrValues = this.loadJSONArray(filename);
                int z = 0;
                while (z < 32) {
                    Color coz = this.c64ColorRGB[z];
                    JSONObject colorx = arrValues.getJSONObject(z);
                    coz.systemR = colorx.getInt("r");
                    coz.systemG = colorx.getInt("g");
                    coz.systemB = colorx.getInt("b");
                    coz.updateGlobalColors();
                    ++z;
                }
            }
        }
        catch (Exception exception) {}
    }

    public void changeDone() {
    }

    public void copyPlayfield() {
        int z = 0;
        while (z < this.arrPlayfield.length) {
            this.arrCopyPastePlayfield[z] = this.arrPlayfield[z];
            ++z;
        }
        this.ibackgroundColor = this.backgroundColor;
        this.iborderColor = this.borderColor;
    }

    public void pastePlayfield() {
        int z = 0;
        while (z < this.arrPlayfield.length) {
            this.arrPlayfield[z] = this.arrCopyPastePlayfield[z];
            ++z;
        }
        this.backgroundColor = this.ibackgroundColor;
        this.borderColor = this.iborderColor;
    }

    public void settings() {
        this.size(1280, 864);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"sketch_AmigaBOB1616Editor"};
        if (passedArgs != null) {
            PApplet.main((String[])sketch_AmigaBOB1616Editor.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Block {
        public int index = -1;
        public Segment[] arrSegments = new Segment[1];

        Block() {
        }

        public void clear() {
            this.arrSegments[0].initColors();
        }

        public void changeColor(int fromCol, int toCol) {
            this.arrSegments[0].changeColorSegment(fromCol, toCol);
        }

        public void randIt() {
            this.arrSegments[0].reset();
        }

        public void updateFrom(Block updateFrom) {
            this.arrSegments[0].updateFrom(updateFrom.arrSegments[0]);
        }

        public C64Color getBlockColor(int x, int y) {
            return this.arrSegments[0].arrColors[x + y * 16];
        }

        public int getBlockPixel(int x, int y) {
            C64Color cox = this.getBlockColor(x, y);
            return cox.c64Color;
        }

        public void setBlockPixel(int x, int y, int val) {
            C64Color cox = this.getBlockColor(x, y);
            cox.c64Color = val;
        }
    }

    class C64Color {
        int c64Color = 0;
        int c64RealColor = 0;

        C64Color() {
        }

        public void setFillColor() {
            sketch_AmigaBOB1616Editor.this.fill(this.c64Color);
        }

        public void updateColors(C64Color copy) {
            this.c64Color = copy.c64Color;
            this.c64RealColor = copy.c64RealColor;
        }
    }

    class Color {
        int r = 0;
        int g = 0;
        int b = 0;
        int systemR = 0;
        int systemG = 0;
        int systemB = 0;

        public Color(int rr, int gg, int bb) {
            this.systemR = rr;
            this.systemG = gg;
            this.systemB = bb;
            this.updateGlobalColors();
        }

        public void init(int rr, int gg, int bb) {
            this.systemR = rr;
            this.systemG = gg;
            this.systemB = bb;
            this.updateGlobalColors();
        }

        public void updateGlobalColors() {
            int max = 16;
            int trueMax = 256;
            int factor5 = trueMax / max;
            this.r = this.systemR * factor5;
            this.b = this.systemB * factor5;
            this.g = this.systemG * factor5;
        }
    }

    class Segment {
        int colorDraw = 0;
        int colorMulti1 = 0;
        int colorMulti2 = 0;
        int[] arrColor = new int[256];
        int colorCounter = 0;
        boolean colorsAreTrue = true;
        public C64Color[] arrColors = new C64Color[256];
        public int[] arrCompressedColors = new int[8];

        Segment() {
        }

        public void initColors() {
            int p = 0;
            while (p < 256) {
                C64Color c64col = new C64Color();
                c64col.c64Color = sketch_AmigaBOB1616Editor.this.backgroundColor;
                this.arrColors[p] = c64col;
                ++p;
            }
        }

        public void reset() {
            int p = 0;
            while (p < 256) {
                this.arrColors[p] = new C64Color();
                float rndx = sketch_AmigaBOB1616Editor.this.random(16.0f);
                this.arrColors[p].c64Color = PApplet.parseInt((float)rndx);
                ++p;
            }
        }

        public void updateFrom(Segment xyz) {
            int p = 0;
            while (p < 256) {
                this.arrColors[p].updateColors(xyz.arrColors[p]);
                ++p;
            }
            this.updateSudokuColors();
        }

        public void setPixel(int x, int y, int val) {
            if (x < 0) {
                return;
            }
            if (x > 16) {
                return;
            }
            if (y < 0) {
                return;
            }
            if (y > 16) {
                return;
            }
            this.arrColors[x + y * 16].c64Color = val;
        }

        public int getPixel(int x, int y) {
            if (x < 0) {
                return -1;
            }
            if (x > 16) {
                return -1;
            }
            if (y < 0) {
                return -1;
            }
            if (y > 16) {
                return -1;
            }
            return this.arrColors[x + y * 16].c64Color;
        }

        public void changeColorSegment(int fromCol, int toCol) {
            int p = 0;
            while (p < 64) {
                C64Color con = this.arrColors[p];
                if (con.c64Color == fromCol) {
                    con.c64Color = toCol;
                }
                ++p;
            }
        }

        public void updateSudokuColors() {
        }

        public int encode4Bit(int colx) {
            if (colx == sketch_AmigaBOB1616Editor.this.backgroundColor) {
                return 0;
            }
            if (colx == this.colorDraw) {
                return 3;
            }
            if (colx == this.colorMulti1) {
                return 1;
            }
            if (colx == this.colorMulti2) {
                return 2;
            }
            return 0;
        }

        public String getColorNumbers() {
            this.updateSudokuColors();
            String str = "";
            str = String.valueOf(str) + this.colorDraw + "," + this.colorMulti1 + "," + this.colorMulti2 + ",      ";
            int u = 0;
            while (u < 16) {
                str = String.valueOf(str) + this.arrCompressedColors[u];
                if (u != 7) {
                    str = String.valueOf(str) + ",";
                }
                ++u;
            }
            if (!this.colorsAreTrue) {
                str = String.valueOf(str) + ">3 colors!";
            }
            return str;
        }

        public String getColorNumbersAsm() {
            String[] arrB = new String[sketch_AmigaBOB1616Editor.this.bitplanes];
            int i = 0;
            while (i < sketch_AmigaBOB1616Editor.this.bitplanes) {
                arrB[i] = "\n\t\tdc.b %";
                ++i;
            }
            int z = 0;
            while (z < 256) {
                int i2;
                int col = this.arrColors[z].c64Color;
                if (z > 0 && z % 8 == 0 && z % 16 != 0) {
                    i2 = 0;
                    while (i2 < sketch_AmigaBOB1616Editor.this.bitplanes) {
                        int n = i2++;
                        arrB[n] = String.valueOf(arrB[n]) + ",%";
                    }
                }
                if (z > 0 && z % 16 == 0) {
                    i2 = 0;
                    while (i2 < sketch_AmigaBOB1616Editor.this.bitplanes) {
                        if (sketch_AmigaBOB1616Editor.this.addByte) {
                            int n = i2;
                            arrB[n] = String.valueOf(arrB[n]) + ",0,0";
                        }
                        int n = i2++;
                        arrB[n] = String.valueOf(arrB[n]) + "\n\t\tdc.b %";
                    }
                }
                i2 = 0;
                while (i2 < sketch_AmigaBOB1616Editor.this.bitplanes) {
                    if (((long)col & 1L << i2) != 0L) {
                        int n = i2;
                        arrB[n] = String.valueOf(arrB[n]) + "1";
                    } else {
                        int n = i2;
                        arrB[n] = String.valueOf(arrB[n]) + "0";
                    }
                    ++i2;
                }
                ++z;
            }
            i = 0;
            while (i < sketch_AmigaBOB1616Editor.this.bitplanes) {
                sketch_AmigaBOB1616Editor.println((String)(String.valueOf(i) + "  " + arrB[i]));
                ++i;
            }
            String allinone = "";
            int i3 = 0;
            while (i3 < sketch_AmigaBOB1616Editor.this.bitplanes) {
                allinone = String.valueOf(allinone) + "\n\t\t; plane_" + i3 + arrB[i3];
                if (sketch_AmigaBOB1616Editor.this.addByte) {
                    allinone = String.valueOf(allinone) + ",0,0";
                }
                ++i3;
            }
            sketch_AmigaBOB1616Editor.print((String)allinone);
            return String.valueOf(allinone) + "\n";
        }
    }
}

