/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.shapes;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;

public class BaseButton
extends GraphShape {
    public static final float ROUND_CORNER = 1.0f;
    public static final float PERP_CORNER = 0.0f;
    protected float width;
    protected float height;
    protected float corner = 1.0f;

    public BaseButton(int n, float f, float f2) {
        super(n);
        this.width = f;
        this.height = f2;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getCorner() {
        return this.corner;
    }

    public BaseButton setCorner(float f) {
        if (0.01f <= f && f <= 1.0f) {
            this.corner = f;
        }
        this.corner = f > 1.0f ? 1.0f : (f < 0.01f ? 0.0f : f);
        this.markShapeDirty();
        return this;
    }

    public BaseButton setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
        this.markShapeDirty();
        return this;
    }

    @Override
    protected void addShapeToRegion(GLProfile gLProfile, GL2ES2 gL2ES2) {
        OutlineShape outlineShape = this.createBaseShape(0.0f);
        this.resetGLRegion(gLProfile, gL2ES2, null, outlineShape);
        this.region.addOutlineShape(outlineShape, null, this.rgbaColor);
        this.box.resize(outlineShape.getBounds());
        this.setRotationPivot(this.box.getCenter());
    }

    protected OutlineShape createBaseShape(float f) {
        OutlineShape outlineShape = new OutlineShape();
        if (this.corner == 0.0f) {
            this.createSharpOutline(outlineShape, f);
        } else {
            this.createCurvedOutline(outlineShape, f);
        }
        outlineShape.setIsQuadraticNurbs();
        outlineShape.setSharpness(this.oshapeSharpness);
        return outlineShape;
    }

    protected void createSharpOutline(OutlineShape outlineShape, float f) {
        float f2 = this.getWidth();
        float f3 = this.getHeight();
        float f4 = f;
        outlineShape.addVertex(0.0f, 0.0f, f4, true);
        outlineShape.addVertex(0.0f + f2, 0.0f, f4, true);
        outlineShape.addVertex(0.0f + f2, 0.0f + f3, f4, true);
        outlineShape.addVertex(0.0f, 0.0f + f3, f4, true);
        outlineShape.closeLastOutline(true);
    }

    protected void createCurvedOutline(OutlineShape outlineShape, float f) {
        float f2 = this.getWidth();
        float f3 = this.getHeight();
        float f4 = 0.5f * this.corner * Math.min(f2, f3);
        float f5 = f;
        outlineShape.addVertex(0.0f, 0.0f + f4, f5, true);
        outlineShape.addVertex(0.0f, 0.0f, f5, false);
        outlineShape.addVertex(0.0f + f4, 0.0f, f5, true);
        outlineShape.addVertex(0.0f + f2 - f4, 0.0f, f5, true);
        outlineShape.addVertex(0.0f + f2, 0.0f, f5, false);
        outlineShape.addVertex(0.0f + f2, 0.0f + f4, f5, true);
        outlineShape.addVertex(0.0f + f2, 0.0f + f3 - f4, f5, true);
        outlineShape.addVertex(0.0f + f2, 0.0f + f3, f5, false);
        outlineShape.addVertex(0.0f + f2 - f4, 0.0f + f3, f5, true);
        outlineShape.addVertex(0.0f + f4, 0.0f + f3, f5, true);
        outlineShape.addVertex(0.0f, 0.0f + f3, f5, false);
        outlineShape.addVertex(0.0f, 0.0f + f3 - f4, f5, true);
        outlineShape.closeLastOutline(true);
    }

    @Override
    public String getSubString() {
        return super.getSubString() + ", dim " + this.getWidth() + " x " + this.getHeight() + ", corner " + this.corner;
    }
}

