/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

public enum GAlign {
    INVALID(0, "INVALID", "Invalid alignment"),
    LEFT(1, "LEFT", "Left align text"),
    CENTER(2, "CENTER", "Centre text horizontally"),
    RIGHT(4, "RIGHT", "Right align text"),
    JUSTIFY(8, "JUSTIFY", "Justify text"),
    TOP(16, "TOP", "Align text to to top"),
    MIDDLE(32, "MIDDLE", "Centre text vertically"),
    BOTTOM(64, "BOTTOM", "Align text to bottom"),
    SOUTH(256, "SOUTH", "Place icon below text"),
    NORTH(512, "NORTH", "Place icon above text"),
    WEST(1024, "WEST", "Place icon left of text"),
    EAST(2048, "EAST", "Place icon right of text");

    private int alignID;
    private String alignText;
    private String description;

    public static GAlign getFromText(String string) {
        if ((string = string.toUpperCase()).equals("LEFT")) {
            return LEFT;
        }
        if (string.equals("CENTER")) {
            return CENTER;
        }
        if (string.equals("RIGHT")) {
            return RIGHT;
        }
        if (string.equals("JUSTIFY")) {
            return JUSTIFY;
        }
        if (string.equals("TOP")) {
            return TOP;
        }
        if (string.equals("MIDDLE")) {
            return MIDDLE;
        }
        if (string.equals("BOTTOM")) {
            return BOTTOM;
        }
        if (string.equals("SOUTH")) {
            return SOUTH;
        }
        if (string.equals("NORTH")) {
            return NORTH;
        }
        if (string.equals("WEST")) {
            return WEST;
        }
        if (string.equals("EAST")) {
            return EAST;
        }
        return INVALID;
    }

    private GAlign(int n2, String string2, String string3) {
        this.alignID = n2;
        this.alignText = string2;
        this.description = string3;
    }

    public String getTextID() {
        return this.alignText;
    }

    public String getDesc() {
        return this.description;
    }

    public boolean isHorzAlign() {
        return (this.alignID & 0xF) != 0;
    }

    public boolean isVertAlign() {
        return (this.alignID & 0xF0) != 0;
    }

    public boolean isPosAlign() {
        return (this.alignID & 0xF00) != 0;
    }

    public String toString() {
        return "ID = " + this.alignText + " {" + this.alignID + "}  " + this.description;
    }
}

