/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAlign;
import g4p_controls.GEvent;
import g4p_controls.GTextIconBase;
import g4p_controls.HotSpot;
import g4p_controls.StyledString;
import java.awt.Graphics2D;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.event.MouseEvent;

public class GButton
extends GTextIconBase {
    private static boolean roundCorners = true;
    private static float CORNER_RADIUS = 6.0f;
    protected int status = 0;
    protected boolean reportAllButtonEvents = false;

    public static void useRoundCorners(boolean bl) {
        roundCorners = bl;
    }

    public GButton(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, f, f2, f3, f4, "");
    }

    public GButton(PApplet pApplet, float f, float f2, float f3, float f4, String string) {
        super(pApplet, f, f2, f3, f4);
        PGraphics pGraphics = this.winApp.createGraphics((int)this.width, (int)this.height, "processing.awt.PGraphicsJava2D");
        pGraphics.beginDraw();
        pGraphics.background(255);
        pGraphics.fill(0);
        pGraphics.stroke(0);
        pGraphics.strokeWeight(1.0f);
        if (roundCorners) {
            pGraphics.rect(0.0f, 0.0f, this.width - 2.0f, this.height - 2.0f, CORNER_RADIUS);
        } else {
            pGraphics.rect(0.0f, 0.0f, this.width - 2.0f, this.height - 2.0f);
        }
        pGraphics.endDraw();
        this.hotspots = new HotSpot[]{new HotSpot.HSmask(1, (PImage)pGraphics)};
        this.PAD = roundCorners ? 4.0f : 2.0f;
        this.textAlignH = GAlign.CENTER;
        this.textAlignV = GAlign.MIDDLE;
        this.iconPos = GAlign.EAST;
        this.iconAlignH = GAlign.CENTER;
        this.iconAlignV = GAlign.MIDDLE;
        this.calcZones(false, true);
        this.setText(string);
        this.z = 24;
        this.createEventHandler(G4P.sketchWindow, "handleButtonEvents", new Class[]{GButton.class, GEvent.class}, new String[]{"button", "event"});
        this.registeredMethods = 3;
        this.cursorOver = 12;
        this.localFont = G4P.displayFont;
        this.bufferInvalid = true;
        G4P.registerControl(this);
    }

    public void fireAllEvents(boolean bl) {
        this.reportAllButtonEvents = bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.status = 0;
        }
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot >= 0 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (focusIsWith == this || this.currSpot < 0 || this.z <= this.focusObjectZ()) break;
                this.dragging = false;
                this.status = 2;
                this.takeFocus();
                if (this.reportAllButtonEvents) {
                    this.fireEvent(new Object[]{this, GEvent.PRESSED});
                }
                this.bufferInvalid = true;
                break;
            }
            case 3: {
                if (focusIsWith != this) break;
                this.status = 0;
                this.bufferInvalid = true;
                this.loseFocus(this.parent);
                this.dragging = false;
                this.fireEvent(new Object[]{this, GEvent.CLICKED});
                break;
            }
            case 2: {
                if (focusIsWith != this || !this.dragging) break;
                if (this.reportAllButtonEvents) {
                    this.fireEvent(new Object[]{this, GEvent.RELEASED});
                }
                this.dragging = false;
                this.loseFocus(this.parent);
                this.status = 0;
                this.bufferInvalid = true;
                break;
            }
            case 5: {
                int n = this.status;
                this.status = this.currSpot >= 0 ? 1 : 0;
                if (n == this.status) break;
                this.bufferInvalid = true;
                break;
            }
            case 4: {
                this.dragging = focusIsWith == this;
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            Graphics2D graphics2D = this.buffer.g2;
            graphics2D.setFont(this.localFont);
            LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
            this.buffer.clear();
            this.buffer.stroke(this.palette[3].getRGB());
            this.buffer.strokeWeight(1.0f);
            switch (this.status) {
                case 1: {
                    this.buffer.fill(this.palette[6].getRGB());
                    break;
                }
                case 2: {
                    this.buffer.fill(this.palette[14].getRGB());
                    break;
                }
                default: {
                    this.buffer.fill(this.palette[4].getRGB());
                }
            }
            if (roundCorners) {
                this.buffer.rect(0.0f, 0.0f, this.width - 2.0f, this.height - 2.0f, CORNER_RADIUS);
            } else {
                this.buffer.rect(0.0f, 0.0f, this.width - 2.0f, this.height - 2.0f);
            }
            if (this.icon != null) {
                this.icon.setFrame(this.status);
                this.buffer.image(this.icon.getFrame(), this.iconX, this.iconY);
            }
            this.displayText(graphics2D, linkedList);
            this.buffer.endDraw();
        }
    }
}

