/*

  _________ ___ ______________.____    .____     ________   ____ __________    ___________________________    _______   
 /   _____//   |   \_   _____/|    |   |    |    \______ \ |    |   \      \  /  _____/\_   _____/\_____  \   \      \  
 \_____  \/    ~    \    __)_ |    |   |    |     |    |  \|    |   /   |   \/   \  ___ |    __)_  /   |   \  /   |   \ 
 /        \    Y    /        \|    |___|    |___  |    `   \    |  /    |    \    \_\  \|        \/    |    \/    |    \
/_______  /\___|_  /_______  /|_______ \_______ \/_______  /______/\____|__  /\______  /_______  /\_______  /\____|__  /
        \/       \/        \/         \/       \/        \/                \/        \/        \/         \/         \/ 

SHELL-DUNGEON 0.5

PROJECT-DOCUMENTATION: https://research.swissdigitization.ch/?p=7826
IDEA & CODE: rene.bauer@zhdk.ch

OnlineIDE: https://www.jdoodle.com/c-online-compiler
  

die:      dwhhhhhh
solution: wwwwawwwsssdssdddddeddeedssaaeaeaadddddddwwdddawwaaaaaeeaaawwededaassddddddddsddsddd
end: 		wwwwawwwsssdssdddddeddeedssaaeaeaadddddddwwddawwaaaaaeeaaawwedwedsaassddddddddssddddddddddwdddwwssadsdwwwwaaaaaaaaaww

*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

// exe
int version = 5;

char *execName;   
char *execCmds;


int actIndex = 0;
char lastCmd = ' ';

// vars
int money = 0; // score
int keys = 0;
int health = 100;

// world
const int playFieldWidth = 30;
const int playFieldHeight = 10;

int playerX = 2;
int playerY = playFieldHeight-2;
int playerCmdIndex = 0; // where are we?

char inv[] = "SWORD";


char executedCommand[30] = "";
char executedCommandArg[30] = "";



// y | x
char playField[10][30] = {
                "######## +*  ####U############",
                "#F#^ oo# *+  # W             #",
                "# #  op#     #               #",
                "# ## #########               #",
                "#  # FO      #         ##    #",
                "## ######### #####           #",
                "#     X o O# XXX             #",
                "#I ^######o# ###       ^^^   #",
                "#   #Foo     # #   ^      ####",
                "############## ############   "
        };


    void showHead() {
    
       for (int i=0;i<40;i++) printf("\n");
        
        printf("[()()()()()()()()()()()()()()()()]\n");  
        printf("[   (                            ]\n");  
        printf("[  )\\ )   SHELLDUNGEON           ]\n");
        printf("[ (()/(    0.%d                   ]\n",version);
        printf("[  /(_))                         ]\n");
        printf("[///////////////////###//////////]\n\n");

        printf("[ THE ARGUMENT ONLY ADVENTURE ] \n");
        printf("[ IDEA&CODE GAMELABZ/CHLUDENS ] \n\n");
    
        // printf("# LINE-IN GAME\n");
        // printf("<>^v\n");
        // printf("  HELP : %s -help\n",execName);
        printf("  PLAY : %s [CMDS]\n",execName);
        printf("  CMDS : [MOVE wasd] [ACTION: e] \n");
        printf("         [HELP: h] \n");
        printf("  TRY  : %s h \n",execName);
        printf("         > help \n\n");
        printf("  TRY  : %s wwh \n",execName);
        printf("         > up up help \n\n");
        
    }

   
    
         void actionHealth( int addToHealth ) {
            health +=addToHealth;
            if (health<=0) {
            	health = 0;
                printf("\n\n  YOU DIED!\n");
                printf("  TRY AGAIN! \n");
                printf("       \n");
                printf("       \n");
                printf("     #\n");
                printf("   #####  \n");
                printf("     #    \n");
                printf("   __#_______\n");
                printf("       \n");
                printf("  YOU CAN USE TIMEMASCHINE TOO:  \n");
                printf("  JUST DELETE THE LAST CMDS!  \n\n\n");
                exit(0);
            }
        }    
    
        //   Field functions
    
        char getField(int xx, int yy) {
                if (xx<0) return '#';
                if (yy<0) return '#';
                if (xx>(playFieldWidth-1)) return '#';
                if (yy>(playFieldHeight-1)) return '#';
                return playField[yy][xx];
            }
            
            void setField(int xx, int yy, char cc) {
                if (xx<0) return;
                if (yy<0) return;
                if (xx>(playFieldWidth-1)) return ;
                if (yy>(playFieldHeight-1)) return;
                playField[yy][xx] = cc;
            }
            
            int checkForWallPlayer( int xx, int yy) {
                
                
                char c = getField(xx,yy);;
                
                if (c=='#') return 1;
                if (c=='o') return 1;
                if (c=='O') return 1;

                if (c=='X') {
                    if (keys>0) {
                        playField[yy][xx] = ' ';
                        keys--;
                        strcpy(executedCommandArg, "OPEN DOOR!"); 
                        return 0;
                    } else {
                        strcpy(executedCommandArg, "NEED A KEY!"); 
                        return 1;
                    }
                }

                return 0;
            }
            
            int checkForWallEnemy( int xx, int yy) {
                
                
                char c = getField(xx,yy);;
                
                if (c=='#') return 1;
                
                /*
                if ((xx==playerX)&&(yy==playerY)) {
                    strcpy(executedCommandArg, "HIT BY THE DRAGON!"); 
                    actionHealth(-20);
                    return 1;
                }   
                */
                
                return 0;
            }            
            

            int checkForWall( char c ) {
                if (c=='#') return 1;
                if (c=='o') return 1;
                if (c=='O') return 1;
                return 0;
            }

               
         
            
        
        // update fields
        void updateField(int u,int u2) {
            
            char zc = getField(u,u2);
            
            // specials ... animations ... 
            if (zc=='+') {
               setField(u,u2,'*');
            } else {
               if (zc=='*') { 
                   setField(u,u2,'+');
               }
            }
            
            // enemy / dragon
            // x
            int udone = 0;
            
            if (actIndex%4==0) {
                if (zc=='W') {
                    if (checkForWallEnemy(u+1,u2)==0) {
                        if (playerX>u) {
                           setField(u,u2,' '); 
                           setField(u+1,u2,'w'); 
                           udone = 1;
                        }
                    }
                    if (checkForWallEnemy(u-1,u2)==0) {
                        if (playerX<u) {
                           setField(u,u2,' '); 
                           setField(u-1,u2,'w'); 
                           udone = 1;
                        }
                    }
                }
            }
            if (actIndex%4==1) {
                if (zc=='w') {
                    if (checkForWallEnemy(u+1,u2)==0) {
                        if (playerX>u) {
                           setField(u,u2,' '); 
                           setField(u+1,u2,'W'); 
                           udone = 1;
                        }
                    }
                    if (checkForWallEnemy(u-1,u2)==0) {
                        if (playerX<u) {
                           setField(u,u2,' '); 
                           setField(u-1,u2,'W'); 
                           udone = 1;
                        }
                    }
                }
            }
            
            // y
            if (1) {
                if (actIndex%4==2) {
                    if (zc=='W') {
                        if (checkForWallEnemy(u,u2+1)==0) {
                            if (playerY>u2) {
                               setField(u,u2,' '); 
                               setField(u,u2+1,'w'); 
                            }
                        }
                        if (checkForWallEnemy(u,u2-1)==0) {
                            if (playerY<u2) {
                               setField(u,u2,' '); 
                               setField(u,u2-1,'w'); 
                            }
                        }
                    }
                }
                if (actIndex%4==3) {
                    if (zc=='w') {
                        if (checkForWallEnemy(u,u2+1)==0) {
                            if (playerY>u2) {
                               setField(u,u2,' '); 
                               setField(u,u2+1,'W'); 
                            }
                        }
                        if (checkForWallEnemy(u,u2-1)==0) {
                            if (playerY<u2) {
                               setField(u,u2,' '); 
                               setField(u,u2-1,'W'); 
                            }
                        }
                    }
                }
            }
            
            
            
        }   
            
        // standon on a field
        void onField(int u,int u2) {
            
            char zc = getField(u,u2);
            
            // specials ...
            if (zc=='^') {
                actionHealth(-30);
                strcpy(executedCommandArg, "HIT BY SPEAR -30H"); 
            }
            if (zc=='F') {
                setField(u,u2,' ');
                keys++;
                strcpy(executedCommandArg, "KEY FOUND!"); 
            }
            
            // enemy
            if (zc=='W') {
                actionHealth(-50);
                strcpy(executedCommandArg, "HIT BY A MONSTER"); 
            }
            if (zc=='w') {
                actionHealth(-50);
                strcpy(executedCommandArg, "HIT BY A MONSTER"); 
            }
            
            if (zc=='U') {
                // end
                printf("\n\n\n []#### WON! #####] \n  YOU GET OUT OF THE SHELLDUNGEON\n\n");

                printf("       _____\n");
                printf("    __  ____  _\n");
                printf("   ____  __  ___\n");
                printf("   _____     ____\n");
                printf("   _____\\o/ _____\n");
                printf("   _____ A ______\n");
                printf("_______ / \\ _________\n");
                printf("\n\n");
                
                exit(0);
            }
            
            
        }        
             
        // player actions                       
        void actionOnField(int u,int u2) {
            
            char zc = getField(u,u2);
            
            // specials ...
            if (zc=='O') {
                setField(u,u2,'o');
                strcpy(executedCommandArg, "OH SMALLER"); 
            }
            
            if (zc=='o') {
                strcpy(executedCommandArg, "DESTROYED FOUND 5 GOLD"); 
                setField(u,u2,'.');
                money +=5; 
            }
            if (zc=='p') {
                strcpy(executedCommandArg, "DESTROYED BARREL"); 
                setField(u,u2,'F');
            }

            if (zc=='w') {
                strcpy(executedCommandArg, "MISSED THE DRAGON"); 
                // setField(u,u2,'F');
            }
            if (zc=='W') {
                strcpy(executedCommandArg, "MISSED THE DRAGON"); 
                // setField(u,u2,'F');
            }

            
        }

        
           
            // parse next round
            void parseNextCommand( char ct ) {
                
                int doneCmd = 0;
                
                if (ct==0) return;
                
                strcpy(executedCommand, "");
                strcpy(executedCommandArg, "");                
                
                if (ct!='.') {
                    lastCmd = ct;
                }

                if (ct=='a') {
                    doneCmd = 1;
//                    if (checkForWall(getField(playerX-1,playerY))==0) {
                    if (checkForWallPlayer(playerX-1,playerY)==0) {
                        playerX--;
                        strcpy(executedCommand, "MOVED LEFT");
                    } else {
                        strcpy(executedCommand, "CRASHED AGAINST A WALL -10 H");
                        actionHealth(-10);
                    }
                }

                if (ct=='d') {
                    doneCmd = 1;
//                    if (checkForWall(getField(playerX+1,playerY))==0) {
                    if (checkForWallPlayer(playerX+1,playerY)==0) {
                        playerX++;
                        strcpy(executedCommand, "MOVED RIGHT");
                    } else {
                        strcpy(executedCommand, "CRASHED AGAINST A WALL -10 H");
                        actionHealth(-10);
                    }    
                }

                if (ct=='h') {
                    doneCmd = 1;
                    strcpy(executedCommand, "HELP: ");
                    lastCmd = ct;
                }
                // lastCmd
                
                if (ct=='w') {
                    doneCmd = 1;
//                    if (checkForWall(getField(playerX,playerY-1))==0) {
                    if (checkForWallPlayer(playerX,playerY-1)==0) {
                        playerY--;
                        strcpy(executedCommand, "MOVED UP");
                    } else {
                        strcpy(executedCommand, "CRASHED AGAINST A WALL -10 H");
                        actionHealth(-10);
                    }  
                }
                if (ct=='s') {
                    doneCmd = 1;
//                    if (checkForWall(getField(playerX,playerY+1))==0) {
                    if (checkForWallPlayer(playerX,playerY+1)==0) {
                        playerY++;
                        strcpy(executedCommand, "MOVED DOWN");
                    } else {
                        strcpy(executedCommand, "CRASHED AGAINST A WALL -10 H");
                        actionHealth(-10);
                    }  
                }
                
                
                // actionField
                if (ct=='e') {
                    doneCmd = 1;
                    
                    for (int v=-1;v<2;v++) {
                        for (int w=-1;w<2;w++) {
                            actionOnField(playerX+v,playerY+w);
                        }
                    }
                   
                    strcpy(executedCommand, "KICKED & PUSHED ALL OVER");
                }                
                
                // standing on a field
                onField(playerX,playerY);
                
                
                // update fields
                 for (int v=0;v<playFieldWidth;v++) {
                    for (int w=0;w<playFieldHeight;w++) {
                        updateField(v,w);
                    }
                }
                
                
                if (ct!=0) {
                    if (doneCmd==0) {
                        strcpy(executedCommand, " : NO COMMAND [wasd]");
                        executedCommand[0] = ct;
                    }
                }
            }
        

        
    
    
        void showPlayfield() {

            for (int y=0;y<playFieldHeight;y++) {    
                printf("  ");
                for (int x=0;x<playFieldWidth;x++) {
             
                    // check player
                    if (x!=playerX || y!=playerY) {
                        char ux = playField[y][x];
                        
                        // batches 
                        if (ux=='p') ux='o';
                        if (ux=='/') ux='#';
                        
                        printf("%c",ux);
                        
                        
                    } else {
                        // player
                        printf("A");
                    }
                    
                        
                }            
                printf("\n");
                
            }
            
        }
    
    void ingame() {
        printf("\n");
        printf("[  HEALTH: %d KEYS:%d GOLD: %d  ]\n",health,keys,money);
        printf("\n");
    }
    
     void intro() {
        ingame();
  
        showPlayfield();

        printf("\nYOU WAKE UP IN A DARK DUNGEON.  \n");
        printf("YOU HEAR A ROARING DRAGON! \n");
        printf("ESCAPE!!!!! \n\n");

        
        printf("\n! USE CURSOR IN SHELL TO GET LAST \n");
        printf("!  COMMAND AND ADD NEXT CMD \n\n\n");
     
        
//        printf("\n  YOU STAND IN FRONT OF A BIG FOOTBALL\n");
//        printf("\n  YOU LOOK INTO A DARK DUNGEON\n");
//        printf("\n  YOU LOOK INTO A DARK CAR\n");
//        printf("  LOOK AT IT!\n");
//        printf("  LOOK AT IT!\n");
//        printf("\n  GO FORWARD BY EXECUTING AGAIN %s w\n",execName);
//        printf("\n  CURSOR UP TO GET LAST COMMAND IN SHELL AGAIN!\n");
    }
    


int main(int argc, char **argv) {

    
    execName = argv[0];
    execCmds = argv[1];
    
    int showHeadF = 1;
    
    

    // printf(" TIPP: USE CURSOR UP \n");
    
    // -help
    if (argc>1) {
        
        // check for help
        if (strcmp("-help", argv[1]) == 0)
        {
            showHead();
            
        }
        // check ingame 
        else
        {
            // do something else.
            
            
            int len = strlen(execCmds);
            
            // lets parse the commands
            int i = 0;
            int c = 0;
            do {
              c = execCmds[i];
              
              actIndex = i;
              
              // printf("%c",c);
              parseNextCommand( c );
              
              // show result last command
              if ((len-1)==i) {
                 //  printf("\n  %s\n\n",executedCommand);
                 lastCmd = c;
              }
              
              i++;  
            } while(c!=0);
            
            ingame();

            showPlayfield();

            printf("\n> %s\n",executedCommand);
            
            if (strlen(executedCommandArg)>1) {
                printf("> %s\n",executedCommandArg);
            }
            
            // help
            if (lastCmd=='h') {
                printf("  PLAY: ADD CMDS TO ARGUMENT IN THE SHELL!\n");
                printf("  // UP\n");
                printf("  %s w\n",execName);
                printf("  // UP&LEFT\n");
                printf("  %s wl\n",execName);
                printf("  USE THE CURSOR ^ TO GET LAST INPUT BACK! \n",execName);
                printf("  ADD THAN NEW CMD \n",execName);
                printf("  \n");
                printf("  COMMANDS (WASD MOVEMENT + E FOR ACTION)\n");
                printf("   a:LEFT\n");
                printf("   d:RIGHT\n");
                printf("   w:UP\n");
                printf("   s:DOWN\n");
                printf("   e: ACTION // DESTROYS THINGS oOW \n");
                printf("   \n");
                printf("   ELEMENTS\n");
                printf("   A: PLAYER* \n");
                printf("   #: WALL \n");
                printf("   X: CLOSED DOOR \n");
                printf("   O: BIG BARREL \n");
                printf("   o: SMALL BARREL \n");
                printf("   F: KEY \n");
                printf("   U: EXIT \n");
                printf("  \n");
                printf("   DECORATION\n");
                printf("   I: PILLAR \n");
                printf("   T: PILLAR \n");
                printf("   .:SMALL STONE\n");
                printf("   _:?\n");
                printf("  \n");
                printf("   SPRITES\n");
                printf("   W: DRAGON - KILLS YOU\n");
                printf("   v: CAT \n");


            }

            printf("\n\n");
            

        }
        
    } else {
        
         showHead();
        
        intro();
        
    }
    
    // input now 
    /*
    printf("argc %d\n",argc);
    for (int i = 0; i < argc; ++i)
    {
        printf("argv[%d]: %s\n", i, argv[i]);
    }
    */
    
}

